/*
 * Decompiled with CFR 0.152.
 */
package sam.resource;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import sam.resource.DeviceResource;
import sam.resource.GUIResource;
import sam.resource.MediaResource;
import sam.resource.ResourceInputStream;
import sam.resource.ScreenResource;
import sam.resource.TableResource;

public class ResourceManager {
    public static final long kb = 1024L;
    public static final long mb = 0x100000L;
    public static final long gb = 0x40000000L;
    public static String baseDirectory = "/etc/opt/SUNWsamfs/";
    private static File resourceFile = new File("SamGUI.rsc");
    private static String bundleName = new String("SamGUI");
    private static ResourceBundle translationText;
    private static Hashtable resources;
    public static final boolean debug = false;

    public static void setResourceFile(String string) {
        resourceFile = new File(string);
    }

    public static void setLocale() {
        Locale.setDefault(ResourceManager.getLocale());
        ResourceManager.loadLocaleResources(bundleName);
    }

    public static void setLocale(Locale locale) {
        Locale.setDefault(locale);
        ResourceManager.loadLocaleResources(bundleName);
    }

    public static void setLocale(String string) {
        Locale.setDefault(new Locale(string, ""));
        ResourceManager.loadLocaleResources(bundleName);
    }

    public static Locale getLocale() {
        return Locale.getDefault();
    }

    private static void loadLocaleResources(String string) {
        try {
            translationText = ResourceBundle.getBundle(string);
            bundleName = string;
            return;
        }
        catch (MissingResourceException missingResourceException) {
            System.err.println("Unable to find translation file: " + missingResourceException.getClassName() + ".properties");
            Locale.setDefault(Locale.ENGLISH);
            System.err.println("Defaulting to: " + Locale.getDefault().getDisplayName());
            return;
        }
    }

    private static String getStringKey(String string) {
        return string.replace(' ', '_');
    }

    public static String getString(String string) {
        if (translationText == null) {
            return string;
        }
        try {
            return translationText.getString(ResourceManager.getStringKey(string));
        }
        catch (MissingResourceException missingResourceException) {
            return "*" + string;
        }
    }

    public static void debugMessage(String string) {
    }

    /*
     * Unable to fully structure code
     */
    public static void loadResources() {
        ResourceManager.resources = new Hashtable<K, V>();
        try {
            var0 = new ResourceInputStream(ResourceManager.resourceFile);
            ** GOTO lbl42
        }
        catch (FileNotFoundException v0) {
            ResourceManager.setResourceFile(String.valueOf(ResourceManager.baseDirectory) + ResourceManager.resourceFile);
            try {
                var0 = new ResourceInputStream(ResourceManager.resourceFile);
                if (true) ** GOTO lbl42
            }
            catch (FileNotFoundException v1) {
                System.err.println(String.valueOf(ResourceManager.getString("Can not find resources file")) + ": " + ResourceManager.resourceFile);
                return;
            }
        }
        do {
            var2_2 = null;
            if (ResourceManager.resources.containsKey(var1_1.keytype)) {
                var2_2 = (Hashtable)ResourceManager.resources.get(var1_1.keytype);
            } else {
                var2_2 = new Hashtable();
                ResourceManager.resources.put(var1_1.keytype, var2_2);
            }
            var3_3 = null;
            if (var2_2.containsKey(var1_1.key)) {
                var3_3 = (GUIResource)var2_2.get(var1_1.key);
            } else {
                if (var1_1.keytype.equals(ResourceInputStream.device)) {
                    var3_3 = new DeviceResource(var1_1.key);
                } else if (var1_1.keytype.equals(ResourceInputStream.media)) {
                    var3_3 = new MediaResource(var1_1.key);
                } else if (var1_1.keytype.equals(ResourceInputStream.catalog) || var1_1.keytype.equals(ResourceInputStream.mountRequests)) {
                    var3_3 = new TableResource(var1_1.key);
                } else if (var1_1.keytype.equals(ResourceInputStream.screen)) {
                    var3_3 = new ScreenResource(var1_1.key);
                } else {
                    System.err.println(String.valueOf(ResourceManager.getString("Invalid resource entry")) + ":  " + var1_1.keytype + " " + var1_1.key);
                    continue;
                }
                var2_2.put(var1_1.key, var3_3);
            }
            var3_3.setResource(var1_1.keyword, var1_1.data);
lbl42:
            // 4 sources

        } while ((var1_1 = var0.readResource()) != null);
    }

    private static GUIResource getResource(String string, String string2) {
        try {
            Hashtable hashtable = (Hashtable)resources.get(string);
            return (GUIResource)hashtable.get(string2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getDeviceIcon(int n) {
        try {
            DeviceResource deviceResource = (DeviceResource)ResourceManager.getResource(ResourceInputStream.device, Integer.toString(n));
            return deviceResource.getImage();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getDeviceTypeIcon(String string) {
        try {
            DeviceResource deviceResource = (DeviceResource)ResourceManager.getResource(ResourceInputStream.device, string);
            return deviceResource.getImage();
        }
        catch (Exception exception) {
            try {
                DeviceResource deviceResource = (DeviceResource)ResourceManager.getResource(ResourceInputStream.device, ResourceInputStream.all);
                return deviceResource.getImage();
            }
            catch (Exception exception2) {
                return null;
            }
        }
    }

    public static String getDeviceName(int n) {
        try {
            DeviceResource deviceResource = (DeviceResource)ResourceManager.getResource(ResourceInputStream.device, Integer.toString(n));
            return deviceResource.getName();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getMailIcon(int n) {
        try {
            DeviceResource deviceResource = (DeviceResource)ResourceManager.getResource(ResourceInputStream.device, Integer.toString(n));
            return deviceResource.getMailboxImage();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getMailTypeIcon(String string) {
        try {
            DeviceResource deviceResource = (DeviceResource)ResourceManager.getResource(ResourceInputStream.device, string);
            return deviceResource.getMailboxImage();
        }
        catch (Exception exception) {
            try {
                DeviceResource deviceResource = (DeviceResource)ResourceManager.getResource(ResourceInputStream.device, ResourceInputStream.all);
                return deviceResource.getMailboxImage();
            }
            catch (Exception exception2) {
                return null;
            }
        }
    }

    public static String getMediaIcon(String string) {
        try {
            MediaResource mediaResource = (MediaResource)ResourceManager.getResource(ResourceInputStream.media, string);
            return mediaResource.getImage();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String[] getCatalogHeaders(int n) {
        try {
            TableResource tableResource = (TableResource)ResourceManager.getResource(ResourceInputStream.catalog, Integer.toString(n));
            return tableResource.getColumns();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String[] getCatalogTypeHeaders(String string) {
        try {
            TableResource tableResource = (TableResource)ResourceManager.getResource(ResourceInputStream.catalog, string);
            return tableResource.getColumns();
        }
        catch (Exception exception) {
            try {
                TableResource tableResource = (TableResource)ResourceManager.getResource(ResourceInputStream.catalog, ResourceInputStream.all);
                return tableResource.getColumns();
            }
            catch (Exception exception2) {
                return null;
            }
        }
    }

    public static String[] getMountRequestHeaders() {
        try {
            TableResource tableResource = (TableResource)ResourceManager.getResource(ResourceInputStream.mountRequests, ResourceInputStream.all);
            return tableResource.getColumns();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Integer[] getScreenSizings(int n) {
        try {
            ScreenResource screenResource = (ScreenResource)ResourceManager.getResource(ResourceInputStream.screen, Integer.toString(n));
            return screenResource.getSizings();
        }
        catch (Exception exception) {
            try {
                ScreenResource screenResource = (ScreenResource)ResourceManager.getResource(ResourceInputStream.screen, ResourceInputStream.all);
                return screenResource.getSizings();
            }
            catch (Exception exception2) {
                return null;
            }
        }
    }

    public static float getFloatKB(long l) {
        return l / 1024L;
    }

    public static float getFloatMB(long l) {
        return l / 0x100000L;
    }

    public static float getFloatGB(long l) {
        return l / 0x40000000L;
    }

    public static String trimToDecimalPlace(String string, int n) {
        try {
            return string.substring(0, string.indexOf(".") + 1 + n);
        }
        catch (Exception exception) {
            return string;
        }
    }

    public static String getPreferredNumber(long l) {
        if (l > 0x40000000L) {
            return String.valueOf(ResourceManager.trimToDecimalPlace(String.valueOf(ResourceManager.getFloatGB(l)), 1)) + "GB";
        }
        if (l > 0x100000L) {
            return String.valueOf(ResourceManager.trimToDecimalPlace(String.valueOf(ResourceManager.getFloatMB(l)), 1)) + "MB";
        }
        if (l > 1024L) {
            return String.valueOf(ResourceManager.trimToDecimalPlace(String.valueOf(ResourceManager.getFloatKB(l)), 1)) + "KB";
        }
        return String.valueOf(l);
    }
}

