/*
 * Decompiled with CFR 0.152.
 */
package sam.model;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Vector;
import sam.model.TableEntry;

public class Table
extends Observable {
    private Hashtable entry = new Hashtable();
    private boolean updating = false;

    public void setUpdating(boolean bl) {
        if (bl != this.updating) {
            this.updating = bl;
            this.setChanged();
            this.notifyObservers(null);
        }
    }

    public boolean isUpdating() {
        return this.updating;
    }

    public synchronized void addEntry(TableEntry tableEntry) {
        this.addEntry(tableEntry.getSlotNumber(), (Object)tableEntry);
    }

    public synchronized void addEntry(int n, Object object) {
        this.addEntry(new Integer(n), object);
    }

    public synchronized void addEntry(Object object, Object object2) {
        this.entry.put(object, object2);
        this.setChanged();
        this.notifyObservers(object);
    }

    public Object getEntry(int n) {
        return this.getEntry(new Integer(n));
    }

    public Object getEntry(Object object) {
        return this.entry.get(object);
    }

    public int getSize() {
        return this.entry.size();
    }

    public boolean isEmpty() {
        return this.entry.size() == 0;
    }

    public TableEntry[] getEntries() {
        if (this.getSize() == 0) {
            return null;
        }
        Vector<TableEntry> vector = new Vector<TableEntry>();
        Enumeration enumeration = this.entry.elements();
        while (enumeration.hasMoreElements()) {
            try {
                TableEntry tableEntry = (TableEntry)enumeration.nextElement();
                vector.insertElementAt(tableEntry, 0);
            }
            catch (ClassCastException classCastException) {}
        }
        if (vector.size() == 0) {
            return null;
        }
        Object[] objectArray = new TableEntry[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public synchronized void removeEntry(int n) {
        this.removeEntry(new Integer(n));
    }

    public synchronized void removeEntry(Object object) {
        Object v = this.entry.get(object);
        if (v == null) {
            return;
        }
        this.entry.remove(object);
        this.setChanged();
        this.notifyObservers(v);
    }

    public void refresh() {
        if (!this.isEmpty()) {
            this.setUpdating(true);
            TableEntry[] tableEntryArray = this.getEntries();
            int n = 0;
            while (n < tableEntryArray.length) {
                tableEntryArray[n].refresh();
                ++n;
            }
            this.setUpdating(false);
        }
    }

    public void bugFix() {
        if (!this.isEmpty()) {
            TableEntry[] tableEntryArray = this.getEntries();
            tableEntryArray[1].refresh();
        }
    }
}

