/*
 * Decompiled with CFR 0.152.
 */
package sam.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Toolkit;
import sam.gui.GUIManager;
import sam.gui.Icon;
import sam.gui.ObjectPanel;

public class ObjectDisplay
extends ObjectPanel {
    private Font labelFont = new Font("SansSerif", 1, GUIManager.getFontPointSize(2));
    private Icon iconImage;
    private Label iconText;
    protected GridBagLayout gridBag = new GridBagLayout();
    Color background;

    public int getIconWidth() {
        return this.iconImage.getPreferredSize().width;
    }

    public void setIcon(String string) {
        this.iconImage.setImage(string);
    }

    public void setText(String string) {
        if (this.iconText != null) {
            this.iconText.setText(string);
        }
        this.repaint();
    }

    public Icon getIcon() {
        return this.iconImage;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.iconImage.getPreferredSize();
        Insets insets = this.getInsets();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        if (this.iconText != null) {
            dimension.height += Toolkit.getDefaultToolkit().getFontMetrics(this.labelFont).getHeight();
        }
        return dimension;
    }

    public void setHighlight(boolean bl) {
        if (bl) {
            this.background = this.getBackground();
            this.setBackground(this.getBackground().brighter());
            this.iconText.setBackground(this.iconText.getBackground().brighter());
            this.iconImage.setBackground(this.iconImage.getBackground().brighter());
            return;
        }
        this.setBackground(this.background);
        this.iconText.setBackground(this.background);
        this.iconImage.setBackground(this.background);
    }

    public Insets getInsets() {
        return new Insets(5, 5, 5, 5);
    }

    ObjectDisplay(Icon icon, String string) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(this.gridBag);
        if (string != null) {
            this.iconText = new Label(string);
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.gridheight = 1;
            this.gridBag.setConstraints(this.iconText, gridBagConstraints);
            this.iconText.setFont(this.labelFont);
            this.iconText.addMouseListener(this);
            this.add(this.iconText);
        }
        this.iconImage = icon;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        this.gridBag.setConstraints(this.iconImage, gridBagConstraints);
        this.iconImage.addMouseListener(this);
        this.add(this.iconImage);
    }

    ObjectDisplay(String string, String string2) {
        this(new Icon(string), string2);
    }
}

