/*
 * Decompiled with CFR 0.152.
 */
package sam.gui;

import java.util.Hashtable;
import sam.gui.MountMediaIcon;
import sam.gui.TableDisplay;
import sam.gui.dialog.MountReqEntryDialog;
import sam.gui.dialog.TableEntryDialog;
import sam.gui.popup.MountReqEntryPopUp;
import sam.model.Media;
import sam.model.MountRequestEntry;
import sam.model.MountRequestTable;
import sam.model.Table;
import sam.model.TableEntry;
import sam.resource.ResourceManager;

public class MountRequestDisplay
extends TableDisplay {
    private static final String[] columnHeaders = new String[]{"Slot", "Media", "Process ID", "User", "VSN", "Wait Time", "Request Count", "Request Time", "Assigned Robot", "Priority"};
    private static final int[] columnAlignments = new int[]{TableDisplay.ALIGN_RIGHT, TableDisplay.ALIGN_MIDDLE, TableDisplay.ALIGN_RIGHT, TableDisplay.ALIGN_LEFT, TableDisplay.ALIGN_LEFT, TableDisplay.ALIGN_RIGHT, TableDisplay.ALIGN_RIGHT, TableDisplay.ALIGN_LEFT, TableDisplay.ALIGN_RIGHT, TableDisplay.ALIGN_RIGHT};
    private static final String[] defaultHeaders = new String[]{"Slot", "Media", "Request Count", "VSN", "Wait Time"};

    protected Hashtable buildSlotData(TableEntry tableEntry) {
        MountRequestEntry mountRequestEntry = (MountRequestEntry)tableEntry;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        Media media = mountRequestEntry.getMedia();
        hashtable.put("Slot", new Integer(mountRequestEntry.getSlotNumber()));
        hashtable.put("Request Count", new Integer(mountRequestEntry.getRequestCount()));
        hashtable.put("Wait Time", mountRequestEntry.getElapsedTimeString());
        hashtable.put("Request Time", mountRequestEntry.getRequestTime());
        hashtable.put("User", mountRequestEntry.getUser());
        hashtable.put("Process ID", new Integer(mountRequestEntry.getPID()));
        hashtable.put("Priority", new Float(mountRequestEntry.getPriority()));
        if (mountRequestEntry.getRobot() != null) {
            hashtable.put("Assigned Robot", new Integer(mountRequestEntry.getRobot().getEqId()));
        }
        if (media != null) {
            try {
                hashtable.put("Media", MountRequestDisplay.getMediaIcon(mountRequestEntry, this.getRowHeight()));
            }
            catch (Exception exception) {}
            hashtable.put("VSN", media.getName());
        }
        return hashtable;
    }

    public static MountMediaIcon getMediaIcon(MountRequestEntry mountRequestEntry, int n) {
        if (!mountRequestEntry.isBusy()) {
            return null;
        }
        return new MountMediaIcon(mountRequestEntry, -1, n);
    }

    protected void defineHeaders(Table table) {
        String[] stringArray = ResourceManager.getMountRequestHeaders();
        if (stringArray == null) {
            stringArray = defaultHeaders;
        }
        this.setHeaderRow(stringArray, columnHeaders, columnAlignments);
    }

    protected TableEntryDialog getDialogBox() {
        return new MountReqEntryDialog(this);
    }

    public MountRequestDisplay(MountRequestTable mountRequestTable) {
        super(mountRequestTable);
        this.setPopupMenu(new MountReqEntryPopUp(this));
    }
}

