/*
 * Decompiled with CFR 0.152.
 */
package sam.gui;

import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import sam.gui.GUIManager;
import sam.gui.StatusPanel;
import sam.gui.event.DialogButtonsListener;
import sam.resource.ResourceManager;

public class DialogBox
extends Dialog
implements ActionListener,
DialogButtonsListener {
    public static final int OK = 1;
    public static final int APPLY = 2;
    public static final int CANCEL = 4;
    protected GridBagLayout gridBag = new GridBagLayout();
    private boolean horizontal;
    private Vector statusPanels = new Vector();
    private Vector buttonHandlers = new Vector();
    int closeStatus;

    public static Frame getParentFrame(Container container) {
        Container container2 = container.getParent();
        while (!(container2 instanceof Frame)) {
            container2 = container2.getParent();
        }
        return (Frame)container2;
    }

    public void addButtonListener(DialogButtonsListener dialogButtonsListener) {
        this.buttonHandlers.addElement(dialogButtonsListener);
    }

    public void removeButtonListener(DialogButtonsListener dialogButtonsListener) {
        this.buttonHandlers.removeElement(dialogButtonsListener);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.buttonHandlers.isEmpty()) {
            return;
        }
        boolean bl = actionEvent.getActionCommand().equals(ResourceManager.getString("OK"));
        boolean bl2 = actionEvent.getActionCommand().equals(ResourceManager.getString("Apply"));
        Enumeration enumeration = this.buttonHandlers.elements();
        while (enumeration.hasMoreElements()) {
            if (bl) {
                ((DialogButtonsListener)enumeration.nextElement()).buttonOK(actionEvent);
                continue;
            }
            if (bl2) {
                ((DialogButtonsListener)enumeration.nextElement()).buttonApply(actionEvent);
                continue;
            }
            ((DialogButtonsListener)enumeration.nextElement()).buttonCancel(actionEvent);
        }
    }

    public void buttonOK(ActionEvent actionEvent) {
        this.close();
    }

    public void buttonCancel(ActionEvent actionEvent) {
        this.cancel();
    }

    public void buttonApply(ActionEvent actionEvent) {
        this.apply();
    }

    public void addButtons(int n) {
        Serializable serializable;
        Panel panel = new Panel();
        Font font = new Font("SansSerif", 1, GUIManager.getFontPointSize(2));
        int n2 = 1;
        int n3 = n;
        while ((n3 >>= 1) != 0) {
            ++n2;
        }
        GridLayout gridLayout = this.horizontal ? new GridLayout(n2, 1) : new GridLayout(1, n2);
        gridLayout.setVgap(10);
        gridLayout.setHgap(10);
        panel.setLayout(gridLayout);
        if ((n & 1) == 1) {
            serializable = new Button(ResourceManager.getString("OK"));
            ((Component)serializable).setFont(font);
            ((Button)serializable).addActionListener(this);
            panel.add((Component)serializable);
        }
        if ((n & 2) == 2) {
            serializable = new Button(ResourceManager.getString("Apply"));
            ((Component)serializable).setFont(font);
            ((Button)serializable).addActionListener(this);
            panel.add((Component)serializable);
        }
        if ((n & 4) == 4) {
            serializable = new Button(ResourceManager.getString("Cancel"));
            ((Component)serializable).setFont(font);
            ((Button)serializable).addActionListener(this);
            panel.add((Component)serializable);
        }
        serializable = new GridBagConstraints();
        ((GridBagConstraints)serializable).fill = 0;
        ((GridBagConstraints)serializable).gridwidth = 0;
        ((GridBagConstraints)serializable).gridheight = 1;
        ((GridBagConstraints)serializable).insets = new Insets(5, 5, 5, 5);
        this.gridBag.setConstraints(panel, (GridBagConstraints)serializable);
        this.add(panel);
        this.addButtonListener(this);
    }

    private void positionDialog(Frame frame) {
        Dimension dimension = frame.getSize();
        Dimension dimension2 = this.getSize();
        Point point = frame.getLocation();
        Point point2 = new Point(point);
        point2.y += (dimension.height - dimension2.height) / 2;
        point2.x += (dimension.width - dimension2.width) / 2;
        ((Component)this).setLocation(point2);
    }

    public void show() {
        Frame frame = DialogBox.getParentFrame(this);
        ((Component)frame).setCursor(Cursor.getPredefinedCursor(3));
        this.setupPanels();
        this.pack();
        this.positionDialog(frame);
        super.show();
        ((Component)frame).setCursor(Cursor.getDefaultCursor());
    }

    public void apply() {
        this.applyPanels();
    }

    public boolean close() {
        this.closeStatus = 1;
        if (this.closePanels()) {
            this.dispose();
            return true;
        }
        return false;
    }

    public void cancel() {
        this.closeStatus = 4;
        this.cancelPanels();
        this.dispose();
    }

    public void addPanel(Panel panel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = this.horizontal ? 1 : 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.gridBag.setConstraints(panel, gridBagConstraints);
        this.add(panel);
    }

    public void addPanel(StatusPanel statusPanel) {
        this.addPanel((Panel)statusPanel);
        this.statusPanels.addElement(statusPanel);
    }

    public void setupPanels() {
        int n = 0;
        while (n < this.statusPanels.size()) {
            ((StatusPanel)this.statusPanels.elementAt(n)).setup();
            ++n;
        }
    }

    public void applyPanels() {
        int n = 0;
        while (n < this.statusPanels.size()) {
            ((StatusPanel)this.statusPanels.elementAt(n)).apply();
            ++n;
        }
    }

    public boolean closePanels() {
        boolean bl = true;
        int n = 0;
        while (n < this.statusPanels.size()) {
            if (!((StatusPanel)this.statusPanels.elementAt(n)).close()) {
                bl = false;
            }
            ++n;
        }
        return bl;
    }

    public void cancelPanels() {
        int n = 0;
        while (n < this.statusPanels.size()) {
            ((StatusPanel)this.statusPanels.elementAt(n)).cancel();
            ++n;
        }
    }

    public void setFlowHorizontal(boolean bl) {
        this.horizontal = bl;
    }

    public int closeStatus() {
        return this.closeStatus;
    }

    public DialogBox(String string, Container container) {
        super(DialogBox.getParentFrame(container), string);
        this.setLayout(this.gridBag);
        this.addWindowListener(new 1());
        this.setModal(true);
    }

    private final class 1
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            DialogBox.this.cancel();
        }

        /* synthetic */ 1() {
        }
    }
}

