#!/bin/sh
# Copyright(c) 2002 Sun Microsystems, Inc.
# All rights reserved.

#ident  "@(#)help.sh  1.4  02/04/16  SMI"

#============================================================
# This help script is to launch SunVTS help in netscape
#============================================================

type netscape >/dev/null 2>&1

if [ $? -ne 0 ]; then

  echo Could not invoke netscape to display online help.
  echo Please set the Netscape Path in your machine.
  if [ -n "$DISPLAY" ]; then
    if (type xterm >/dev/null 2>&1); then
      xterm -e  sh -c  '
       echo; echo; 
       echo Could not invoke netscape to display SunVTS online help.;
       echo Please set the Netscape Path in your machine.;
       echo Press Any Key to dismiss this window.;
       read ch'  &
    fi
  fi   
  exit 1

fi

LANG_DIR=$LANG
if [ -z "$LANG_DIR" ]; 
then
  LANG_DIR=C
fi

VTS_INST=`dirname $PWD`

# If help files are not installed for that LANG, display
# the one in C lang dir.
if [ ! -f $VTS_INST/lib/locale/$LANG_DIR/help/help.html ];
then
  LANG_DIR=C
fi

netscape $VTS_INST/lib/locale/$LANG_DIR/help/help.html &

exit 0
