/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.http;

public class Cookie
implements Cloneable {
    private String name;
    private String value;
    private String comment;
    private String domain;
    private int maxAge = -1;
    private String path;
    private boolean secure;
    private int version = 0;
    private static final String tspecials = "()<>@,;:\\\"/[]?={} \t";

    public Cookie(String string, String string2) {
        if (!this.isToken(string) || string.equalsIgnoreCase("Comment") || string.equalsIgnoreCase("Discard") || string.equalsIgnoreCase("Domain") || string.equalsIgnoreCase("Expires") || string.equalsIgnoreCase("Max-Age") || string.equalsIgnoreCase("Path") || string.equalsIgnoreCase("Secure") || string.equalsIgnoreCase("Version")) {
            throw new IllegalArgumentException("cookie name: " + string);
        }
        this.name = string;
        this.value = string2;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException.getMessage());
        }
    }

    public String getComment() {
        return this.comment;
    }

    public String getDomain() {
        return this.domain;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public boolean getSecure() {
        return this.secure;
    }

    public String getValue() {
        return this.value;
    }

    public int getVersion() {
        return this.version;
    }

    private boolean isToken(String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c < ' ' || c >= '\u007f' || tspecials.indexOf(c) != -1) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public void setDomain(String string) {
        this.domain = string.toLowerCase();
    }

    public void setMaxAge(int n) {
        this.maxAge = n;
    }

    public void setPath(String string) {
        this.path = string;
    }

    public void setSecure(boolean bl) {
        this.secure = bl;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public void setVersion(int n) {
        this.version = n;
    }
}

