/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.views.topology;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.SMRequestStatus;
import com.sun.symon.base.client.SMResourceAccess;
import com.sun.symon.base.client.alarm.SMAlarmStatusData;
import com.sun.symon.base.client.topology.SMFamilyCommands;
import com.sun.symon.base.client.topology.SMTopologyAdornmentData;
import com.sun.symon.base.client.topology.SMTopologyEntityViewData;
import com.sun.symon.base.client.topology.SMTopologyRequest;
import com.sun.symon.base.client.topology.SMTopologyResponse;
import com.sun.symon.base.console.views.CvContextPopupEvent;
import com.sun.symon.base.console.views.CvContextPopupListener;
import com.sun.symon.base.console.views.CvNavigationEvent;
import com.sun.symon.base.console.views.CvNavigationListener;
import com.sun.symon.base.console.views.CvPresentationView;
import com.sun.symon.base.console.views.CvSelectionInfo;
import com.sun.symon.base.console.views.CvToolTip;
import com.sun.symon.base.console.views.topology.CvTopBaseLinkEntity;
import com.sun.symon.base.console.views.topology.CvTopBusNodeEntity;
import com.sun.symon.base.console.views.topology.CvTopIconNodeEntity;
import com.sun.symon.base.console.views.topology.CvTopRingNodeEntity;
import com.sun.symon.base.console.views.topology.CvTopologyBusLayout;
import com.sun.symon.base.console.views.topology.CvTopologyDisplayEntity;
import com.sun.symon.base.console.views.topology.CvTopologyDisplayLink;
import com.sun.symon.base.console.views.topology.CvTopologyDisplayNode;
import com.sun.symon.base.console.views.topology.CvTopologyDisplayUnit;
import com.sun.symon.base.console.views.topology.CvTopologyGridLayout;
import com.sun.symon.base.console.views.topology.CvTopologyLayoutChangeListener;
import com.sun.symon.base.console.views.topology.CvTopologyLayoutManager;
import com.sun.symon.base.console.views.topology.CvTopologyLayoutUpdate;
import com.sun.symon.base.console.views.topology.CvTopologyListLayout;
import com.sun.symon.base.console.views.topology.CvTopologyMessageListener;
import com.sun.symon.base.console.views.topology.CvTopologyMover;
import com.sun.symon.base.console.views.topology.CvTopologySelectEvent;
import com.sun.symon.base.console.views.topology.CvTopologySelectListener;
import com.sun.symon.base.console.views.topology.CvTopologySpokedRingLayout;
import com.sun.symon.base.console.views.topology.CvTopologyStarLayout;
import com.sun.symon.base.console.views.topology.CvTopologyUI;
import com.sun.symon.base.console.views.topology.CvTopologyView;
import com.sun.symon.base.utility.UcDDL;
import com.sun.symon.base.utility.UcDialog;
import com.sun.symon.base.utility.UcInternationalizer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.border.EmptyBorder;

public class CvTopologyViewPanel
extends JComponent
implements CvPresentationView,
SMTopologyResponse,
ActionListener,
ComponentListener {
    private SMRawDataRequest RawDataSource = null;
    private SMTopologyRequest TopologyDataSource = null;
    private SMResourceAccess ResourceDataSource = null;
    private CvTopologyView TheView = null;
    private String ObjectUrl = null;
    private String RefreshPeriod = "120";
    private Object ChildReqHandle = null;
    private Object AdornmentReqHandle = null;
    private Hashtable ChildDisplayUnits = new Hashtable();
    private Vector EntityList = new Vector();
    private Vector AdornmentList = new Vector();
    private int DisableUpdateCnt = 0;
    private boolean UpdatePending = false;
    private Vector NavigationListeners = new Vector();
    private Vector PopupListeners = new Vector();
    private Vector SelectListeners = new Vector();
    private Vector MessageListeners = new Vector();
    private Vector LayoutListeners = new Vector();
    private Color RBandColour = new Color(0, 0, 0);
    private boolean Editable = true;
    private int NodeMargin = 10;
    private int NodeSpacing = 5;
    private String DefaultTopologyLayoutManager;
    private String TopologyLayoutManagerName = "grid";
    private CvTopologyLayoutManager TopologyLayoutManager = new CvTopologyGridLayout();
    private boolean TrackInProgress = false;
    private CvTopologyDisplayUnit[] PendingCutUnits;
    private Font StandardDisplayFont;
    private Font ItalicDisplayFont;
    private Object PanSyncObject = new Object();
    private Timer PanAndScanTimer = null;
    private int HorPanDirection = 0;
    private int VertPanDirection = 0;
    private int PanAndScanRate = -1;
    private Graphics SelectGC = null;
    private Graphics AntsGC = null;
    private int SelMvXOrig;
    private int SelMvYOrig;
    private int SelMvWidth;
    private int SelMvHeight;
    private int MoveXOffset;
    private int MoveYOffset;
    private int MoveXOrig;
    private int MoveYOrig;
    private boolean InvertSelect;
    private CvTopologyDisplayUnit PendingSelectUnit;
    private String PendingSelectIds = null;
    private Image DoubleBuffer = null;
    private Image BackgroundImg = null;
    private String BackgroundConfig = null;
    private boolean BackgroundTile = false;
    private Dimension SpaceSize = new Dimension(0, 0);
    private Point SpaceOrigin = new Point(0, 0);
    private int SelectMotionIndicator = 0;
    private static final int SELMOTION_NONE = 0;
    private static final int SELMOTION_RECTANGLE_SELECT = 1;
    private static final int SELMOTION_DRAW_SELECT = 2;
    private static final int SELMOTION_BUFFER_DRAG = 3;
    private static final int SELMOTION_PENDING = 4;
    private static final int SELMOTION_MOD_PENDING = 5;
    private static final int SELMOTION_MOVE = 6;

    public CvTopologyViewPanel(CvTopologyView cvTopologyView) throws Exception {
        this.TheView = cvTopologyView;
        this.setFont(new Font("Dialog", 0, 12));
        super.setBackground(new Color(255, 255, 255));
        this.enableEvents(49L);
        ToolTipManager.sharedInstance().registerComponent(this);
        ToolTipManager.sharedInstance().setDismissDelay(10000);
        this.handleNewSizing();
        this.setUI(CvTopologyUI.createUI(this));
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.updateCoordinates();
        this.requestUpdate(true);
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = this.PanSyncObject;
        synchronized (object) {
            int n;
            int n2;
            if (this.PanAndScanTimer == null) {
                return;
            }
            this.drawSelectMoveRect(this.SelectGC);
            if (this.HorPanDirection != 0) {
                n2 = this.TheView.getHorizontalScrollBar().getValue();
                this.TheView.getHorizontalScrollBar().setValue(n2 + this.HorPanDirection * 10);
                n = this.TheView.getHorizontalScrollBar().getValue() - n2;
                if (this.SelectMotionIndicator == 6) {
                    this.SelMvXOrig += n;
                } else {
                    this.SelMvWidth += n;
                }
            }
            if (this.VertPanDirection != 0) {
                n2 = this.TheView.getVerticalScrollBar().getValue();
                this.TheView.getVerticalScrollBar().setValue(n2 + this.VertPanDirection * 10);
                n = this.TheView.getVerticalScrollBar().getValue() - n2;
                if (this.SelectMotionIndicator == 6) {
                    this.SelMvYOrig += n;
                } else {
                    this.SelMvHeight += n;
                }
            }
            this.SelectGC = this.getGraphics();
            this.SelectGC.setColor(this.getBackground());
            this.SelectGC.setXORMode(this.RBandColour);
            this.drawSelectMoveRect(this.SelectGC);
            if (this.PanAndScanRate > 0) {
                this.PanAndScanTimer.setDelay(this.PanAndScanRate);
            }
        }
    }

    public void setAlternateColor(Color color) {
        this.RBandColour = color;
    }

    public Color getAlternateColor() {
        return this.RBandColour;
    }

    public void setManagedObjectUrl(String string) {
        this.ObjectUrl = string;
    }

    public void setStdRefreshPeriod(String string) {
        this.RefreshPeriod = string == null ? "120" : string;
    }

    public void addCvNavigationListener(CvNavigationListener cvNavigationListener) {
        Vector vector = this.NavigationListeners;
        synchronized (vector) {
            if (!this.NavigationListeners.contains(cvNavigationListener)) {
                this.NavigationListeners.addElement(cvNavigationListener);
            }
        }
    }

    public void removeCvNavigationListener(CvNavigationListener cvNavigationListener) {
        Vector vector = this.NavigationListeners;
        synchronized (vector) {
            this.NavigationListeners.removeElement(cvNavigationListener);
        }
    }

    public void addCvContextPopupListener(CvContextPopupListener cvContextPopupListener) {
        Vector vector = this.PopupListeners;
        synchronized (vector) {
            if (!this.PopupListeners.contains(cvContextPopupListener)) {
                this.PopupListeners.addElement(cvContextPopupListener);
            }
        }
    }

    public void addCvTopologyLayoutChangeListener(CvTopologyLayoutChangeListener cvTopologyLayoutChangeListener) {
        Vector vector = this.LayoutListeners;
        synchronized (vector) {
            if (!this.LayoutListeners.contains(cvTopologyLayoutChangeListener)) {
                this.LayoutListeners.addElement(cvTopologyLayoutChangeListener);
            }
        }
    }

    public void addCvTopologyMessageListener(CvTopologyMessageListener cvTopologyMessageListener) {
        Vector vector = this.MessageListeners;
        synchronized (vector) {
            if (!this.MessageListeners.contains(cvTopologyMessageListener)) {
                this.MessageListeners.addElement(cvTopologyMessageListener);
            }
        }
    }

    public void removeCvContextPopupListener(CvContextPopupListener cvContextPopupListener) {
        Vector vector = this.PopupListeners;
        synchronized (vector) {
            this.NavigationListeners.removeElement(cvContextPopupListener);
        }
    }

    public void addCvTopologySelectListener(CvTopologySelectListener cvTopologySelectListener) {
        Vector vector = this.SelectListeners;
        synchronized (vector) {
            if (!this.SelectListeners.contains(cvTopologySelectListener)) {
                this.SelectListeners.addElement(cvTopologySelectListener);
            }
        }
    }

    public void removeCvTopologySelectListener(CvTopologySelectListener cvTopologySelectListener) {
        Vector vector = this.SelectListeners;
        synchronized (vector) {
            this.SelectListeners.removeElement(cvTopologySelectListener);
        }
    }

    public void removeCvTopologyLayoutChangeListener(CvTopologyLayoutChangeListener cvTopologyLayoutChangeListener) {
        Vector vector = this.LayoutListeners;
        synchronized (vector) {
            this.LayoutListeners.removeElement(cvTopologyLayoutChangeListener);
        }
    }

    public void removeCvTopologyMessageListener(CvTopologyMessageListener cvTopologyMessageListener) {
        Vector vector = this.MessageListeners;
        synchronized (vector) {
            this.MessageListeners.removeElement(cvTopologyMessageListener);
        }
    }

    public void sendMessage(String string, boolean bl) {
        Vector vector;
        Vector vector2 = this.MessageListeners;
        synchronized (vector2) {
            vector = (Vector)this.MessageListeners.clone();
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            CvTopologyMessageListener cvTopologyMessageListener = (CvTopologyMessageListener)enumeration.nextElement();
            cvTopologyMessageListener.topoMessageOccurred(string, bl);
        }
    }

    public void setFont(Font font) {
        Object object;
        if (font == null) {
            return;
        }
        this.StandardDisplayFont = font;
        this.ItalicDisplayFont = new Font(font.getName(), 2, font.getSize());
        Enumeration enumeration = this.EntityList.elements();
        while (enumeration.hasMoreElements()) {
            object = (CvTopologyDisplayUnit)enumeration.nextElement();
            if (((CvTopologyDisplayUnit)object).getUserInfo() == null || !((Boolean)((CvTopologyDisplayUnit)object).getUserInfo()).booleanValue()) {
                ((CvTopologyDisplayUnit)object).setFont(this.StandardDisplayFont);
            } else {
                ((CvTopologyDisplayUnit)object).setFont(this.ItalicDisplayFont);
            }
            ((CvTopologyDisplayUnit)object).handleNewFont();
        }
        object = this.AdornmentList.elements();
        while (object.hasMoreElements()) {
            CvTopologyDisplayUnit cvTopologyDisplayUnit = (CvTopologyDisplayUnit)object.nextElement();
            cvTopologyDisplayUnit.setFont(this.StandardDisplayFont);
            cvTopologyDisplayUnit.handleNewFont();
        }
        super.setFont(font);
        this.requestUpdate(true);
    }

    public void setEditable(boolean bl) {
        this.Editable = bl;
    }

    public boolean getEditable() {
        return this.Editable;
    }

    public void setDefaultTopologyLayoutManager(String string) {
        this.DefaultTopologyLayoutManager = string;
    }

    public void setTopologyLayoutManager(String string) {
        if (this.TopologyDataSource != null) {
            CvTopologyLayoutUpdate cvTopologyLayoutUpdate = new CvTopologyLayoutUpdate(this, this.ObjectUrl, this.TopologyDataSource, this.TopologyLayoutManagerName, string);
            Thread thread = new Thread((Runnable)cvTopologyLayoutUpdate, "layout-save");
            thread.start();
        }
    }

    private void setTopologyLayoutManagerByName(String string) {
        if (string == null) {
            this.TopologyLayoutManagerName = "free";
            this.TopologyLayoutManager = null;
        } else if (string.equalsIgnoreCase("free")) {
            this.TopologyLayoutManagerName = "free";
            this.TopologyLayoutManager = null;
        } else if (string.equalsIgnoreCase("list")) {
            this.TopologyLayoutManagerName = "list";
            this.TopologyLayoutManager = new CvTopologyListLayout();
        } else if (string.equalsIgnoreCase("grid")) {
            this.TopologyLayoutManagerName = "grid";
            this.TopologyLayoutManager = new CvTopologyGridLayout();
        } else if (string.equalsIgnoreCase("bus")) {
            this.TopologyLayoutManagerName = "bus";
            this.TopologyLayoutManager = new CvTopologyBusLayout();
        } else if (string.equalsIgnoreCase("star")) {
            this.TopologyLayoutManagerName = "star";
            this.TopologyLayoutManager = new CvTopologyStarLayout();
        } else if (string.equalsIgnoreCase("spokedring")) {
            this.TopologyLayoutManagerName = "spokedring";
            this.TopologyLayoutManager = new CvTopologySpokedRingLayout();
        } else {
            try {
                Class<?> clazz = this.getClass().getClassLoader().loadClass(string);
                this.TopologyLayoutManagerName = string;
                this.TopologyLayoutManager = (CvTopologyLayoutManager)clazz.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                UcDDL.logErrorMessage((String)("Unknown layout manager " + string));
            }
            catch (ClassCastException classCastException) {
                UcDDL.logErrorMessage((String)("Invalid layout manager " + string));
            }
            catch (Exception exception) {
                UcDDL.logErrorMessage((String)"Layout manager instantiation error", (Throwable)exception);
            }
        }
        this.sendLayoutChange(this.TopologyLayoutManagerName);
        this.updateCoordinates();
        this.requestUpdate(true);
    }

    public void sendCurrentLayout() {
        this.sendLayoutChange(this.TopologyLayoutManagerName);
    }

    public void sendLayoutChange(String string) {
        Vector vector;
        Vector vector2 = this.LayoutListeners;
        synchronized (vector2) {
            vector = (Vector)this.LayoutListeners.clone();
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            CvTopologyLayoutChangeListener cvTopologyLayoutChangeListener = (CvTopologyLayoutChangeListener)enumeration.nextElement();
            cvTopologyLayoutChangeListener.layoutChangeOccurred(string);
        }
    }

    public void setMargin(int n) {
        this.NodeMargin = n;
    }

    public int getMargin() {
        return this.NodeMargin;
    }

    public void setSpacing(int n) {
        this.NodeSpacing = n;
    }

    public int getSpacing() {
        return this.NodeSpacing;
    }

    public void setDataSource(SMRawDataRequest sMRawDataRequest) {
        this.RawDataSource = sMRawDataRequest;
    }

    public void init() {
        this.TopologyDataSource = new SMTopologyRequest(this.RawDataSource);
        this.ResourceDataSource = new SMResourceAccess(this.RawDataSource);
        this.setTopologyLayoutManagerByName(this.DefaultTopologyLayoutManager);
        try {
            this.ChildReqHandle = this.TopologyDataSource.getEntityViewsRequest(this.ObjectUrl, this.RefreshPeriod, true, (SMTopologyResponse)this, null);
            this.AdornmentReqHandle = this.TopologyDataSource.getAdornmentsRequest(this.ObjectUrl, this.RefreshPeriod, (SMTopologyResponse)this, null);
        }
        catch (SMAPIException sMAPIException) {
            // empty catch block
        }
    }

    public void removeAllListeners() {
        this.NavigationListeners.removeAllElements();
        this.PopupListeners.removeAllElements();
        this.SelectListeners.removeAllElements();
    }

    public void shutdown() {
        Object object;
        try {
            if (this.ChildReqHandle != null) {
                this.RawDataSource.removeURLRequest(this.ChildReqHandle);
            }
            if (this.AdornmentReqHandle != null) {
                this.RawDataSource.removeURLRequest(this.AdornmentReqHandle);
            }
        }
        catch (SMAPIException sMAPIException) {
            // empty catch block
        }
        Enumeration enumeration = this.EntityList.elements();
        while (enumeration.hasMoreElements()) {
            object = (CvTopologyDisplayUnit)enumeration.nextElement();
            ((CvTopologyDisplayUnit)object).shutdown();
        }
        object = this.AdornmentList.elements();
        while (object.hasMoreElements()) {
            CvTopologyDisplayUnit cvTopologyDisplayUnit = (CvTopologyDisplayUnit)object.nextElement();
            cvTopologyDisplayUnit.shutdown();
        }
    }

    public JToolTip createToolTip() {
        return new CvToolTip();
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        if (this.SelectMotionIndicator != 0) {
            return null;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = n + this.SpaceOrigin.x;
        int n4 = n2 + this.SpaceOrigin.y;
        Enumeration enumeration = this.EntityList.elements();
        while (enumeration.hasMoreElements()) {
            CvTopologyDisplayUnit cvTopologyDisplayUnit = (CvTopologyDisplayUnit)enumeration.nextElement();
            if (!cvTopologyDisplayUnit.contains(n3, n4)) continue;
            SMAlarmStatusData sMAlarmStatusData = ((CvTopologyDisplayEntity)((Object)cvTopologyDisplayUnit)).getCurrentStatus();
            if (sMAlarmStatusData == null) {
                return null;
            }
            return sMAlarmStatusData.getStatusInToolTip("\n");
        }
        return null;
    }

    public void clearSelection() {
        Object object;
        Enumeration enumeration = this.EntityList.elements();
        while (enumeration.hasMoreElements()) {
            object = (CvTopologyDisplayUnit)enumeration.nextElement();
            ((CvTopologyDisplayUnit)object).setSelected(false);
        }
        object = this.AdornmentList.elements();
        while (object.hasMoreElements()) {
            CvTopologyDisplayUnit cvTopologyDisplayUnit = (CvTopologyDisplayUnit)object.nextElement();
            cvTopologyDisplayUnit.setSelected(false);
        }
        this.requestUpdate(true);
    }

    public void selectAll() {
        Object object;
        Enumeration enumeration = this.EntityList.elements();
        while (enumeration.hasMoreElements()) {
            object = (CvTopologyDisplayUnit)enumeration.nextElement();
            ((CvTopologyDisplayUnit)object).setSelected(true);
        }
        object = this.AdornmentList.elements();
        while (object.hasMoreElements()) {
            CvTopologyDisplayUnit cvTopologyDisplayUnit = (CvTopologyDisplayUnit)object.nextElement();
            cvTopologyDisplayUnit.setSelected(true);
        }
        this.requestUpdate(true);
        this.selectionChanged();
    }

    public void selectionChanged() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doSelectionChanged();
        } else {
            try {
                SwingUtilities.invokeAndWait(new SelectionChangedRunnable());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void doSelectionChanged() {
        Object object;
        Object object2;
        int n = 0;
        Enumeration enumeration = this.EntityList.elements();
        while (enumeration.hasMoreElements()) {
            object2 = (CvTopologyDisplayUnit)enumeration.nextElement();
            if (!((CvTopologyDisplayUnit)object2).getSelected()) continue;
            ++n;
        }
        object2 = this.AdornmentList.elements();
        while (object2.hasMoreElements()) {
            object = (CvTopologyDisplayUnit)object2.nextElement();
            if (!((CvTopologyDisplayUnit)object).getSelected()) continue;
            ++n;
        }
        object = new CvTopologySelectEvent(this.TheView, n);
        Vector vector = this.SelectListeners;
        synchronized (vector) {
            Enumeration enumeration2 = this.SelectListeners.elements();
            while (enumeration2.hasMoreElements()) {
                CvTopologySelectListener cvTopologySelectListener = (CvTopologySelectListener)enumeration2.nextElement();
                cvTopologySelectListener.selectionOccurred((CvTopologySelectEvent)object);
            }
        }
    }

    public CvTopologyDisplayEntity[] getSelectedEntities() {
        String[] stringArray = this.getSelectedEntityIds();
        if (stringArray.length == 0) {
            return null;
        }
        CvTopologyDisplayEntity[] cvTopologyDisplayEntityArray = new CvTopologyDisplayEntity[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            cvTopologyDisplayEntityArray[n] = (CvTopologyDisplayEntity)this.ChildDisplayUnits.get(stringArray[n]);
            ++n;
        }
        return cvTopologyDisplayEntityArray;
    }

    public String[] getSelectedNodeIds() {
        Object object;
        int n = 0;
        Enumeration enumeration = this.EntityList.elements();
        while (enumeration.hasMoreElements()) {
            object = (CvTopologyDisplayUnit)enumeration.nextElement();
            if (!(object instanceof CvTopologyDisplayNode) || !((CvTopologyDisplayUnit)object).getSelected()) continue;
            ++n;
        }
        object = new String[n];
        n = 0;
        Enumeration enumeration2 = this.EntityList.elements();
        while (enumeration2.hasMoreElements()) {
            CvTopologyDisplayUnit cvTopologyDisplayUnit = (CvTopologyDisplayUnit)enumeration2.nextElement();
            if (!(cvTopologyDisplayUnit instanceof CvTopologyDisplayNode) || !cvTopologyDisplayUnit.getSelected()) continue;
            object[n++] = cvTopologyDisplayUnit.getUnitId();
        }
        return object;
    }

    public String[] getSelectedEntityIds() {
        Object object;
        int n = 0;
        Enumeration enumeration = this.EntityList.elements();
        while (enumeration.hasMoreElements()) {
            object = (CvTopologyDisplayUnit)enumeration.nextElement();
            if (!((CvTopologyDisplayUnit)object).getSelected()) continue;
            ++n;
        }
        object = new String[n];
        n = 0;
        Enumeration enumeration2 = this.EntityList.elements();
        while (enumeration2.hasMoreElements()) {
            CvTopologyDisplayUnit cvTopologyDisplayUnit = (CvTopologyDisplayUnit)enumeration2.nextElement();
            if (!cvTopologyDisplayUnit.getSelected()) continue;
            object[n++] = cvTopologyDisplayUnit.getUnitId();
        }
        return object;
    }

    public String[] getSelectedAdornmentIds() {
        Object object;
        int n = 0;
        Enumeration enumeration = this.AdornmentList.elements();
        while (enumeration.hasMoreElements()) {
            object = (CvTopologyDisplayUnit)enumeration.nextElement();
            if (!((CvTopologyDisplayUnit)object).getSelected()) continue;
            ++n;
        }
        object = new String[n];
        n = 0;
        Enumeration enumeration2 = this.AdornmentList.elements();
        while (enumeration2.hasMoreElements()) {
            CvTopologyDisplayUnit cvTopologyDisplayUnit = (CvTopologyDisplayUnit)enumeration2.nextElement();
            if (!cvTopologyDisplayUnit.getSelected()) continue;
            object[n++] = cvTopologyDisplayUnit.getUnitId();
        }
        return object;
    }

    public CvSelectionInfo getSelectionInfo() {
        Object object;
        String[] stringArray = this.getSelectedEntityIds();
        CvContextPopupEvent cvContextPopupEvent = null;
        if (stringArray.length == 1) {
            CvTopologyDisplayEntity cvTopologyDisplayEntity = (CvTopologyDisplayEntity)this.ChildDisplayUnits.get(stringArray[0]);
            CvTopologyDisplayUnit cvTopologyDisplayUnit = (CvTopologyDisplayUnit)((Object)cvTopologyDisplayEntity);
            object = null;
            if (cvTopologyDisplayUnit instanceof CvTopologyDisplayLink) {
                object = "!cut !copy !edit";
            }
            if (cvTopologyDisplayEntity != null) {
                cvContextPopupEvent = new CvContextPopupEvent(this.TheView, "entity", null, cvTopologyDisplayEntity.getName(), cvTopologyDisplayEntity.getFamilyCommands(), 0, 0, this.ObjectUrl + "#" + cvTopologyDisplayUnit.getUnitId(), cvTopologyDisplayEntity.getNavigationUrl(), cvTopologyDisplayEntity.getTargetUrl(), (String)object, null);
            }
        }
        boolean bl = false;
        int n = 0;
        while (n < stringArray.length) {
            object = (CvTopologyDisplayEntity)this.ChildDisplayUnits.get(stringArray[n]);
            if (object instanceof CvTopologyDisplayLink) {
                String string = ((CvTopologyDisplayLink)object).getANode().getUnitId();
                String string2 = ((CvTopologyDisplayLink)object).getZNode().getUnitId();
                boolean bl2 = false;
                boolean bl3 = false;
                int n2 = 0;
                while (n2 < stringArray.length) {
                    if (string.equals(stringArray[n2])) {
                        bl2 = true;
                    }
                    if (string2.equals(stringArray[n2])) {
                        bl3 = true;
                    }
                    ++n2;
                }
                if (!bl2 || !bl3) {
                    bl = true;
                }
            }
            ++n;
        }
        object = new CvSelectionInfo(this.ObjectUrl, stringArray, cvContextPopupEvent);
        if (bl) {
            ((CvSelectionInfo)object).Exclusions = "!cut !copy";
        }
        return object;
    }

    public void selectNodesById(String string) {
        this.clearSelection();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        Rectangle rectangle = null;
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            CvTopologyDisplayEntity cvTopologyDisplayEntity = (CvTopologyDisplayEntity)this.ChildDisplayUnits.get(string2);
            CvTopologyDisplayUnit cvTopologyDisplayUnit = (CvTopologyDisplayUnit)((Object)cvTopologyDisplayEntity);
            if (cvTopologyDisplayEntity == null) continue;
            cvTopologyDisplayUnit.setSelected(true);
            Dimension dimension = cvTopologyDisplayUnit.getBounds();
            int n = cvTopologyDisplayUnit.getXOrigin() - dimension.width / 2;
            int n2 = cvTopologyDisplayUnit.getYOrigin() - dimension.height / 2;
            rectangle = rectangle == null ? new Rectangle(n, n2, dimension.width, dimension.height) : rectangle.union(new Rectangle(n, n2, dimension.width, dimension.height));
            bl = true;
        }
        if (rectangle != null) {
            this.scrollRectToVisible(rectangle);
        }
        this.PendingSelectIds = !bl ? string : null;
        this.requestUpdate(true);
        this.selectionChanged();
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        Enumeration enumeration;
        super.processMouseEvent(mouseEvent);
        String string = "sym//iso/org/dod/internet/private/enterprises/sun/prod/sunsymon/agent/base/mibman/modules/";
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = n + this.SpaceOrigin.x;
        int n4 = n2 + this.SpaceOrigin.y;
        if (mouseEvent.getID() == 501) {
            if (!this.hasFocus()) {
                this.requestFocus();
                this.repaint();
            }
            boolean bl = false;
            if (this.PendingCutUnits != null) {
                int n5 = 0;
                while (n5 < this.PendingCutUnits.length) {
                    if (this.PendingCutUnits[n5] != null && this.PendingCutUnits[n5].contains(n3, n4)) {
                        bl = true;
                    }
                    ++n5;
                }
            }
            if (bl) {
                this.TheView.clearCutInfo();
            }
        }
        if (mouseEvent.isPopupTrigger()) {
            Object object;
            Object object2;
            Object object3;
            int n6;
            enumeration = this.EntityList.elements();
            while (enumeration.hasMoreElements()) {
                CvTopologyDisplayUnit cvTopologyDisplayUnit = (CvTopologyDisplayUnit)enumeration.nextElement();
                CvTopologyDisplayEntity cvTopologyDisplayEntity = (CvTopologyDisplayEntity)((Object)cvTopologyDisplayUnit);
                if (!cvTopologyDisplayUnit.contains(n3, n4)) continue;
                this.clearSelection();
                cvTopologyDisplayUnit.setSelected(true);
                this.selectionChanged();
                n6 = this.TheView.getHorizontalScrollBar().getValue();
                int n7 = this.TheView.getVerticalScrollBar().getValue();
                object3 = null;
                if (cvTopologyDisplayUnit instanceof CvTopologyDisplayLink) {
                    object3 = "!cut !copy !edit";
                }
                object2 = null;
                object2 = cvTopologyDisplayEntity.getFamilyCommands();
                object = new CvContextPopupEvent(this.TheView, "entity", null, cvTopologyDisplayEntity.getName(), (SMFamilyCommands)object2, n - n6, n2 - n7, this.ObjectUrl + "#" + cvTopologyDisplayUnit.getUnitId(), cvTopologyDisplayEntity.getNavigationUrl(), cvTopologyDisplayEntity.getTargetUrl(), (String)object3, null);
                Vector vector = this.PopupListeners;
                synchronized (vector) {
                    Enumeration enumeration2 = this.PopupListeners.elements();
                    while (enumeration2.hasMoreElements()) {
                        CvContextPopupListener cvContextPopupListener = (CvContextPopupListener)enumeration2.nextElement();
                        cvContextPopupListener.contextPopupOccurred((CvContextPopupEvent)object);
                    }
                }
                if (mouseEvent.getID() != 501) continue;
                this.requestUpdate(true);
                return;
            }
            enumeration = this.AdornmentList.elements();
            while (enumeration.hasMoreElements()) {
                CvTopologyDisplayUnit cvTopologyDisplayUnit = (CvTopologyDisplayUnit)enumeration.nextElement();
                if (!cvTopologyDisplayUnit.contains(n3, n4)) continue;
                this.clearSelection();
                cvTopologyDisplayUnit.setSelected(true);
                this.selectionChanged();
                int n8 = this.TheView.getHorizontalScrollBar().getValue();
                n6 = this.TheView.getVerticalScrollBar().getValue();
                CvContextPopupEvent cvContextPopupEvent = new CvContextPopupEvent(this.TheView, "adorn", null, "", null, n - n8, n2 - n6, this.ObjectUrl + "#" + cvTopologyDisplayUnit.getUnitId(), "", "", null, null);
                object3 = this.PopupListeners;
                synchronized (object3) {
                    object2 = this.PopupListeners.elements();
                    while (object2.hasMoreElements()) {
                        object = (CvContextPopupListener)object2.nextElement();
                        object.contextPopupOccurred(cvContextPopupEvent);
                    }
                }
                if (mouseEvent.getID() != 501) continue;
                this.requestUpdate(true);
                return;
            }
        }
        if (mouseEvent.getID() == 502) {
            if (this.SelectMotionIndicator == 0) {
                return;
            }
            Object object = this.PanSyncObject;
            synchronized (object) {
                if (this.PanAndScanTimer != null) {
                    this.PanAndScanTimer.stop();
                    this.PanAndScanTimer = null;
                }
            }
            switch (this.SelectMotionIndicator) {
                case 4: {
                    this.selectionChanged();
                    break;
                }
                case 5: {
                    Object object4;
                    Object object5;
                    Object object6;
                    Object object7;
                    this.clearSelection();
                    this.PendingSelectUnit.setSelected(true);
                    if (mouseEvent.getClickCount() == 2 && this.PendingSelectUnit instanceof CvTopologyDisplayEntity) {
                        object7 = (CvTopologyDisplayEntity)((Object)this.PendingSelectUnit);
                        CvTopologyDisplayUnit cvTopologyDisplayUnit = this.PendingSelectUnit;
                        object6 = new CvNavigationEvent(this.TheView, object7.getName(), object7.getFamilyCommands().getNavigateSpec(), this.ObjectUrl + "#" + cvTopologyDisplayUnit.getUnitId(), object7.getNavigationUrl(), object7.getTargetUrl(), new String[]{cvTopologyDisplayUnit.getUnitId()}, new String[]{object7.getName()}, new String[]{object7.getNavigationUrl()});
                        object5 = this.NavigationListeners;
                        synchronized (object5) {
                            object4 = this.NavigationListeners.elements();
                            while (object4.hasMoreElements()) {
                                CvNavigationListener cvNavigationListener = (CvNavigationListener)object4.nextElement();
                                cvNavigationListener.navigationOccurred((CvNavigationEvent)object6);
                            }
                        }
                    }
                    this.selectionChanged();
                    break;
                }
                case 1: {
                    CvTopologyDisplayUnit cvTopologyDisplayUnit;
                    this.drawSelectMoveRect(this.SelectGC);
                    this.SelectGC = null;
                    if (this.SelMvWidth == 0 && this.SelMvHeight == 0) break;
                    if (this.SelMvWidth < 0) {
                        this.SelMvWidth = -this.SelMvWidth;
                        this.SelMvXOrig -= this.SelMvWidth;
                    }
                    if (this.SelMvHeight < 0) {
                        this.SelMvHeight = -this.SelMvHeight;
                        this.SelMvYOrig -= this.SelMvHeight;
                    }
                    this.SelMvXOrig += this.SpaceOrigin.x;
                    this.SelMvYOrig += this.SpaceOrigin.y;
                    Object object7 = new Rectangle(this.SelMvXOrig, this.SelMvYOrig, this.SelMvWidth, this.SelMvHeight);
                    enumeration = this.EntityList.elements();
                    while (enumeration.hasMoreElements()) {
                        cvTopologyDisplayUnit = (CvTopologyDisplayUnit)enumeration.nextElement();
                        if (!cvTopologyDisplayUnit.within((Rectangle)object7)) continue;
                        if (this.InvertSelect) {
                            cvTopologyDisplayUnit.invertSelected();
                            continue;
                        }
                        cvTopologyDisplayUnit.setSelected(true);
                    }
                    enumeration = this.AdornmentList.elements();
                    while (enumeration.hasMoreElements()) {
                        cvTopologyDisplayUnit = (CvTopologyDisplayUnit)enumeration.nextElement();
                        if (!cvTopologyDisplayUnit.within((Rectangle)object7)) continue;
                        if (this.InvertSelect) {
                            cvTopologyDisplayUnit.invertSelected();
                            continue;
                        }
                        cvTopologyDisplayUnit.setSelected(true);
                    }
                    this.selectionChanged();
                    break;
                }
                case 6: {
                    Object object8;
                    Object object9;
                    Object object6;
                    this.SelectGC = null;
                    if (!this.Editable || this.TopologyLayoutManager != null) break;
                    int n9 = n - this.MoveXOrig;
                    int n10 = n2 - this.MoveYOrig;
                    int n11 = 0;
                    enumeration = this.EntityList.elements();
                    while (enumeration.hasMoreElements()) {
                        object6 = (CvTopologyDisplayUnit)enumeration.nextElement();
                        if (!((CvTopologyDisplayUnit)object6).getSelected()) continue;
                        ++n11;
                    }
                    object6 = new String[n11];
                    Object object5 = new int[n11];
                    Object object4 = new int[n11];
                    int n12 = 0;
                    enumeration = this.EntityList.elements();
                    while (enumeration.hasMoreElements()) {
                        CvTopologyDisplayUnit cvTopologyDisplayUnit = (CvTopologyDisplayUnit)enumeration.nextElement();
                        if (!cvTopologyDisplayUnit.getSelected()) continue;
                        object6[n12] = cvTopologyDisplayUnit.getUnitId();
                        object5[n12] = cvTopologyDisplayUnit.getXOrigin() + n9;
                        object4[n12++] = cvTopologyDisplayUnit.getYOrigin() + n10;
                    }
                    int n13 = 0;
                    enumeration = this.AdornmentList.elements();
                    while (enumeration.hasMoreElements()) {
                        object9 = (CvTopologyDisplayUnit)enumeration.nextElement();
                        if (!((CvTopologyDisplayUnit)object9).getSelected()) continue;
                        ++n13;
                    }
                    object9 = new String[n13];
                    int[] nArray = new int[n13];
                    int[] nArray2 = new int[n13];
                    int n14 = 0;
                    enumeration = this.AdornmentList.elements();
                    while (enumeration.hasMoreElements()) {
                        object8 = (CvTopologyDisplayUnit)enumeration.nextElement();
                        if (!((CvTopologyDisplayUnit)object8).getSelected()) continue;
                        object6[n14] = ((CvTopologyDisplayUnit)object8).getUnitId();
                        object5[n14] = ((CvTopologyDisplayUnit)object8).getXOrigin() + n9;
                        object4[n14++] = ((CvTopologyDisplayUnit)object8).getYOrigin() + n10;
                    }
                    object8 = new CvTopologyMover(this, this.ObjectUrl, this.TopologyDataSource, (String[])object6, (int[])object5, (int[])object4, (String[])object9, nArray, nArray2, true);
                    Thread thread = new Thread((Runnable)object8, "topo-mover");
                    thread.start();
                }
            }
            this.SelectMotionIndicator = 0;
            this.InvertSelect = false;
            this.PendingSelectUnit = null;
            this.requestUpdate(true);
        }
        if (mouseEvent.getID() != 501) {
            return;
        }
        this.InvertSelect = mouseEvent.isShiftDown();
        enumeration = this.EntityList.elements();
        while (enumeration.hasMoreElements()) {
            CvTopologyDisplayUnit cvTopologyDisplayUnit = (CvTopologyDisplayUnit)enumeration.nextElement();
            if (!cvTopologyDisplayUnit.contains(n3, n4)) continue;
            this.PendingSelectUnit = cvTopologyDisplayUnit;
            if (cvTopologyDisplayUnit.getSelected() && !this.InvertSelect) {
                this.requestUpdate(true);
                this.SelectMotionIndicator = 5;
            } else {
                if (this.InvertSelect) {
                    this.PendingSelectUnit.invertSelected();
                } else {
                    this.clearSelection();
                    this.PendingSelectUnit.setSelected(true);
                }
                this.requestUpdate(true);
                this.SelectMotionIndicator = 4;
            }
            this.MoveXOrig = mouseEvent.getX();
            this.MoveYOrig = mouseEvent.getY();
            return;
        }
        enumeration = this.AdornmentList.elements();
        while (enumeration.hasMoreElements()) {
            CvTopologyDisplayUnit cvTopologyDisplayUnit = (CvTopologyDisplayUnit)enumeration.nextElement();
            if (!cvTopologyDisplayUnit.contains(n3, n4)) continue;
            this.PendingSelectUnit = cvTopologyDisplayUnit;
            if (cvTopologyDisplayUnit.getSelected() && !this.InvertSelect) {
                this.requestUpdate(true);
                this.SelectMotionIndicator = 5;
            } else {
                if (this.InvertSelect) {
                    this.PendingSelectUnit.invertSelected();
                } else {
                    this.clearSelection();
                    this.PendingSelectUnit.setSelected(true);
                }
                this.requestUpdate(true);
                this.SelectMotionIndicator = 4;
            }
            this.MoveXOrig = mouseEvent.getX();
            this.MoveYOrig = mouseEvent.getY();
            return;
        }
        if (!this.InvertSelect) {
            this.clearSelection();
            this.selectionChanged();
            this.requestUpdate(true);
        }
        this.SelectMotionIndicator = 1;
        this.SelectGC = this.getGraphics();
        this.SelectGC.setColor(this.getBackground());
        this.SelectGC.setXORMode(this.RBandColour);
        this.SelMvXOrig = mouseEvent.getX();
        this.SelMvYOrig = mouseEvent.getY();
        this.SelMvHeight = 0;
        this.SelMvWidth = 0;
        this.drawSelectMoveRect(this.SelectGC);
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        int n;
        super.processMouseMotionEvent(mouseEvent);
        if (this.SelectMotionIndicator == 0) {
            return;
        }
        int n2 = 250;
        if (this.TheView.getHorizontalScrollBar().isVisible()) {
            n = mouseEvent.getX() - this.TheView.getHorizontalScrollBar().getValue();
            if (n < -5) {
                this.HorPanDirection = -1;
                if (n < -50) {
                    n2 = 125;
                }
            } else {
                n = mouseEvent.getX() - this.TheView.getHorizontalScrollBar().getValue() - this.TheView.getSize().width;
                if (n > 5) {
                    this.HorPanDirection = 1;
                    if (n > 50) {
                        n2 = 125;
                    }
                } else {
                    this.HorPanDirection = 0;
                }
            }
        } else {
            this.HorPanDirection = 0;
        }
        if (this.TheView.getVerticalScrollBar().isVisible()) {
            n = mouseEvent.getY() - this.TheView.getVerticalScrollBar().getValue();
            if (n < -5) {
                this.VertPanDirection = -1;
                if (n < -50) {
                    n2 = 125;
                }
            } else {
                n = mouseEvent.getY() - this.TheView.getVerticalScrollBar().getValue() - this.TheView.getSize().height;
                if (n > 5) {
                    this.VertPanDirection = 1;
                    if (n > 50) {
                        n2 = 125;
                    }
                } else {
                    this.VertPanDirection = 0;
                }
            }
        } else {
            this.VertPanDirection = 0;
        }
        Object object = this.PanSyncObject;
        synchronized (object) {
            if (this.PanAndScanTimer == null) {
                if (this.HorPanDirection != 0 || this.VertPanDirection != 0) {
                    this.PanAndScanTimer = new Timer(n2, this);
                    this.PanAndScanTimer.start();
                    this.PanAndScanRate = n2;
                }
            } else if (this.HorPanDirection == 0 && this.VertPanDirection == 0) {
                this.PanAndScanTimer.stop();
                this.PanAndScanTimer = null;
                this.PanAndScanRate = -1;
            } else {
                this.PanAndScanRate = n2;
            }
        }
        switch (this.SelectMotionIndicator) {
            case 1: {
                Object object2 = this.PanSyncObject;
                synchronized (object2) {
                    this.drawSelectMoveRect(this.SelectGC);
                    this.SelMvWidth = mouseEvent.getX() - this.SelMvXOrig;
                    this.SelMvHeight = mouseEvent.getY() - this.SelMvYOrig;
                    this.drawSelectMoveRect(this.SelectGC);
                    break;
                }
            }
            case 4: 
            case 5: {
                int n3;
                Object object3;
                Object object4;
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    return;
                }
                int n4 = mouseEvent.getX() - this.MoveXOrig;
                int n5 = mouseEvent.getY() - this.MoveYOrig;
                if (n4 >= -2 && n4 <= 2 && n5 >= -2 && n5 <= 2) break;
                if (!this.Editable || this.TopologyLayoutManager != null) {
                    this.SelectMotionIndicator = 0;
                    return;
                }
                this.SelectGC = this.getGraphics();
                this.SelectGC.setColor(this.getBackground());
                this.SelectGC.setXORMode(this.RBandColour);
                if (!this.PendingSelectUnit.getSelected()) break;
                this.SelectMotionIndicator = 6;
                int n6 = Integer.MAX_VALUE;
                int n7 = Integer.MAX_VALUE;
                int n8 = -2147483647;
                int n9 = -2147483647;
                Enumeration enumeration = this.EntityList.elements();
                while (enumeration.hasMoreElements()) {
                    object4 = (CvTopologyDisplayUnit)enumeration.nextElement();
                    if (!((CvTopologyDisplayUnit)object4).getSelected()) continue;
                    object3 = ((CvTopologyDisplayUnit)object4).getBounds();
                    int n10 = ((CvTopologyDisplayUnit)object4).getXOrigin() - ((Dimension)object3).width / 2;
                    n3 = ((CvTopologyDisplayUnit)object4).getYOrigin() - ((Dimension)object3).height / 2;
                    if (n10 < n6) {
                        n6 = n10;
                    }
                    if (n3 < n7) {
                        n7 = n3;
                    }
                    n3 += ((Dimension)object3).height;
                    if ((n10 += ((Dimension)object3).width) > n8) {
                        n8 = n10;
                    }
                    if (n3 <= n9) continue;
                    n9 = n3;
                }
                object4 = this.AdornmentList.elements();
                while (object4.hasMoreElements()) {
                    object3 = (CvTopologyDisplayUnit)object4.nextElement();
                    if (!((CvTopologyDisplayUnit)object3).getSelected()) continue;
                    Dimension dimension = ((CvTopologyDisplayUnit)object3).getBounds();
                    n3 = ((CvTopologyDisplayUnit)object3).getXOrigin() - dimension.width / 2;
                    int n11 = ((CvTopologyDisplayUnit)object3).getYOrigin() - dimension.height / 2;
                    if (n3 < n6) {
                        n6 = n3;
                    }
                    if (n11 < n7) {
                        n7 = n11;
                    }
                    n11 += dimension.height;
                    if ((n3 += dimension.width) > n8) {
                        n8 = n3;
                    }
                    if (n11 <= n9) continue;
                    n9 = n11;
                }
                this.MoveXOffset = n6 - this.SpaceOrigin.x - this.MoveXOrig;
                this.MoveYOffset = n7 - this.SpaceOrigin.y - this.MoveYOrig;
                this.SelMvWidth = n8 - n6;
                this.SelMvHeight = n9 - n7;
                this.SelMvXOrig = mouseEvent.getX() + this.MoveXOffset;
                this.SelMvYOrig = mouseEvent.getY() + this.MoveYOffset;
                this.drawSelectMoveRect(this.SelectGC);
                break;
            }
            case 6: {
                Object object5 = this.PanSyncObject;
                synchronized (object5) {
                    this.drawSelectMoveRect(this.SelectGC);
                    this.SelMvXOrig = mouseEvent.getX() + this.MoveXOffset;
                    this.SelMvYOrig = mouseEvent.getY() + this.MoveYOffset;
                    this.drawSelectMoveRect(this.SelectGC);
                    break;
                }
            }
        }
    }

    public void paintBuffer(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        if (this.DoubleBuffer != null) {
            graphics.drawImage(this.DoubleBuffer, 0, 0, null);
        }
        if (this.SelectMotionIndicator == 0) {
            return;
        }
        switch (this.SelectMotionIndicator) {
            case 1: 
            case 6: {
                Object object = this.PanSyncObject;
                synchronized (object) {
                    graphics.setColor(this.getBackground());
                    graphics.setXORMode(this.RBandColour);
                    this.drawSelectMoveRect(graphics);
                    break;
                }
            }
        }
    }

    public void setPendingCutIds(String[] stringArray) {
        if (stringArray != null) {
            this.PendingCutUnits = new CvTopologyDisplayUnit[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                CvTopologyDisplayUnit cvTopologyDisplayUnit;
                this.PendingCutUnits[n] = cvTopologyDisplayUnit = (CvTopologyDisplayUnit)this.ChildDisplayUnits.get(stringArray[n]);
                ++n;
            }
        } else {
            this.PendingCutUnits = null;
        }
        this.requestUpdate(true);
    }

    private void drawTheAnts(Graphics graphics) {
        if (this.PendingCutUnits == null) {
            return;
        }
        int n = 0;
        while (n < this.PendingCutUnits.length) {
            if (this.PendingCutUnits[n] != null) {
                Dimension dimension = this.PendingCutUnits[n].getBounds();
                dimension.width += 8;
                dimension.height += 8;
                int n2 = this.PendingCutUnits[n].getXOrigin() - dimension.width / 2 - this.SpaceOrigin.x;
                int n3 = this.PendingCutUnits[n].getYOrigin() - dimension.height / 2 - this.SpaceOrigin.y;
                this.drawDashedLine(graphics, n2, n3 + dimension.height, n2 + dimension.width, n3 + dimension.height, true);
                this.drawDashedLine(graphics, n2 + dimension.width, n3 + dimension.height, n2 + dimension.width, n3, true);
                this.drawDashedLine(graphics, n2 + dimension.width, n3, n2, n3, true);
                this.drawDashedLine(graphics, n2, n3, n2, n3 + dimension.height, true);
            }
            ++n;
        }
    }

    public void walkTheAnts() {
        this.AntsGC = this.getGraphics();
        this.AntsGC.setColor(this.getBackground());
        this.AntsGC.setXORMode(this.RBandColour);
        if (this.AntsGC == null) {
            return;
        }
        if (this.PendingCutUnits == null) {
            return;
        }
        int n = 0;
        while (n < this.PendingCutUnits.length) {
            if (this.PendingCutUnits[n] != null) {
                Dimension dimension = this.PendingCutUnits[n].getBounds();
                dimension.width += 4;
                dimension.height += 4;
                int n2 = this.PendingCutUnits[n].getXOrigin() - dimension.width / 2 - this.SpaceOrigin.x;
                int n3 = this.PendingCutUnits[n].getYOrigin() - dimension.height / 2 - this.SpaceOrigin.y;
                this.AntsGC.drawRect(n2 + 1, n3, dimension.width, dimension.height);
            }
            ++n;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void drawDashedLine(Graphics var1_1, int var2_2, int var3_3, int var4_4, int var5_5, boolean var6_6) {
        block13: {
            block12: {
                var7_7 = 4;
                var8_8 = var4_4 - var2_2;
                var9_9 = var5_5 - var3_3;
                if (var8_8 != 0) break block12;
                if (var9_9 <= 0) ** GOTO lbl25
                while (var9_9 > 0) {
                    var10_10 = var9_9;
                    if (var10_10 > var7_7) {
                        var10_10 = var7_7;
                    }
                    if (var6_6) {
                        var1_1.drawLine(var2_2, var3_3, var2_2, var3_3 + var10_10);
                    }
                    var9_9 -= var10_10;
                    var3_3 += var10_10;
                    v0 = var6_6 = var6_6 == false;
                }
                break block13;
lbl-1000:
                // 1 sources

                {
                    var10_11 = var9_9;
                    if (var10_11 < -var7_7) {
                        var10_11 = -var7_7;
                    }
                    if (var6_6) {
                        var1_1.drawLine(var2_2, var3_3, var2_2, var3_3 + var10_11);
                    }
                    var9_9 -= var10_11;
                    var3_3 += var10_11;
                    v1 = var6_6 = var6_6 == false;
lbl25:
                    // 2 sources

                    ** while (var9_9 < 0)
                }
lbl26:
                // 1 sources

                break block13;
            }
            if (var8_8 <= 0) ** GOTO lbl48
            while (var8_8 > 0) {
                var10_12 = var8_8;
                if (var10_12 > var7_7) {
                    var10_12 = var7_7;
                }
                if (var6_6) {
                    var1_1.drawLine(var2_2, var3_3, var2_2 + var10_12, var3_3);
                }
                var8_8 -= var10_12;
                var2_2 += var10_12;
                v2 = var6_6 = var6_6 == false;
            }
            break block13;
lbl-1000:
            // 1 sources

            {
                var10_13 = var8_8;
                if (var10_13 < -var7_7) {
                    var10_13 = -var7_7;
                }
                if (var6_6) {
                    var1_1.drawLine(var2_2, var3_3, var2_2 + var10_13, var3_3);
                }
                var8_8 -= var10_13;
                var2_2 += var10_13;
                v3 = var6_6 = var6_6 == false;
lbl48:
                // 2 sources

                ** while (var8_8 < 0)
            }
        }
    }

    private void drawSelectMoveRect(Graphics graphics) {
        int n = this.SelMvXOrig;
        int n2 = this.SelMvYOrig;
        int n3 = this.SelMvWidth;
        int n4 = this.SelMvHeight;
        if (n3 < 0) {
            n3 = -n3;
            n -= n3;
        }
        if (n4 < 0) {
            n4 = -n4;
            n2 -= n4;
        }
        graphics.drawRect(n, n2, n3, n4);
    }

    public Dimension getSpatialSize() {
        return new Dimension(this.SpaceSize.width, this.SpaceSize.height);
    }

    private void updateCoordinates() {
        int n;
        int n2;
        if (this.TopologyLayoutManager == null) {
            Object object;
            String[] stringArray;
            int n3;
            int n4;
            Object object2;
            boolean bl = true;
            int n5 = 0;
            n2 = 0;
            n = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            Enumeration enumeration = this.EntityList.elements();
            while (enumeration.hasMoreElements()) {
                object2 = (CvTopologyDisplayUnit)enumeration.nextElement();
                ((CvTopologyDisplayUnit)object2).setListAlignment(false);
                if (!(object2 instanceof CvTopologyDisplayNode)) continue;
                Dimension dimension = ((CvTopologyDisplayUnit)object2).getBounds();
                if (((CvTopologyDisplayUnit)object2).getXCoord() == Integer.MAX_VALUE || ((CvTopologyDisplayUnit)object2).getYCoord() == Integer.MAX_VALUE) {
                    if (dimension.width > n2) {
                        n2 = dimension.width;
                    }
                    if (dimension.height <= n5) continue;
                    n5 = dimension.height;
                    continue;
                }
                n4 = ((CvTopologyDisplayUnit)object2).getXCoord() - dimension.width / 2;
                n3 = ((CvTopologyDisplayUnit)object2).getYCoord() - dimension.height / 2;
                if (bl || n4 < n) {
                    n = n4;
                }
                if (bl || n3 < n6) {
                    n6 = n3;
                }
                n3 += dimension.height;
                if (bl || (n4 += dimension.width) > n7) {
                    n7 = n4;
                }
                if (bl || n3 > n8) {
                    n8 = n3;
                }
                bl = false;
            }
            object2 = this.getSize();
            if (n7 == n) {
                n7 = n + ((Dimension)object2).width;
            }
            boolean bl2 = true;
            n4 = n;
            n3 = n8 + this.NodeSpacing;
            Vector<String[]> vector = new Vector<String[]>();
            Enumeration enumeration2 = this.EntityList.elements();
            while (enumeration2.hasMoreElements()) {
                stringArray = (String[])enumeration2.nextElement();
                if (!(stringArray instanceof CvTopologyDisplayNode)) continue;
                if (stringArray.getXCoord() != Integer.MAX_VALUE && stringArray.getYCoord() != Integer.MAX_VALUE) {
                    stringArray.setXOrigin(stringArray.getXCoord());
                    stringArray.setYOrigin(stringArray.getYCoord());
                    continue;
                }
                object = stringArray.getBounds();
                if (n4 + n2 > n7 && !bl2) {
                    n4 = n;
                    n3 += n5 + this.NodeSpacing;
                    bl2 = true;
                }
                stringArray.setXOrigin(n4 + n2 / 2);
                stringArray.setYOrigin(n3 + n5 / 2);
                bl2 = false;
                if ((n4 += n2 + this.NodeSpacing) > n7) {
                    n4 = n;
                    n3 += n5 + this.NodeSpacing;
                    bl2 = true;
                }
                vector.addElement(stringArray);
            }
            if (vector.size() > 0) {
                Object object3;
                stringArray = new String[vector.size()];
                object = new int[vector.size()];
                int[] nArray = new int[vector.size()];
                int n9 = 0;
                while (n9 < vector.size()) {
                    object3 = (CvTopologyDisplayUnit)vector.elementAt(n9);
                    stringArray[n9] = ((CvTopologyDisplayUnit)object3).getUnitId();
                    object[n9] = ((CvTopologyDisplayUnit)object3).getXOrigin();
                    nArray[n9] = ((CvTopologyDisplayUnit)object3).getYOrigin();
                    ++n9;
                }
                object3 = new String[]{};
                int[] nArray2 = new int[]{};
                int[] nArray3 = new int[]{};
                CvTopologyMover cvTopologyMover = new CvTopologyMover(this, this.ObjectUrl, this.TopologyDataSource, stringArray, (int[])object, nArray, (String[])object3, nArray2, nArray3, false);
                Thread thread = new Thread((Runnable)cvTopologyMover, "topo-mover");
                thread.start();
            }
        } else {
            Dimension dimension = this.getSize();
            Point point = null;
            if (this.BackgroundImg != null && !this.BackgroundTile) {
                n2 = this.BackgroundImg.getWidth(null);
                n = this.BackgroundImg.getHeight(null);
                if (n2 > 0 && n > 0) {
                    if (n2 > dimension.width) {
                        dimension.width = n2;
                    }
                    point = new Point(n2 / 2, n / 2);
                }
            }
            this.TopologyLayoutManager.performLayout(this, this.EntityList, dimension, point);
        }
        Enumeration enumeration = this.EntityList.elements();
        while (enumeration.hasMoreElements()) {
            CvTopologyDisplayUnit cvTopologyDisplayUnit = (CvTopologyDisplayUnit)enumeration.nextElement();
            if (!(cvTopologyDisplayUnit instanceof CvTopologyDisplayLink)) continue;
            ((CvTopologyDisplayLink)cvTopologyDisplayUnit).computeEndPoints();
        }
        Enumeration enumeration3 = this.AdornmentList.elements();
        while (enumeration3.hasMoreElements()) {
            CvTopologyDisplayUnit cvTopologyDisplayUnit = (CvTopologyDisplayUnit)enumeration3.nextElement();
            if (!(cvTopologyDisplayUnit instanceof CvTopologyDisplayLink)) continue;
            ((CvTopologyDisplayLink)cvTopologyDisplayUnit).computeEndPoints();
        }
        this.handleCoordinateChange();
    }

    private void handleCoordinateChange() {
        int n;
        Object object;
        Object object2;
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        Enumeration enumeration = this.EntityList.elements();
        while (enumeration.hasMoreElements()) {
            object2 = (CvTopologyDisplayUnit)enumeration.nextElement();
            object = ((CvTopologyDisplayUnit)object2).getBounds();
            if (bl) {
                n2 = ((CvTopologyDisplayUnit)object2).getXOrigin() - ((Dimension)object).width / 2;
                n3 = ((CvTopologyDisplayUnit)object2).getYOrigin() - ((Dimension)object).height / 2;
                n4 = n2 + ((Dimension)object).width;
                n5 = n3 + ((Dimension)object).height;
                bl = false;
                continue;
            }
            int n6 = ((CvTopologyDisplayUnit)object2).getXOrigin() - ((Dimension)object).width / 2;
            n = ((CvTopologyDisplayUnit)object2).getYOrigin() - ((Dimension)object).height / 2;
            if (n6 < n2) {
                n2 = n6;
            }
            if (n < n3) {
                n3 = n;
            }
            n += ((Dimension)object).height;
            if ((n6 += ((Dimension)object).width) > n4) {
                n4 = n6;
            }
            if (n <= n5) continue;
            n5 = n;
        }
        object2 = this.AdornmentList.elements();
        while (object2.hasMoreElements()) {
            object = (CvTopologyDisplayUnit)object2.nextElement();
            Dimension dimension = ((CvTopologyDisplayUnit)object).getBounds();
            if (bl) {
                n2 = ((CvTopologyDisplayUnit)object).getXOrigin() - dimension.width / 2;
                n3 = ((CvTopologyDisplayUnit)object).getYOrigin() - dimension.height / 2;
                n4 = n2 + dimension.width;
                n5 = n3 + dimension.height;
                bl = false;
                continue;
            }
            n = ((CvTopologyDisplayUnit)object).getXOrigin() - dimension.width / 2;
            int n7 = ((CvTopologyDisplayUnit)object).getYOrigin() - dimension.height / 2;
            if (n < n2) {
                n2 = n;
            }
            if (n7 < n3) {
                n3 = n7;
            }
            n7 += dimension.height;
            if ((n += dimension.width) > n4) {
                n4 = n;
            }
            if (n7 <= n5) continue;
            n5 = n7;
        }
        if (this.BackgroundImg != null && !this.BackgroundTile) {
            int n8 = this.BackgroundImg.getWidth(null);
            int n9 = this.BackgroundImg.getHeight(null);
            if (n2 > 0) {
                n2 = 0;
            }
            if (n3 > 0) {
                n3 = 0;
            }
            if (n4 < n8) {
                n4 = n8;
            }
            if (n5 < n9) {
                n5 = n9;
            }
        }
        n4 += this.NodeMargin;
        n5 += this.NodeMargin;
        boolean bl2 = false;
        if ((n2 -= this.NodeMargin) != this.SpaceOrigin.x || (n3 -= this.NodeMargin) != this.SpaceOrigin.y) {
            this.SpaceOrigin.setLocation(n2, n3);
            bl2 = true;
        }
        if (n4 - n2 != this.SpaceSize.width || n5 - n3 != this.SpaceSize.height) {
            this.SpaceSize.setSize(n4 - n2, n5 - n3);
            try {
                this.handleNewSizing();
                bl2 = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (bl2) {
            this.requestUpdate(true);
        }
    }

    public void processComponentEvent(ComponentEvent componentEvent) {
        if (componentEvent.getID() == 101) {
            try {
                this.handleNewSizing();
            }
            catch (Exception exception) {
                String string = "com.sun.symon.base.console.ConsoleMessages:";
                if (this.TopologyLayoutManagerName != null && this.TopologyLayoutManagerName.equals("grid")) {
                    UcDialog.showError((Component)this.TheView, (Object)UcInternationalizer.translateKey((String)(string + "topology.outofmem")));
                }
                UcDialog.showError((Component)this.TheView, (Object)UcInternationalizer.translateKey((String)(string + "topology.switchtogrid")));
                this.setTopologyLayoutManagerByName("grid");
                this.setTopologyLayoutManager("grid");
            }
        }
    }

    private void handleNewSizing() throws Exception {
        Dimension dimension = this.getSize();
        if (dimension.width == 0 || dimension.height == 0) {
            return;
        }
        try {
            this.DoubleBuffer = this.createImage(dimension.width, dimension.height);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new Exception();
        }
        this.requestUpdate(true);
    }

    private void disableUpdates(boolean bl) {
        CvTopologyViewPanel cvTopologyViewPanel = this;
        synchronized (cvTopologyViewPanel) {
            if (bl) {
                ++this.DisableUpdateCnt;
            } else if (this.DisableUpdateCnt > 0) {
                --this.DisableUpdateCnt;
            }
        }
        if (this.DisableUpdateCnt == 0 && this.UpdatePending) {
            this.requestUpdate(true);
        }
    }

    public void requestUpdate(boolean bl) {
        if (this.DisableUpdateCnt != 0) {
            this.UpdatePending = true;
            return;
        }
        this.UpdatePending = false;
        if (this.DoubleBuffer == null) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.doRequestUpdate(bl);
        } else {
            RequestUpdateRunnable requestUpdateRunnable = new RequestUpdateRunnable(bl);
            try {
                SwingUtilities.invokeAndWait(requestUpdateRunnable);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void doRequestUpdate(boolean bl) {
        Dimension dimension = this.getSize();
        Graphics graphics = this.DoubleBuffer.getGraphics();
        if (graphics == null) {
            return;
        }
        graphics.setFont(this.getFont());
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        if (this.BackgroundImg != null) {
            if (this.BackgroundTile) {
                int n = this.BackgroundImg.getWidth(null);
                int n2 = this.BackgroundImg.getHeight(null);
                if (n > 0 && n2 > 0) {
                    int n3 = 0;
                    int n4 = 0;
                    while (n4 < dimension.height) {
                        graphics.drawImage(this.BackgroundImg, n3, n4, null);
                        if ((n3 += n) <= dimension.width) continue;
                        n4 += n2;
                        n3 = 0;
                    }
                }
            } else {
                graphics.drawImage(this.BackgroundImg, -this.SpaceOrigin.x, -this.SpaceOrigin.y, null);
            }
        }
        if (this.TopologyLayoutManager != null) {
            this.TopologyLayoutManager.draw(graphics, -this.SpaceOrigin.x, -this.SpaceOrigin.y);
        }
        if (this.TopologyLayoutManager == null || this.TopologyLayoutManager.showAdornments()) {
            Enumeration enumeration = this.AdornmentList.elements();
            while (enumeration.hasMoreElements()) {
                CvTopologyDisplayUnit cvTopologyDisplayUnit = (CvTopologyDisplayUnit)enumeration.nextElement();
                if (!(cvTopologyDisplayUnit instanceof CvTopologyDisplayLink)) continue;
                graphics.setFont(cvTopologyDisplayUnit.getFont());
                cvTopologyDisplayUnit.draw(graphics, -this.SpaceOrigin.x, -this.SpaceOrigin.y);
            }
            Enumeration enumeration2 = this.AdornmentList.elements();
            while (enumeration2.hasMoreElements()) {
                CvTopologyDisplayUnit cvTopologyDisplayUnit = (CvTopologyDisplayUnit)enumeration2.nextElement();
                if (cvTopologyDisplayUnit instanceof CvTopologyDisplayLink) continue;
                graphics.setFont(cvTopologyDisplayUnit.getFont());
                cvTopologyDisplayUnit.draw(graphics, -this.SpaceOrigin.x, -this.SpaceOrigin.y);
            }
        }
        if (this.TopologyLayoutManager == null || this.TopologyLayoutManager.showLinks()) {
            Enumeration enumeration = this.EntityList.elements();
            while (enumeration.hasMoreElements()) {
                CvTopologyDisplayUnit cvTopologyDisplayUnit = (CvTopologyDisplayUnit)enumeration.nextElement();
                if (!(cvTopologyDisplayUnit instanceof CvTopologyDisplayLink)) continue;
                graphics.setFont(cvTopologyDisplayUnit.getFont());
                cvTopologyDisplayUnit.draw(graphics, -this.SpaceOrigin.x, -this.SpaceOrigin.y);
            }
        }
        Enumeration enumeration = this.EntityList.elements();
        while (enumeration.hasMoreElements()) {
            CvTopologyDisplayUnit cvTopologyDisplayUnit = (CvTopologyDisplayUnit)enumeration.nextElement();
            if (cvTopologyDisplayUnit instanceof CvTopologyDisplayLink) continue;
            graphics.setFont(cvTopologyDisplayUnit.getFont());
            cvTopologyDisplayUnit.draw(graphics, -this.SpaceOrigin.x, -this.SpaceOrigin.y);
        }
        graphics.setColor(this.getBackground());
        graphics.setXORMode(this.RBandColour);
        if (this.PendingCutUnits != null) {
            this.drawTheAnts(graphics);
        }
        if (bl) {
            this.resizeAndRepaint();
        }
    }

    public void resizeAndRepaint() {
        this.revalidate();
        this.repaint();
    }

    public void finishEntityMove(String[] stringArray, int[] nArray, int[] nArray2) {
        int n = 0;
        while (n < stringArray.length) {
            CvTopologyDisplayUnit cvTopologyDisplayUnit = (CvTopologyDisplayUnit)this.ChildDisplayUnits.get(stringArray[n]);
            if (cvTopologyDisplayUnit != null) {
                cvTopologyDisplayUnit.setXCoord(nArray[n]);
                cvTopologyDisplayUnit.setYCoord(nArray2[n]);
            }
            ++n;
        }
    }

    public void finishAdornMove(String[] stringArray, int[] nArray, int[] nArray2) {
        int n = 0;
        while (n < stringArray.length) {
            CvTopologyDisplayUnit cvTopologyDisplayUnit = (CvTopologyDisplayUnit)this.ChildDisplayUnits.get(stringArray[n]);
            if (cvTopologyDisplayUnit != null) {
                cvTopologyDisplayUnit.setXCoord(nArray[n]);
                cvTopologyDisplayUnit.setYCoord(nArray2[n]);
            }
            ++n;
        }
    }

    public Image getImage(String string) {
        return this.ResourceDataSource.getImage(string);
    }

    public void getAdornmentsResponse(SMRequestStatus sMRequestStatus, SMTopologyAdornmentData[] sMTopologyAdornmentDataArray, Object object) {
        if (sMRequestStatus.getReturnCode() != 0) {
            return;
        }
        this.disableUpdates(true);
        try {
            block14: {
                try {
                    int n = 0;
                    while (n < sMTopologyAdornmentDataArray.length) {
                        String string;
                        SMTopologyAdornmentData sMTopologyAdornmentData = sMTopologyAdornmentDataArray[n];
                        if (sMTopologyAdornmentData.getAdornmentType().compareTo("background") == 0) {
                            string = sMTopologyAdornmentData.getAdornmentConfig();
                            if (this.BackgroundConfig == null || this.BackgroundConfig.compareTo(string) != 0) {
                                this.BackgroundConfig = string;
                                int n2 = string.indexOf(124);
                                if (n2 < 0) {
                                    this.BackgroundImg = this.ResourceDataSource.getImage(string);
                                    this.BackgroundTile = false;
                                } else {
                                    this.BackgroundTile = string.substring(0, 4).compareTo("true") == 0;
                                    if (n2 >= string.length()) {
                                        this.BackgroundImg = null;
                                    } else {
                                        string = string.substring(n2 + 1);
                                        this.BackgroundImg = this.ResourceDataSource.getImage(string);
                                    }
                                }
                                this.requestUpdate(true);
                            }
                        } else if (sMTopologyAdornmentData.getAdornmentType().compareTo("layout") == 0) {
                            string = sMTopologyAdornmentData.getAdornmentConfig();
                            this.setTopologyLayoutManagerByName(string);
                        }
                        ++n;
                    }
                    if (sMTopologyAdornmentDataArray.length == 0) break block14;
                    this.updateCoordinates();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    Object var9_10 = null;
                    this.disableUpdates(false);
                }
            }
            Object var9_9 = null;
            this.disableUpdates(false);
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            this.disableUpdates(false);
            throw throwable;
        }
    }

    public void getEntityViewsResponse(SMRequestStatus sMRequestStatus, SMTopologyEntityViewData[] sMTopologyEntityViewDataArray, Object object) {
        if (sMRequestStatus.getReturnCode() != 0) {
            return;
        }
        this.disableUpdates(true);
        try {
            block45: {
                try {
                    String string;
                    Object object2;
                    Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
                    ClassLoader classLoader = this.getClass().getClassLoader();
                    int n = 0;
                    while (n < 2) {
                        int n2 = 0;
                        while (n2 < sMTopologyEntityViewDataArray.length) {
                            block43: {
                                Object object3;
                                Object object4;
                                Object object5;
                                CvTopologyDisplayNode cvTopologyDisplayNode;
                                CvTopologyDisplayNode cvTopologyDisplayNode2;
                                block44: {
                                    block47: {
                                        object2 = sMTopologyEntityViewDataArray[n2];
                                        string = object2.getEntityType();
                                        cvTopologyDisplayNode2 = null;
                                        cvTopologyDisplayNode = null;
                                        if (string.length() <= 5 || string.substring(0, 5).compareTo("link|") != 0) break block47;
                                        if (n != 0) {
                                            try {
                                                string = string.substring(5);
                                                int n3 = string.indexOf(124);
                                                object5 = string.substring(0, n3);
                                                string = string.substring(n3 + 1);
                                                n3 = string.indexOf(124);
                                                object4 = string.substring(0, n3);
                                                string = string.substring(n3 + 1);
                                                cvTopologyDisplayNode2 = (CvTopologyDisplayNode)hashtable.get(object5);
                                                cvTopologyDisplayNode = (CvTopologyDisplayNode)hashtable.get(object4);
                                                if (cvTopologyDisplayNode2 == null) break block43;
                                                if (cvTopologyDisplayNode == null) {
                                                }
                                                break block44;
                                            }
                                            catch (Exception exception) {}
                                        }
                                        break block43;
                                    }
                                    if (n != 0) break block43;
                                    if (string.length() >= 5 && string.substring(0, 5).compareTo("node|") == 0) {
                                        string = string.length() == 5 ? "" : string.substring(5);
                                    }
                                }
                                String string2 = object2.getEntityId();
                                object5 = null;
                                object4 = null;
                                int n4 = -1;
                                if (this.ChildDisplayUnits.containsKey(string2)) {
                                    CvTopologyDisplayUnit cvTopologyDisplayUnit = (CvTopologyDisplayUnit)this.ChildDisplayUnits.get(string2);
                                    n4 = this.EntityList.indexOf(cvTopologyDisplayUnit);
                                    object3 = cvTopologyDisplayUnit.getRepClass();
                                    if (((String)object3).compareTo(object2.getEntityType()) != 0) {
                                        cvTopologyDisplayUnit.shutdown();
                                        this.ChildDisplayUnits.remove(string2);
                                    } else {
                                        object5 = cvTopologyDisplayUnit;
                                    }
                                }
                                boolean bl = false;
                                if (object5 == null) {
                                    bl = true;
                                }
                                if (string.length() == 0 && object5 == null) {
                                    object5 = n == 0 ? new CvTopIconNodeEntity() : new CvTopBaseLinkEntity(cvTopologyDisplayNode2, cvTopologyDisplayNode);
                                    this.ChildDisplayUnits.put(string2, object5);
                                    ((CvTopologyDisplayUnit)object5).setUnitId(string2);
                                    ((CvTopologyDisplayUnit)object5).setRepClass(object2.getEntityType());
                                    ((CvTopologyDisplayUnit)object5).setParent(this);
                                    this.requestUpdate(true);
                                }
                                if (object5 == null) {
                                    if (string.compareTo("bus") == 0) {
                                        object5 = new CvTopBusNodeEntity();
                                    } else if (string.compareTo("ring") == 0) {
                                        object5 = new CvTopRingNodeEntity();
                                    } else {
                                        try {
                                            object3 = classLoader != null ? classLoader.loadClass(string) : Class.forName(string);
                                            try {
                                                Object obj = ((Class)object3).newInstance();
                                                object5 = (CvTopologyDisplayUnit)obj;
                                            }
                                            catch (Exception exception) {
                                                object5 = new CvTopIconNodeEntity();
                                            }
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            object5 = new CvTopIconNodeEntity();
                                        }
                                    }
                                    this.ChildDisplayUnits.put(string2, object5);
                                    ((CvTopologyDisplayUnit)object5).setUnitId(string2);
                                    ((CvTopologyDisplayUnit)object5).setRepClass(object2.getEntityType());
                                    ((CvTopologyDisplayUnit)object5).setParent(this);
                                    this.requestUpdate(true);
                                }
                                object4 = (CvTopologyDisplayEntity)object5;
                                if (bl) {
                                    ((CvTopologyDisplayUnit)object5).setUserInfo(new Boolean(object2.getIsSoftGroupLink()));
                                    if (!object2.getIsSoftGroupLink()) {
                                        ((CvTopologyDisplayUnit)object5).setFont(this.StandardDisplayFont);
                                    } else {
                                        ((CvTopologyDisplayUnit)object5).setFont(this.ItalicDisplayFont);
                                    }
                                }
                                hashtable.put(string2, object5);
                                if (n4 >= 0) {
                                    this.EntityList.setElementAt(object5, n4);
                                } else {
                                    this.EntityList.addElement(object5);
                                }
                                object3 = object2.getEntityDesc();
                                if (object3 == null) {
                                    object3 = "";
                                }
                                if (object4.getName().compareTo((String)object3) != 0) {
                                    this.requestUpdate(true);
                                }
                                object4.setName((String)object3);
                                if (this.TopologyLayoutManager == null && (((CvTopologyDisplayUnit)object5).getXCoord() != object2.getXCoord() || ((CvTopologyDisplayUnit)object5).getYCoord() != object2.getYCoord())) {
                                    this.requestUpdate(true);
                                }
                                ((CvTopologyDisplayUnit)object5).setXCoord(object2.getXCoord());
                                ((CvTopologyDisplayUnit)object5).setYCoord(object2.getYCoord());
                                ((CvTopologyDisplayUnit)object5).setConfigureInfo(object2.getEntityConfig());
                                object4.setFamilyImages(object2.getFamilyImages());
                                object4.setFamilyCommands(object2.getFamilyCommands());
                                object4.setNavigationUrl(object2.getNavigationUrl());
                                object4.setTargetUrl(object2.getTargetUrl());
                                if (object2.getAlarmStatusInfo() != null) {
                                    object4.setCurrentStatus(object2.getAlarmStatusInfo());
                                }
                                if (bl) {
                                    ((CvTopologyDisplayUnit)object5).init();
                                }
                            }
                            ++n2;
                        }
                        ++n;
                    }
                    Enumeration enumeration = this.ChildDisplayUnits.keys();
                    while (enumeration.hasMoreElements()) {
                        object2 = (String)enumeration.nextElement();
                        if (hashtable.containsKey(object2)) continue;
                        string = this.ChildDisplayUnits.get(object2);
                        ((CvTopologyDisplayUnit)((Object)string)).shutdown();
                        this.ChildDisplayUnits.remove(object2);
                        this.EntityList.removeElement(string);
                        this.requestUpdate(true);
                    }
                    if (this.PendingCutUnits != null) {
                        int n5 = 0;
                        while (n5 < this.PendingCutUnits.length) {
                            if (this.PendingCutUnits[n5] != null && !hashtable.containsKey(this.PendingCutUnits[n5].getUnitId())) {
                                this.PendingCutUnits[n5] = null;
                            }
                            ++n5;
                        }
                    }
                    this.updateCoordinates();
                    this.selectionChanged();
                    if (this.PendingSelectIds == null) break block45;
                    this.selectNodesById(this.PendingSelectIds);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    Object var20_28 = null;
                    this.disableUpdates(false);
                }
            }
            Object var20_27 = null;
            this.disableUpdates(false);
        }
        catch (Throwable throwable) {
            Object var20_29 = null;
            this.disableUpdates(false);
            throw throwable;
        }
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        if (this.EntityList.size() == 0) {
            return;
        }
        if (keyEvent.isShiftDown()) {
            Object object;
            if (keyEvent.getKeyCode() == 121) {
                Object object2;
                Object object3;
                Object object4;
                int n;
                CvTopologyDisplayUnit cvTopologyDisplayUnit;
                object = this.EntityList.elements();
                while (object.hasMoreElements()) {
                    cvTopologyDisplayUnit = (CvTopologyDisplayUnit)object.nextElement();
                    CvTopologyDisplayEntity cvTopologyDisplayEntity = (CvTopologyDisplayEntity)((Object)cvTopologyDisplayUnit);
                    if (!cvTopologyDisplayUnit.getSelected()) continue;
                    n = this.TheView.getHorizontalScrollBar().getValue();
                    int n2 = this.TheView.getVerticalScrollBar().getValue();
                    object4 = null;
                    if (cvTopologyDisplayUnit instanceof CvTopologyDisplayLink) {
                        object4 = "!cut !copy !edit";
                    }
                    object3 = null;
                    object3 = cvTopologyDisplayEntity.getFamilyCommands();
                    object2 = new CvContextPopupEvent(this.TheView, "entity", null, cvTopologyDisplayEntity.getName(), (SMFamilyCommands)object3, cvTopologyDisplayUnit.XOrigin - n, cvTopologyDisplayUnit.YOrigin - n2, this.ObjectUrl + "#" + cvTopologyDisplayUnit.getUnitId(), cvTopologyDisplayEntity.getNavigationUrl(), cvTopologyDisplayEntity.getTargetUrl(), (String)object4, null);
                    Vector vector = this.PopupListeners;
                    synchronized (vector) {
                        Enumeration enumeration = this.PopupListeners.elements();
                        while (enumeration.hasMoreElements()) {
                            CvContextPopupListener cvContextPopupListener = (CvContextPopupListener)enumeration.nextElement();
                            cvContextPopupListener.contextPopupOccurred((CvContextPopupEvent)object2);
                        }
                        break;
                    }
                }
                object = this.AdornmentList.elements();
                while (object.hasMoreElements()) {
                    cvTopologyDisplayUnit = (CvTopologyDisplayUnit)object.nextElement();
                    if (!cvTopologyDisplayUnit.getSelected()) continue;
                    int n3 = this.TheView.getHorizontalScrollBar().getValue();
                    n = this.TheView.getVerticalScrollBar().getValue();
                    CvContextPopupEvent cvContextPopupEvent = new CvContextPopupEvent(this.TheView, "adorn", null, "", null, cvTopologyDisplayUnit.XOrigin - n3, cvTopologyDisplayUnit.YOrigin - n, this.ObjectUrl + "#" + cvTopologyDisplayUnit.getUnitId(), "", "", null, null);
                    object4 = this.PopupListeners;
                    synchronized (object4) {
                        object3 = this.PopupListeners.elements();
                        while (object3.hasMoreElements()) {
                            object2 = (CvContextPopupListener)object3.nextElement();
                            object2.contextPopupOccurred(cvContextPopupEvent);
                        }
                        break;
                    }
                }
            }
            if (keyEvent.getKeyCode() == 40) {
                if (keyEvent.getID() != 401) {
                    keyEvent.consume();
                    return;
                }
                object = (CvTopologyDisplayUnit)this.EntityList.elementAt(0);
                int n = 0;
                while (n < this.EntityList.size() - 1) {
                    if (((CvTopologyDisplayUnit)this.EntityList.elementAt(n)).getSelected()) {
                        object = (CvTopologyDisplayUnit)this.EntityList.elementAt(n + 1);
                    }
                    ++n;
                }
                ((CvTopologyDisplayUnit)object).setSelected(true);
                this.selectionChanged();
                this.requestUpdate(true);
                return;
            }
            if (keyEvent.getKeyCode() == 38) {
                if (keyEvent.getID() != 401) {
                    keyEvent.consume();
                    return;
                }
                object = (CvTopologyDisplayUnit)this.EntityList.elementAt(this.EntityList.size() - 1);
                int n = this.EntityList.size() - 1;
                while (n > 0) {
                    if (((CvTopologyDisplayUnit)this.EntityList.elementAt(n)).getSelected()) {
                        object = (CvTopologyDisplayUnit)this.EntityList.elementAt(n - 1);
                    }
                    --n;
                }
                ((CvTopologyDisplayUnit)object).setSelected(true);
                this.selectionChanged();
                this.requestUpdate(true);
                return;
            }
        } else {
            if (keyEvent.getKeyCode() == 9) {
                if (keyEvent.getID() != 401) {
                    this.repaint();
                    keyEvent.consume();
                    return;
                }
                this.TheView.setBorder(new EmptyBorder(1, 1, 1, 1));
                this.repaint();
                return;
            }
            if (keyEvent.getKeyCode() == 40) {
                if (keyEvent.getID() != 401) {
                    keyEvent.consume();
                    return;
                }
                CvTopologyDisplayUnit cvTopologyDisplayUnit = (CvTopologyDisplayUnit)this.EntityList.elementAt(0);
                int n = 0;
                while (n < this.EntityList.size() - 1) {
                    if (((CvTopologyDisplayUnit)this.EntityList.elementAt(n)).getSelected()) {
                        cvTopologyDisplayUnit = (CvTopologyDisplayUnit)this.EntityList.elementAt(n + 1);
                        break;
                    }
                    ++n;
                }
                this.clearSelection();
                cvTopologyDisplayUnit.setSelected(true);
                this.selectionChanged();
                this.requestUpdate(true);
                return;
            }
            if (keyEvent.getKeyCode() == 38) {
                if (keyEvent.getID() != 401) {
                    keyEvent.consume();
                    return;
                }
                CvTopologyDisplayUnit cvTopologyDisplayUnit = (CvTopologyDisplayUnit)this.EntityList.elementAt(this.EntityList.size() - 1);
                int n = this.EntityList.size() - 1;
                while (n > 0) {
                    if (((CvTopologyDisplayUnit)this.EntityList.elementAt(n)).getSelected()) {
                        cvTopologyDisplayUnit = (CvTopologyDisplayUnit)this.EntityList.elementAt(n - 1);
                        break;
                    }
                    --n;
                }
                this.clearSelection();
                cvTopologyDisplayUnit.setSelected(true);
                this.selectionChanged();
                this.requestUpdate(true);
                return;
            }
        }
    }

    class RequestUpdateRunnable
    implements Runnable {
        private boolean repaint = false;

        RequestUpdateRunnable(boolean bl) {
            this.repaint = bl;
        }

        public void run() {
            CvTopologyViewPanel.this.doRequestUpdate(this.repaint);
        }
    }

    class SelectionChangedRunnable
    implements Runnable {
        SelectionChangedRunnable() {
        }

        public void run() {
            CvTopologyViewPanel.this.doSelectionChanged();
        }
    }
}

