/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.main;

import com.sun.symon.base.bootstrap.BsRMIBootstrap;
import com.sun.symon.base.bootstrap.BsRMIBootstrapException;
import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.SMResourceAccess;
import com.sun.symon.base.console.main.ConsoleLoginPanel;
import com.sun.symon.base.console.main.ConsoleVersion;
import com.sun.symon.base.console.main.CustomTextField;
import com.sun.symon.base.console.main.SymonConsoleLoginPanel;
import com.sun.symon.base.utility.UcDDL;
import com.sun.symon.base.utility.UcDialog;
import com.sun.symon.base.utility.UcInternationalizer;
import java.awt.Cursor;
import java.util.StringTokenizer;
import javax.swing.text.JTextComponent;

public class ConsoleLoginRunner
extends Thread {
    protected ConsoleLoginPanel Panel;
    protected BsRMIBootstrap Bootstrap;
    protected SMRawDataRequest rawHandle;
    protected String baseXFile;
    protected CustomTextField serverHost;
    static final String consolePkg = "base.console.main.ConsoleLogin:";

    public ConsoleLoginRunner(SymonConsoleLoginPanel symonConsoleLoginPanel, BsRMIBootstrap bsRMIBootstrap, String string) {
        super("console-runner");
        this.Panel = symonConsoleLoginPanel;
        this.Bootstrap = bsRMIBootstrap;
        this.baseXFile = string;
        this.serverHost = symonConsoleLoginPanel.serverHost;
    }

    public void run() {
        try {
            String string = this.Panel.passwordField.getText();
            String string2 = string.length() > 8 ? string.substring(0, 8) : string;
            this.Bootstrap.authenticate(this.Panel.loginIDTextfield.getText().trim(), string2, this.Panel.publicKey, this.Panel.securityScheme, this.Panel.wantEncryption);
        }
        catch (BsRMIBootstrapException bsRMIBootstrapException) {
            this.Panel.handleBootException(bsRMIBootstrapException);
            this.Panel.enableButtons(true);
            return;
        }
        this.Panel.statusMesg.setText(UcInternationalizer.translateKey((String)"base.console.main.ConsoleLogin:loginok", (boolean)true));
        this.Panel.statusBox.validate();
        this.Panel.frame.repaint();
        ((JTextComponent)this.Panel.passwordField).setText("");
        this.Panel.frame.repaint();
        this.rawHandle = new SMRawDataRequest(this.Bootstrap.getServerConn());
        UcDDL.logInfoMessage((String)("Sun Management Center Console " + ConsoleVersion.getVersion("desc")));
        ConsoleLoginRunner.checkVersion(this.rawHandle);
        this.baseXFile = ConsoleLoginRunner.getBaseXFile(this.rawHandle);
        ConsoleLoginRunner.checkLicense(this.rawHandle);
        try {
            this.Bootstrap.launch(this.baseXFile);
            this.Panel.loadComplete();
        }
        catch (BsRMIBootstrapException bsRMIBootstrapException) {
            this.Panel.handleBootException(bsRMIBootstrapException);
            this.Panel.loginButt.setEnabled(true);
            this.serverHost.addActionListener(this.Panel);
        }
        this.Panel.frame.setCursor(Cursor.getPredefinedCursor(0));
        this.Panel.frame.getToolkit().sync();
        this.Panel.frame.setCursor(Cursor.getPredefinedCursor(0));
        this.Panel.frame.getToolkit().sync();
    }

    public static void checkLicense(SMRawDataRequest sMRawDataRequest) {
        int n = 0;
        String string = null;
        String string2 = sMRawDataRequest.getServerVersion("revision");
        if (!string2.startsWith("2_0_00")) {
            SMResourceAccess sMResourceAccess = new SMResourceAccess(sMRawDataRequest);
            boolean bl = false;
            if (bl) {
                try {
                    n = sMRawDataRequest.getModuleLicense();
                    if (n == 1) {
                        string = UcInternationalizer.translateKey((String)"base.console.main.ConsoleLogin:licenseMissing", (boolean)true) + "\n" + UcInternationalizer.translateKey((String)"base.console.main.ConsoleLogin:licenseRequired", (boolean)true);
                    } else if (n == 2) {
                        string = UcInternationalizer.translateKey((String)"base.console.main.ConsoleLogin:licenseExpired", (boolean)true) + "\n" + UcInternationalizer.translateKey((String)"base.console.main.ConsoleLogin:licenseRequired", (boolean)true);
                    }
                }
                catch (SMAPIException sMAPIException) {
                    string = UcInternationalizer.translateKey((String)"base.console.main.ConsoleLogin:licenseError", (boolean)true);
                }
            }
            if (string != null) {
                ConsoleLoginPanel.showInvalidInfoDialog(string);
            }
        }
    }

    public static String getBaseXFile(SMRawDataRequest sMRawDataRequest) {
        String string = null;
        sMRawDataRequest.versionCheck(ConsoleVersion.getVersion("overall"));
        String string2 = ConsoleVersion.getVersion("revision");
        String string3 = sMRawDataRequest.getServerVersion("revision");
        if (string3 != null && !string3.equals("2_0_00_00") && !string2.equals(string3)) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "_");
            StringTokenizer stringTokenizer2 = new StringTokenizer(string3, "_");
            if (stringTokenizer.countTokens() == stringTokenizer2.countTokens()) {
                while (stringTokenizer.hasMoreTokens() || stringTokenizer2.hasMoreTokens()) {
                    String string4;
                    String string5 = stringTokenizer.nextToken();
                    if (string5.compareTo(string4 = stringTokenizer2.nextToken()) < 0) {
                        string = "base-console_" + string2 + ".x";
                    } else {
                        if (string5.compareTo(string4) <= 0) continue;
                        string = "base-console_" + string3 + ".x";
                    }
                    break;
                }
            }
        } else if (string2.equals(string3)) {
            string = "base-console_" + string3 + ".x";
        }
        return string;
    }

    private static void checkVersion(SMRawDataRequest sMRawDataRequest) {
        String string;
        String string2 = ConsoleVersion.getVersion("overall");
        if (!string2.equals(string = sMRawDataRequest.getServerVersion("overall"))) {
            UcDialog.showOk((String)(UcInternationalizer.translateKey((String)("base.console.main.ConsoleLogin:versionMismatch.server(" + string + ")")) + "\n" + UcInternationalizer.translateKey((String)("base.console.main.ConsoleLogin:versionMismatch.console(" + string2 + ")"))));
            sMRawDataRequest.disconnect();
            System.exit(0);
        }
    }
}

