/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.grouping.filter;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.config.SMConfig;
import com.sun.symon.base.client.config.SMPlatformName;
import com.sun.symon.base.client.console.SMConsoleContext;
import com.sun.symon.base.client.group.SMFilter;
import com.sun.symon.base.client.group.SMFilterCriteria;
import com.sun.symon.base.client.group.SMFilterData;
import com.sun.symon.base.client.group.SMFilterInfo;
import com.sun.symon.base.client.group.SMIPRangeCriteria;
import com.sun.symon.base.client.group.SMModuleCriteria;
import com.sun.symon.base.client.group.SMNameCriteria;
import com.sun.symon.base.client.group.SMOSCriteria;
import com.sun.symon.base.client.group.SMPlatformCriteria;
import com.sun.symon.base.client.module.SMModuleInfo;
import com.sun.symon.base.client.service.SMDBChangeEvent;
import com.sun.symon.base.client.service.SMDBChangeListener;
import com.sun.symon.base.client.service.SMDBObject;
import com.sun.symon.base.client.service.SMHandle;
import com.sun.symon.base.client.service.SMHandleRegistry;
import com.sun.symon.base.client.service.SMLengthException;
import com.sun.symon.base.console.grouping.CgComparableAdapter;
import com.sun.symon.base.console.grouping.CgFieldValidator;
import com.sun.symon.base.console.grouping.CgGlassPane;
import com.sun.symon.base.console.grouping.CgUtility;
import com.sun.symon.base.console.grouping.filter.CgFilterListEditor;
import com.sun.symon.base.console.manager.CmConsoleSession;
import com.sun.symon.base.utility.UcCommon;
import com.sun.symon.base.utility.UcURL;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;

public class CgFilterManager
extends JFrame
implements SMDBChangeListener {
    private static final String FM_FILTER = "FM_FILTER";
    private static final String FM_CONFIG = "FM_CONFIG";
    private boolean testing_ = false;
    private boolean reloadNeeded_ = false;
    private boolean formCleared_ = false;
    private CgFieldValidator nameValidator_ = new CgFieldValidator(32, 8L);
    private CgFieldValidator patternValidator_ = new CgFieldValidator(64, 1L);
    private CgFieldValidator fromIPValidator_ = new CgFieldValidator(31, 16L);
    private CgFieldValidator toIPValidator_ = new CgFieldValidator(31, 16L);
    private boolean isModified_ = false;
    private SMFilterInfo[] filters_;
    private SMFilterData filter_;
    private SMFilter filterHandle_;
    private CgComparableAdapter[] os_;
    private CgComparableAdapter[] platforms_;
    private CgComparableAdapter[] modules_;
    private boolean hasSetLists_ = false;
    private int currentRow_ = -1;
    BorderLayout mainBorderLayout_ = new BorderLayout();
    JPanel topPanel_ = new JPanel();
    JPanel buttonPanel_ = new JPanel();
    JButton closeButton_ = new JButton();
    JPanel closeButtonPanel_ = new JPanel();
    JButton helpButton_ = new JButton();
    JPanel detailsPanel_ = new JPanel();
    BorderLayout topInnerBorderLayout_ = new BorderLayout();
    GridLayout listGridLayout_ = new GridLayout();
    CgFilterListEditor platformPanel_ = new CgFilterListEditor();
    JPanel detailsBottomPanel_ = new JPanel();
    JPanel listPanel_ = new JPanel();
    CgFilterListEditor modulePanel_ = new CgFilterListEditor();
    CgFilterListEditor osPanel_ = new CgFilterListEditor();
    JLabel descriptionLabel_ = new JLabel();
    JPanel descriptionPanel_ = new JPanel();
    BorderLayout descriptionBorderLayout_ = new BorderLayout();
    JScrollPane descriptionScrollPane_ = new JScrollPane();
    JTextArea descriptionTextArea_ = new JTextArea(new CgFieldValidator(256, 0L));
    BorderLayout detailsBottomBorderLayout_ = new BorderLayout();
    GridBagLayout buttonGridBagLayout_ = new GridBagLayout();
    JPanel detailsTopPanel_ = new JPanel();
    JPanel detailsTopInnerPanel_ = new JPanel();
    JComboBox matchComboBox_ = new JComboBox();
    GridBagLayout detailsTopInnerGridBagLayout_ = new GridBagLayout();
    JTextField patternTextField_ = new JTextField();
    JTextField nameTextField_ = new JTextField();
    JCheckBox nameCheckBox_ = new JCheckBox();
    JLabel nameLabel_ = new JLabel();
    BorderLayout detailsTopBorderLayout_ = new BorderLayout();
    JPanel detailsBottomInnerPanel_ = new JPanel();
    JPanel IPPanel_ = new JPanel();
    JLabel toIPLabel_ = new JLabel();
    JCheckBox IPCheckBox_ = new JCheckBox();
    JTextField fromIPTextField_ = new JTextField();
    JTextField toIPTextField_ = new JTextField();
    GridBagLayout IPgridBagLayout_ = new GridBagLayout();
    JLabel fromIPLabel_ = new JLabel();
    BorderLayout detailsBottomInnerBorderLayout_ = new BorderLayout();
    JPanel topInnerPanel_ = new JPanel();
    BorderLayout topBorderLayout_ = new BorderLayout();
    JLabel filterTableLabel_ = new JLabel();
    GridBagLayout gridBagLayout3 = new GridBagLayout();
    JScrollPane tableScrollPane_ = new JScrollPane();
    JList table_ = new JList();
    JButton deleteButton_ = new JButton();
    JLabel statusLabel_ = new JLabel();
    GridLayout closeButtonGridLayout_ = new GridLayout();
    JPanel editButtonPanel_ = new JPanel();
    JPanel editButtonInnerPanel_ = new JPanel();
    JButton addButton_ = new JButton();
    GridLayout editorButtonGridLayout_ = new GridLayout();
    JButton changeButton_ = new JButton();
    JButton clearButton_ = new JButton();

    public CgFilterManager() {
        this(true);
    }

    public CgFilterManager(boolean bl) {
        this.testing_ = bl;
        this.setGlassPane(new CgGlassPane());
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.table_.setBackground(UcCommon.getLightGrayColor());
        this.platformPanel_.setDisablePanelFlag(true);
        this.platformPanel_.setPanelEnabled(false);
        this.modulePanel_.setDisablePanelFlag(true);
        this.modulePanel_.setPanelEnabled(false);
        this.osPanel_.setDisablePanelFlag(true);
        this.osPanel_.setPanelEnabled(false);
        ((JTextComponent)this.nameTextField_).setDocument(this.nameValidator_);
        this.nameTextField_.getDocument().addDocumentListener(new MyDocumentListener());
        ((JTextComponent)this.patternTextField_).setDocument(this.patternValidator_);
        this.patternTextField_.getDocument().addDocumentListener(new MyDocumentListener());
        ((JTextComponent)this.fromIPTextField_).setDocument(this.fromIPValidator_);
        this.fromIPTextField_.getDocument().addDocumentListener(new MyDocumentListener());
        ((JTextComponent)this.toIPTextField_).setDocument(this.toIPValidator_);
        this.toIPTextField_.getDocument().addDocumentListener(new MyDocumentListener());
        this.descriptionTextArea_.getDocument().addDocumentListener(new MyDocumentListener());
        this.statusLabel_.setForeground(Color.black);
        this.localize();
        this.table_.getSelectionModel().setSelectionMode(0);
        this.table_.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                CgFilterManager.this.tableRowSelected(listSelectionEvent);
            }
        });
        CgUtility.setLastEditedFilter("");
        this.clearStatusMessage();
        this.pack();
        ((Component)this).setSize(740, 720);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setLocation((int)(dimension.getWidth() - (double)this.getWidth()) / 2, (int)(dimension.getHeight() - (double)this.getHeight()) / 2);
        this.getRootPane().setDefaultButton(this.addButton_);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                CgFilterManager.this.dispose();
            }
        });
        ((Frame)this).setIconImage(CgUtility.getSunMCImage());
        ((Component)this).setVisible(true);
        this.nameTextField_.requestFocus();
        this.load();
    }

    public void dispose() {
        if (this.isModified() && !CgUtility.confirmDiscardChanges(this, CgUtility.getI18nMsg("standard.askDiscardChanges"))) {
            return;
        }
        if (this.filterHandle_ != null) {
            try {
                this.filterHandle_.removeDBChangeListener((SMDBChangeListener)this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.dispose();
    }

    public void setModified() {
        this.isModified_ = true;
        this.clearStatusMessage();
    }

    public void setStatusMessage(String string) {
        this.statusLabel_.setText(string);
    }

    public void clearStatusMessage() {
        this.setStatusMessage("");
    }

    public void setBusy(boolean bl) {
        CgUtility.setGlassPaneVisible(this, bl);
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(this.mainBorderLayout_);
        this.buttonPanel_.setLayout(this.buttonGridBagLayout_);
        this.buttonPanel_.setBorder(BorderFactory.createEmptyBorder(0, 12, 0, 12));
        this.buttonPanel_.setMinimumSize(new Dimension(700, 84));
        this.buttonPanel_.setPreferredSize(new Dimension(700, 84));
        this.closeButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CgFilterManager.this.closeButton__actionPerformed(actionEvent);
            }
        });
        this.closeButton_.setText("close");
        this.closeButtonPanel_.setLayout(this.closeButtonGridLayout_);
        this.helpButton_.setText("help");
        this.helpButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CgFilterManager.this.helpButton__actionPerformed(actionEvent);
            }
        });
        this.detailsPanel_.setLayout(this.topInnerBorderLayout_);
        this.listGridLayout_.setRows(3);
        this.listGridLayout_.setColumns(1);
        this.listPanel_.setLayout(this.listGridLayout_);
        this.descriptionLabel_.setText("description");
        this.descriptionPanel_.setLayout(this.descriptionBorderLayout_);
        this.descriptionPanel_.setBorder(BorderFactory.createEmptyBorder(10, 0, 5, 0));
        this.descriptionTextArea_.setRows(2);
        this.descriptionTextArea_.setMinimumSize(new Dimension(21, 34));
        this.detailsBottomPanel_.setLayout(this.detailsBottomBorderLayout_);
        this.detailsPanel_.setBorder(BorderFactory.createEmptyBorder(0, 12, 0, 12));
        this.detailsPanel_.setPreferredSize(new Dimension(709, 464));
        this.detailsTopInnerPanel_.setLayout(this.detailsTopInnerGridBagLayout_);
        this.patternTextField_.setEnabled(false);
        this.patternTextField_.setMinimumSize(new Dimension(150, 21));
        this.patternTextField_.setPreferredSize(new Dimension(150, 21));
        this.nameTextField_.setMinimumSize(new Dimension(150, 21));
        this.nameTextField_.setPreferredSize(new Dimension(150, 21));
        this.nameCheckBox_.setText("filterOnObjectLabel");
        this.nameCheckBox_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CgFilterManager.this.nameCheckBox__actionPerformed(actionEvent);
            }
        });
        this.nameLabel_.setText("filterName");
        this.detailsTopPanel_.setLayout(this.detailsTopBorderLayout_);
        this.IPPanel_.setLayout(this.IPgridBagLayout_);
        this.toIPLabel_.setText("to");
        this.IPCheckBox_.setText("filterOnIPAddresses");
        this.IPCheckBox_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CgFilterManager.this.IPCheckBox__actionPerformed(actionEvent);
            }
        });
        this.fromIPTextField_.setEnabled(false);
        this.fromIPTextField_.setMinimumSize(new Dimension(120, 21));
        this.fromIPTextField_.setPreferredSize(new Dimension(120, 21));
        this.toIPTextField_.setEnabled(false);
        this.toIPTextField_.setMinimumSize(new Dimension(120, 21));
        this.toIPTextField_.setPreferredSize(new Dimension(120, 21));
        this.fromIPLabel_.setText("from");
        this.detailsBottomInnerPanel_.setLayout(this.detailsBottomInnerBorderLayout_);
        this.matchComboBox_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CgFilterManager.this.matchComboBox__actionPerformed(actionEvent);
            }
        });
        this.topPanel_.setLayout(this.topBorderLayout_);
        this.filterTableLabel_.setText("filters");
        this.topInnerPanel_.setLayout(this.gridBagLayout3);
        this.tableScrollPane_.setPreferredSize(new Dimension(200, 80));
        this.deleteButton_.setEnabled(false);
        this.deleteButton_.setText("delete");
        this.deleteButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CgFilterManager.this.deleteButton__actionPerformed(actionEvent);
            }
        });
        this.topInnerPanel_.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.statusLabel_.setText("status");
        this.closeButtonGridLayout_.setColumns(2);
        this.closeButtonGridLayout_.setHgap(5);
        this.descriptionScrollPane_.setMinimumSize(new Dimension(24, 38));
        this.matchComboBox_.setEnabled(false);
        this.addButton_.setEnabled(true);
        this.addButton_.setText("saveFilter");
        this.addButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CgFilterManager.this.addButton__actionPerformed(actionEvent);
            }
        });
        this.editButtonInnerPanel_.setLayout(this.editorButtonGridLayout_);
        this.changeButton_.setEnabled(false);
        this.changeButton_.setText("updateFilter");
        this.changeButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CgFilterManager.this.changeButton__actionPerformed(actionEvent);
            }
        });
        this.clearButton_.setEnabled(true);
        this.clearButton_.setText("clearForm");
        this.clearButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CgFilterManager.this.clearButton__actionPerformed(actionEvent);
            }
        });
        this.editorButtonGridLayout_.setColumns(3);
        this.editorButtonGridLayout_.setHgap(5);
        this.getContentPane().add((Component)this.topPanel_, "North");
        this.topPanel_.add((Component)this.topInnerPanel_, "Center");
        this.topInnerPanel_.add((Component)this.filterTableLabel_, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.topInnerPanel_.add((Component)this.tableScrollPane_, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.topInnerPanel_.add((Component)this.deleteButton_, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.tableScrollPane_.getViewport().add((Component)this.table_, null);
        this.getContentPane().add((Component)this.detailsPanel_, "Center");
        this.detailsPanel_.add((Component)this.listPanel_, "Center");
        this.listPanel_.add((Component)this.platformPanel_, null);
        this.listPanel_.add((Component)this.osPanel_, null);
        this.listPanel_.add((Component)this.modulePanel_, null);
        this.detailsPanel_.add((Component)this.detailsBottomPanel_, "South");
        this.detailsBottomPanel_.add((Component)this.descriptionPanel_, "South");
        this.descriptionPanel_.add((Component)this.descriptionLabel_, "Center");
        this.descriptionPanel_.add((Component)this.descriptionScrollPane_, "South");
        this.detailsBottomPanel_.add((Component)this.detailsBottomInnerPanel_, "North");
        this.detailsBottomInnerPanel_.add((Component)this.IPPanel_, "West");
        this.IPPanel_.add((Component)this.IPCheckBox_, new GridBagConstraints(0, 0, 4, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.IPPanel_.add((Component)this.fromIPLabel_, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 18, 0, 0), 0, 0));
        this.IPPanel_.add((Component)this.toIPTextField_, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.IPPanel_.add((Component)this.toIPLabel_, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.IPPanel_.add((Component)this.fromIPTextField_, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 10), 0, 0));
        this.detailsPanel_.add((Component)this.detailsTopPanel_, "North");
        this.detailsTopPanel_.add((Component)this.detailsTopInnerPanel_, "West");
        this.detailsTopInnerPanel_.add((Component)this.nameLabel_, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.detailsTopInnerPanel_.add((Component)this.nameCheckBox_, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.detailsTopInnerPanel_.add((Component)this.nameTextField_, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.detailsTopInnerPanel_.add((Component)this.patternTextField_, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.detailsTopInnerPanel_.add((Component)this.matchComboBox_, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.buttonPanel_, "South");
        this.buttonPanel_.add((Component)this.closeButtonPanel_, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 12, 0), 0, 0));
        this.closeButtonPanel_.add((Component)this.closeButton_, null);
        this.closeButtonPanel_.add((Component)this.helpButton_, null);
        this.buttonPanel_.add((Component)this.statusLabel_, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 16, 2, new Insets(0, 0, 12, 0), 0, 0));
        this.buttonPanel_.add((Component)this.editButtonPanel_, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.editButtonPanel_.add((Component)this.editButtonInnerPanel_, null);
        this.editButtonInnerPanel_.add((Component)this.addButton_, null);
        this.editButtonInnerPanel_.add((Component)this.changeButton_, null);
        this.editButtonInnerPanel_.add((Component)this.clearButton_, null);
        this.descriptionScrollPane_.getViewport().add((Component)this.descriptionTextArea_, null);
        this.closeButton_.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CgFilterManager.this.closeButton__actionPerformed(actionEvent);
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
    }

    private void localize() {
        this.setTitle(CgUtility.getI18nMsg("task.newFilter"));
        this.filterTableLabel_.setText(CgUtility.getI18nMsg("filter.tableTitle"));
        this.filterTableLabel_.setLabelFor(this.table_);
        this.filterTableLabel_.setDisplayedMnemonic(CgUtility.getMnemonic("filter.tableTitle"));
        this.deleteButton_.setText(CgUtility.getI18nMsg("filter.deleteFilter"));
        this.deleteButton_.setMnemonic(CgUtility.getMnemonic("filter.deleteFilter"));
        MatchType[] matchTypeArray = new MatchType[]{new MatchType(CgUtility.getI18nMsg("filter.exactMatch"), "X"), new MatchType(CgUtility.getI18nMsg("filter.contains"), "C"), new MatchType(CgUtility.getI18nMsg("filter.startsWith"), "S"), new MatchType(CgUtility.getI18nMsg("filter.endsWith"), "E")};
        int n = 0;
        while (n < matchTypeArray.length) {
            this.matchComboBox_.addItem(matchTypeArray[n]);
            ++n;
        }
        this.nameLabel_.setText(CgUtility.getI18nMsg("filter.filterName") + ":");
        this.nameLabel_.setLabelFor(this.nameTextField_);
        this.nameLabel_.setDisplayedMnemonic(CgUtility.getMnemonic("filter.filterName"));
        this.nameCheckBox_.setText(CgUtility.getI18nMsg("filter.filterOnObjectLabel") + ":");
        this.nameCheckBox_.setMnemonic(CgUtility.getMnemonic("filter.filterOnObjectLabel"));
        this.platformPanel_.setCheckBoxText(CgUtility.getI18nMsg("filter.filterOnPlatform") + ":");
        this.platformPanel_.setCheckBoxMnemonic(CgUtility.getMnemonic("filter.filterOnPlatform"));
        this.osPanel_.setCheckBoxText(CgUtility.getI18nMsg("filter.filterOnOS") + ":");
        this.osPanel_.setCheckBoxMnemonic(CgUtility.getMnemonic("filter.filterOnOS"));
        this.modulePanel_.setCheckBoxText(CgUtility.getI18nMsg("filter.filterOnModule") + ":");
        this.modulePanel_.setCheckBoxMnemonic(CgUtility.getMnemonic("filter.filterOnModule"));
        this.IPCheckBox_.setText(CgUtility.getI18nMsg("filter.filterOnIP") + ":");
        this.IPCheckBox_.setMnemonic(CgUtility.getMnemonic("filter.filterOnIP"));
        this.fromIPLabel_.setText(CgUtility.getI18nMsg("standard.from") + ":");
        this.toIPLabel_.setText(CgUtility.getI18nMsg("standard.to") + ":");
        this.descriptionLabel_.setText(CgUtility.getI18nMsg("standard.description") + " (" + CgUtility.getI18nMsg("standard.optional") + ")");
        this.descriptionLabel_.setLabelFor(this.descriptionTextArea_);
        this.descriptionLabel_.setDisplayedMnemonic(CgUtility.getMnemonic("standard.description"));
        this.addButton_.setText(CgUtility.getI18nMsg("filter.message.addFilter"));
        this.changeButton_.setText(CgUtility.getI18nMsg("filter.updateFilter"));
        this.changeButton_.setMnemonic(CgUtility.getMnemonic("filter.updateFilter"));
        this.clearButton_.setText(CgUtility.getI18nMsg("standard.resetForm"));
        this.clearButton_.setMnemonic(CgUtility.getMnemonic("standard.resetForm"));
        this.closeButton_.setText(CgUtility.getI18nMsg("message.close"));
        this.helpButton_.setText(CgUtility.getI18nMsg("standard.help"));
        this.helpButton_.setMnemonic(CgUtility.getMnemonic("standard.help"));
    }

    private void load() {
        Thread thread = new Thread(){

            public void run() {
                CgFilterManager.this.setBusy(true);
                CgFilterManager.this.setStatusMessage(CgUtility.getI18nMsg("standard.loading") + "...");
                try {
                    try {
                        SMConfig sMConfig = (SMConfig)SMHandleRegistry.getInstance((String)"CONSOLE").getHandle(CgFilterManager.FM_CONFIG);
                        if (sMConfig == null) {
                            sMConfig = new SMConfig(SMConsoleContext.getInstance().getAPIHandle());
                            SMHandleRegistry.getInstance((String)"CONSOLE").addHandle(CgFilterManager.FM_CONFIG, (SMHandle)sMConfig);
                        }
                        String[] stringArray = sMConfig.getOperatingSystems();
                        SMPlatformName[] sMPlatformNameArray = sMConfig.getPlatformNames();
                        CgFilterManager.access$802(CgFilterManager.this, new CgComparableAdapter[stringArray.length]);
                        int n = 0;
                        while (n < stringArray.length) {
                            ((CgFilterManager)CgFilterManager.this).os_[n] = new CgComparableAdapter(stringArray[n], true);
                            ++n;
                        }
                        CgFilterManager.access$902(CgFilterManager.this, new CgComparableAdapter[sMPlatformNameArray.length]);
                        int n2 = 0;
                        while (n2 < sMPlatformNameArray.length) {
                            ((CgFilterManager)CgFilterManager.this).platforms_[n2] = new CgComparableAdapter(sMPlatformNameArray[n2]);
                            ++n2;
                        }
                        SMModuleInfo[] sMModuleInfoArray = CgUtility.getMDRModules(SMConsoleContext.getInstance().getAPIHandle());
                        if (sMModuleInfoArray.length == 0) {
                            Object var9_8 = null;
                            CgFilterManager.this.clearStatusMessage();
                            CgFilterManager.this.setBusy(false);
                            return;
                        }
                        CgFilterManager.access$1002(CgFilterManager.this, new CgComparableAdapter[sMModuleInfoArray.length]);
                        int n3 = 0;
                        while (n3 < sMModuleInfoArray.length) {
                            ((CgFilterManager)CgFilterManager.this).modules_[n3] = new CgComparableAdapter(sMModuleInfoArray[n3]);
                            ++n3;
                        }
                    }
                    catch (SMAPIException sMAPIException) {
                        CgUtility.showErrorMessage(CgUtility.getI18nMsg("filter.noConfigService"));
                        Object var9_10 = null;
                        CgFilterManager.this.clearStatusMessage();
                        CgFilterManager.this.setBusy(false);
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var9_11 = null;
                    CgFilterManager.this.clearStatusMessage();
                    CgFilterManager.this.setBusy(false);
                    throw throwable;
                }
                Object var9_9 = null;
                CgFilterManager.this.clearStatusMessage();
                CgFilterManager.this.setBusy(false);
                CgFilterManager.this.loadFilters();
            }
        };
        thread.start();
    }

    private void loadFilters() {
        this.reloadNeeded_ = false;
        final CgFilterManager cgFilterManager = this;
        Runnable runnable = new Runnable(){

            public void run() {
                CgFilterManager.this.setBusy(true);
                CgFilterManager.this.setStatusMessage(CgUtility.getI18nMsg("standard.loading") + "...");
                try {
                    try {
                        if (CgFilterManager.this.filterHandle_ == null) {
                            CgFilterManager.this.filterHandle_ = (SMFilter)SMHandleRegistry.getInstance((String)"CONSOLE").getHandle(CgFilterManager.FM_FILTER);
                            if (CgFilterManager.this.filterHandle_ == null) {
                                CgFilterManager.this.filterHandle_ = new SMFilter(SMConsoleContext.getInstance().getAPIHandle());
                                SMHandleRegistry.getInstance((String)"CONSOLE").addHandle(CgFilterManager.FM_FILTER, (SMHandle)CgFilterManager.this.filterHandle_);
                            }
                            CgFilterManager.this.filterHandle_.addDBChangeListener(cgFilterManager);
                        }
                        CgFilterManager.access$1302(CgFilterManager.this, CgFilterManager.this.filterHandle_.getAll());
                    }
                    catch (SMAPIException sMAPIException) {
                        CgUtility.showErrorMessage(CgUtility.getI18nMsg("filter.noService"));
                        Object var3_2 = null;
                        CgFilterManager.this.clearStatusMessage();
                        CgFilterManager.this.setBusy(false);
                        return;
                    }
                    Object var3_1 = null;
                    CgFilterManager.this.clearStatusMessage();
                    CgFilterManager.this.setBusy(false);
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    CgFilterManager.this.clearStatusMessage();
                    CgFilterManager.this.setBusy(false);
                    throw throwable;
                }
                Runnable runnable = new Runnable(this){
                    private final /* synthetic */ 14 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        if (!CgFilterManager.access$1500(14.access$1400(this.this$1))) {
                            CgFilterManager.access$1502(14.access$1400(this.this$1), true);
                            14.access$1400(this.this$1).osPanel_.setMasterList(CgFilterManager.access$800(14.access$1400(this.this$1)));
                            14.access$1400(this.this$1).platformPanel_.setMasterList(CgFilterManager.access$900(14.access$1400(this.this$1)));
                            14.access$1400(this.this$1).modulePanel_.setMasterList(CgFilterManager.access$1000(14.access$1400(this.this$1)));
                        }
                        Vector<FilterCellData> vector = new Vector<FilterCellData>();
                        14.access$1400(this.this$1).table_.removeAll();
                        int n = 0;
                        while (n < CgFilterManager.access$1300(14.access$1400(this.this$1)).length) {
                            vector.addElement(14.access$1400(this.this$1).new FilterCellData(CgFilterManager.access$1300(14.access$1400(this.this$1))[n]));
                            ++n;
                        }
                        14.access$1400(this.this$1).table_.setListData(vector);
                        CgFilterManager.access$1600(14.access$1400(this.this$1));
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }

            static /* synthetic */ CgFilterManager access$1400(14 var0) {
                return var0.CgFilterManager.this;
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            Thread thread = new Thread(runnable);
            thread.start();
        } else {
            runnable.run();
        }
    }

    private void loadFilter(final SMFilterInfo sMFilterInfo) {
        Thread thread = new Thread(){

            public void run() {
                CgFilterManager.this.setBusy(true);
                CgFilterManager.this.setStatusMessage(CgUtility.getI18nMsg("standard.loading") + "...");
                try {
                    try {
                        CgFilterManager.this.filter_ = CgFilterManager.this.filterHandle_.load(sMFilterInfo);
                    }
                    catch (SMAPIException sMAPIException) {
                        CgUtility.handleError(sMAPIException);
                        Object var3_2 = null;
                        CgFilterManager.this.clearStatusMessage();
                        CgFilterManager.this.setBusy(false);
                        return;
                    }
                    Object var3_1 = null;
                    CgFilterManager.this.clearStatusMessage();
                    CgFilterManager.this.setBusy(false);
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    CgFilterManager.this.clearStatusMessage();
                    CgFilterManager.this.setBusy(false);
                    throw throwable;
                }
                Runnable runnable = new Runnable(this){
                    private final /* synthetic */ 16 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        SMFilterCriteria[] sMFilterCriteriaArray = CgFilterManager.access$1700(16.access$1800(this.this$1)).getFilterCriteria();
                        int n = 0;
                        while (n < sMFilterCriteriaArray.length) {
                            SMNameCriteria sMNameCriteria;
                            if (sMFilterCriteriaArray[n] instanceof SMNameCriteria) {
                                sMNameCriteria = (SMNameCriteria)sMFilterCriteriaArray[n];
                                16.access$1800(this.this$1).nameCheckBox_.setSelected(sMNameCriteria.isEnabled());
                                16.access$1800(this.this$1).patternTextField_.setEnabled(sMNameCriteria.isEnabled());
                                16.access$1800(this.this$1).patternTextField_.setText(sMNameCriteria.getPattern());
                                CgFilterManager.access$1900(16.access$1800(this.this$1), sMNameCriteria.getMatchType());
                            } else if (sMFilterCriteriaArray[n] instanceof SMIPRangeCriteria) {
                                sMNameCriteria = (SMIPRangeCriteria)sMFilterCriteriaArray[n];
                                16.access$1800(this.this$1).IPCheckBox_.setSelected(sMNameCriteria.isEnabled());
                                16.access$1800(this.this$1).fromIPTextField_.setEnabled(sMNameCriteria.isEnabled());
                                16.access$1800(this.this$1).toIPTextField_.setEnabled(sMNameCriteria.isEnabled());
                                16.access$1800(this.this$1).fromIPTextField_.setText(sMNameCriteria.getFromAddress());
                                16.access$1800(this.this$1).toIPTextField_.setText(sMNameCriteria.getToAddress());
                            } else if (sMFilterCriteriaArray[n] instanceof SMPlatformCriteria) {
                                sMNameCriteria = (SMPlatformCriteria)sMFilterCriteriaArray[n];
                                16.access$1800(this.this$1).platformPanel_.setCheckboxSelected(sMNameCriteria.isEnabled());
                                16.access$1800(this.this$1).platformPanel_.setPanelEnabled(sMNameCriteria.isEnabled());
                                16.access$1800(this.this$1).platformPanel_.setSelectedList(CgFilterManager.access$2000(16.access$1800(this.this$1), sMNameCriteria.getList()));
                                16.access$1800(this.this$1).platformPanel_.setInclude(sMNameCriteria.isInclude());
                            } else if (sMFilterCriteriaArray[n] instanceof SMModuleCriteria) {
                                sMNameCriteria = (SMModuleCriteria)sMFilterCriteriaArray[n];
                                16.access$1800(this.this$1).modulePanel_.setCheckboxSelected(sMNameCriteria.isEnabled());
                                16.access$1800(this.this$1).modulePanel_.setPanelEnabled(sMNameCriteria.isEnabled());
                                16.access$1800(this.this$1).modulePanel_.setSelectedList(CgFilterManager.access$2100(16.access$1800(this.this$1), sMNameCriteria.getList()));
                                16.access$1800(this.this$1).modulePanel_.setInclude(sMNameCriteria.isInclude());
                            } else if (sMFilterCriteriaArray[n] instanceof SMOSCriteria) {
                                sMNameCriteria = (SMOSCriteria)sMFilterCriteriaArray[n];
                                16.access$1800(this.this$1).osPanel_.setCheckboxSelected(sMNameCriteria.isEnabled());
                                16.access$1800(this.this$1).osPanel_.setPanelEnabled(sMNameCriteria.isEnabled());
                                16.access$1800(this.this$1).osPanel_.setSelectedList(CgFilterManager.access$2200(16.access$1800(this.this$1), sMNameCriteria.getList()));
                                16.access$1800(this.this$1).osPanel_.setInclude(sMNameCriteria.isInclude());
                            }
                            ++n;
                        }
                        16.access$1800(this.this$1).changeButton_.setEnabled(true);
                        16.access$1800(this.this$1).deleteButton_.setEnabled(true);
                        CgFilterManager.access$2300(16.access$1800(this.this$1));
                        CgFilterManager.access$2402(16.access$1800(this.this$1), false);
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }

            static /* synthetic */ CgFilterManager access$1800(16 var0) {
                return var0.CgFilterManager.this;
            }
        };
        thread.start();
    }

    private void setMatchType(String string) {
        int n = 0;
        while (n < this.matchComboBox_.getItemCount()) {
            MatchType matchType = (MatchType)this.matchComboBox_.getItemAt(n);
            if (matchType.getType().equals(string)) {
                this.matchComboBox_.setSelectedIndex(n);
                return;
            }
            ++n;
        }
    }

    private CgComparableAdapter[] makePlatformList(String[] stringArray) {
        CgComparableAdapter[] cgComparableAdapterArray = new CgComparableAdapter[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            cgComparableAdapterArray[n] = new CgComparableAdapter(new SMPlatformName(stringArray[n]));
            ++n;
        }
        return cgComparableAdapterArray;
    }

    private CgComparableAdapter[] makeModuleList(String[] stringArray) {
        CgComparableAdapter[] cgComparableAdapterArray = new CgComparableAdapter[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            SMModuleInfo sMModuleInfo = this.getModuleInfo(stringArray[n]);
            cgComparableAdapterArray[n] = sMModuleInfo == null ? new CgComparableAdapter(stringArray[n]) : new CgComparableAdapter(sMModuleInfo);
            ++n;
        }
        return cgComparableAdapterArray;
    }

    private CgComparableAdapter[] makeOSList(String[] stringArray) {
        CgComparableAdapter[] cgComparableAdapterArray = new CgComparableAdapter[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            cgComparableAdapterArray[n] = new CgComparableAdapter(stringArray[n], true);
            ++n;
        }
        return cgComparableAdapterArray;
    }

    private SMModuleInfo getModuleInfo(String string) {
        int n = 0;
        while (n < this.modules_.length) {
            SMModuleInfo sMModuleInfo = (SMModuleInfo)this.modules_[n].getObject();
            if (sMModuleInfo.getModule().equals(string)) {
                return sMModuleInfo;
            }
            ++n;
        }
        return null;
    }

    private void clearModified() {
        this.isModified_ = false;
        this.osPanel_.clearModified();
        this.platformPanel_.clearModified();
        this.modulePanel_.clearModified();
    }

    private boolean isModified() {
        if (this.isModified_) {
            return true;
        }
        if (this.platformPanel_.isModified()) {
            return true;
        }
        if (this.osPanel_.isModified()) {
            return true;
        }
        return this.modulePanel_.isModified();
    }

    private SMFilterData getFilter() {
        SMNameCriteria sMNameCriteria;
        SMIPRangeCriteria sMIPRangeCriteria;
        Vector<Object> vector = new Vector<Object>();
        if (this.nameTextField_.getText().trim().equals("")) {
            this.setStatusMessage(CgUtility.getI18nMsg("filter.filterNameRequired"));
            return null;
        }
        try {
            sMIPRangeCriteria = this.getIPRangeCriteria();
            if (sMIPRangeCriteria != null) {
                vector.addElement(sMIPRangeCriteria);
            }
        }
        catch (Exception exception) {
            return null;
        }
        if (this.nameCheckBox_.isSelected()) {
            if (this.patternTextField_.getText().trim().equals("")) {
                this.setStatusMessage(CgUtility.getI18nMsg("filter.objectLabelRequired"));
                return null;
            }
            try {
                sMNameCriteria = new SMNameCriteria(((MatchType)this.matchComboBox_.getSelectedItem()).getType(), this.patternTextField_.getText().trim(), this.nameCheckBox_.isSelected());
                vector.addElement(sMNameCriteria);
            }
            catch (SMLengthException sMLengthException) {
                // empty catch block
            }
        }
        try {
            sMIPRangeCriteria = this.getPlatfromCriteria();
            if (sMIPRangeCriteria != null) {
                vector.addElement(sMIPRangeCriteria);
            }
            if ((sMIPRangeCriteria = this.getOSCriteria()) != null) {
                vector.addElement(sMIPRangeCriteria);
            }
            if ((sMIPRangeCriteria = this.getModuleCriteria()) != null) {
                vector.addElement(sMIPRangeCriteria);
            }
            if (vector.size() == 0) {
                this.setStatusMessage(CgUtility.getI18nMsg("filter.criteriaRequired"));
                return null;
            }
        }
        catch (Exception exception) {
            return null;
        }
        sMNameCriteria = new SMFilterData();
        try {
            sMNameCriteria.setName(this.nameTextField_.getText().trim());
            sMNameCriteria.setDescription(this.descriptionTextArea_.getText().trim());
        }
        catch (SMLengthException sMLengthException) {
            // empty catch block
        }
        SMFilterCriteria[] sMFilterCriteriaArray = new SMFilterCriteria[vector.size()];
        vector.toArray(sMFilterCriteriaArray);
        sMNameCriteria.setFilterCriteria(sMFilterCriteriaArray);
        return sMNameCriteria;
    }

    private SMPlatformCriteria getPlatfromCriteria() throws Exception {
        if (!this.platformPanel_.isCheckboxSelected()) {
            return null;
        }
        Object[] objectArray = this.platformPanel_.getSelectedList();
        if (objectArray.length == 0) {
            this.setStatusMessage(CgUtility.getI18nMsg("filter.platformsRequired"));
            throw new Exception();
        }
        String[] stringArray = new String[objectArray.length];
        int n = 0;
        while (n < stringArray.length) {
            SMPlatformName sMPlatformName = (SMPlatformName)((CgComparableAdapter)objectArray[n]).getObject();
            stringArray[n] = sMPlatformName.getName();
            ++n;
        }
        try {
            return new SMPlatformCriteria(stringArray, this.platformPanel_.isInclude(), this.platformPanel_.isCheckboxSelected());
        }
        catch (SMLengthException sMLengthException) {
            return null;
        }
    }

    private SMOSCriteria getOSCriteria() throws Exception {
        if (!this.osPanel_.isCheckboxSelected()) {
            return null;
        }
        Object[] objectArray = this.osPanel_.getSelectedList();
        if (objectArray.length == 0) {
            this.setStatusMessage(CgUtility.getI18nMsg("filter.osRequired"));
            throw new Exception();
        }
        String[] stringArray = new String[objectArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = (String)((CgComparableAdapter)objectArray[n]).getObject();
            ++n;
        }
        try {
            return new SMOSCriteria(stringArray, this.osPanel_.isInclude(), this.osPanel_.isCheckboxSelected());
        }
        catch (SMLengthException sMLengthException) {
            return null;
        }
    }

    private SMModuleCriteria getModuleCriteria() throws Exception {
        if (!this.modulePanel_.isCheckboxSelected()) {
            return null;
        }
        Object[] objectArray = this.modulePanel_.getSelectedList();
        if (objectArray.length == 0) {
            this.setStatusMessage(CgUtility.getI18nMsg("filter.modulesRequired"));
            throw new Exception();
        }
        String[] stringArray = new String[objectArray.length];
        int n = 0;
        while (n < stringArray.length) {
            Object object = ((CgComparableAdapter)objectArray[n]).getObject();
            stringArray[n] = object instanceof SMModuleInfo ? ((SMModuleInfo)object).getModule() : (String)object;
            ++n;
        }
        try {
            return new SMModuleCriteria(stringArray, this.modulePanel_.isInclude(), this.modulePanel_.isCheckboxSelected());
        }
        catch (SMLengthException sMLengthException) {
            return null;
        }
    }

    private SMIPRangeCriteria getIPRangeCriteria() throws Exception {
        if (!this.IPCheckBox_.isSelected()) {
            return null;
        }
        String string = this.fromIPTextField_.getText().trim();
        String string2 = this.toIPTextField_.getText().trim();
        if (this.IPCheckBox_.isSelected()) {
            if (string.length() == 0 && string2.length() == 0) {
                this.setStatusMessage(CgUtility.getI18nMsg("filter.invalidIPAddress"));
                throw new Exception();
            }
        } else if (string.length() == 0 && string2.length() == 0) {
            return null;
        }
        if (string.length() == 0 || string2.length() == 0) {
            this.setStatusMessage(CgUtility.getI18nMsg("filter.invalidIPAddress"));
            throw new Exception();
        }
        if (!UcURL.validateIpAddress((String)string) || !UcURL.validateIpAddress((String)string2)) {
            this.setStatusMessage(CgUtility.getI18nMsg("filter.invalidIPAddress"));
            throw new Exception();
        }
        if (!UcURL.compareIpSequence((String)string, (String)string2)) {
            String string3 = string;
            string = string2;
            string2 = string3;
            this.fromIPTextField_.setText(string);
            this.toIPTextField_.setText(string2);
        }
        try {
            return new SMIPRangeCriteria(string, string2, this.IPCheckBox_.isSelected());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.setStatusMessage(CgUtility.getI18nMsg("filter.invalidIPAddress"));
            throw new Exception();
        }
        catch (SMLengthException sMLengthException) {
            return null;
        }
    }

    private void clear() {
        this.nameTextField_.setText("");
        this.nameCheckBox_.setSelected(false);
        this.patternTextField_.setText("");
        this.patternTextField_.setEnabled(false);
        this.matchComboBox_.setSelectedIndex(0);
        this.matchComboBox_.setEnabled(false);
        this.platformPanel_.clear();
        this.osPanel_.clear();
        this.modulePanel_.clear();
        this.IPCheckBox_.setSelected(false);
        this.fromIPTextField_.setText("");
        this.toIPTextField_.setText("");
        this.fromIPTextField_.setEnabled(false);
        this.toIPTextField_.setEnabled(false);
        this.descriptionTextArea_.setText("");
        this.clearModified();
    }

    private void save(boolean bl) {
        SMFilterData sMFilterData = this.getFilter();
        if (sMFilterData == null) {
            return;
        }
        if (!bl && this.filter_ != null) {
            try {
                this.filter_.setName(sMFilterData.getName());
                this.filter_.setDescription(sMFilterData.getDescription());
                this.filter_.setFilterCriteria(sMFilterData.getFilterCriteria());
            }
            catch (SMLengthException sMLengthException) {
                // empty catch block
            }
            sMFilterData = this.filter_;
        }
        final SMFilterData sMFilterData2 = sMFilterData;
        this.setBusy(true);
        this.setStatusMessage(CgUtility.getI18nMsg("standard.saving") + "...");
        final CgFilterManager cgFilterManager = this;
        Thread thread = new Thread(){

            public void run() {
                try {
                    CgFilterManager.this.clearModified();
                    CgFilterManager.this.table_.clearSelection();
                    if (!CgUtility.saveObj(cgFilterManager, (SMHandle)CgFilterManager.this.filterHandle_, (SMDBObject)sMFilterData2)) {
                        CgFilterManager.this.setModified();
                    } else {
                        CgUtility.setLastEditedFilter(sMFilterData2.getName());
                    }
                    Object var2_1 = null;
                    CgFilterManager.this.clearStatusMessage();
                    CgFilterManager.this.setBusy(false);
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    CgFilterManager.this.clearStatusMessage();
                    CgFilterManager.this.setBusy(false);
                    throw throwable;
                }
            }
        };
        thread.start();
    }

    private void clearForm() {
        this.filter_ = null;
        this.clear();
        this.changeButton_.setEnabled(false);
        this.deleteButton_.setEnabled(false);
        this.table_.clearSelection();
        this.clearStatusMessage();
        this.currentRow_ = -1;
        this.formCleared_ = true;
    }

    public void changed(SMDBChangeEvent sMDBChangeEvent) throws SMAPIException {
        if (!this.isModified() && this.table_.getSelectedIndex() < 0) {
            this.loadFilters();
        } else {
            this.reloadNeeded_ = true;
        }
    }

    private void tableRowSelected(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        int n = this.table_.getSelectedIndex();
        if (n < 0) {
            this.currentRow_ = -1;
            return;
        }
        if (this.currentRow_ == n) {
            return;
        }
        if (this.isModified() && !CgUtility.confirmDiscardChanges(this, CgUtility.getI18nMsg("standard.askDiscardChanges"))) {
            this.table_.setSelectedIndex(this.currentRow_);
            return;
        }
        this.currentRow_ = n;
        SMFilterInfo sMFilterInfo = ((FilterCellData)this.table_.getSelectedValue()).getFilterInfo();
        this.clear();
        this.nameTextField_.setText(sMFilterInfo.getName());
        this.descriptionTextArea_.setText(sMFilterInfo.getDescription());
        this.loadFilter(sMFilterInfo);
    }

    private void deleteButton__actionPerformed(ActionEvent actionEvent) {
        if (!CgUtility.confirmDelete(this, CgUtility.getI18nMsg("filter.askFilterDelete"))) {
            return;
        }
        this.setBusy(true);
        this.setStatusMessage(CgUtility.getI18nMsg("standard.deleting") + "...");
        Thread thread = new Thread(){

            public void run() {
                SMFilterInfo sMFilterInfo = ((FilterCellData)CgFilterManager.this.table_.getSelectedValue()).getFilterInfo();
                try {
                    try {
                        CgFilterManager.this.clearForm();
                        CgFilterManager.this.filterHandle_.delete(sMFilterInfo.getObjectID());
                    }
                    catch (SMAPIException sMAPIException) {
                        CgUtility.handleError(sMAPIException);
                        Object var4_3 = null;
                        CgFilterManager.this.clearStatusMessage();
                        CgFilterManager.this.setBusy(false);
                    }
                    Object var4_2 = null;
                    CgFilterManager.this.clearStatusMessage();
                    CgFilterManager.this.setBusy(false);
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    CgFilterManager.this.clearStatusMessage();
                    CgFilterManager.this.setBusy(false);
                    throw throwable;
                }
            }
        };
        thread.start();
    }

    private void addButton__actionPerformed(ActionEvent actionEvent) {
        this.save(true);
    }

    private void changeButton__actionPerformed(ActionEvent actionEvent) {
        this.save(false);
    }

    private void clearButton__actionPerformed(ActionEvent actionEvent) {
        this.clearStatusMessage();
        if (this.isModified() && !CgUtility.confirmDiscardChanges(this, CgUtility.getI18nMsg("standard.askDiscardChanges"))) {
            return;
        }
        this.clearForm();
        if (this.reloadNeeded_) {
            this.loadFilters();
        }
    }

    private void closeButton__actionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }

    private void helpButton__actionPerformed(ActionEvent actionEvent) {
        CmConsoleSession.getInstance().launchHelp("grouping-filter-manager-help");
    }

    private void matchComboBox__actionPerformed(ActionEvent actionEvent) {
        this.setModified();
    }

    void nameCheckBox__actionPerformed(ActionEvent actionEvent) {
        this.setModified();
        this.patternTextField_.setEnabled(this.nameCheckBox_.isSelected());
        this.matchComboBox_.setEnabled(this.nameCheckBox_.isSelected());
    }

    void IPCheckBox__actionPerformed(ActionEvent actionEvent) {
        this.setModified();
        this.fromIPTextField_.setEnabled(this.IPCheckBox_.isSelected());
        this.toIPTextField_.setEnabled(this.IPCheckBox_.isSelected());
    }

    static /* synthetic */ CgComparableAdapter[] access$802(CgFilterManager cgFilterManager, CgComparableAdapter[] cgComparableAdapterArray) {
        cgFilterManager.os_ = cgComparableAdapterArray;
        return cgComparableAdapterArray;
    }

    static /* synthetic */ CgComparableAdapter[] access$902(CgFilterManager cgFilterManager, CgComparableAdapter[] cgComparableAdapterArray) {
        cgFilterManager.platforms_ = cgComparableAdapterArray;
        return cgComparableAdapterArray;
    }

    static /* synthetic */ CgComparableAdapter[] access$1002(CgFilterManager cgFilterManager, CgComparableAdapter[] cgComparableAdapterArray) {
        cgFilterManager.modules_ = cgComparableAdapterArray;
        return cgComparableAdapterArray;
    }

    static /* synthetic */ SMFilterInfo[] access$1302(CgFilterManager cgFilterManager, SMFilterInfo[] sMFilterInfoArray) {
        cgFilterManager.filters_ = sMFilterInfoArray;
        return sMFilterInfoArray;
    }

    static /* synthetic */ boolean access$1500(CgFilterManager cgFilterManager) {
        return cgFilterManager.hasSetLists_;
    }

    static /* synthetic */ boolean access$1502(CgFilterManager cgFilterManager, boolean bl) {
        cgFilterManager.hasSetLists_ = bl;
        return cgFilterManager.hasSetLists_;
    }

    static /* synthetic */ SMFilterInfo[] access$1300(CgFilterManager cgFilterManager) {
        return cgFilterManager.filters_;
    }

    static /* synthetic */ SMFilterData access$1700(CgFilterManager cgFilterManager) {
        return cgFilterManager.filter_;
    }

    static /* synthetic */ void access$1900(CgFilterManager cgFilterManager, String string) {
        cgFilterManager.setMatchType(string);
    }

    static /* synthetic */ CgComparableAdapter[] access$2000(CgFilterManager cgFilterManager, String[] stringArray) {
        return cgFilterManager.makePlatformList(stringArray);
    }

    static /* synthetic */ CgComparableAdapter[] access$2100(CgFilterManager cgFilterManager, String[] stringArray) {
        return cgFilterManager.makeModuleList(stringArray);
    }

    static /* synthetic */ CgComparableAdapter[] access$2200(CgFilterManager cgFilterManager, String[] stringArray) {
        return cgFilterManager.makeOSList(stringArray);
    }

    static /* synthetic */ boolean access$2402(CgFilterManager cgFilterManager, boolean bl) {
        cgFilterManager.formCleared_ = bl;
        return cgFilterManager.formCleared_;
    }

    class MyDocumentListener
    implements DocumentListener {
        MyDocumentListener() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            CgFilterManager.this.setModified();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            CgFilterManager.this.setModified();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            CgFilterManager.this.setModified();
        }
    }

    class FilterCellData {
        private SMFilterInfo info_;

        public FilterCellData(SMFilterInfo sMFilterInfo) {
            this.info_ = sMFilterInfo;
        }

        public SMFilterInfo getFilterInfo() {
            return this.info_;
        }

        public String toString() {
            return this.info_.getName();
        }
    }

    class MatchType {
        private String name_;
        private String type_;

        public MatchType(String string, String string2) {
            this.name_ = string;
            this.type_ = string2;
        }

        public String getType() {
            return this.type_;
        }

        public String toString() {
            return this.name_;
        }
    }
}

