/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.tools.discovery.console.presentation;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.SMResourceAccess;
import com.sun.symon.base.client.console.SMConsoleContext;
import com.sun.symon.base.client.module.SMModuleInfo;
import com.sun.symon.base.console.grouping.CgComparableAdapter;
import com.sun.symon.base.console.grouping.CgUtility;
import com.sun.symon.base.console.grouping.filter.CgFilterFieldEditor;
import com.sun.symon.base.console.grouping.filter.CgFilterListEditor;
import com.sun.symon.tools.discovery.console.presentation.DiscoverConstants;
import com.sun.symon.tools.discovery.console.presentation.DiscoverPanel;
import com.sun.symon.tools.discovery.console.presentation.DiscoverRequest;
import com.sun.symon.tools.discovery.console.presentation.FilterData;
import java.awt.Dimension;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

public class RequestFilterPanel
extends JPanel {
    private DiscoverPanel parent;
    private DiscoverRequest request;
    private FilterData filterData;
    private SMRawDataRequest rawRequest;
    private String[] moduleIdentifier;
    private String[] moduleName;
    private CgComparableAdapter[] os_;
    private CgComparableAdapter[] platforms_;
    private CgComparableAdapter[] modules_;
    JPanel topPanel_ = new JPanel();
    JPanel buttomPanel_ = new JPanel();
    CgFilterFieldEditor hostPanel_ = new CgFilterFieldEditor();
    CgFilterListEditor platformPanel_ = new CgFilterListEditor();
    CgFilterListEditor osPanel_ = new CgFilterListEditor();
    CgFilterListEditor modulePanel_ = new CgFilterListEditor();
    private Hashtable modName2InterHash = new Hashtable();
    private Hashtable modInter2NameHash = new Hashtable();

    public RequestFilterPanel(DiscoverPanel discoverPanel, DiscoverRequest discoverRequest) throws SMAPIException {
        this.parent = discoverPanel;
        this.request = discoverRequest;
        this.rawRequest = this.parent.getRequestHandle();
        this.filterData = new FilterData(new SMResourceAccess(this.rawRequest));
        this.filterData.parseData();
        this.buildGUI();
        this.populateLists();
        this.showFilterData();
    }

    void buildGUI() {
        this.setLayout(new BoxLayout(this, 1));
        this.topPanel_.setPreferredSize(new Dimension(500, 50));
        this.buttomPanel_.setPreferredSize(new Dimension(500, 50));
        this.hostPanel_.setPreferredSize(new Dimension(500, 80));
        this.platformPanel_.setPreferredSize(new Dimension(500, 80));
        this.osPanel_.setPreferredSize(new Dimension(500, 80));
        this.modulePanel_.setPreferredSize(new Dimension(500, 80));
        this.add(this.topPanel_);
        this.add(this.hostPanel_);
        this.add(this.platformPanel_);
        this.add(this.osPanel_);
        this.add(this.modulePanel_);
        this.add(this.buttomPanel_);
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
    }

    void populateLists() {
        try {
            String[] stringArray = this.filterData.i18nPlatforms;
            String[] stringArray2 = DiscoverConstants.OS_ARR;
            SMModuleInfo[] sMModuleInfoArray = CgUtility.getMDRModules(SMConsoleContext.getInstance().getAPIHandle());
            this.os_ = new CgComparableAdapter[stringArray2.length];
            int n = 0;
            while (n < stringArray2.length) {
                this.os_[n] = new CgComparableAdapter(stringArray2[n], true);
                ++n;
            }
            this.platforms_ = new CgComparableAdapter[stringArray.length];
            int n2 = 0;
            while (n2 < stringArray.length) {
                this.platforms_[n2] = new CgComparableAdapter(stringArray[n2]);
                ++n2;
            }
            if (sMModuleInfoArray == null || sMModuleInfoArray.length == 0) {
                return;
            }
            this.modules_ = new CgComparableAdapter[sMModuleInfoArray.length];
            this.moduleIdentifier = new String[sMModuleInfoArray.length];
            this.moduleName = new String[sMModuleInfoArray.length];
            int n3 = 0;
            while (n3 < sMModuleInfoArray.length) {
                this.modules_[n3] = new CgComparableAdapter(sMModuleInfoArray[n3]);
                this.moduleIdentifier[n3] = sMModuleInfoArray[n3].getModule();
                this.moduleName[n3] = sMModuleInfoArray[n3].getModuleI18Name();
                ++n3;
            }
            this.hostPanel_.setDisablePanelFlag(true);
            this.platformPanel_.setDisablePanelFlag(true);
            this.osPanel_.setDisablePanelFlag(true);
            this.modulePanel_.setDisablePanelFlag(true);
            this.hostPanel_.setCheckBoxText(CgUtility.getI18nMsg("discoverFilter.hostLabel") + ":");
            this.hostPanel_.setCheckBoxMnemonic(CgUtility.getMnemonic("discoverFilter.hostLabel"));
            this.platformPanel_.setCheckBoxText(CgUtility.getI18nMsg("discoverFilter.platformLabel") + ":");
            this.platformPanel_.setCheckBoxMnemonic(CgUtility.getMnemonic("discoverFilter.platformLabel"));
            this.osPanel_.setCheckBoxText(CgUtility.getI18nMsg("discoverFilter.osLabel") + ":");
            this.osPanel_.setCheckBoxMnemonic(CgUtility.getMnemonic("discoverFilter.osLabel"));
            this.modulePanel_.setCheckBoxText(CgUtility.getI18nMsg("discoverFilter.moduleLabel") + ":");
            this.modulePanel_.setCheckBoxMnemonic(CgUtility.getMnemonic("discoverFilter.moduleLabel"));
            this.hostPanel_.setMasterList();
            this.platformPanel_.setMasterList(this.platforms_);
            this.osPanel_.setMasterList(this.os_);
            this.modulePanel_.setMasterList(this.modules_);
            this.hostPanel_.setPanelEnabled(false);
            this.platformPanel_.setPanelEnabled(false);
            this.osPanel_.setPanelEnabled(false);
            this.modulePanel_.setPanelEnabled(false);
        }
        catch (SMAPIException sMAPIException) {
            CgUtility.showErrorMessage(CgUtility.getI18nMsg("filter.noConfigService"));
            return;
        }
    }

    void showFilterData() {
        int n = this.request.getNumFilterCriteria();
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4;
            int n5 = this.request.getFilterCriteria(n2);
            String[] stringArray = this.request.getIncludeItemValue(n2);
            String[] stringArray2 = this.request.getExcludeItemValue(n2);
            if (n5 == 2) {
                if (stringArray != null) {
                    n4 = 0;
                    while (n4 < stringArray.length) {
                        stringArray[n4] = this.filterData.getI18NforPlatform(stringArray[n4]);
                        ++n4;
                    }
                }
                if (stringArray2 != null) {
                    n4 = 0;
                    while (n4 < stringArray2.length) {
                        stringArray2[n4] = this.filterData.getI18NforPlatform(stringArray2[n4]);
                        ++n4;
                    }
                }
            }
            if (n5 == 1) {
                if (stringArray != null) {
                    n4 = 0;
                    while (n4 < stringArray.length) {
                        stringArray[n4] = "SunOS " + stringArray[n4];
                        ++n4;
                    }
                }
                if (stringArray2 != null) {
                    n4 = 0;
                    while (n4 < stringArray2.length) {
                        stringArray2[n4] = "SunOS " + stringArray2[n4];
                        ++n4;
                    }
                }
            }
            if (n5 == 3) {
                int n6;
                if (stringArray != null) {
                    n4 = 0;
                    while (n4 < stringArray.length) {
                        n6 = 0;
                        while (n6 < this.moduleName.length) {
                            if (stringArray[n4].equals(this.moduleIdentifier[n6])) {
                                stringArray[n4] = this.moduleName[n6];
                                break;
                            }
                            ++n6;
                        }
                        ++n4;
                    }
                }
                if (stringArray2 != null) {
                    n4 = 0;
                    while (n4 < stringArray2.length) {
                        n6 = 0;
                        while (n6 < this.moduleName.length) {
                            if (stringArray2[n4].equals(this.moduleIdentifier[n6])) {
                                stringArray2[n4] = this.moduleName[n6];
                                break;
                            }
                            ++n6;
                        }
                        ++n4;
                    }
                }
            }
            Comparable[] comparableArray = null;
            Comparable[] comparableArray2 = null;
            if (stringArray2 != null && stringArray2.length > 0) {
                comparableArray = new CgComparableAdapter[stringArray2.length];
                n3 = 0;
                while (n3 < stringArray2.length) {
                    comparableArray[n3] = new CgComparableAdapter(stringArray2[n3], true);
                    ++n3;
                }
            } else {
                comparableArray2 = new CgComparableAdapter[stringArray.length];
                n3 = 0;
                while (n3 < stringArray.length) {
                    comparableArray2[n3] = new CgComparableAdapter(stringArray[n3], true);
                    ++n3;
                }
            }
            if (n5 == 0) {
                this.hostPanel_.setPanelEnabled(true);
                this.hostPanel_.setCheckboxSelected(true);
                if (stringArray2 != null && stringArray2.length > 0) {
                    this.hostPanel_.setInclude(false);
                    this.hostPanel_.setSelectedList(comparableArray);
                } else {
                    this.hostPanel_.setInclude(true);
                    this.hostPanel_.setSelectedList(comparableArray2);
                }
            }
            if (n5 == 2) {
                this.platformPanel_.setPanelEnabled(true);
                this.platformPanel_.setCheckboxSelected(true);
                if (stringArray2 != null && stringArray2.length > 0) {
                    this.platformPanel_.setInclude(false);
                    this.platformPanel_.setSelectedList(comparableArray);
                } else {
                    this.platformPanel_.setInclude(true);
                    this.platformPanel_.setSelectedList(comparableArray2);
                }
            }
            if (n5 == 1) {
                this.osPanel_.setPanelEnabled(true);
                this.osPanel_.setCheckboxSelected(true);
                if (stringArray2 != null && stringArray2.length > 0) {
                    this.osPanel_.setInclude(false);
                    this.osPanel_.setSelectedList(comparableArray);
                } else {
                    this.osPanel_.setInclude(true);
                    this.osPanel_.setSelectedList(comparableArray2);
                }
            }
            if (n5 == 3) {
                this.modulePanel_.setPanelEnabled(true);
                this.modulePanel_.setCheckboxSelected(true);
                if (stringArray2 != null && stringArray2.length > 0) {
                    this.modulePanel_.setInclude(false);
                    this.modulePanel_.setSelectedList(comparableArray);
                } else {
                    this.modulePanel_.setInclude(true);
                    this.modulePanel_.setSelectedList(comparableArray2);
                }
            }
            ++n2;
        }
    }

    void readFilterData() {
        int n;
        String[] stringArray;
        int n2 = 0;
        if (this.hostPanel_.isCheckboxSelected()) {
            ++n2;
        }
        if (this.platformPanel_.isCheckboxSelected()) {
            ++n2;
        }
        if (this.osPanel_.isCheckboxSelected()) {
            ++n2;
        }
        if (this.modulePanel_.isCheckboxSelected()) {
            ++n2;
        }
        this.request.setNumFilterCriteria(n2);
        int n3 = 0;
        if (this.hostPanel_.isCheckboxSelected()) {
            stringArray = this.getSelectedStringArray(this.hostPanel_);
            if (this.hostPanel_.isInclude()) {
                this.request.setIncludeItemValue(n3, stringArray);
            } else {
                this.request.setExcludeItemValue(n3, stringArray);
            }
            this.request.setFilterCriteria(n3, 0);
            ++n3;
        }
        if (this.platformPanel_.isCheckboxSelected()) {
            stringArray = this.getSelectedStringArray(this.platformPanel_);
            if (stringArray != null) {
                n = 0;
                while (n < stringArray.length) {
                    stringArray[n] = this.filterData.getPlatformforI18N(stringArray[n]);
                    ++n;
                }
            }
            if (this.platformPanel_.isInclude()) {
                this.request.setIncludeItemValue(n3, stringArray);
            } else {
                this.request.setExcludeItemValue(n3, stringArray);
            }
            this.request.setFilterCriteria(n3, 2);
            ++n3;
        }
        if (this.osPanel_.isCheckboxSelected()) {
            stringArray = this.getSelectedStringArray(this.osPanel_);
            if (stringArray != null) {
                n = 0;
                while (n < stringArray.length) {
                    stringArray[n] = stringArray[n].substring(6);
                    ++n;
                }
            }
            if (this.osPanel_.isInclude()) {
                this.request.setIncludeItemValue(n3, stringArray);
            } else {
                this.request.setExcludeItemValue(n3, stringArray);
            }
            this.request.setFilterCriteria(n3, 1);
            ++n3;
        }
        if (this.modulePanel_.isCheckboxSelected()) {
            stringArray = this.getSelectedStringArray(this.modulePanel_);
            if (stringArray != null) {
                n = 0;
                while (n < stringArray.length) {
                    int n4 = 0;
                    while (n4 < this.moduleName.length) {
                        if (stringArray[n].equals(this.moduleName[n4])) {
                            stringArray[n] = this.moduleIdentifier[n4];
                            break;
                        }
                        ++n4;
                    }
                    ++n;
                }
            }
            if (this.modulePanel_.isInclude()) {
                this.request.setIncludeItemValue(n3, stringArray);
            } else {
                this.request.setExcludeItemValue(n3, stringArray);
            }
            this.request.setFilterCriteria(n3, 3);
            ++n3;
        }
    }

    private String[] getSelectedStringArray(CgFilterFieldEditor cgFilterFieldEditor) {
        Object[] objectArray = cgFilterFieldEditor.getSelectedList();
        if (objectArray.length == 0) {
            return null;
        }
        String[] stringArray = new String[objectArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = ((CgComparableAdapter)objectArray[n]).getObject().toString();
            ++n;
        }
        return stringArray;
    }

    private String[] getSelectedStringArray(CgFilterListEditor cgFilterListEditor) {
        Object[] objectArray = cgFilterListEditor.getSelectedList();
        if (objectArray.length == 0) {
            return null;
        }
        String[] stringArray = new String[objectArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = ((CgComparableAdapter)objectArray[n]).getObject().toString();
            ++n;
        }
        return stringArray;
    }
}

