/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.grouping.aggregate;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.console.SMConsoleContext;
import com.sun.symon.base.client.task.SMTask;
import com.sun.symon.base.client.task.SMTaskInfo;
import com.sun.symon.base.client.task.SMTaskType;
import com.sun.symon.base.console.grouping.CgUtility;
import com.sun.symon.base.console.views.table.CvBaseTable;
import com.sun.symon.base.console.views.table.CvBaseTableModel;
import com.sun.symon.base.utility.UcCommon;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class CgTaskPanel
extends JPanel {
    private CvBaseTableModel model_;
    private SMTaskType[] taskTypes_;
    private SMTaskInfo[] tasks_;
    private SMTaskInfo[] filteredTasks_;
    private Hashtable taskTypeTable_;
    private SMTaskType currentTaskType_;
    GridBagLayout mainGridBagLayout_ = new GridBagLayout();
    JLabel tableTitleLabel_ = new JLabel();
    JScrollPane scrollPane_ = new JScrollPane();
    CvBaseTable table_ = new CvBaseTable();
    JPanel typePanel_ = new JPanel();
    JComboBox showTaskComboBox_ = new JComboBox();
    JLabel showTasKTypeLabel_ = new JLabel();
    GridBagLayout typeGridBagLayout_ = new GridBagLayout();

    public CgTaskPanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.localize();
        if (SMConsoleContext.getInstance().getAPIHandle() != null) {
            this.model_ = new CvBaseTableModel(new String[]{CgUtility.getI18nMsg("task.message.taskName"), CgUtility.getI18nMsg("task.taskType")}, new Vector());
            this.table_.setModel(this.model_);
            this.table_.setSortable(true);
            this.table_.setBackground(UcCommon.getLightGrayColor());
            this.table_.getSelectionModel().setSelectionMode(0);
            this.table_.getColumnModel().getColumn(0).setPreferredWidth(250);
        }
    }

    public void setTableTitle(String string) {
        this.tableTitleLabel_.setText(string);
    }

    public JTable getTable() {
        return this.table_;
    }

    public JComboBox getTaskTypeComboBox() {
        return this.showTaskComboBox_;
    }

    public int getSelectedRow() {
        return this.model_.convertRowIndexToModel(this.table_.getSelectedRow());
    }

    public void selectRow(int n) {
        if (n < 0 || n >= this.table_.getRowCount()) {
            this.table_.clearSelection();
            return;
        }
        n = this.model_.convertRowIndexToView(n);
        this.table_.setRowSelectionInterval(n, n);
    }

    public SMTaskInfo getSelectedTask() {
        int n = this.getSelectedRow();
        if (n < 0) {
            return null;
        }
        return this.filteredTasks_[n];
    }

    public SMTaskInfo[] getTasks() {
        return this.filteredTasks_;
    }

    public void load(SMTask sMTask) {
        if (this.taskTypes_ == null) {
            this.taskTypes_ = CgUtility.getTaskTypes(sMTask);
            this.showTaskComboBox_.addItem(CgUtility.getI18nMsg("standard.all"));
            int n = 0;
            while (n < this.taskTypes_.length) {
                this.showTaskComboBox_.addItem(this.taskTypes_[n]);
                ++n;
            }
        }
        try {
            this.tasks_ = sMTask.getAll();
        }
        catch (SMAPIException sMAPIException) {
            this.tasks_ = new SMTaskInfo[0];
        }
        this.showByTaskType(this.currentTaskType_);
    }

    private SMTaskType lookupTaskType(String string) {
        if (this.taskTypes_ == null) {
            return null;
        }
        if (this.taskTypeTable_ == null) {
            this.taskTypeTable_ = new Hashtable();
            int n = 0;
            while (n < this.taskTypes_.length) {
                this.taskTypeTable_.put(this.taskTypes_[n].getTaskTypeString(), this.taskTypes_[n]);
                ++n;
            }
        }
        return (SMTaskType)this.taskTypeTable_.get(string);
    }

    private void localize() {
        this.tableTitleLabel_.setText(CgUtility.getI18nMsg("task.currentTasks"));
        this.showTasKTypeLabel_.setText(CgUtility.getI18nMsg("task.showTaskType") + ":");
        this.showTasKTypeLabel_.setLabelFor(this.showTaskComboBox_);
        this.showTasKTypeLabel_.setDisplayedMnemonic(CgUtility.getMnemonic("task.showTaskType"));
    }

    private void jbInit() throws Exception {
        this.setLayout(this.mainGridBagLayout_);
        this.tableTitleLabel_.setText("currentTasks");
        this.showTaskComboBox_.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                CgTaskPanel.this.showTaskComboBox__itemStateChanged(itemEvent);
            }
        });
        this.showTasKTypeLabel_.setText("showTaskType");
        this.typePanel_.setLayout(this.typeGridBagLayout_);
        this.setMinimumSize(new Dimension(269, 200));
        this.setPreferredSize(new Dimension(454, 200));
        this.scrollPane_.setPreferredSize(new Dimension(454, 300));
        this.add((Component)this.tableTitleLabel_, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.scrollPane_, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.typePanel_, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.typePanel_.add((Component)this.showTasKTypeLabel_, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.typePanel_.add((Component)this.showTaskComboBox_, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 5, 0), 0, 0));
        this.scrollPane_.getViewport().add((Component)this.table_, null);
    }

    private void showByTaskType(SMTaskType sMTaskType) {
        this.filteredTasks_ = sMTaskType == null ? this.tasks_ : this.getTasks(sMTaskType);
        if (this.model_ == null || this.filteredTasks_ == null) {
            return;
        }
        Vector<String> vector = new Vector<String>();
        this.model_.removeAllRows();
        int n = 0;
        while (n < this.filteredTasks_.length) {
            vector = new Vector();
            vector.addElement(this.filteredTasks_[n].getName());
            vector.addElement((String)this.lookupTaskType(this.filteredTasks_[n].getTaskTypeString()));
            this.model_.addRow(vector);
            ++n;
        }
        this.table_.repaint();
    }

    private SMTaskInfo[] getTasks(SMTaskType sMTaskType) {
        Vector<SMTaskInfo> vector = new Vector<SMTaskInfo>();
        int n = 0;
        while (n < this.tasks_.length) {
            if (this.tasks_[n].getTaskTypeString().equals(sMTaskType.getTaskTypeString())) {
                vector.addElement(this.tasks_[n]);
            }
            ++n;
        }
        Object[] objectArray = new SMTaskInfo[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    void showTaskComboBox__itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 2) {
            return;
        }
        Object object = this.showTaskComboBox_.getSelectedItem();
        if (object == null) {
            return;
        }
        this.currentTaskType_ = object instanceof SMTaskType ? (SMTaskType)object : null;
        this.showByTaskType(this.currentTaskType_);
    }
}

