/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.grouping.aggregate;

import com.sun.symon.base.client.SMResourceAccess;
import com.sun.symon.base.client.console.SMConsoleContext;
import com.sun.symon.base.client.task.SMTaskRequestLogDetail;
import com.sun.symon.base.client.task.SMTaskRequestLogEvent;
import com.sun.symon.base.client.task.SMTaskRequestLogFactory;
import com.sun.symon.base.client.task.SMTaskRequestLogManager;
import com.sun.symon.base.client.task.SMTaskRequestLogOperation;
import com.sun.symon.base.console.grouping.CgUtility;
import com.sun.symon.base.utility.UcCommon;
import com.sun.symon.base.utility.UcInternationalizer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.AbstractList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

class CgPropertyLogFactory
implements SMTaskRequestLogFactory {
    private int focusRow_ = -1;
    private int focusColumn_ = -1;
    private final int ALARMS = 1;
    private final int ACTIONS = 2;
    private final int REFRESH = 3;
    private final int HISTORY = 4;
    private final int VALUE = 5;
    private SMTaskRequestLogManager manager_;
    private SMTaskRequestLogDetail[] agents_;
    private Hashtable requestInfo_;
    private JTable table_ = new JTable();
    private Vector tableRows_;
    private final String[] colNames_ = new String[]{this.localize("log.domainObj"), this.localize("log.alarm"), this.localize("log.action"), this.localize("log.refresh"), this.localize("log.history"), this.localize("log.value")};
    static /* synthetic */ Class class$java$lang$Object;

    CgPropertyLogFactory() {
    }

    public void setManager(SMTaskRequestLogManager sMTaskRequestLogManager) {
        this.manager_ = sMTaskRequestLogManager;
    }

    public void setData(SMTaskRequestLogDetail[] sMTaskRequestLogDetailArray) {
        this.agents_ = sMTaskRequestLogDetailArray;
        this.table_.getTableHeader().setReorderingAllowed(false);
        this.table_.setCellSelectionEnabled(true);
        this.table_.setModel(new TableModel());
        this.table_.setDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = CgPropertyLogFactory.class$("java.lang.Object")) : class$java$lang$Object, new OperationCellRenderer());
        this.table_.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                CgPropertyLogFactory.this.cellSelectionChanged();
            }
        });
        this.table_.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                CgPropertyLogFactory.this.cellSelectionChanged();
            }
        });
        this.toTable();
    }

    private void cellSelectionChanged() {
        int n = this.table_.getSelectedRow();
        int n2 = this.table_.getSelectedColumn();
        if (n < 0 || n2 < 0) {
            return;
        }
        if (this.focusRow_ == n && this.focusColumn_ == n2) {
            return;
        }
        this.focusRow_ = n;
        this.focusColumn_ = n2;
        SMTaskRequestLogDetail sMTaskRequestLogDetail = this.agents_[this.focusRow_];
        if (sMTaskRequestLogDetail == null) {
            return;
        }
        String string = sMTaskRequestLogDetail.getCellMsg(this.focusColumn_);
        if (string == null) {
            string = "";
        }
        this.manager_.showStatusDetail(string);
    }

    private void toTable() {
        TableModel tableModel;
        this.tableRows_ = new Vector();
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < this.colNames_.length) {
            vector.add(this.colNames_[n]);
            ++n;
        }
        int n2 = 0;
        while (n2 < this.agents_.length) {
            tableModel = this.agents_[n2];
            this.tableRows_.add(this.toRow((SMTaskRequestLogDetail)tableModel));
            ++n2;
        }
        tableModel = (TableModel)this.table_.getModel();
        tableModel.setDataVector(this.tableRows_, vector);
        TableColumn tableColumn = this.table_.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(120);
        tableColumn.setMinWidth(120);
    }

    private Vector toRow(SMTaskRequestLogDetail sMTaskRequestLogDetail) {
        String[] stringArray = new String[this.colNames_.length];
        String[] stringArray2 = new String[this.colNames_.length];
        this.getStatusAndMsgs(sMTaskRequestLogDetail, stringArray, stringArray2);
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < this.colNames_.length) {
            vector.add(stringArray[n]);
            ++n;
        }
        sMTaskRequestLogDetail.setCellDetailMsgs(stringArray2);
        return vector;
    }

    private void getStatusAndMsgs(SMTaskRequestLogDetail sMTaskRequestLogDetail, String[] stringArray, String[] stringArray2) {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        Vector[] vectorArray = new Vector[this.colNames_.length];
        StringBuffer[] stringBufferArray = new StringBuffer[this.colNames_.length];
        Vector vector = new Vector();
        Vector vector2 = sMTaskRequestLogDetail.getOperations();
        int n = 0;
        while (n < this.colNames_.length) {
            vectorArray[n] = new Vector();
            stringBufferArray[n] = new StringBuffer();
            ++n;
        }
        int n2 = 0;
        while (n2 < vector2.size()) {
            Object object;
            int n3;
            SMTaskRequestLogOperation sMTaskRequestLogOperation = (SMTaskRequestLogOperation)vector2.get(n2);
            string = sMTaskRequestLogOperation.getUserData();
            Hashtable hashtable = sMTaskRequestLogOperation.getResult();
            vector.add(hashtable.get("status"));
            String string2 = (String)hashtable.get("status");
            if (string.startsWith("Alarms")) {
                n3 = 1;
            } else if (string.startsWith("Actions")) {
                n3 = 2;
            } else if (string.startsWith("Refresh")) {
                n3 = 3;
            } else if (string.startsWith("History")) {
                n3 = 4;
            } else if (string.startsWith("Value")) {
                n3 = 5;
            } else {
                return;
            }
            if (string2 != null && !string2.equals("")) {
                object = vectorArray[n3];
                ((Vector)object).add(string2);
            }
            if ((object = this.createCellDetailMsg(sMTaskRequestLogOperation)) != null && ((String)object).length() > 0) {
                stringBuffer.append((String)object);
                stringBuffer.append("<br><br>");
            }
            if (!((String)object).equals("")) {
                if (!stringBufferArray[n3].toString().equals("")) {
                    stringBufferArray[n3].append("<br><br>");
                }
                stringBufferArray[n3].append((String)object);
            }
            ++n2;
        }
        int n4 = 1;
        while (n4 < this.colNames_.length) {
            stringArray[n4] = this.sumStatus(vectorArray[n4]);
            stringArray2[n4] = stringBufferArray[n4].toString();
            ++n4;
        }
        string = this.sumStatus(vector);
        stringArray[0] = string + ":" + sMTaskRequestLogDetail.getName() + ":" + sMTaskRequestLogDetail.getPort();
        stringArray2[0] = stringBuffer.toString();
    }

    private String sumStatus(Vector vector) {
        String string = null;
        String string2 = null;
        String string3 = null;
        if (vector.isEmpty()) {
            return "unknown";
        }
        int n = 0;
        while (n < vector.size()) {
            String string4 = (String)vector.get(n);
            if (string4 == null) {
                string3 = "unknown";
            } else {
                if (string4.equals("failure")) {
                    string2 = string4;
                    break;
                }
                if (string4.equals("unknown") || string4 == null) {
                    string3 = string4;
                } else if (string4.equals("OK")) {
                    string = string4;
                }
            }
            ++n;
        }
        String string5 = string2 != null ? string2 : (string3 != null ? string3 : "OK");
        return string5;
    }

    public void updateScreenByOperation(SMTaskRequestLogEvent sMTaskRequestLogEvent) {
        Object object;
        String string;
        Object object2 = null;
        String string2 = null;
        String string3 = sMTaskRequestLogEvent.getHost();
        String string4 = String.valueOf(sMTaskRequestLogEvent.getPort());
        String string5 = String.valueOf(sMTaskRequestLogEvent.getIndex());
        String string6 = String.valueOf(sMTaskRequestLogEvent.getStartTime());
        String string7 = String.valueOf(sMTaskRequestLogEvent.getStopTime());
        int n = sMTaskRequestLogEvent.getStatus();
        switch (n) {
            case 0: {
                string = "unknown";
                break;
            }
            case 1: {
                string = "OK";
                break;
            }
            case 2: {
                string = "failure";
                string2 = sMTaskRequestLogEvent.getErrorMessage();
                break;
            }
            default: {
                string = "invalidStatus";
            }
        }
        int n2 = -1;
        int n3 = 0;
        while (n3 < this.agents_.length) {
            object = this.agents_[n3];
            if (object.getName().equals(string3) && object.getPort().equals(string4)) {
                n2 = n3;
                object2 = object;
                break;
            }
            ++n3;
        }
        if (n2 == -1) {
            return;
        }
        object = object2.getOperations();
        Iterator iterator = ((AbstractList)object).iterator();
        int n4 = -1;
        while (iterator.hasNext()) {
            SMTaskRequestLogOperation sMTaskRequestLogOperation = (SMTaskRequestLogOperation)iterator.next();
            if (!sMTaskRequestLogOperation.getIndex().equals(string5)) continue;
            Hashtable hashtable = sMTaskRequestLogOperation.getResult();
            hashtable.put("host", object2.getName());
            hashtable.put("index", string5);
            hashtable.put("status", string);
            hashtable.put("startTime", string6);
            hashtable.put("stopTime", string7);
            String string8 = sMTaskRequestLogOperation.getUserData();
            if (string8.startsWith("Alarms")) {
                n4 = 1;
            } else if (string8.startsWith("Actions")) {
                n4 = 2;
            } else if (string8.startsWith("Refresh")) {
                n4 = 3;
            } else if (string8.startsWith("History")) {
                n4 = 4;
            } else if (string8.startsWith("Value")) {
                n4 = 5;
            }
            String[] stringArray = new String[this.colNames_.length];
            String[] stringArray2 = new String[this.colNames_.length];
            this.getStatusAndMsgs((SMTaskRequestLogDetail)object2, stringArray, stringArray2);
            object2.setStatus(stringArray[0]);
            object2.setCellDetailMsgs(stringArray2);
            TableModel tableModel = (TableModel)this.table_.getModel();
            tableModel.setValueAt(stringArray[n4], n2, n4);
            tableModel.setValueAt(object2.getStatus(), n2, 0);
            break;
        }
    }

    private String createCellDetailMsg(SMTaskRequestLogOperation sMTaskRequestLogOperation) {
        Hashtable hashtable = sMTaskRequestLogOperation.getResult();
        if (hashtable.isEmpty()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string = (String)hashtable.get("message");
        String string2 = (String)hashtable.get("startTime");
        String string3 = (String)hashtable.get("stopTime");
        String string4 = (String)hashtable.get("status");
        String string5 = (String)hashtable.get("index");
        String string6 = sMTaskRequestLogOperation.getCommand();
        String string7 = sMTaskRequestLogOperation.getOperand();
        String string8 = sMTaskRequestLogOperation.getValue();
        float f = Long.valueOf(string3) - Long.valueOf(string2);
        String string9 = CgUtility.formatDuration(f);
        stringBuffer.append("<b>" + this.localize("log.operation") + ": </b> ");
        stringBuffer.append(Integer.valueOf(string5) + 1);
        stringBuffer.append("<br><b>" + this.localize("log.result") + ": </b> ");
        if (string4.equals("unknown")) {
            string4 = "";
        } else if (string4.equals("OK")) {
            stringBuffer.append("<font color=#008000>");
            string4 = this.localize("standard.succeeded");
        } else {
            stringBuffer.append("<font color=#FF0000>");
            string4 = this.localize("standard.failed");
        }
        stringBuffer.append(string == null ? string4 : UcInternationalizer.translateKey((String)string, (boolean)false));
        stringBuffer.append("</font>");
        stringBuffer.append("<br><b>" + this.localize("log.command") + ": </b> ");
        stringBuffer.append(string6);
        stringBuffer.append("<br><b>" + this.localize("log.operand") + ": </b> ");
        stringBuffer.append(string7);
        if (!string8.equals("") && string8 != null) {
            stringBuffer.append("<br><b>" + this.localize("log.value") + ": </b> ");
            stringBuffer.append(string8);
        }
        if (!string4.equals("")) {
            stringBuffer.append("<br><b>" + this.localize("log.duration") + ": </b>" + string9);
        }
        return stringBuffer.toString();
    }

    public Component getComponent() {
        return this.table_;
    }

    public void cleanup() {
        if (this.agents_ != null && this.agents_.length > 0) {
            TableModel tableModel = (TableModel)this.table_.getModel();
            tableModel.removeAllRows();
        }
    }

    private String localize(String string) {
        String string2 = CgUtility.getI18nMsg(string);
        if (string2.startsWith("base.") && string2.endsWith(".defaultdomain")) {
            string2 = UcInternationalizer.translateKey((String)("com.sun.symon." + string), (boolean)false);
        }
        return string2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class OperationCellRenderer
    extends DefaultTableCellRenderer {
        private Border focusBorder_;
        private Border noFocusBorder_;
        private ImageIcon okIcon_;
        private ImageIcon failIcon_;
        private int focusRow_ = -1;
        private int focusColumn_ = -1;

        public OperationCellRenderer() {
            if (SMConsoleContext.getInstance().getAPIHandle() == null) {
                this.okIcon_ = new ImageIcon("\\log\\OK-CheckMark-16x16.gif");
                this.failIcon_ = new ImageIcon("\\log\\view-log-error.gif");
            } else {
                SMResourceAccess sMResourceAccess = new SMResourceAccess(SMConsoleContext.getInstance().getAPIHandle());
                this.okIcon_ = new ImageIcon(sMResourceAccess.getImage("stdimages/OK-CheckMark-16x16.gif"));
                this.failIcon_ = new ImageIcon(sMResourceAccess.getImage("stdimages/view-log-error.gif"));
            }
            this.setOpaque(true);
            this.setFont(new Font("dialog", 0, 12));
            this.focusBorder_ = BorderFactory.createLineBorder(new Color(102, 102, 153), 1);
            this.noFocusBorder_ = new EmptyBorder(1, 2, 1, 2);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (n2 > 0) {
                this.setHorizontalAlignment(0);
                this.setText(null);
                if (object.toString().equals("OK")) {
                    this.setIcon(this.okIcon_);
                } else if (object.toString().equals("failure")) {
                    this.setIcon(this.failIcon_);
                } else {
                    this.setIcon(null);
                }
            } else {
                this.setHorizontalAlignment(2);
                String string = object.toString();
                int n3 = string.indexOf(":");
                if (n3 != -1) {
                    String string2 = string.substring(0, n3);
                    String string3 = string.substring(n3 + 1);
                    if (string2.equals("OK")) {
                        this.setIcon(this.okIcon_);
                    } else if (string2.equals("failure")) {
                        this.setIcon(this.failIcon_);
                    } else {
                        this.setIcon(null);
                        string3 = "     " + string3;
                    }
                    this.setText(string3);
                } else {
                    this.setText("     " + object.toString());
                    this.setIcon(null);
                }
            }
            if (bl2) {
                this.focusRow_ = n;
                this.focusColumn_ = n2;
                this.setBorder(this.focusBorder_);
            } else {
                this.setBorder(this.noFocusBorder_);
            }
            if ((bl || bl2) && n == this.focusRow_ && this.focusColumn_ == n2) {
                this.setForeground(jTable.getSelectionForeground());
                this.setBackground(jTable.getSelectionBackground());
            } else {
                this.setBackground(UcCommon.getLightGrayColor());
                this.setForeground(jTable.getForeground());
            }
            return this;
        }
    }

    class TableModel
    extends DefaultTableModel {
        public static final String SUCCESS = "OK";
        public static final String FAILURE = "failure";
        public static final String UNKNOWN = "unknown";

        TableModel() {
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public void removeAllRows() {
            int n = this.dataVector.size();
            this.dataVector.removeAllElements();
            this.fireTableRowsDeleted(0, n);
        }
    }
}

