/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.grouping;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.SMResourceAccess;
import com.sun.symon.base.client.console.SMConsoleContext;
import com.sun.symon.base.client.module.SMModuleInfo;
import com.sun.symon.base.client.module.SMModuleRequest;
import com.sun.symon.base.client.service.SMDBObject;
import com.sun.symon.base.client.service.SMDatabaseException;
import com.sun.symon.base.client.service.SMDuplicateException;
import com.sun.symon.base.client.service.SMHandle;
import com.sun.symon.base.client.service.SMHandleRegistry;
import com.sun.symon.base.client.service.SMIntegrityException;
import com.sun.symon.base.client.service.SMNoSuchObjectException;
import com.sun.symon.base.client.service.SMSecurityException;
import com.sun.symon.base.client.service.SMStaleDataException;
import com.sun.symon.base.client.task.SMTask;
import com.sun.symon.base.client.task.SMTaskType;
import com.sun.symon.base.client.topology.SMHierarchyViewData;
import com.sun.symon.base.client.topology.SMTopologyRequest;
import com.sun.symon.base.client.topology.SMUserDomainData;
import com.sun.symon.base.client.topology.SMUserDomainRequest;
import com.sun.symon.base.console.grouping.aggregate.CgAggregateManager;
import com.sun.symon.base.console.grouping.aggregate.CgTaskManager;
import com.sun.symon.base.console.grouping.filter.CgFilterManager;
import com.sun.symon.base.console.manager.CmTopologyPath;
import com.sun.symon.base.server.types.StObject;
import com.sun.symon.base.utility.UcAgentURL;
import com.sun.symon.base.utility.UcDialog;
import com.sun.symon.base.utility.UcInternationalizer;
import com.sun.symon.base.utility.UcListUtil;
import com.sun.symon.base.utility.UcURL;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class CgUtility {
    private static final Integer AGGREGATE_MANAGER = new Integer(0);
    private static final Integer FILTER_MANAGER = new Integer(1);
    private static final Integer TASK_MANAGER = new Integer(2);
    private static SMTaskType[] taskTypes_;
    private static SMModuleInfo[] mdrModules_;
    private static Image logo_;
    private static String lastFilter_;
    private static String lastTask_;
    private static Hashtable instance_;

    public static Image getSunMCImage() {
        if (logo_ != null) {
            return logo_;
        }
        if (SMConsoleContext.getInstance().getAPIHandle() == null) {
            return null;
        }
        SMResourceAccess sMResourceAccess = new SMResourceAccess(SMConsoleContext.getInstance().getAPIHandle());
        logo_ = sMResourceAccess.getImage("stdimages/symon-small.gif");
        return logo_;
    }

    public static CgAggregateManager getAggregateManager() {
        return (CgAggregateManager)instance_.get(AGGREGATE_MANAGER);
    }

    public static void showAggregateManager() {
        CgUtility.showAggregateManager(false);
    }

    public static void showAggregateManager(boolean bl) {
        CgAggregateManager cgAggregateManager = (CgAggregateManager)instance_.get(AGGREGATE_MANAGER);
        if (cgAggregateManager != null) {
            if (cgAggregateManager.getState() == 1) {
                cgAggregateManager.setState(0);
            }
            cgAggregateManager.toFront();
            return;
        }
        try {
            cgAggregateManager = new CgAggregateManager(bl);
            instance_.put(AGGREGATE_MANAGER, cgAggregateManager);
            cgAggregateManager.addWindowListener(new WindowAdapter(){

                public void windowClosed(WindowEvent windowEvent) {
                    instance_.remove(AGGREGATE_MANAGER);
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void showFilterManager() {
        CgUtility.showFilterManager(false);
    }

    public static void showFilterManager(boolean bl) {
        CgFilterManager cgFilterManager = (CgFilterManager)instance_.get(FILTER_MANAGER);
        if (cgFilterManager != null) {
            if (cgFilterManager.getState() == 1) {
                cgFilterManager.setState(0);
            }
            cgFilterManager.toFront();
            return;
        }
        cgFilterManager = new CgFilterManager(bl);
        instance_.put(FILTER_MANAGER, cgFilterManager);
        cgFilterManager.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                instance_.remove(FILTER_MANAGER);
            }
        });
    }

    public static CgFilterManager getFilterManager() {
        return (CgFilterManager)instance_.get(FILTER_MANAGER);
    }

    public static void setLastEditedFilter(String string) {
        lastFilter_ = string;
    }

    public static String getLastEditedFilter() {
        return lastFilter_;
    }

    public static void showTaskManager() {
        CgTaskManager cgTaskManager = (CgTaskManager)instance_.get(TASK_MANAGER);
        if (cgTaskManager != null) {
            if (cgTaskManager.getState() == 1) {
                cgTaskManager.setState(0);
            }
            cgTaskManager.toFront();
            return;
        }
        cgTaskManager = new CgTaskManager();
        instance_.put(TASK_MANAGER, cgTaskManager);
        cgTaskManager.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                instance_.remove(TASK_MANAGER);
            }
        });
    }

    public static CgTaskManager getTaskManager() {
        return (CgTaskManager)instance_.get(TASK_MANAGER);
    }

    public static void setLastEditedTask(String string) {
        lastTask_ = string;
    }

    public static String getLastEditedTask() {
        return lastTask_;
    }

    public static void setGlassPaneVisible(final JFrame jFrame, final boolean bl) {
        Runnable runnable = new Runnable(){

            public void run() {
                if (bl) {
                    jFrame.setCursor(new Cursor(3));
                } else {
                    jFrame.setCursor(new Cursor(0));
                }
                if (jFrame.getGlassPane() != null) {
                    jFrame.getGlassPane().setVisible(bl);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public static char getMnemonic(String string) {
        return CgUtility.getI18nMsg(string + ".mnemonic").charAt(0);
    }

    public static String getI18nMsg(String string) {
        if (string.equals("")) {
            return "";
        }
        String string2 = UcInternationalizer.translateKey((String)("com.sun.symon.base.console.grouping.GroupingMessages:" + string), (boolean)false);
        if (!string2.startsWith("com.")) {
            return string2;
        }
        string2 = UcInternationalizer.translateKey((String)("com.sun.symon.base.console.ConsoleGeneric:" + string), (boolean)false);
        if (!string2.startsWith("com.")) {
            return string2;
        }
        string2 = UcInternationalizer.translateKey((String)("com.sun.symon.base.utility.UcDialogBundle:" + string), (boolean)false);
        if (!string2.startsWith("com.")) {
            return string2;
        }
        return string;
    }

    public static boolean confirmDelete(Component component, String string) {
        return CgUtility.confirm(component, CgUtility.getI18nMsg("standard.permanentDelete"), string, CgUtility.getI18nMsg("message.delete"), CgUtility.getI18nMsg("message.cancel"));
    }

    public static boolean confirmDiscardChanges(Component component, String string) {
        return CgUtility.confirm(component, CgUtility.getI18nMsg("standard.changesMade"), string, CgUtility.getI18nMsg("standard.discard"), CgUtility.getI18nMsg("message.cancel"));
    }

    public static boolean confirm(Component component, String string, String string2, String string3, String string4) {
        Object[] objectArray = new String[]{string3, string4};
        String string5 = UcInternationalizer.translateKey((String)"com.sun.symon.base.utility.UcDialogBundle:alert", (boolean)false);
        JLabel jLabel = new JLabel(string2);
        jLabel.setFont(new Font("Dialog", 0, 12));
        jLabel.setForeground(Color.black);
        int n = JOptionPane.showOptionDialog(component, new Object[]{string, jLabel}, string5, 0, 2, null, objectArray, objectArray[1]);
        return n == 0;
    }

    public static void showErrorMessage(String string) {
        UcDialog.showError((Object)CgUtility.getI18nMsg(string));
    }

    public static void handleError(SMAPIException sMAPIException) {
        String string = "";
        if (sMAPIException instanceof SMSecurityException) {
            string = CgUtility.getI18nMsg("standard.noRight");
            System.out.println(sMAPIException.getMessage());
        } else if (sMAPIException instanceof SMIntegrityException) {
            string = CgUtility.getI18nMsg("standard.integrityError");
            System.out.println(sMAPIException.getMessage());
        } else if (sMAPIException instanceof SMDatabaseException) {
            string = CgUtility.getI18nMsg("standard.dbError");
            System.out.println(sMAPIException.getMessage());
        } else {
            string = sMAPIException.getMessage(Locale.getDefault());
        }
        UcDialog.showError((Object)string);
        System.out.println((Object)sMAPIException);
    }

    public static boolean saveObj(Component component, SMHandle sMHandle, SMDBObject sMDBObject) {
        return CgUtility.saveObj(component, sMHandle, sMDBObject, true);
    }

    public static boolean saveObj(Component component, SMHandle sMHandle, SMDBObject sMDBObject, boolean bl) {
        return CgUtility.saveObj(component, sMHandle, sMDBObject, bl, true);
    }

    public static boolean saveObj(Component component, SMHandle sMHandle, SMDBObject sMDBObject, boolean bl, boolean bl2) {
        try {
            sMHandle.saveObj(sMDBObject);
        }
        catch (SMStaleDataException sMStaleDataException) {
            if (CgUtility.confirm(component, CgUtility.getI18nMsg("standard.updatedByAnotherUser"), CgUtility.getI18nMsg("standard.askOverwrite"), CgUtility.getI18nMsg("standard.overwrite"), CgUtility.getI18nMsg("message.cancel"))) {
                if (!bl2) {
                    return false;
                }
                try {
                    SMDBObject sMDBObject2 = sMHandle.loadObj(sMDBObject.getObjectID());
                    sMDBObject.setTimestamp(sMDBObject2.getTimestamp());
                    return CgUtility.saveObj(component, sMHandle, sMDBObject, bl);
                }
                catch (SMAPIException sMAPIException) {
                    CgUtility.handleError(sMAPIException);
                    return false;
                }
            }
            return false;
        }
        catch (SMDuplicateException sMDuplicateException) {
            String string = sMDBObject.getName();
            boolean bl3 = false;
            if (bl) {
                if (CgUtility.confirm(component, CgUtility.getI18nMsg("standard.duplicateName(" + string + ")"), CgUtility.getI18nMsg("standard.askOverwrite"), CgUtility.getI18nMsg("standard.overwrite"), CgUtility.getI18nMsg("message.cancel"))) {
                    bl3 = true;
                }
            } else {
                bl3 = true;
            }
            if (!bl2) {
                return bl3;
            }
            if (bl3) {
                try {
                    SMDBObject sMDBObject3 = sMHandle.loadObj(string);
                    sMHandle.deleteObj(sMDBObject3);
                    return CgUtility.saveObj(component, sMHandle, sMDBObject, bl);
                }
                catch (SMAPIException sMAPIException) {
                    CgUtility.handleError(sMAPIException);
                    return false;
                }
            }
            return false;
        }
        catch (SMNoSuchObjectException sMNoSuchObjectException) {
            sMDBObject.setObjectID(null);
            return CgUtility.saveObj(component, sMHandle, sMDBObject, bl);
        }
        catch (SMAPIException sMAPIException) {
            CgUtility.handleError(sMAPIException);
            return false;
        }
        return true;
    }

    public static SMModuleInfo[] getMDRModules(SMRawDataRequest sMRawDataRequest) throws SMAPIException {
        String string;
        if (sMRawDataRequest == null) {
            return CgUtility.sortModules(new SMModuleInfo[]{new SMModuleInfo("kernel-reader", "Kernel Reader", "xx", "1.0", 1, "kernel-reader", "", Locale.getDefault()), new SMModuleInfo("health-monitor", "Health Monitor", "xx", "1.0", 1, "health-monitor", "", Locale.getDefault()), new SMModuleInfo("fscan", "File Scanning", "xx", "1.0", 1, "fscan", "M", Locale.getDefault())});
        }
        if (mdrModules_ != null) {
            return mdrModules_;
        }
        String string2 = sMRawDataRequest.getMDRBaseURL();
        if (string2 == null && string2.equals("")) {
            return new SMModuleInfo[0];
        }
        SMModuleRequest sMModuleRequest = new SMModuleRequest(sMRawDataRequest);
        UcURL ucURL = new UcURL(string2);
        String string3 = ucURL.getHost();
        Vector vector = sMModuleRequest.getModuleInfo(string3, Integer.parseInt(string = ucURL.getPort()));
        if (vector == null || vector.size() == 0) {
            return new SMModuleInfo[0];
        }
        Vector<SMModuleInfo> vector2 = new Vector<SMModuleInfo>();
        int n = 0;
        while (n < vector.size()) {
            SMModuleInfo sMModuleInfo = (SMModuleInfo)vector.elementAt(n);
            if (sMModuleInfo.getCurrentLoadCount() >= 1) {
                vector2.addElement(sMModuleInfo);
            }
            ++n;
        }
        mdrModules_ = new SMModuleInfo[vector2.size()];
        vector2.copyInto(mdrModules_);
        mdrModules_ = CgUtility.sortModules(mdrModules_);
        return mdrModules_;
    }

    public static SMModuleInfo[] sortModules(SMModuleInfo[] sMModuleInfoArray) {
        TreeSet<SMModuleInfo> treeSet = new TreeSet<SMModuleInfo>();
        int n = 0;
        while (n < sMModuleInfoArray.length) {
            treeSet.add(sMModuleInfoArray[n]);
            ++n;
        }
        SMModuleInfo[] sMModuleInfoArray2 = new SMModuleInfo[sMModuleInfoArray.length];
        Iterator iterator = treeSet.iterator();
        int n2 = 0;
        while (n2 < sMModuleInfoArray2.length) {
            sMModuleInfoArray2[n2] = (SMModuleInfo)iterator.next();
            ++n2;
        }
        return sMModuleInfoArray2;
    }

    public static SMTaskType[] getTaskTypes(SMTask sMTask) {
        if (taskTypes_ != null) {
            return taskTypes_;
        }
        try {
            if (sMTask == null) {
                if (SMConsoleContext.getInstance().getAPIHandle() == null) {
                    return SMTask.getStaticTaskTypes();
                }
                if (sMTask == null) {
                    String string = "GU_TASK";
                    sMTask = (SMTask)SMHandleRegistry.getInstance((String)"CONSOLE").getHandle(string);
                    if (sMTask == null) {
                        sMTask = new SMTask(SMConsoleContext.getInstance().getAPIHandle());
                        SMHandleRegistry.getInstance((String)"CONSOLE").addHandle(string, (SMHandle)sMTask);
                    }
                }
            }
            taskTypes_ = sMTask.getTaskTypes() == null || sMTask.getTaskTypes().length == 0 ? SMTask.getStaticTaskTypes() : sMTask.getTaskTypes();
        }
        catch (Exception exception) {
            taskTypes_ = SMTask.getStaticTaskTypes();
        }
        return taskTypes_;
    }

    public static boolean isValidModuleInstanceName(String string) {
        if (string == null) {
            return false;
        }
        if (Character.isDigit(string.trim().charAt(0))) {
            return false;
        }
        if (UcListUtil.isAsciiString((String)string)) {
            return string.indexOf("/") == -1 && string.indexOf(" ") == -1 && string.indexOf("\"") == -1 && string.indexOf("\\") == -1 && string.indexOf("<") == -1 && string.indexOf(">") == -1 && string.indexOf("#") == -1 && string.indexOf("%") == -1 && string.indexOf("{") == -1 && string.indexOf("}") == -1 && string.indexOf("|") == -1 && string.indexOf("^") == -1 && string.indexOf("~") == -1 && string.indexOf("`") == -1 && string.indexOf("[") == -1 && string.indexOf("]") == -1 && string.indexOf(":") == -1 && string.indexOf(".") == -1 && string.indexOf("$") == -1 && string.indexOf("(") == -1 && string.indexOf(")") == -1 && string.indexOf("!") == -1 && string.indexOf("@") == -1 && string.indexOf("&") == -1 && string.indexOf("*") == -1 && string.indexOf("=") == -1 && string.indexOf("'") == -1 && string.indexOf("?") == -1 && string.indexOf(",") == -1 && string.indexOf(";") == -1;
        }
        return false;
    }

    public static int getPortForAgent(String string) {
        SMUserDomainRequest sMUserDomainRequest = new SMUserDomainRequest(SMConsoleContext.getInstance().getAPIHandle());
        try {
            SMUserDomainData[] sMUserDomainDataArray = sMUserDomainRequest.getAllConfiguredDomains();
            if (sMUserDomainDataArray == null) {
                return -1;
            }
            int n = 0;
            while (n < sMUserDomainDataArray.length) {
                int n2 = CgUtility.getPortForAgent(sMUserDomainDataArray[n], string);
                if (n2 > 0) {
                    return n2;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    private static int getPortForAgent(SMUserDomainData sMUserDomainData, String string) {
        SMTopologyRequest sMTopologyRequest = new SMTopologyRequest(SMConsoleContext.getInstance().getAPIHandle());
        CmTopologyPath cmTopologyPath = new CmTopologyPath(sMUserDomainData.getDomainName(), sMUserDomainData.getDomainName(), sMUserDomainData.getDomainRootUrl());
        boolean bl = false;
        boolean bl2 = false;
        Vector<CmTopologyPath> vector = new Vector<CmTopologyPath>();
        Vector<Object> vector2 = new Vector<Object>();
        vector.addElement(cmTopologyPath);
        vector2.addElement(new Hashtable());
        while (vector.size() != 0) {
            Vector vector3 = new Vector();
            Vector vector4 = new Vector();
            try {
                UcAgentURL ucAgentURL;
                CmTopologyPath cmTopologyPath2 = (CmTopologyPath)vector.elementAt(0);
                String string2 = cmTopologyPath2.getEnd().getNodeUrl();
                string2 = UcURL.standardizeURL((String)string2);
                Hashtable hashtable = (Hashtable)vector2.elementAt(0);
                if (hashtable.containsKey(string2)) {
                    vector.removeElementAt(0);
                    vector2.removeElementAt(0);
                    continue;
                }
                hashtable.put(string2, string2);
                sMTopologyRequest.topologySearchByHost(string2, string, vector3, vector4);
                SMRawDataRequest sMRawDataRequest = SMConsoleContext.getInstance().getAPIHandle();
                int n = 0;
                while (n < vector3.size()) {
                    SMHierarchyViewData sMHierarchyViewData = (SMHierarchyViewData)vector3.elementAt(n);
                    ucAgentURL = new UcAgentURL(sMHierarchyViewData.getTargetUrl());
                    int n2 = ucAgentURL.getAgentPort();
                    String[] stringArray = new String[]{"snmp://" + ucAgentURL.getHost() + ":" + n2 + "/sym/base/info/agent/general/component#0"};
                    try {
                        StObject[][] stObjectArray = sMRawDataRequest.getURLValue(stringArray);
                        if (stObjectArray.length == 1 && stObjectArray[0][0] != null && stObjectArray[0][0].toString().equals("agent")) {
                            return n2;
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    ++n;
                }
                int n3 = 0;
                while (n3 < vector4.size()) {
                    ucAgentURL = (SMHierarchyViewData)vector4.elementAt(n3);
                    CmTopologyPath cmTopologyPath3 = new CmTopologyPath(cmTopologyPath2);
                    cmTopologyPath3.push(ucAgentURL.getObjectId(), ucAgentURL.getName(), ucAgentURL.getTargetUrl());
                    vector.addElement(cmTopologyPath3);
                    vector2.addElement(hashtable.clone());
                    ++n3;
                }
            }
            catch (SMAPIException sMAPIException) {
                if (sMAPIException.getReasonCode() == 1) {
                    bl2 = true;
                }
                bl = true;
            }
            vector.removeElementAt(0);
            vector2.removeElementAt(0);
        }
        if (bl2) {
            return -1;
        }
        return -1;
    }

    public static String formatDuration(float f) {
        StringBuffer stringBuffer = new StringBuffer();
        if (f / 1000.0f < 1.0f) {
            stringBuffer.append(f / 1000.0f);
            stringBuffer.append(" ");
            stringBuffer.append(CgUtility.getI18nMsg("log.secs"));
            return stringBuffer.toString();
        }
        String string = "HH:mm:ss";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        try {
            Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            Date date = new Date((long)f);
            calendar.setTime(date);
            int n = calendar.get(5);
            if (n > 1) {
                stringBuffer.append(n - 1);
                stringBuffer.append(" ");
                stringBuffer.append(CgUtility.getI18nMsg("log.days"));
                stringBuffer.append(" ");
            }
            stringBuffer.append(simpleDateFormat.format(date));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    public static String getInstanceName(JFrame jFrame) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JLabel jLabel = new JLabel(CgUtility.getI18nMsg("module.instanceName") + ":");
        jLabel.setAlignmentX(0.0f);
        jPanel.add(jLabel);
        JTextField jTextField = new JTextField();
        jTextField.setAlignmentX(0.0f);
        jPanel.add(jTextField);
        Object[] objectArray = new Object[]{CgUtility.getI18nMsg("message.ok"), CgUtility.getI18nMsg("message.cancel")};
        JOptionPane jOptionPane = new JOptionPane(jPanel, 3, 2, null, objectArray, objectArray[0]);
        JDialog jDialog = jOptionPane.createDialog(jFrame, CgUtility.getI18nMsg("module.inputInstanceTitle"));
        jDialog.show();
        Object object = jOptionPane.getValue();
        if (object != null && object.equals(objectArray[0])) {
            String string = jTextField.getText().trim();
            if (string.length() == 0 || !CgUtility.isValidModuleInstanceName(string)) {
                CgUtility.showErrorMessage("module.invalidInstanceName");
                return null;
            }
            return string;
        }
        return null;
    }

    static {
        lastFilter_ = "";
        lastTask_ = "";
        instance_ = new Hashtable();
    }
}

