/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.didgets;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.task.SMTaskOperationData;
import com.sun.symon.base.console.awx.AwxServiceManager;
import com.sun.symon.base.console.awx.AwxServiceProvider;
import com.sun.symon.base.console.didgets.CdValueEditorException;
import com.sun.symon.base.console.manager.CmConsoleSession;
import com.sun.symon.base.server.types.StInteger;
import com.sun.symon.base.server.types.StNull;
import com.sun.symon.base.server.types.StObject;
import com.sun.symon.base.server.types.StSnmpCounter;
import com.sun.symon.base.server.types.StSnmpCounter32;
import com.sun.symon.base.server.types.StSnmpCounter64;
import com.sun.symon.base.server.types.StSnmpGauge;
import com.sun.symon.base.server.types.StSnmpIpAddress;
import com.sun.symon.base.server.types.StSnmpOBJECT_IDENTIFIER;
import com.sun.symon.base.server.types.StSnmpOCTET_STRING;
import com.sun.symon.base.server.types.StSnmpTimeTicks;
import com.sun.symon.base.server.types.StSnmpUInteger32;
import com.sun.symon.base.server.types.StString;
import com.sun.symon.base.utility.UcDDL;
import com.sun.symon.base.utility.UcDialog;
import com.sun.symon.base.utility.UcInternationalizer;
import com.sun.symon.base.utility.UcListUtil;
import com.sun.symon.base.utility.UcURL;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.text.Keymap;

public class CdPropValueEditorPane
extends JPanel
implements AwxServiceManager,
ActionListener {
    private JTextField inputArea;
    private JButton okDefault;
    private String initValue = "";
    private String format = null;
    private boolean isRequired = false;
    private String url;
    private String type = null;
    private boolean doModify = false;
    private boolean forColumn = false;
    SMRawDataRequest handle = null;
    Component parent = null;
    private AwxServiceProvider SvcProvider = null;
    String windowId = null;
    Vector taskOpListeners = new Vector();
    boolean hasInit = false;

    public CdPropValueEditorPane() {
    }

    public CdPropValueEditorPane(SMTaskOperationData sMTaskOperationData) throws CdValueEditorException {
        this.doModify = true;
        if (sMTaskOperationData == null) {
            throw new CdValueEditorException("null task  operation for set value", sMTaskOperationData);
        }
        String string = sMTaskOperationData.getUserData();
        if (!string.startsWith("Value")) {
            throw new CdValueEditorException("Invalid task  operation for set value", sMTaskOperationData);
        }
        this.url = sMTaskOperationData.getOperand();
        this.type = sMTaskOperationData.getValueType();
        this.initValue = sMTaskOperationData.getValue();
        int n = string.indexOf("#$#");
        this.format = string.substring(n + 3);
        if (this.format == null) {
            this.format = "";
        }
    }

    public CdPropValueEditorPane(String string) {
        this.initValue = string;
    }

    public void registerServiceProvider(AwxServiceProvider awxServiceProvider) {
        this.SvcProvider = awxServiceProvider;
    }

    public void setDataFormat(String string) {
        this.format = string;
    }

    public void setParent(Component component) {
        this.parent = component;
    }

    public void setWindow(Object object) {
        this.parent = (Dialog)object;
    }

    public void setTargetURL(String string) {
        this.url = string;
        this.setInitBySelf(true);
    }

    public void setDataType(String string) {
        this.type = string;
    }

    public void setDataSource(SMRawDataRequest sMRawDataRequest) {
        this.handle = sMRawDataRequest;
        this.setInitBySelf(true);
    }

    public void setInitBySelf(boolean bl) {
        if (!bl) {
            return;
        }
        if (this.handle != null && this.url != null && !this.url.equals("")) {
            this.init();
        }
    }

    private void findTopParent() {
        if (this.parent != null) {
            return;
        }
        Container container = this;
        while (container != null) {
            if (container instanceof Window) {
                this.parent = (Window)container;
                return;
            }
            container = container.getParent();
        }
        this.parent = null;
    }

    public void init() {
        if (this.hasInit) {
            return;
        }
        this.findTopParent();
        if (this.type == null || this.format == null) {
            this.getTypeInfo();
        }
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        String string = UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:table.setValueMesg");
        JLabel jLabel = new JLabel(string);
        jPanel2.add((Component)jLabel, "West");
        jLabel.setDisplayedMnemonic(UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:table.setValueMesg.mnemonic", (boolean)true).charAt(0));
        JTextField jTextField = new JTextField(16);
        if (this.initValue != null) {
            jTextField.setText(this.initValue);
        }
        jPanel2.add((Component)jTextField, "Center");
        jLabel.setLabelFor(jTextField);
        this.inputArea = jTextField;
        jPanel.add(jPanel2);
        jPanel.add(Box.createVerticalStrut(10));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.add(Box.createHorizontalGlue());
        string = UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:message.ok");
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        this.okDefault = jButton;
        string = UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:message.cancel");
        JButton jButton2 = new JButton(string);
        jButton2.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (CdPropValueEditorPane.this.SvcProvider != null) {
                    CdPropValueEditorPane.this.SvcProvider.triggerService("close");
                } else if (CdPropValueEditorPane.this.parent != null && CdPropValueEditorPane.this.parent instanceof Window) {
                    ((Window)CdPropValueEditorPane.this.parent).dispose();
                }
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (CdPropValueEditorPane.this.SvcProvider != null) {
                    CdPropValueEditorPane.this.SvcProvider.triggerService("close");
                } else if (CdPropValueEditorPane.this.parent != null && CdPropValueEditorPane.this.parent instanceof Window) {
                    ((Window)CdPropValueEditorPane.this.parent).dispose();
                }
            }
        });
        string = UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:standard.help");
        JButton jButton3 = new JButton(string);
        jButton3.setMnemonic(UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:standard.help.mnemonic", (boolean)true).charAt(0));
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = "grouping-task-value-help";
                CmConsoleSession cmConsoleSession = CmConsoleSession.getInstance();
                cmConsoleSession.launchHelp(string);
            }
        });
        jPanel3.add(jButton);
        jPanel3.add(Box.createHorizontalStrut(10));
        jPanel3.add(jButton2);
        jPanel3.add(Box.createHorizontalStrut(10));
        jPanel3.add(jButton3);
        jPanel.add(jPanel3);
        jPanel.add(Box.createVerticalGlue());
        this.add(jPanel);
        this.hasInit = true;
    }

    public void addNotify() {
        super.addNotify();
        Keymap keymap = this.inputArea.getKeymap();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0);
        keymap.removeKeyStrokeBinding(keyStroke);
        Container container = this.getParent();
        while (container != null && !(container instanceof JRootPane)) {
            container = container.getParent();
        }
        if (container != null && container instanceof JRootPane) {
            ((JRootPane)container).setDefaultButton(this.okDefault);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = this.inputArea.getText().trim();
        CdPropValueEditorPane.saveDataToAgent(this.url, string, this.type, this.format, true, this, this.handle);
        this.inputArea.setText("");
        if (this.SvcProvider != null) {
            this.SvcProvider.triggerService("close");
        } else if (this.parent != null && this.parent instanceof Window) {
            ((Window)this.parent).dispose();
        }
    }

    public static boolean saveDataToAgent(String string, String string2, String string3, String string4, boolean bl, Component component, SMRawDataRequest sMRawDataRequest) {
        if (string == null || string3 == null) {
            return false;
        }
        int n = UcDialog.showOkCancel((String)UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:table.confirmChangeMesg"));
        if (n == 0) {
            boolean bl2 = CdPropValueEditorPane.confirmEditedData(string2, string3, string4);
            if (!bl2) {
                JOptionPane.showMessageDialog(component, UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:table.errValueMesg"), UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:table.errValueTitle"), 2);
                return false;
            }
            if (string4 != null && string4.equals("unicode")) {
                string2 = UcListUtil.UnicodeToAscii((String)string2);
            }
            return CdPropValueEditorPane.confirmSaveValue(string, string2, string3, bl, component, sMRawDataRequest);
        }
        return false;
    }

    public static boolean confirmSaveValue(String string, String string2, String string3, boolean bl, Component component, SMRawDataRequest sMRawDataRequest) {
        String string4;
        if (string2 == null || string2.trim().equals("")) {
            if (CdPropValueEditorPane.isValueRequired(sMRawDataRequest, string)) {
                String string5 = UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:table.errValueRequired");
                UcDialog.showError((Component)component, (Object)string5);
                return false;
            }
            if (string2 == null) {
                return false;
            }
        } else {
            string2 = string4 = string2.trim();
        }
        string4 = SMRawDataRequest.buildShadowURL((String)string, (String)"asn1type", null);
        String[] stringArray = new String[]{string4};
        StObject[][] stObjectArray = null;
        try {
            stObjectArray = sMRawDataRequest.getURLValue(stringArray);
        }
        catch (SMAPIException sMAPIException) {
            Object object;
            UcDDL.logErrorMessage((String)("Editing cell failed for: " + string), (Throwable)sMAPIException);
            String[] stringArray2 = new String[1];
            stringArray2[0] = sMAPIException.getReasonCode() == 1 ? (CmConsoleSession.isInRemoteServerContext((object = new UcURL(string)).getHost(), object.getPort()) ? UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:tableCell.editNoaccess") + " " + UcInternationalizer.translateKey((String)"base.console.ConsoleMessages:console.remoteServer") : "base.console.ConsoleGeneric:tableCell.editNoaccess") : "base.console.ConsoleGeneric:tableCell.editFailed";
            object = UcInternationalizer.translateKey((String)stringArray2[0]);
            UcDialog.showError((Component)component, (Object)object);
            return false;
        }
        String string6 = stObjectArray == null || stObjectArray.length != 1 ? string3 : stObjectArray[0][0].toString();
        StObject[][] stObjectArray2 = new StObject[1][1];
        StObject stObject = CdPropValueEditorPane.mapValue(string2, string6);
        try {
            String[] stringArray3 = new String[]{string};
            stObjectArray2[0][0] = stObject;
            if (!bl) {
                sMRawDataRequest.setURLValue(stringArray3, stObjectArray2);
            } else if (bl) {
                stringArray3[0] = string = SMRawDataRequest.buildShadowURL((String)string, null, null, (String)"ALL");
                sMRawDataRequest.setURLValue(stringArray3, stObjectArray2);
            }
        }
        catch (SMAPIException sMAPIException) {
            Object object;
            UcDDL.logErrorMessage((String)("Editing cell failed for: " + string), (Throwable)sMAPIException);
            String[] stringArray4 = new String[1];
            stringArray4[0] = sMAPIException.getReasonCode() == 1 ? (CmConsoleSession.isInRemoteServerContext((object = new UcURL(string)).getHost(), object.getPort()) ? UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:tableCell.editNoaccess") + " " + UcInternationalizer.translateKey((String)"base.console.ConsoleMessages:console.remoteServer") : "base.console.ConsoleGeneric:tableCell.editFailed") : "base.console.ConsoleGeneric:tableCell.editFailed";
            object = UcInternationalizer.translateKey((String)stringArray4[0]);
            UcDialog.showError((Component)component, (Object)object);
            return false;
        }
        return true;
    }

    public static boolean confirmEditedData(String string, String string2, String string3) {
        int n;
        String string4 = string;
        int n2 = string4.indexOf("\"");
        int n3 = string4.indexOf("\\");
        if (string3 == null) {
            string3 = "";
        }
        if (!string3.equals("unicode") && !UcListUtil.isAsciiString((String)string4)) {
            return false;
        }
        if (string3.equals("instance")) {
            if (Character.isDigit(string4.trim().charAt(0))) {
                return false;
            }
            if (string4.indexOf("\"") != -1 || string4.indexOf("\\") != -1 || string4.indexOf("<") != -1 || string4.indexOf(">") != -1 || string4.indexOf("#") != -1 || string4.indexOf("%") != -1 || string4.indexOf("{") != -1 || string4.indexOf("}") != -1 || string4.indexOf("|") != -1 || string4.indexOf("^") != -1 || string4.indexOf("~") != -1 || string4.indexOf("`") != -1 || string4.indexOf("[") != -1 || string4.indexOf("]") != -1 || string4.indexOf(":") != -1 || string4.indexOf(".") != -1 || string4.indexOf("$") != -1 || string4.indexOf("(") != -1 || string4.indexOf(")") != -1 || string4.indexOf("!") != -1 || string4.indexOf("@") != -1 || string4.indexOf("&") != -1 || string4.indexOf("*") != -1 || string4.indexOf("=") != -1 || string4.indexOf("'") != -1 || string4.indexOf("?") != -1 || string4.indexOf(",") != -1 || string4.indexOf(";") != -1) {
                return false;
            }
            n = (string4 = string4.trim()).indexOf(" ");
            if (n > 0) {
                return false;
            }
            if ((string4 = string4.trim()).length() > 32) {
                return false;
            }
        } else if (string3.equals("filename_nopath") && ((string4 = string4.trim()).indexOf("/") != -1 || string4.indexOf("#") != -1 || string4.indexOf(";") != -1 || string4.indexOf(":") != -1 || string4.indexOf("?") != -1)) {
            return false;
        }
        return !(string2.equals("int") ? !CdPropValueEditorPane.typeMatch(string4, string2) && string4.length() != 0 : (string2.equals("uint") ? !CdPropValueEditorPane.typeMatch(string4, string2) && string4.length() != 0 : (string2.equals("float") ? !CdPropValueEditorPane.typeMatch(string4, string2) && string4.length() != 0 : string2.equals("nospace") && (n = (string4 = string4.trim()).indexOf(" ")) > 0)));
    }

    public static boolean typeMatch(String string, String string2) {
        if (string2.equals("int")) {
            try {
                int n = Integer.parseInt(string);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        if (string2.equals("uint")) {
            try {
                int n = Integer.parseInt(string);
                return n >= 0;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        if (string2.equals("float")) {
            try {
                Float f = Float.valueOf(string);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        return true;
    }

    private void getTypeInfo() {
        if (this.handle == null || this.url == null) {
            return;
        }
        String string = SMRawDataRequest.buildShadowURL((String)this.url, (String)"datatype", null);
        String string2 = SMRawDataRequest.buildShadowURL((String)this.url, (String)"dataformat", null);
        String[] stringArray = new String[]{string, string2};
        StObject[][] stObjectArray = null;
        try {
            stObjectArray = this.handle.getURLValue(stringArray);
        }
        catch (SMAPIException sMAPIException) {
            sMAPIException.printStackTrace();
            return;
        }
        if (stObjectArray == null || stObjectArray.length != 2) {
            return;
        }
        this.type = stObjectArray[0][0].toString();
        this.format = stObjectArray[1][0].toString();
    }

    public static boolean isValueRequired(SMRawDataRequest sMRawDataRequest, String string) {
        if (sMRawDataRequest == null) {
            return false;
        }
        String string2 = SMRawDataRequest.buildShadowURL((String)string, (String)"required", null);
        String[] stringArray = new String[]{string2};
        StObject[][] stObjectArray = null;
        try {
            stObjectArray = sMRawDataRequest.getURLValue(stringArray);
        }
        catch (SMAPIException sMAPIException) {
            sMAPIException.printStackTrace();
            return false;
        }
        if (stObjectArray == null || stObjectArray.length != 1) {
            return false;
        }
        String string3 = stObjectArray[0][0].toString();
        return string3.equals("true");
    }

    public static String mapType(String string) {
        String string2 = "com.sun.symon.base.server.types.";
        String string3 = string.equals("string") ? "StString" : (string.equals("int") ? "StInteger" : (string.equals("counter") ? "StSnmpCounter" : (string.equals("conter32") ? "StSnmpCounter32" : (string.equals("counter64") ? "StSnmpCounter64" : (string.equals("gauge") ? "StSnmpGauge" : (string.equals("uint") ? "StSnmpUInteger32" : (string.equals("timeticks") ? "StSnmpTimeTicks" : (string.equals("ipaddress") ? "StSnmpIpAddress" : (string.equals("oid") ? "StSnmpOBJECT_IDENTIFIER" : (string.equals("octetstring") ? "StSnmpOCTET_STRING" : "StString"))))))))));
        return string2 + string3;
    }

    public static StObject mapValue(String string, String string2) {
        if (string == null) {
            return new StNull();
        }
        if (string2.equals("string")) {
            return new StString(string);
        }
        if (string2.equals("int") || string2.equals("Integer32")) {
            return new StInteger(string);
        }
        if (string2.equals("counter")) {
            return new StSnmpCounter(string);
        }
        if (string2.equals("conter32") || string2.equals("Counter32")) {
            return new StSnmpCounter32(string);
        }
        if (string2.equals("counter64") || string2.equals("Counter64")) {
            return new StSnmpCounter64(string);
        }
        if (string2.equals("gauge") || string2.equals("Gauge32")) {
            return new StSnmpGauge(string);
        }
        if (string2.equals("uint") || string2.equals("Unsigned32")) {
            return new StSnmpUInteger32(string);
        }
        if (string2.equals("timeticks") || string2.equals("TimeTicks")) {
            return new StSnmpTimeTicks(string);
        }
        if (string2.equals("ipaddress") || string2.equals("IpAddress")) {
            return new StSnmpIpAddress(string);
        }
        if (string2.equals("oid") || string2.equals("OBJECT IDENTIFIER")) {
            return new StSnmpOBJECT_IDENTIFIER(string);
        }
        if (string2.equals("octetstring") || string2.equals("OCTET STRING")) {
            return new StSnmpOCTET_STRING(string);
        }
        return new StString(string);
    }
}

