/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.client.topology;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.SMRawDataResponse;
import com.sun.symon.base.client.SMResourceAccess;
import com.sun.symon.base.client.alarm.SMAlarmStatusData;
import com.sun.symon.base.client.alarm.SMAlarmStatusRequest;
import com.sun.symon.base.client.alarm.SMAlarmStatusResponse;
import com.sun.symon.base.client.topology.SMAdornmentTxltr;
import com.sun.symon.base.client.topology.SMEntityViewTxltr;
import com.sun.symon.base.client.topology.SMFamilyCommands;
import com.sun.symon.base.client.topology.SMFamilyImages;
import com.sun.symon.base.client.topology.SMHierarchyResponse;
import com.sun.symon.base.client.topology.SMHierarchyTxltr;
import com.sun.symon.base.client.topology.SMHierarchyViewData;
import com.sun.symon.base.client.topology.SMTopologyAdornmentData;
import com.sun.symon.base.client.topology.SMTopologyEntityData;
import com.sun.symon.base.client.topology.SMTopologyEntityInfo;
import com.sun.symon.base.client.topology.SMTopologyEntityViewData;
import com.sun.symon.base.client.topology.SMTopologyException;
import com.sun.symon.base.client.topology.SMTopologyResponse;
import com.sun.symon.base.client.topology.SMTopologyViewInfo;
import com.sun.symon.base.client.topology.SMUserDomainData;
import com.sun.symon.base.client.topology.SMUserDomainRequest;
import com.sun.symon.base.server.types.StObject;
import com.sun.symon.base.server.types.StString;
import com.sun.symon.base.utility.UcAgentURL;
import com.sun.symon.base.utility.UcDDL;
import com.sun.symon.base.utility.UcInternationalizer;
import com.sun.symon.base.utility.UcListUtil;
import com.sun.symon.base.utility.UcURL;
import java.io.Serializable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class SMTopologyRequest {
    private SMRawDataRequest handle;
    private SMResourceAccess resourceAcc;
    private ResourceBundle rbundle;
    private Locale locale;
    private String topoBaseUrl;
    private boolean sunHostOnly;
    private static Boolean isTopologyAgentInIPMode = null;

    public SMTopologyRequest(SMRawDataRequest sMRawDataRequest) {
        this.handle = sMRawDataRequest;
        this.resourceAcc = new SMResourceAccess(sMRawDataRequest);
        this.rbundle = this.handle.getResourceBundle();
        this.locale = this.handle.getLocale();
        this.topoBaseUrl = this.handle.getTopologyBaseURL();
        this.sunHostOnly = this.handle.isSunHostOnly();
    }

    private static String buildMibUrl(String string, String string2) {
        if (string.charAt(string.length() - 1) == '/') {
            return string + string2;
        }
        return string + "/" + string2;
    }

    public SMRawDataRequest getHandle() {
        return this.handle;
    }

    public void createAdornment(String string, int n, int n2, String string2, String string3) throws SMAPIException {
        String[] stringArray = new String[]{SMTopologyRequest.buildMibUrl(string, "adornmentAdder#0")};
        StObject[][] stObjectArray = new StObject[1][1];
        StringBuffer stringBuffer = new StringBuffer();
        UcListUtil.appendElement((StringBuffer)stringBuffer, (String)("" + n));
        UcListUtil.appendElement((StringBuffer)stringBuffer, (String)("" + n2));
        UcListUtil.appendElement((StringBuffer)stringBuffer, (String)string2);
        UcListUtil.appendElement((StringBuffer)stringBuffer, (String)string3);
        stObjectArray[0][0] = new StString(stringBuffer.toString());
        StObject[][] stObjectArray2 = this.handle.setURLValue(stringArray, stObjectArray);
        if (stObjectArray2 == null || stObjectArray2.length != 1) {
            throw new SMAPIException(this.rbundle.getString("TopologyRequest.InvalidAdornmentCreateReturn"));
        }
        if (stObjectArray2[0][0].toString().compareTo("addok") != 0) {
            throw new SMAPIException(this.rbundle.getString("TopologyRequest.AdornmentCreationFailed"));
        }
    }

    public String createChildDataView(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) throws SMAPIException, SMTopologyException {
        String[] stringArray = new String[]{SMTopologyRequest.buildMibUrl(string, "viewCreator#0")};
        StObject[][] stObjectArray = new StObject[1][1];
        StringBuffer stringBuffer = new StringBuffer();
        UcListUtil.appendElement((StringBuffer)stringBuffer, (String)"data");
        UcListUtil.appendElement((StringBuffer)stringBuffer, (String)"");
        UcListUtil.appendElement((StringBuffer)stringBuffer, (String)UcListUtil.UnicodeToAscii((String)string2));
        UcListUtil.appendElement((StringBuffer)stringBuffer, (String)UcListUtil.UnicodeToAscii((String)string3));
        UcListUtil.appendElement((StringBuffer)stringBuffer, (String)string4);
        UcListUtil.appendElement((StringBuffer)stringBuffer, (String)string5);
        UcListUtil.appendElement((StringBuffer)stringBuffer, (String)string6);
        UcListUtil.appendElement((StringBuffer)stringBuffer, (String)string7);
        UcListUtil.appendElement((StringBuffer)stringBuffer, (String)string8);
        stObjectArray[0][0] = new StString(stringBuffer.toString());
        StObject[][] stObjectArray2 = this.handle.setURLValue(stringArray, stObjectArray);
        if (stObjectArray2 == null || stObjectArray2.length != 1) {
            throw new SMAPIException(this.rbundle.getString("TopologyRequest.InvalidViewCreateReturnInformation"));
        }
        Vector vector = new Vector();
        if (!UcListUtil.decomposeList((String)stObjectArray2[0][0].toString(), vector) || vector.size() == 0) {
            throw new SMAPIException(this.rbundle.getString("TopologyRequest.InvalidViewCreateReturnInfo") + " " + stObjectArray2[0][0].toString());
        }
        if (((String)vector.elementAt(0)).compareTo("createmax") == 0) {
            throw new SMTopologyException(5, this.rbundle.getString("TopologyRequest.ViewCreationFailed"));
        }
        if (((String)vector.elementAt(0)).compareTo("createlicense") == 0) {
            throw new SMTopologyException(6, this.rbundle.getString("TopologyRequest.ViewCreationFailed"));
        }
        if (((String)vector.elementAt(0)).compareTo("createok") != 0) {
            throw new SMAPIException(this.rbundle.getString("TopologyRequest.ViewCreationFailed"));
        }
        if (vector.size() != 3) {
            throw new SMAPIException(this.rbundle.getString("TopologyRequest.InvalidViewCreateResult") + " " + stObjectArray2[0][0].toString());
        }
        return (String)vector.elementAt(2);
    }

    public String createChildTopologyView(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) throws SMAPIException, SMTopologyException {
        return this.createChildTopologyView(string, string2, string3, string4, string5, string6, string7, string8, "");
    }

    public String createChildTopologyView(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9) throws SMAPIException, SMTopologyException {
        String[] stringArray = new String[]{SMTopologyRequest.buildMibUrl(string, "viewCreator#0")};
        StObject[][] stObjectArray = new StObject[1][1];
        StringBuffer stringBuffer = new StringBuffer();
        UcListUtil.appendElement((StringBuffer)stringBuffer, (String)"topo");
        UcListUtil.appendElement((StringBuffer)stringBuffer, (String)"");
        UcListUtil.appendElement((StringBuffer)stringBuffer, (String)UcListUtil.UnicodeToAscii((String)string2));
        UcListUtil.appendElement((StringBuffer)stringBuffer, (String)UcListUtil.UnicodeToAscii((String)string3));
        UcListUtil.appendElement((StringBuffer)stringBuffer, (String)string4);
        UcListUtil.appendElement((StringBuffer)stringBuffer, (String)string5);
        UcListUtil.appendElement((StringBuffer)stringBuffer, (String)string6);
        UcListUtil.appendElement((StringBuffer)stringBuffer, (String)string7);
        UcListUtil.appendElement((StringBuffer)stringBuffer, (String)string8);
        UcListUtil.appendElement((StringBuffer)stringBuffer, (String)string9);
        stObjectArray[0][0] = new StString(stringBuffer.toString());
        StObject[][] stObjectArray2 = this.handle.setURLValue(stringArray, stObjectArray);
        if (stObjectArray2 == null || stObjectArray2.length != 1) {
            throw new SMAPIException(this.rbundle.getString("TopologyRequest.InvalidViewCreateReturnInformation"));
        }
        Vector vector = new Vector();
        if (!UcListUtil.decomposeList((String)stObjectArray2[0][0].toString(), vector) || vector.size() == 0) {
            throw new SMAPIException(this.rbundle.getString("TopologyRequest.InvalidViewCreateReturnInfo") + " " + stObjectArray2[0][0].toString());
        }
        if (((String)vector.elementAt(0)).compareTo("createmax") == 0) {
            throw new SMTopologyException(5, this.rbundle.getString("TopologyRequest.ViewCreationFailed"));
        }
        if (((String)vector.elementAt(0)).compareTo("createlicense") == 0) {
            throw new SMTopologyException(6, this.rbundle.getString("TopologyRequest.ViewCreationFailed"));
        }
        if (((String)vector.elementAt(0)).compareTo("createok") != 0) {
            throw new SMAPIException(this.rbundle.getString("TopologyRequest.ViewCreationFailed"));
        }
        if (vector.size() != 3) {
            throw new SMAPIException(this.rbundle.getString("TopologyRequest.InvalidViewCreateResult") + " " + stObjectArray2[0][0].toString());
        }
        return (String)vector.elementAt(2);
    }

    public String createEntity(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, boolean bl, String string11, String string12, String string13, String string14, String string15, String string16) throws SMAPIException, SMTopologyException {
        return this.createEntity(string, string2, string3, string4, string5, string6, string7, string8, string9, string10, bl, string11, string12, string13, string14, string15, string16, this.sunHostOnly);
    }

    public String createEntity(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, boolean bl, String string11, String string12, String string13, String string14, String string15, String string16, boolean bl2) throws SMAPIException, SMTopologyException {
        Object object;
        String[] stringArray = new String[]{SMTopologyRequest.buildMibUrl(string, "entityAdder#0")};
        if (string11.equals("ahost") && bl2) {
            object = this.handle.getAgentVersion(string16, "name");
            boolean bl3 = this.handle.isSunHost(string16);
            if (!bl3 || !((String)object).equals("SyMON")) {
                throw new SMAPIException(this.rbundle.getString("TopologyRequest.EntityCreationFailed"));
            }
        }
        object = new StObject[1][1];
        StringBuffer stringBuffer = new StringBuffer();
        UcListUtil.appendElement((StringBuffer)stringBuffer, (String)"");
        UcListUtil.appendElement((StringBuffer)stringBuffer, (String)UcListUtil.UnicodeToAscii((String)string2));
        UcListUtil.appendElement((StringBuffer)stringBuffer, (String)UcListUtil.UnicodeToAscii((String)string3));
        UcListUtil.appendElement((StringBuffer)stringBuffer, (String)string4);
        UcListUtil.appendElement((StringBuffer)stringBuffer, (String)string5);
        UcListUtil.appendElement((StringBuffer)stringBuffer, (String)string6);
        UcListUtil.appendElement((StringBuffer)stringBuffer, (String)string7);
        UcListUtil.appendElement((StringBuffer)stringBuffer, (String)string8);
        UcListUtil.appendElement((StringBuffer)stringBuffer, (String)string9);
        UcListUtil.appendElement((StringBuffer)stringBuffer, (String)string10);
        UcListUtil.appendElement((StringBuffer)stringBuffer, (String)(bl ? "true" : "false"));
        UcListUtil.appendElement((StringBuffer)stringBuffer, (String)string11);
        UcListUtil.appendElement((StringBuffer)stringBuffer, (String)string12);
        UcListUtil.appendElement((StringBuffer)stringBuffer, (String)string13);
        UcListUtil.appendElement((StringBuffer)stringBuffer, (String)string14);
        UcListUtil.appendElement((StringBuffer)stringBuffer, (String)string15);
        UcListUtil.appendElement((StringBuffer)stringBuffer, (String)string16);
        object[0][0] = new StString(stringBuffer.toString());
        StObject[][] stObjectArray = this.handle.setURLValue(stringArray, (StObject[][])object);
        Vector vector = new Vector();
        if (!UcListUtil.decomposeList((String)stObjectArray[0][0].toString(), vector) || vector.size() == 0) {
            throw new SMAPIException(this.rbundle.getString("TopologyRequest.InvalidEntityCreateReturnInfo") + " " + stObjectArray[0][0].toString());
        }
        if (((String)vector.elementAt(0)).compareTo("addmax") == 0) {
            throw new SMTopologyException(5, this.rbundle.getString("TopologyRequest.EntityCreationFailed"));
        }
        if (((String)vector.elementAt(0)).compareTo("addlicense") == 0) {
            throw new SMTopologyException(6, this.rbundle.getString("TopologyRequest.EntityCreationFailed"));
        }
        if (((String)vector.elementAt(0)).compareTo("addok") != 0) {
            throw new SMAPIException(this.rbundle.getString("TopologyRequest.EntityCreationFailed"));
        }
        if (vector.size() != 2) {
            throw new SMAPIException(this.rbundle.getString("TopologyRequest.InvalidEntityCreateResult") + " " + stObjectArray[0][0].toString());
        }
        return (String)vector.elementAt(1);
    }

    public void deleteAdornments(String string, String[] stringArray) throws SMAPIException {
        String[] stringArray2 = new String[]{SMTopologyRequest.buildMibUrl(string, "adornmentRemover#0")};
        StObject[][] stObjectArray = new StObject[1][1];
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            UcListUtil.appendElement((StringBuffer)stringBuffer, (String)stringArray[n]);
            ++n;
        }
        stObjectArray[0][0] = new StString(stringBuffer.toString());
        StObject[][] stObjectArray2 = this.handle.setURLValue(stringArray2, stObjectArray);
        if (stObjectArray2 == null || stObjectArray2.length != 1) {
            throw new SMAPIException(this.rbundle.getString("TopologyRequest.InvalidAdornmentDeleteReturn"));
        }
        if (stObjectArray2[0][0].toString().compareTo("removeok") != 0) {
            throw new SMAPIException(this.rbundle.getString("TopologyRequest.AdornmentDeletionFailed"));
        }
    }

    public void deleteEntities(String string, String[] stringArray) throws SMAPIException, SMTopologyException {
        String[] stringArray2 = new String[]{SMTopologyRequest.buildMibUrl(string, "entityRemover#0")};
        StObject[][] stObjectArray = new StObject[1][1];
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            UcListUtil.appendElement((StringBuffer)stringBuffer, (String)stringArray[n]);
            ++n;
        }
        stObjectArray[0][0] = new StString(stringBuffer.toString());
        StObject[][] stObjectArray2 = this.handle.setURLValue(stringArray2, stObjectArray);
        if (stObjectArray2 == null || stObjectArray2.length != 1) {
            throw new SMAPIException(this.rbundle.getString("TopologyRequest.InvalidEntityDeleteReturn"));
        }
        if (stObjectArray2[0][0].toString().compareTo("removepartial") == 0) {
            throw new SMTopologyException(2, this.rbundle.getString("TopologyRequest.EntityDeletionFailed"));
        }
        if (stObjectArray2[0][0].toString().compareTo("removeok") != 0) {
            throw new SMAPIException(this.rbundle.getString("TopologyRequest.EntityDeletionFailed"));
        }
    }

    public void deleteView(String string) throws SMAPIException {
        String[] stringArray = new String[]{SMRawDataRequest.buildShadowURL(string, "moduleadminaction", null)};
        StObject[][] stObjectArray = new StObject[1][1];
        stObjectArray[0][0] = new StString("unload");
        StObject[][] stObjectArray2 = this.handle.setURLValue(stringArray, stObjectArray);
        if (stObjectArray2.length == 1 && stObjectArray2[0].length == 1 && stObjectArray2[0][0].toString().compareTo("unloadok") == 0) {
            return;
        }
        throw new SMAPIException(this.rbundle.getString("TopologyRequest.ErrorOccurredWhileDeletingView"));
    }

    public SMTopologyAdornmentData[] getAdornments(String string) throws SMAPIException {
        String[] stringArray = new String[]{SMRawDataRequest.buildShadowURL(string, "topologyadorn", null)};
        StObject[][] stObjectArray = this.handle.getURLValue(stringArray);
        SMTopologyAdornmentData[] sMTopologyAdornmentDataArray = null;
        try {
            if (stObjectArray.length == 0 || stObjectArray[0].length == 0) {
                throw new SMAPIException(3, this.rbundle.getString("TopologyRequest.InvalidAdornmentReturnData"));
            }
            Vector vector = new Vector();
            Vector vector2 = new Vector();
            String string2 = stObjectArray[0][0].toString();
            if (!UcListUtil.decomposeList((String)string2, vector)) {
                throw new SMAPIException(3, this.rbundle.getString("TopologyRequest.InvalidAdornmentReturnData"));
            }
            sMTopologyAdornmentDataArray = new SMTopologyAdornmentData[vector.size()];
            int n = 0;
            while (n < vector.size()) {
                String string3 = (String)vector.elementAt(n);
                UcListUtil.decomposeList((String)string3, vector2);
                if (vector2.size() != 5) {
                    throw new SMAPIException(3, this.rbundle.getString("TopologyRequest.InvalidAdornmentReturnData"));
                }
                int n2 = Integer.parseInt((String)vector2.elementAt(1));
                int n3 = Integer.parseInt((String)vector2.elementAt(2));
                sMTopologyAdornmentDataArray[n] = new SMTopologyAdornmentData((String)vector2.elementAt(0), n2, n3, (String)vector2.elementAt(3), (String)vector2.elementAt(4));
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            UcDDL.logErrorMessage((String)"Error processing adornments result");
        }
        return sMTopologyAdornmentDataArray;
    }

    public Object getAdornmentsRequest(String string, String string2, SMTopologyResponse sMTopologyResponse, Object object) throws SMAPIException {
        String[] stringArray = new String[]{SMRawDataRequest.buildShadowURL(string, "topologyadorn", null)};
        return this.handle.getURLValue(stringArray, string2, (SMRawDataResponse)new SMAdornmentTxltr(sMTopologyResponse, this.locale), object);
    }

    public Object getEntityViewsRequest(String string, String string2, boolean bl, SMTopologyResponse sMTopologyResponse, Object object) throws SMAPIException {
        String[] stringArray = bl ? new String[]{SMRawDataRequest.buildShadowURL(string, "topologychild", null), SMRawDataRequest.buildShadowURL(string, "indexedstatus", null), SMRawDataRequest.buildShadowURL(string, "module", null)} : new String[]{SMRawDataRequest.buildShadowURL(string, "topologychild", null)};
        UcAgentURL ucAgentURL = new UcAgentURL(string);
        String string3 = "snmp://" + ucAgentURL.getHost() + ":" + ucAgentURL.getPort() + "/mod/" + ucAgentURL.getModuleSpec() + "/entityInfoTable" + "/entityInfoEntry/entity";
        String string4 = "snmp://" + ucAgentURL.getHost() + ":" + ucAgentURL.getPort() + "/mod/" + ucAgentURL.getModuleSpec() + "/entityViewTable" + "/entityViewEntry/entityStatus";
        return this.handle.getURLValue(stringArray, string2, (SMRawDataResponse)new SMEntityViewTxltr(sMTopologyResponse, this.resourceAcc, string3, string4), object);
    }

    public String getEventMngrFromContext(String string) throws SMAPIException {
        return this.getEntityInfoProperty(string, "entityEventDest");
    }

    public String getTrapMngrFromContext(String string) throws SMAPIException {
        return this.getEntityInfoProperty(string, "entityTrapDest");
    }

    protected String getEntityInfoProperty(String string, String string2) throws SMAPIException {
        String[] stringArray = new String[1];
        UcAgentURL ucAgentURL = new UcAgentURL(string);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("snmp://").append(ucAgentURL.getHost()).append(":").append(ucAgentURL.getPort()).append("/mod/").append(ucAgentURL.getModuleSpec()).append("/entityInfoTable/entityInfoEntry/").append(string2).append(ucAgentURL.getFragment());
        stringArray[0] = stringBuffer.toString();
        StObject[][] stObjectArray = this.handle.getURLValue(stringArray);
        if (stObjectArray == null || stObjectArray.length != 1) {
            throw new SMAPIException(this.rbundle.getString("TopologyRequest.InvalidEventMngrInfo"));
        }
        return stObjectArray[0][0].toString();
    }

    public Object getHierarchyChildRequest(String string, String string2, boolean bl, SMHierarchyResponse sMHierarchyResponse, Object object) throws SMAPIException {
        String[] stringArray = bl ? new String[]{SMRawDataRequest.buildShadowURL(string, "hierarchychild", null), SMRawDataRequest.buildShadowURL(string, "indexedstatus", null), SMRawDataRequest.buildShadowURL(string, "module", null)} : new String[]{SMRawDataRequest.buildShadowURL(string, "hierarchychild", null)};
        UcAgentURL ucAgentURL = new UcAgentURL(string);
        String string3 = "snmp://" + ucAgentURL.getHost() + ":" + ucAgentURL.getPort() + "/mod/" + ucAgentURL.getModuleSpec() + "/entityInfoTable" + "/entityInfoEntry/entity";
        String string4 = "snmp://" + ucAgentURL.getHost() + ":" + ucAgentURL.getPort() + "/mod/" + ucAgentURL.getModuleSpec() + "/entityViewTable" + "/entityViewEntry/entityStatus";
        return this.handle.getURLValue(stringArray, string2, (SMRawDataResponse)new SMHierarchyTxltr(sMHierarchyResponse, this.resourceAcc, false, false, string3, string4), object);
    }

    public Object getHierarchyRootRequest(String string, String string2, boolean bl, SMHierarchyResponse sMHierarchyResponse, Object object) throws SMAPIException {
        String[] stringArray = bl ? new String[]{SMRawDataRequest.buildShadowURL(string, "hierarchydetail", null), SMRawDataRequest.buildShadowURL(string, "status", null), SMRawDataRequest.buildShadowURL(string, "module", null)} : new String[]{SMRawDataRequest.buildShadowURL(string, "hierarchydetail", null)};
        UcAgentURL ucAgentURL = new UcAgentURL(string);
        String string3 = "snmp://" + ucAgentURL.getHost() + ":" + ucAgentURL.getPort() + "/mod/" + ucAgentURL.getModuleSpec() + "/entityInfoTable" + "/entityInfoEntry/entity";
        String string4 = "snmp://" + ucAgentURL.getHost() + ":" + ucAgentURL.getPort() + "/mod/" + ucAgentURL.getModuleSpec() + "/entityViewTable" + "/entityViewEntry/entityStatus";
        return this.handle.getURLValue(stringArray, string2, (SMRawDataResponse)new SMHierarchyTxltr(sMHierarchyResponse, this.resourceAcc, true, false, string3, string4), object);
    }

    public Object getHierarchyRootRequestFromTopology(String string, String string2, SMHierarchyResponse sMHierarchyResponse, Object object) throws SMAPIException {
        String[] stringArray = new String[4];
        UcAgentURL ucAgentURL = new UcAgentURL(string);
        String string3 = "snmp://" + ucAgentURL.getHost() + ":" + ucAgentURL.getPort() + "/mod/" + ucAgentURL.getModuleSpec() + "/entityInfoTable" + "/entityInfoEntry";
        stringArray[0] = string3 + "/entityDesc" + ucAgentURL.getFragment();
        stringArray[1] = string3 + "/entityFamily" + ucAgentURL.getFragment();
        stringArray[2] = string3 + "/entityAttrInfo" + ucAgentURL.getFragment();
        stringArray[3] = string3 + "/entityTargetUrl" + ucAgentURL.getFragment();
        String string4 = "snmp://" + ucAgentURL.getHost() + ":" + ucAgentURL.getPort() + "/mod/" + ucAgentURL.getModuleSpec() + "/entityInfoTable" + "/entityInfoEntry/entity";
        String string5 = "snmp://" + ucAgentURL.getHost() + ":" + ucAgentURL.getPort() + "/mod/" + ucAgentURL.getModuleSpec() + "/entityViewTable" + "/entityViewEntry/entityStatus";
        return this.handle.getURLValue(stringArray, string2, (SMRawDataResponse)new SMHierarchyTxltr(sMHierarchyResponse, this.resourceAcc, true, true, string4, string5), object);
    }

    public Object getEntityStatusFromTopology(String string, String string2, SMAlarmStatusResponse sMAlarmStatusResponse, Object object) throws SMAPIException {
        UcAgentURL ucAgentURL = new UcAgentURL(string);
        String string3 = "snmp://" + ucAgentURL.getHost() + ":" + ucAgentURL.getPort() + "/mod/" + ucAgentURL.getModuleSpec() + "/entityViewTable" + "/entityViewEntry";
        SMAlarmStatusRequest sMAlarmStatusRequest = new SMAlarmStatusRequest(this.handle);
        return sMAlarmStatusRequest.getTableRowAlarmStatusRequest(string3, ucAgentURL.getFragment(), string2, sMAlarmStatusResponse, object);
    }

    public SMTopologyEntityData[] getTopologyInfo(String string, String[] stringArray) throws SMAPIException {
        Object object;
        Serializable serializable;
        String[] stringArray2 = new String[]{SMRawDataRequest.buildShadowURL(string, "topologyinfo", null)};
        StObject[][] stObjectArray = null;
        if (stringArray == null) {
            stObjectArray = this.handle.getURLValue(stringArray2);
        } else {
            serializable = new StringBuffer();
            if (stringArray != null) {
                int n = 0;
                while (n < stringArray.length) {
                    UcListUtil.appendElement((StringBuffer)serializable, (String)stringArray[n]);
                    ++n;
                }
            }
            object = new StObject[1][1];
            object[0][0] = new StString(((StringBuffer)serializable).toString());
            stObjectArray = this.handle.setURLValue(stringArray2, (StObject[][])object);
        }
        if (stObjectArray == null || stObjectArray.length != 1) {
            throw new SMAPIException(this.rbundle.getString("TopologyRequest.InvalidTopologyInfoReturn"));
        }
        serializable = new Vector();
        if (!UcListUtil.decomposeList((String)stObjectArray[0][0].toString(), (Vector)serializable)) {
            throw new SMAPIException(this.rbundle.getString("TopologyRequest.InvalidTopologyInfoListData"));
        }
        object = new Vector();
        SMTopologyEntityData[] sMTopologyEntityDataArray = new SMTopologyEntityData[((Vector)serializable).size()];
        int n = 0;
        while (n < ((Vector)serializable).size()) {
            String string2 = (String)((Vector)serializable).elementAt(n);
            UcListUtil.decomposeList((String)string2, (Vector)object);
            if (((Vector)object).size() != 20) {
                throw new SMAPIException(this.rbundle.getString("TopologyRequest.InvalidTopologyInfoRecord"));
            }
            sMTopologyEntityDataArray[n] = new SMTopologyEntityData((String)((Vector)object).elementAt(0), (String)((Vector)object).elementAt(1), (String)((Vector)object).elementAt(2), UcListUtil.AsciiToUnicode((String)((String)((Vector)object).elementAt(3))), UcListUtil.AsciiToUnicode((String)((String)((Vector)object).elementAt(4))), (String)((Vector)object).elementAt(5), (String)((Vector)object).elementAt(6), (String)((Vector)object).elementAt(7), (String)((Vector)object).elementAt(8), (String)((Vector)object).elementAt(9), (String)((Vector)object).elementAt(10), (String)((Vector)object).elementAt(11), (String)((Vector)object).elementAt(12), (String)((Vector)object).elementAt(13), (String)((Vector)object).elementAt(14), (String)((Vector)object).elementAt(15), (String)((Vector)object).elementAt(16), (String)((Vector)object).elementAt(17), (String)((Vector)object).elementAt(18), (String)((Vector)object).elementAt(19));
            ++n;
        }
        return sMTopologyEntityDataArray;
    }

    public SMTopologyEntityData[] getTopologyInfo(String string) throws SMAPIException {
        String[] stringArray;
        SMUserDomainData[] sMUserDomainDataArray;
        Object object;
        if (string == null || string == "") {
            string = "defaultdomain";
        }
        String string2 = string;
        boolean bl = false;
        if (!string.startsWith("snmp://")) {
            if (string.equalsIgnoreCase("defaultdomain")) {
                bl = true;
            }
            object = new SMUserDomainRequest(this.handle);
            sMUserDomainDataArray = ((SMUserDomainRequest)object).getAllConfiguredDomains();
            stringArray = null;
            int n = 0;
            n = 0;
            while (n < sMUserDomainDataArray.length) {
                stringArray = sMUserDomainDataArray[n];
                String string3 = stringArray.getDomainName();
                if (string.equals(string3) || bl && string3.endsWith("defaultdomain")) break;
                ++n;
            }
            if (n == sMUserDomainDataArray.length || stringArray == null) {
                throw new SMAPIException("Domain not found");
            }
            string2 = stringArray.getDomainRootUrl();
        }
        object = new String[]{string2 + "/entityInfoTable.entityInfoEntry.entity"};
        sMUserDomainDataArray = this.handle.getURLValue((String[])object);
        stringArray = null;
        if (sMUserDomainDataArray != null && sMUserDomainDataArray.length != 0) {
            Vector vector = new Vector();
            if (UcListUtil.decomposeList((String)((StObject)((Object)sMUserDomainDataArray[0][0])).toString(), vector)) {
                stringArray = new String[vector.size()];
                int n = 0;
                while (n < vector.size()) {
                    stringArray[n] = (String)vector.elementAt(n);
                    ++n;
                }
            }
        }
        return this.getTopologyInfo(string2, stringArray);
    }

    public SMTopologyEntityData getHostTopologyInfo(String string, String string2) throws SMAPIException {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        vector.addElement(string);
        while (n < vector.size()) {
            String string3 = (String)vector.elementAt(n);
            SMTopologyEntityData[] sMTopologyEntityDataArray = this.getTopologyInfo(string3);
            int n2 = 0;
            while (n2 < sMTopologyEntityDataArray.length) {
                String string4;
                if (!sMTopologyEntityDataArray[n2].getPollType().equals("aview")) {
                    if (string2.equals(sMTopologyEntityDataArray[n2].getHostName())) {
                        string4 = sMTopologyEntityDataArray[n2].getTargetUrl();
                        return sMTopologyEntityDataArray[n2];
                    }
                    if (string2.equals(sMTopologyEntityDataArray[n2].getIpAddr())) {
                        return sMTopologyEntityDataArray[n2];
                    }
                } else {
                    string4 = sMTopologyEntityDataArray[n2].getTargetUrl();
                    if (string4.endsWith("/")) {
                        string4 = string4.substring(0, string4.length() - 1);
                    }
                    if (!string3.equals(string4) && !string3.equals(sMTopologyEntityDataArray[n2].getDesc())) {
                        vector.addElement(string4);
                    }
                }
                ++n2;
            }
            ++n;
        }
        return null;
    }

    public int getAgentPort(String string, String string2) throws SMAPIException {
        SMTopologyEntityData sMTopologyEntityData = this.getHostTopologyInfo(string, string2);
        if (sMTopologyEntityData == null) {
            throw new SMAPIException("Host not found");
        }
        if (!sMTopologyEntityData.getPollType().equals("ahost")) {
            return 0;
        }
        UcURL ucURL = new UcURL(sMTopologyEntityData.getTargetUrl());
        return Integer.parseInt(ucURL.getPort());
    }

    public SMTopologyViewInfo[] getTopologyViewInfo() throws SMAPIException {
        Object object;
        String string = this.topoBaseUrl + "sym/base/mibman/modules/serverSupport/moduleTable/moduleEntry/";
        String[] stringArray = new String[]{string + "modspec", string + "name"};
        StObject[][] stObjectArray = this.handle.getURLValue(stringArray);
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        UcListUtil.decomposeList((String)stObjectArray[0][0].toString(), vector);
        UcListUtil.decomposeList((String)stObjectArray[1][0].toString(), vector2);
        Vector<SMTopologyViewInfo> vector3 = new Vector<SMTopologyViewInfo>();
        SMTopologyViewInfo sMTopologyViewInfo = null;
        int n = 0;
        while (n < vector2.size()) {
            object = (String)vector.elementAt(n);
            if (((String)object).startsWith("topology+view-")) {
                sMTopologyViewInfo = new SMTopologyViewInfo((String)vector.elementAt(n), (String)vector2.elementAt(n));
                vector3.addElement(sMTopologyViewInfo);
            }
            ++n;
        }
        object = new SMTopologyViewInfo[vector3.size()];
        int n2 = 0;
        while (n2 < vector3.size()) {
            object[n2] = (SMTopologyViewInfo)vector3.elementAt(n2);
            ++n2;
        }
        return object;
    }

    public SMTopologyEntityInfo getTopologyEntityInfo(String string, String string2, int n) throws SMAPIException {
        String string3;
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        if (n == 0) {
            n = 161;
        }
        if (string == null || string == "") {
            string = "defaultdomain";
        }
        boolean bl = false;
        if (string.equalsIgnoreCase("default domain") || string.equalsIgnoreCase("defaultdomain")) {
            string = "defaultdomain";
            bl = true;
        }
        String string4 = null;
        try {
            string4 = this.handle.getIPAddress(string2);
        }
        catch (Exception exception) {
            throw new SMAPIException(exception.getMessage());
        }
        String string5 = "snmp://" + string4 + ":" + n;
        String string6 = "snmp://" + string2 + ":" + n;
        SMUserDomainRequest sMUserDomainRequest = new SMUserDomainRequest(this.handle);
        SMUserDomainData[] sMUserDomainDataArray = sMUserDomainRequest.getAllConfiguredDomains();
        SMUserDomainData sMUserDomainData = null;
        int n2 = 0;
        n2 = 0;
        while (n2 < sMUserDomainDataArray.length) {
            sMUserDomainData = sMUserDomainDataArray[n2];
            string3 = sMUserDomainData.getDomainName();
            if (string.equals(string3) || bl && string3.endsWith("defaultdomain")) break;
            ++n2;
        }
        if (n2 == sMUserDomainDataArray.length || sMUserDomainData == null) {
            throw new SMAPIException("Domain not found");
        }
        string3 = sMUserDomainData.getDomainRootUrl();
        Vector<String> vector = new Vector<String>();
        vector.addElement(string3);
        int n3 = 0;
        while (n3 < vector.size()) {
            String string7 = (String)vector.elementAt(n3);
            SMTopologyEntityInfo[] sMTopologyEntityInfoArray = this.getTopologyEntitiesInfo(string7);
            n2 = 0;
            while (n2 < sMTopologyEntityInfoArray.length) {
                if (sMTopologyEntityInfoArray[n2].getPollType().equals("aview")) {
                    vector.addElement(sMTopologyEntityInfoArray[n2].getTargetUrl());
                } else if (sMTopologyEntityInfoArray[n2].getPollType().equals("ahost") && (sMTopologyEntityInfoArray[n2].getTargetUrl().startsWith(string5) || sMTopologyEntityInfoArray[n2].getTargetUrl().startsWith(string6))) {
                    return sMTopologyEntityInfoArray[n2];
                }
                ++n2;
            }
            ++n3;
        }
        return null;
    }

    public SMTopologyEntityInfo[] getTopologyEntitiesInfo(String object) throws SMAPIException {
        StObject[][] stObjectArray;
        Object object2;
        String[] stringArray;
        if (object == null) {
            object = "Default Domain";
        }
        if (!object.startsWith("snmp://")) {
            stringArray = object;
            object = null;
            object2 = this.getTopologyViewInfo();
            stObjectArray = null;
            int n = 0;
            while (n < ((SMTopologyViewInfo[])object2).length) {
                if (object2[n].getName().equals(stringArray)) {
                    object = this.topoBaseUrl + "mod/" + object2[n].getModSpec();
                    break;
                }
                ++n;
            }
            if (object == null) {
                return new SMTopologyEntityInfo[0];
            }
        }
        stringArray = new String[7];
        object2 = (String)object + "/entityInfoTable/entityInfoEntry/";
        stringArray[0] = (String)object2 + "entity";
        stringArray[1] = (String)object2 + "entityHostname";
        stringArray[2] = (String)object2 + "entityIpAddress";
        stringArray[3] = (String)object2 + "entityPollType";
        stringArray[4] = (String)object2 + "entityTrapDest";
        stringArray[5] = (String)object2 + "entityEventDest";
        stringArray[6] = (String)object2 + "entityTargetUrl";
        stObjectArray = this.handle.getURLValue(stringArray);
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        Vector vector4 = new Vector();
        Vector vector5 = new Vector();
        Vector vector6 = new Vector();
        Vector vector7 = new Vector();
        UcListUtil.decomposeList((String)stObjectArray[0][0].toString(), vector);
        UcListUtil.decomposeList((String)stObjectArray[1][0].toString(), vector2);
        UcListUtil.decomposeList((String)stObjectArray[2][0].toString(), vector3);
        UcListUtil.decomposeList((String)stObjectArray[3][0].toString(), vector4);
        UcListUtil.decomposeList((String)stObjectArray[4][0].toString(), vector5);
        UcListUtil.decomposeList((String)stObjectArray[5][0].toString(), vector6);
        UcListUtil.decomposeList((String)stObjectArray[6][0].toString(), vector7);
        SMTopologyEntityInfo[] sMTopologyEntityInfoArray = new SMTopologyEntityInfo[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            sMTopologyEntityInfoArray[n] = new SMTopologyEntityInfo((String)vector.elementAt(n), (String)vector2.elementAt(n), (String)vector3.elementAt(n), (String)vector4.elementAt(n), (String)vector5.elementAt(n), (String)vector6.elementAt(n), (String)object, (String)vector7.elementAt(n));
            ++n;
        }
        return sMTopologyEntityInfoArray;
    }

    public void modifyAdornmentConfigurations(String string, String[] stringArray, String[] stringArray2) throws SMAPIException {
        StObject[][] stObjectArray;
        String[] stringArray3 = new String[]{SMTopologyRequest.buildMibUrl(string, "adornmentModifier#0")};
        StObject[][] stObjectArray2 = new StObject[1][1];
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            stObjectArray = new StringBuffer();
            UcListUtil.appendElement((StringBuffer)stObjectArray, (String)stringArray[n]);
            UcListUtil.appendElement((StringBuffer)stObjectArray, (String)"");
            UcListUtil.appendElement((StringBuffer)stObjectArray, (String)"");
            UcListUtil.appendElement((StringBuffer)stObjectArray, (String)("!" + stringArray2[n]));
            UcListUtil.appendElement((StringBuffer)stringBuffer, (String)stObjectArray.toString());
            ++n;
        }
        stObjectArray2[0][0] = new StString(stringBuffer.toString());
        stObjectArray = this.handle.setURLValue(stringArray3, stObjectArray2);
        if (stObjectArray == null || stObjectArray.length != 1) {
            throw new SMAPIException(this.rbundle.getString("TopologyRequest.InvalidAdornmentModifyReturn"));
        }
        if (stObjectArray[0][0].toString().compareTo("updateok") != 0) {
            throw new SMAPIException(this.rbundle.getString("TopologyRequest.AdornmentModificationFailed"));
        }
    }

    public void modifyEntityDetailInfo(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, Boolean bl, String string10, String string11, String string12, String string13, String string14, String string15, String string16, String string17, String string18, String string19) throws SMAPIException {
        String[] stringArray = new String[]{SMTopologyRequest.buildMibUrl(string, "entityDetailModifier#0")};
        StObject[][] stObjectArray = new StObject[1][1];
        StringBuffer stringBuffer = new StringBuffer();
        UcListUtil.appendElement((StringBuffer)stringBuffer, (String)string2);
        UcListUtil.appendElement((StringBuffer)stringBuffer, (String)(string3 != null ? "!" + UcListUtil.UnicodeToAscii((String)string3) : ""));
        UcListUtil.appendElement((StringBuffer)stringBuffer, (String)(string4 != null ? "!" + UcListUtil.UnicodeToAscii((String)string4) : ""));
        UcListUtil.appendElement((StringBuffer)stringBuffer, (String)(string5 != null ? "!" + string5 : ""));
        UcListUtil.appendElement((StringBuffer)stringBuffer, (String)(string6 != null ? "!" + string6 : ""));
        UcListUtil.appendElement((StringBuffer)stringBuffer, (String)(string7 != null ? "!" + string7 : ""));
        UcListUtil.appendElement((StringBuffer)stringBuffer, (String)(string8 != null ? "!" + string8 : ""));
        UcListUtil.appendElement((StringBuffer)stringBuffer, (String)(string9 != null ? "!" + string9 : ""));
        UcListUtil.appendElement((StringBuffer)stringBuffer, (String)(bl != null ? "!" + bl : ""));
        UcListUtil.appendElement((StringBuffer)stringBuffer, (String)(string10 != null ? "!" + string10 : ""));
        UcListUtil.appendElement((StringBuffer)stringBuffer, (String)(string11 != null ? "!" + string11 : ""));
        UcListUtil.appendElement((StringBuffer)stringBuffer, (String)(string12 != null ? "!" + string12 : ""));
        UcListUtil.appendElement((StringBuffer)stringBuffer, (String)(string13 != null ? "!" + string13 : ""));
        UcListUtil.appendElement((StringBuffer)stringBuffer, (String)(string14 != null ? "!" + string14 : ""));
        UcListUtil.appendElement((StringBuffer)stringBuffer, (String)(string15 != null ? "!" + string15 : ""));
        UcListUtil.appendElement((StringBuffer)stringBuffer, (String)(string16 != null ? "!" + string16 : ""));
        UcListUtil.appendElement((StringBuffer)stringBuffer, (String)(string17 != null ? "!" + string17 : ""));
        UcListUtil.appendElement((StringBuffer)stringBuffer, (String)(string18 != null ? "!" + string18 : ""));
        UcListUtil.appendElement((StringBuffer)stringBuffer, (String)(string19 != null ? "!" + string19 : ""));
        stObjectArray[0][0] = new StString(stringBuffer.toString());
        StObject[][] stObjectArray2 = this.handle.setURLValue(stringArray, stObjectArray);
        if (stObjectArray2 == null || stObjectArray2.length != 1) {
            throw new SMAPIException(this.rbundle.getString("TopologyRequest.InvalidEntityModifyReturn"));
        }
        if (stObjectArray2[0][0].toString().compareTo("updateok") != 0) {
            throw new SMAPIException(this.rbundle.getString("TopologyRequest.EntityModificationFailed"));
        }
    }

    public void modifyEntityViewInfo(String string, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, Boolean[] booleanArray) throws SMAPIException {
        StObject[][] stObjectArray;
        String[] stringArray5 = new String[]{SMTopologyRequest.buildMibUrl(string, "entityViewModifier#0")};
        StObject[][] stObjectArray2 = new StObject[1][1];
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            stObjectArray = new StringBuffer();
            UcListUtil.appendElement((StringBuffer)stObjectArray, (String)stringArray[n]);
            UcListUtil.appendElement((StringBuffer)stObjectArray, (String)"");
            UcListUtil.appendElement((StringBuffer)stObjectArray, (String)"");
            if (stringArray2 != null && stringArray2[n] != null) {
                UcListUtil.appendElement((StringBuffer)stObjectArray, (String)("!" + UcListUtil.UnicodeToAscii((String)stringArray2[n])));
            } else {
                UcListUtil.appendElement((StringBuffer)stObjectArray, (String)"");
            }
            if (stringArray3 != null && stringArray3[n] != null) {
                UcListUtil.appendElement((StringBuffer)stObjectArray, (String)("!" + stringArray3[n]));
            } else {
                UcListUtil.appendElement((StringBuffer)stObjectArray, (String)"");
            }
            if (stringArray4 != null && stringArray4[n] != null) {
                UcListUtil.appendElement((StringBuffer)stObjectArray, (String)("!" + stringArray4[n]));
            } else {
                UcListUtil.appendElement((StringBuffer)stObjectArray, (String)"");
            }
            if (booleanArray != null && booleanArray[n] != null) {
                UcListUtil.appendElement((StringBuffer)stObjectArray, (String)("!" + booleanArray[n]));
            } else {
                UcListUtil.appendElement((StringBuffer)stObjectArray, (String)"");
            }
            UcListUtil.appendElement((StringBuffer)stringBuffer, (String)stObjectArray.toString());
            ++n;
        }
        stObjectArray2[0][0] = new StString(stringBuffer.toString());
        stObjectArray = this.handle.setURLValue(stringArray5, stObjectArray2);
        if (stObjectArray == null || stObjectArray.length != 1) {
            throw new SMAPIException(this.rbundle.getString("TopologyRequest.InvalidEntityModifyReturn"));
        }
        if (stObjectArray[0][0].toString().compareTo("updateok") != 0) {
            throw new SMAPIException(this.rbundle.getString("TopologyRequest.EntityModificationFailed"));
        }
    }

    public void moveAdornments(String string, String[] stringArray, int[] nArray, int[] nArray2) throws SMAPIException {
        StObject[][] stObjectArray;
        String[] stringArray2 = new String[]{SMTopologyRequest.buildMibUrl(string, "adornmentModifier#0")};
        StObject[][] stObjectArray2 = new StObject[1][1];
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            stObjectArray = new StringBuffer();
            UcListUtil.appendElement((StringBuffer)stObjectArray, (String)stringArray[n]);
            UcListUtil.appendElement((StringBuffer)stObjectArray, (String)("!" + nArray[n]));
            UcListUtil.appendElement((StringBuffer)stObjectArray, (String)("!" + nArray2[n]));
            UcListUtil.appendElement((StringBuffer)stObjectArray, (String)"");
            UcListUtil.appendElement((StringBuffer)stringBuffer, (String)stObjectArray.toString());
            ++n;
        }
        stObjectArray2[0][0] = new StString(stringBuffer.toString());
        stObjectArray = this.handle.setURLValue(stringArray2, stObjectArray2);
        if (stObjectArray == null || stObjectArray.length != 1) {
            throw new SMAPIException(this.rbundle.getString("TopologyRequest.InvalidAdornmentMoveReturn"));
        }
        if (stObjectArray[0][0].toString().compareTo("updateok") != 0) {
            throw new SMAPIException(this.rbundle.getString("TopologyRequest.AdornmentMoveFailed"));
        }
    }

    public void moveEntities(String string, String[] stringArray, int[] nArray, int[] nArray2) throws SMAPIException {
        StObject[][] stObjectArray;
        String[] stringArray2 = new String[]{SMTopologyRequest.buildMibUrl(string, "entityViewModifier#0")};
        StObject[][] stObjectArray2 = new StObject[1][1];
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            stObjectArray = new StringBuffer();
            UcListUtil.appendElement((StringBuffer)stObjectArray, (String)stringArray[n]);
            UcListUtil.appendElement((StringBuffer)stObjectArray, (String)("!" + nArray[n]));
            UcListUtil.appendElement((StringBuffer)stObjectArray, (String)("!" + nArray2[n]));
            UcListUtil.appendElement((StringBuffer)stObjectArray, (String)"");
            UcListUtil.appendElement((StringBuffer)stObjectArray, (String)"");
            UcListUtil.appendElement((StringBuffer)stObjectArray, (String)"");
            UcListUtil.appendElement((StringBuffer)stObjectArray, (String)"");
            UcListUtil.appendElement((StringBuffer)stringBuffer, (String)stObjectArray.toString());
            ++n;
        }
        stObjectArray2[0][0] = new StString(stringBuffer.toString());
        stObjectArray = this.handle.setURLValue(stringArray2, stObjectArray2);
        if (stObjectArray == null || stObjectArray.length != 1) {
            throw new SMAPIException(this.rbundle.getString("TopologyRequest.InvalidEntityMoveReturn"));
        }
        if (stObjectArray[0][0].toString().compareTo("updateok") != 0) {
            throw new SMAPIException(this.rbundle.getString("TopologyRequest.EntityMoveFailed"));
        }
    }

    public void pasteElements(String string, String string2, SMTopologyEntityData[] sMTopologyEntityDataArray) throws SMAPIException, SMTopologyException {
        this.pasteElements(string, string2, sMTopologyEntityDataArray, string2 == null);
    }

    public void pasteElements(String string, String string2, SMTopologyEntityData[] sMTopologyEntityDataArray, boolean bl) throws SMAPIException, SMTopologyException {
        StObject[][] stObjectArray;
        String[] stringArray = new String[]{SMTopologyRequest.buildMibUrl(string, "elementPaster#0")};
        StObject[][] stObjectArray2 = new StObject[1][1];
        StringBuffer stringBuffer = new StringBuffer();
        UcListUtil.appendElement((StringBuffer)stringBuffer, (String)(string2 != null ? string2 : ""));
        UcListUtil.appendElement((StringBuffer)stringBuffer, (String)(bl ? "copy" : "cut"));
        StringBuffer stringBuffer2 = new StringBuffer();
        int n = 0;
        while (n < sMTopologyEntityDataArray.length) {
            stObjectArray = new StringBuffer();
            SMTopologyEntityData sMTopologyEntityData = sMTopologyEntityDataArray[n];
            StObject[][] stObjectArray3 = null;
            boolean bl2 = sMTopologyEntityData.getPollType().startsWith("a");
            if (bl2) {
                String[] stringArray2 = new String[2];
                UcURL ucURL = new UcURL(sMTopologyEntityData.getTargetUrl());
                stringArray2[0] = ucURL.getScheme() + "://" + ucURL.getHost() + ":" + ucURL.getPort() + "/sym/base/info/system/os#0";
                stringArray2[1] = SMRawDataRequest.buildShadowURL(sMTopologyEntityData.getTargetUrl(), "topologydetail", null);
                stObjectArray3 = this.handle.getURLValue(stringArray2);
                if (stObjectArray3 == null || stObjectArray3.length != 2) {
                    throw new SMAPIException(this.rbundle.getString("TopologyRequest.InvalidTopologyInfoReturn"));
                }
            }
            UcListUtil.appendElement((StringBuffer)stObjectArray, (String)sMTopologyEntityData.getEntityId());
            UcListUtil.appendElement((StringBuffer)stObjectArray, (String)sMTopologyEntityData.getXCoord());
            UcListUtil.appendElement((StringBuffer)stObjectArray, (String)sMTopologyEntityData.getYCoord());
            UcListUtil.appendElement((StringBuffer)stObjectArray, (String)UcListUtil.UnicodeToAscii((String)sMTopologyEntityData.getDesc()));
            UcListUtil.appendElement((StringBuffer)stObjectArray, (String)UcListUtil.UnicodeToAscii((String)sMTopologyEntityData.getFullDesc()));
            UcListUtil.appendElement((StringBuffer)stObjectArray, (String)sMTopologyEntityData.getHostName());
            UcListUtil.appendElement((StringBuffer)stObjectArray, (String)sMTopologyEntityData.getIpAddr());
            UcListUtil.appendElement((StringBuffer)stObjectArray, (String)sMTopologyEntityData.getNetmask());
            UcListUtil.appendElement((StringBuffer)stObjectArray, (String)sMTopologyEntityData.getArch());
            UcListUtil.appendElement((StringBuffer)stObjectArray, (String)sMTopologyEntityData.getFamily());
            UcListUtil.appendElement((StringBuffer)stObjectArray, (String)sMTopologyEntityData.getType());
            UcListUtil.appendElement((StringBuffer)stObjectArray, (String)sMTopologyEntityData.getConfig());
            UcListUtil.appendElement((StringBuffer)stObjectArray, (String)sMTopologyEntityData.getIsPoll());
            UcListUtil.appendElement((StringBuffer)stObjectArray, (String)sMTopologyEntityData.getPollType());
            UcListUtil.appendElement((StringBuffer)stObjectArray, (String)sMTopologyEntityData.getReadInfo());
            UcListUtil.appendElement((StringBuffer)stObjectArray, (String)sMTopologyEntityData.getWriteInfo());
            UcListUtil.appendElement((StringBuffer)stObjectArray, (String)sMTopologyEntityData.getTargetHost());
            UcListUtil.appendElement((StringBuffer)stObjectArray, (String)sMTopologyEntityData.getTargetIP());
            UcListUtil.appendElement((StringBuffer)stObjectArray, (String)sMTopologyEntityData.getTargetUrl());
            if (bl2) {
                UcListUtil.appendElement((StringBuffer)stObjectArray, (String)stObjectArray3[0][0].toString());
                UcListUtil.appendElement((StringBuffer)stObjectArray, (String)stObjectArray3[1][0].toString());
            }
            UcListUtil.appendElement((StringBuffer)stringBuffer2, (String)stObjectArray.toString());
            ++n;
        }
        UcListUtil.appendElement((StringBuffer)stringBuffer, (String)stringBuffer2.toString());
        UcListUtil.appendElement((StringBuffer)stringBuffer, (String)"");
        stObjectArray2[0][0] = new StString(stringBuffer.toString());
        stObjectArray = this.handle.setURLValue(stringArray, stObjectArray2);
        if (stObjectArray == null || stObjectArray.length != 1) {
            throw new SMAPIException(this.rbundle.getString("TopologyRequest.InvalidPasteInfoReturn"));
        }
        if (stObjectArray[0][0].toString().compareTo("pastecircular") == 0) {
            throw new SMTopologyException(1, this.rbundle.getString("TopologyRequest.ElementPasteFailed"));
        }
        if (stObjectArray[0][0].toString().compareTo("pastemax") == 0) {
            throw new SMTopologyException(5, this.rbundle.getString("TopologyRequest.ElementPasteFailed"));
        }
        if (stObjectArray[0][0].toString().compareTo("pastelicense") == 0) {
            throw new SMTopologyException(6, this.rbundle.getString("TopologyRequest.ElementPasteFailed"));
        }
        if (stObjectArray[0][0].toString().compareTo("pastecutunknown") == 0) {
            throw new SMTopologyException(3, this.rbundle.getString("TopologyRequest.ElementPasteFailed"));
        }
        if (stObjectArray[0][0].toString().compareTo("pastecutnoaccess") == 0) {
            throw new SMTopologyException(4, this.rbundle.getString("TopologyRequest.ElementPasteFailed"));
        }
        if (stObjectArray[0][0].toString().compareTo("pastedeadref") == 0) {
            throw new SMTopologyException(7, this.rbundle.getString("TopologyRequest.ElementPasteFailed"));
        }
        if (stObjectArray[0][0].toString().compareTo("pasteok") != 0) {
            throw new SMAPIException(this.rbundle.getString("TopologyRequest.ElementPasteFailed"));
        }
    }

    public void topologySearch(String string, String string2, Vector vector, Vector vector2) throws SMAPIException {
        String[] stringArray = new String[]{SMRawDataRequest.buildShadowURL(string, "topologysearch", null)};
        this.doTopologySearch(stringArray, string2, vector, vector2);
    }

    public void topologySearchByHost(String string, String string2, Vector vector, Vector vector2) throws SMAPIException {
        if (string2 == null || string2 == "") {
            this.topologySearch(string, string2, vector, vector2);
            return;
        }
        String[] stringArray = new String[]{SMRawDataRequest.buildShadowURL(string, "topologysearchhost", null)};
        if (isTopologyAgentInIPMode == null) {
            isTopologyAgentInIPMode = new Boolean(this.isTopologyAgentInIPMode());
        }
        if (isTopologyAgentInIPMode.booleanValue()) {
            String string3 = string2;
            try {
                string3 = this.handle.getIPAddress(string2);
            }
            catch (Exception exception) {
                throw new SMAPIException(exception.getMessage());
            }
            this.doTopologySearch(stringArray, string3, vector, vector2);
        } else {
            this.doTopologySearch(stringArray, string2, vector, vector2);
        }
    }

    private boolean isTopologyAgentInIPMode() {
        StObject[][] stObjectArray;
        String[] stringArray = new String[]{this.handle.getTopologyBaseURL() + "sym/base/info/system/trapaddr#0"};
        try {
            stObjectArray = this.handle.getURLValue(stringArray);
        }
        catch (SMAPIException sMAPIException) {
            return false;
        }
        if (stObjectArray == null || stObjectArray.length != 1) {
            return false;
        }
        String string = ((StString)stObjectArray[0][0]).toString();
        int n = string.indexOf(":");
        if (n > 0) {
            return this.isIPAddress(string.substring(0, n));
        }
        return this.isIPAddress(string);
    }

    /*
     * Unable to fully structure code
     */
    private boolean isIPAddress(String var1_1) {
        var2_2 = new StringTokenizer(var1_1, ".");
        if (var2_2.countTokens() != 0) ** GOTO lbl11
        return false;
lbl-1000:
        // 1 sources

        {
            try {
                var3_3 = Integer.parseInt(var2_2.nextToken());
                if (var3_3 < 0 || var3_3 > 255) {
                    return false;
                }
                continue;
            }
            catch (Exception var5_4) {
                return false;
            }
lbl11:
            // 2 sources

            ** while (var2_2.hasMoreTokens())
        }
lbl12:
        // 1 sources

        return true;
    }

    public SMHierarchyViewData topologySearchHost(String string, String string2) throws SMAPIException {
        Object var3_3 = null;
        if (string2 == null || string2 == "") {
            return null;
        }
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        this.topologySearch(string, string2, vector2, vector3);
        if (vector2 != null && vector2.size() > 0) {
            return (SMHierarchyViewData)vector2.elementAt(0);
        }
        int n = 0;
        vector = vector3;
        while (n < vector.size()) {
            SMHierarchyViewData sMHierarchyViewData = (SMHierarchyViewData)vector.elementAt(n);
            String string3 = sMHierarchyViewData.getTargetUrl();
            if (string3.indexOf("topology+") > 0) {
                this.topologySearch(string3, string2, vector2, vector3);
                if (vector2 != null && vector2.size() > 0) {
                    return (SMHierarchyViewData)vector2.elementAt(0);
                }
                if (vector3 != null) {
                    vector.addAll(vector3);
                }
            }
            ++n;
        }
        return null;
    }

    private void doTopologySearch(String[] stringArray, String string, Vector vector, Vector vector2) throws SMAPIException {
        Object object;
        if (string == null) {
            throw new SMAPIException(this.rbundle.getString("TopologyRequest.InvalidSearchPattern"));
        }
        StObject[][] stObjectArray = new StObject[1][1];
        stObjectArray[0][0] = new StString(UcListUtil.UnicodeToAscii((String)string));
        StObject[][] stObjectArray2 = this.handle.setURLValue(stringArray, stObjectArray);
        if (stObjectArray2 == null || stObjectArray2.length != 1) {
            throw new SMAPIException(this.rbundle.getString("TopologyRequest.InvalidSearchInfoReturn"));
        }
        Vector vector3 = new Vector();
        if (!UcListUtil.decomposeList((String)stObjectArray2[0][0].toString(), vector3) || vector3.size() != 2) {
            throw new SMAPIException(this.rbundle.getString("TopologyRequest.InvalidSearchReturnInfo") + " " + stObjectArray2[0][0].toString());
        }
        Vector vector4 = new Vector();
        UcListUtil.decomposeList((String)((String)vector3.elementAt(0)), vector4);
        int n = 0;
        while (n < vector4.size()) {
            object = (String)vector4.elementAt(n);
            SMHierarchyViewData sMHierarchyViewData = SMHierarchyTxltr.txlateHierView(this.resourceAcc, (String)object, "", this.locale);
            if (sMHierarchyViewData != null) {
                vector.addElement(sMHierarchyViewData);
            }
            ++n;
        }
        object = new Vector();
        UcListUtil.decomposeList((String)((String)vector3.elementAt(1)), (Vector)object);
        int n2 = 0;
        while (n2 < ((Vector)object).size()) {
            String string2 = (String)((Vector)object).elementAt(n2);
            SMHierarchyViewData sMHierarchyViewData = SMHierarchyTxltr.txlateHierView(this.resourceAcc, string2, "", this.locale);
            if (sMHierarchyViewData != null) {
                vector2.addElement(sMHierarchyViewData);
            }
            ++n2;
        }
    }

    public void topologyAlarmSearch(String string, String string2, Vector vector, Vector vector2) throws SMAPIException {
        Object object;
        String string3;
        Vector vector3;
        if (string2 == null) {
            throw new SMAPIException(this.rbundle.getString("TopologyRequest.InvalidSearchPattern"));
        }
        String[] stringArray = new String[]{SMRawDataRequest.buildShadowURL(string, "topologyalarms", null)};
        StObject[][] stObjectArray = new StObject[1][1];
        stObjectArray[0][0] = new StString(string2);
        StObject[][] stObjectArray2 = this.handle.setURLValue(stringArray, stObjectArray);
        if (stObjectArray2 == null || stObjectArray2.length != 1) {
            throw new SMAPIException(this.rbundle.getString("TopologyRequest.InvalidSearchInfoReturn"));
        }
        Vector vector4 = new Vector();
        if (!UcListUtil.decomposeList((String)stObjectArray2[0][0].toString(), vector4) || vector4.size() != 2) {
            throw new SMAPIException(this.rbundle.getString("TopologyRequest.InvalidSearchReturnInfo") + " " + stObjectArray2[0][0].toString());
        }
        Vector vector5 = new Vector();
        if (!UcListUtil.decomposeList((String)((String)vector4.elementAt(0)), vector5)) {
            throw new SMAPIException(this.rbundle.getString("TopologyRequest.InvalidSearchReturnInfo") + " " + stObjectArray2[0][0].toString());
        }
        int n = 0;
        while (n < vector5.size()) {
            SMTopologyEntityViewData sMTopologyEntityViewData;
            vector3 = new Vector();
            UcListUtil.decomposeList((String)((String)vector5.elementAt(n)), vector3);
            if (vector3.size() != 4) {
                throw new SMAPIException(this.rbundle.getString("TopologyRequest.InvalidSearchReturnInfo") + " " + stObjectArray2[0][0].toString());
            }
            Vector vector6 = new Vector();
            string3 = null;
            object = null;
            String string4 = null;
            UcListUtil.decomposeList((String)((String)vector3.elementAt(0)), vector6);
            string3 = (String)vector3.elementAt(1);
            object = (String)vector3.elementAt(2);
            SMAlarmStatusData sMAlarmStatusData = SMAlarmStatusData.buildStatusData(null, (String)object, "topology");
            string4 = (String)vector3.elementAt(3);
            if (vector6.size() != 11) {
                throw new SMAPIException(this.rbundle.getString("TopologyRequest.InvalidSearchReturnInfo") + " " + stObjectArray2[0][0].toString());
            }
            String string5 = SMTopologyRequest.localizeName((String)vector6.elementAt(3), this.locale);
            String string6 = (String)vector6.elementAt(1);
            String string7 = (String)vector6.elementAt(2);
            int n2 = Integer.MAX_VALUE;
            int n3 = Integer.MAX_VALUE;
            try {
                if (string6 != null && string6.length() != 0) {
                    n2 = Integer.parseInt(string6);
                }
                if (string7 != null && string7.length() != 0) {
                    n3 = Integer.parseInt(string7);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            SMFamilyImages sMFamilyImages = this.resourceAcc.getFamilyImages((String)vector6.elementAt(4), (String)vector6.elementAt(8));
            SMFamilyCommands sMFamilyCommands = this.resourceAcc.getFamilyCommands((String)vector6.elementAt(4), (String)vector6.elementAt(8));
            boolean bl = false;
            if (((String)vector6.elementAt(7)).charAt(0) == 't') {
                bl = true;
            }
            if ((sMTopologyEntityViewData = new SMTopologyEntityViewData((String)vector6.elementAt(0), string5, n2, n3, sMFamilyImages, sMFamilyCommands, (String)vector6.elementAt(5), (String)vector6.elementAt(6), bl, (String)vector6.elementAt(9), (String)vector6.elementAt(10))) != null && sMAlarmStatusData != null && string4 != null && string3 != null) {
                Vector<Object> vector7 = new Vector<Object>();
                vector7.addElement(sMTopologyEntityViewData);
                vector7.addElement(string3);
                vector7.addElement(sMAlarmStatusData);
                vector7.addElement(string4);
                vector.addElement(vector7);
            }
            ++n;
        }
        vector3 = new Vector();
        UcListUtil.decomposeList((String)((String)vector4.elementAt(1)), vector3);
        int n4 = 0;
        while (n4 < vector3.size()) {
            string3 = (String)vector3.elementAt(n4);
            object = SMHierarchyTxltr.txlateHierView(this.resourceAcc, string3, "", this.locale);
            if (object != null) {
                vector2.addElement(object);
            }
            ++n4;
        }
    }

    static String localizeName(String string, Locale locale) {
        if (string.startsWith("base.console.ConsoleTopology:domain.defaultdomain[")) {
            String string2 = string.substring(string.indexOf("["));
            string = UcInternationalizer.translateKey((Locale)locale, (String)"base.console.ConsoleTopology:domain.defaultdomain") + string2;
        } else {
            string = UcInternationalizer.translateKey((Locale)locale, (String)string);
        }
        string = UcListUtil.AsciiToUnicode((String)string);
        return string;
    }
}

