/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.client.task;

import com.sun.symon.base.client.SMMessageI18nKey;
import com.sun.symon.base.client.SMUtility;
import com.sun.symon.base.client.service.SMDBObject;
import com.sun.symon.base.client.service.SMDBObjectID;
import com.sun.symon.base.client.service.SMLengthException;
import com.sun.symon.base.client.task.SMTaskRequestInfo;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.Locale;

public class SMTaskRequestData
extends SMTaskRequestInfo {
    private static final String version = "1.0";
    protected String owner;
    protected Date beginDate;
    protected long period;
    protected int units;
    private static String i18nBase = "com.sun.symon.base.client.ClientApiMessages";

    public SMTaskRequestData() {
    }

    public SMTaskRequestData(SMDBObjectID sMDBObjectID) {
        super(sMDBObjectID);
    }

    public Object clone() {
        return super.clone();
    }

    public void setName(String string) throws SMLengthException {
        if (string != null && string.length() > 32) {
            SMLengthException sMLengthException = new SMLengthException();
            sMLengthException.setMessageI18nKey(new SMMessageI18nKey(i18nBase, "lengthException"));
            throw sMLengthException;
        }
        this.name = string;
        this.setChanged(true);
    }

    public void setDescription(String string) throws SMLengthException {
        if (string != null && string.length() > 256) {
            SMLengthException sMLengthException = new SMLengthException();
            sMLengthException.setMessageI18nKey(new SMMessageI18nKey(i18nBase, "lengthException"));
            throw sMLengthException;
        }
        this.description = string;
        this.setChanged(true);
    }

    public void setObjectGroupName(String string) throws SMLengthException {
        if (string != null && string.length() > 32) {
            SMLengthException sMLengthException = new SMLengthException();
            sMLengthException.setMessageI18nKey(new SMMessageI18nKey(i18nBase, "lengthException"));
            throw sMLengthException;
        }
        this.groupName = string;
        this.setChanged(true);
    }

    public void setTaskName(String string) throws SMLengthException {
        if (string != null && string.length() > 32) {
            SMLengthException sMLengthException = new SMLengthException();
            sMLengthException.setMessageI18nKey(new SMMessageI18nKey(i18nBase, "lengthException"));
            throw sMLengthException;
        }
        this.taskName = string;
        this.setChanged(true);
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String string) throws SMLengthException {
        this.owner = string;
    }

    public boolean isPeriodic() {
        if (super.isPeriodic()) {
            return true;
        }
        return this.period != 0L && this.units != 0;
    }

    public void setScheduled(boolean bl) {
        this.isScheduled = bl;
    }

    public boolean isScheduled() {
        return this.isScheduled;
    }

    public long getPeriod() {
        return this.period;
    }

    public void setPeriod(long l) {
        this.period = l;
    }

    public int getPeriodUnits() {
        return this.units;
    }

    public void setPeriodUnits(int n) {
        this.units = n;
    }

    public Date getStartDate() {
        return this.beginDate;
    }

    public void setStartDate(Date date) {
        this.beginDate = date;
        this.setChanged(true);
    }

    public void clearStartDate() {
        this.beginDate = null;
        this.setChanged(true);
    }

    public long getStartTime() {
        if (this.beginDate != null) {
            return this.beginDate.getTime();
        }
        return -1L;
    }

    public void setStatus(int n) {
        this.status = n;
    }

    public void setRunImmediate(boolean bl) {
        if (bl) {
            this.status |= 0x40;
            this.clearStartDate();
        } else {
            this.status &= 0xFFFFFFBF;
        }
    }

    public void setIsPeriodic(boolean bl) {
        if (bl) {
            this.status |= 0x80;
        } else {
            this.status &= 0xFFFFFF7F;
            this.period = 0L;
            this.units = 0;
        }
    }

    public void setDomain(String string) {
        this.domain = string;
    }

    public void setFilterName(String string) {
        this.filterName = string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append("Owner:" + this.owner + "\n").append("Start Date:" + this.beginDate + "\n").append("Period:" + this.period + "\n").append("Period units:" + this.units + "\n");
        return stringBuffer.toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        SMDBObject.writeString(objectOutputStream, version);
        SMDBObject.writeString(objectOutputStream, this.owner);
        objectOutputStream.writeObject(this.beginDate);
        objectOutputStream.writeLong(this.period);
        objectOutputStream.writeInt(this.units);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        SMDBObject.readString(objectInputStream);
        this.owner = SMDBObject.readString(objectInputStream);
        this.beginDate = (Date)objectInputStream.readObject();
        this.period = objectInputStream.readLong();
        this.units = objectInputStream.readInt();
    }

    public void validate() {
        this.validate(Locale.getDefault());
    }

    public void validate(Locale locale) {
        String string = this.getName();
        if (string == null || string.trim().length() == 0 || SMUtility.validate(string) >= 0) {
            throw new IllegalArgumentException(SMUtility.getClientMessage(locale, "TaskRequest.InvalidRequestName"));
        }
        string = this.getTaskName();
        if (string == null || string.trim().length() == 0 || SMUtility.validate(string) >= 0) {
            throw new IllegalArgumentException(SMUtility.getClientMessage(locale, "TaskRequest.InvalidTaskName"));
        }
        string = this.getObjectGroupName();
        if (string == null || string.trim().length() == 0 || SMUtility.validate(string) >= 0) {
            throw new IllegalArgumentException(SMUtility.getClientMessage(locale, "TaskRequest.InvalidGroupName"));
        }
    }
}

