/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.client.task;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMMessageI18nKey;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.log.SMLogReader;
import com.sun.symon.base.client.service.SMDBChangeListener;
import com.sun.symon.base.client.service.SMDBObject;
import com.sun.symon.base.client.service.SMDBObjectID;
import com.sun.symon.base.client.service.SMDatabaseException;
import com.sun.symon.base.client.service.SMDuplicateException;
import com.sun.symon.base.client.service.SMHandle;
import com.sun.symon.base.client.service.SMNoSuchObjectException;
import com.sun.symon.base.client.service.SMSecurityException;
import com.sun.symon.base.client.service.SMWrongTypeException;
import com.sun.symon.base.client.task.SMRemoteTaskRequest;
import com.sun.symon.base.client.task.SMTaskConstants;
import com.sun.symon.base.client.task.SMTaskInfo;
import com.sun.symon.base.client.task.SMTaskRequestData;
import com.sun.symon.base.client.task.SMTaskRequestInfo;
import java.util.Vector;

public class SMTaskRequest
extends SMHandle
implements SMTaskConstants {
    private SMRemoteTaskRequest handle;
    private String[] empty = new String[0];
    private static String i18nBase_ = "com.sun.symon.base.client.ClientApiMessages";
    private boolean getHidden_ = false;

    public SMTaskRequest(SMRawDataRequest sMRawDataRequest) throws SMAPIException {
        this(sMRawDataRequest, false);
    }

    public SMTaskRequest(SMRawDataRequest sMRawDataRequest, boolean bl) throws SMAPIException {
        super(sMRawDataRequest);
        this.getHidden_ = bl;
        this.handle = (SMRemoteTaskRequest)sMRawDataRequest.getService("Task_TaskRequest", this.empty);
        this.setHandle(this.handle);
    }

    public SMTaskRequestInfo[] getAll() throws SMAPIException {
        try {
            return this.filterHidden(this.handle.getAll());
        }
        catch (Exception exception) {
            if (exception instanceof SMAPIException) {
                throw (SMAPIException)exception;
            }
            throw new SMAPIException(exception.getMessage(), new SMMessageI18nKey(i18nBase_, "smApiException"));
        }
    }

    public void close() throws SMAPIException {
        try {
            super.close();
            this.handle.close();
            this.handle = null;
        }
        catch (Exception exception) {
            if (exception instanceof SMAPIException) {
                throw (SMAPIException)exception;
            }
            throw new SMAPIException(exception.getMessage(), new SMMessageI18nKey(i18nBase_, "smApiException"));
        }
    }

    public SMTaskRequestData load(SMTaskRequestInfo sMTaskRequestInfo) throws SMAPIException, SMDatabaseException, SMSecurityException {
        try {
            return this.handle.load(sMTaskRequestInfo.getObjectID());
        }
        catch (Exception exception) {
            if (exception instanceof SMAPIException) {
                throw (SMAPIException)exception;
            }
            throw new SMAPIException(exception.getMessage(), new SMMessageI18nKey(i18nBase_, "smApiException"));
        }
    }

    public SMTaskRequestData load(SMDBObjectID sMDBObjectID) throws SMAPIException, SMDatabaseException, SMSecurityException {
        try {
            return this.handle.load(sMDBObjectID);
        }
        catch (Exception exception) {
            if (exception instanceof SMAPIException) {
                throw (SMAPIException)exception;
            }
            throw new SMAPIException(exception.getMessage(), new SMMessageI18nKey(i18nBase_, "smApiException"));
        }
    }

    public SMTaskRequestInfo loadInfo(SMDBObjectID sMDBObjectID) throws SMAPIException, SMDatabaseException, SMSecurityException {
        try {
            return this.handle.loadInfo(sMDBObjectID);
        }
        catch (Exception exception) {
            if (exception instanceof SMAPIException) {
                throw (SMAPIException)exception;
            }
            throw new SMAPIException(exception.getMessage(), new SMMessageI18nKey(i18nBase_, "smApiException"));
        }
    }

    public SMTaskRequestData load(String string) throws SMAPIException, SMDatabaseException, SMSecurityException {
        try {
            return this.handle.load(string);
        }
        catch (Exception exception) {
            if (exception instanceof SMAPIException) {
                throw (SMAPIException)exception;
            }
            throw new SMAPIException(exception.getMessage(), new SMMessageI18nKey(i18nBase_, "smApiException"));
        }
    }

    public SMDBObjectID save(SMTaskRequestData sMTaskRequestData) throws SMAPIException, SMDatabaseException, SMDuplicateException, SMSecurityException {
        try {
            sMTaskRequestData.validate(this.getLocale());
            if (!sMTaskRequestData.isChanged()) {
                return sMTaskRequestData.getObjectID();
            }
            SMDBObject sMDBObject = this.handle.save(sMTaskRequestData);
            sMTaskRequestData.refresh(sMDBObject);
            return sMDBObject.getObjectID();
        }
        catch (Exception exception) {
            if (exception instanceof SMAPIException) {
                throw (SMAPIException)exception;
            }
            throw new SMAPIException(exception.getMessage(), new SMMessageI18nKey(i18nBase_, "smApiException"));
        }
    }

    public SMTaskRequestData saveAs(SMTaskRequestData sMTaskRequestData, String string, boolean bl) throws SMAPIException, SMSecurityException, SMDatabaseException, SMDuplicateException {
        return this.saveAs(sMTaskRequestData, string);
    }

    public SMTaskRequestData saveAs(SMTaskRequestData sMTaskRequestData, String string) throws SMAPIException, SMSecurityException, SMDatabaseException, SMDuplicateException {
        SMTaskRequestData sMTaskRequestData2 = (SMTaskRequestData)sMTaskRequestData.clone();
        sMTaskRequestData2.setName(string);
        this.save(sMTaskRequestData2);
        return sMTaskRequestData2;
    }

    public void delete(SMTaskRequestInfo sMTaskRequestInfo) throws SMAPIException, SMDatabaseException, SMSecurityException {
        this.delete(sMTaskRequestInfo.getObjectID());
    }

    public void delete(SMDBObjectID sMDBObjectID) throws SMAPIException, SMDatabaseException, SMSecurityException {
        try {
            this.handle.delete(sMDBObjectID);
        }
        catch (Exception exception) {
            if (exception instanceof SMAPIException) {
                throw (SMAPIException)exception;
            }
            throw new SMAPIException(exception.getMessage(), new SMMessageI18nKey(i18nBase_, "smApiException"));
        }
    }

    public void resume(SMTaskRequestInfo sMTaskRequestInfo) throws SMAPIException, SMDatabaseException, SMSecurityException {
        this.resume(sMTaskRequestInfo.getObjectID());
    }

    public void resume(SMDBObjectID sMDBObjectID) throws SMAPIException, SMDatabaseException, SMSecurityException {
        try {
            this.handle.resume(sMDBObjectID);
        }
        catch (Exception exception) {
            if (exception instanceof SMAPIException) {
                throw (SMAPIException)exception;
            }
            throw new SMAPIException(exception.getMessage(), new SMMessageI18nKey(i18nBase_, "smApiException"));
        }
    }

    public void suspend(SMTaskRequestInfo sMTaskRequestInfo) throws SMAPIException, SMDatabaseException, SMSecurityException {
        this.suspend(sMTaskRequestInfo.getObjectID());
    }

    public void suspend(SMDBObjectID sMDBObjectID) throws SMAPIException, SMDatabaseException, SMSecurityException {
        try {
            this.handle.suspend(sMDBObjectID);
        }
        catch (Exception exception) {
            if (exception instanceof SMAPIException) {
                throw (SMAPIException)exception;
            }
            throw new SMAPIException(exception.getMessage(), new SMMessageI18nKey(i18nBase_, "smApiException"));
        }
    }

    public void addTaskRequestListener(SMDBChangeListener sMDBChangeListener) throws SMAPIException {
        this.addDBChangeListener(sMDBChangeListener);
    }

    public void removeTaskRequestListener(SMDBChangeListener sMDBChangeListener) throws SMAPIException {
        this.removeDBChangeListener(sMDBChangeListener);
    }

    public SMLogReader getLogReader() throws SMAPIException {
        try {
            return new SMLogReader(this.handle.getLogReader());
        }
        catch (Exception exception) {
            if (exception instanceof SMAPIException) {
                throw (SMAPIException)exception;
            }
            throw new SMAPIException(exception.getMessage(), new SMMessageI18nKey(i18nBase_, "smApiException"));
        }
    }

    public SMDBObject loadObj(SMDBObjectID sMDBObjectID) throws SMAPIException {
        return this.load(sMDBObjectID);
    }

    public SMDBObject loadInfoObj(SMDBObjectID sMDBObjectID) throws SMAPIException {
        return this.loadInfo(sMDBObjectID);
    }

    public SMDBObjectID saveObj(SMDBObject sMDBObject) throws SMAPIException, SMWrongTypeException {
        if (!(sMDBObject instanceof SMTaskRequestData)) {
            SMWrongTypeException sMWrongTypeException = new SMWrongTypeException();
            sMWrongTypeException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "wrongDataTypeException"));
            throw sMWrongTypeException;
        }
        return this.save((SMTaskRequestData)sMDBObject);
    }

    public SMDBObject saveAsObj(SMDBObject sMDBObject, String string) throws SMAPIException, SMWrongTypeException {
        if (!(sMDBObject instanceof SMTaskRequestData)) {
            SMWrongTypeException sMWrongTypeException = new SMWrongTypeException();
            sMWrongTypeException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "wrongDataTypeException"));
            throw sMWrongTypeException;
        }
        return this.saveAs((SMTaskRequestData)sMDBObject, string, true);
    }

    public SMDBObject loadObj(String string) throws SMAPIException, SMSecurityException, SMNoSuchObjectException, SMDatabaseException {
        return this.load(string);
    }

    public SMDBObject[] getAllObjs() throws SMAPIException, SMSecurityException, SMDatabaseException {
        return this.getAll();
    }

    public static boolean isHiddenObject(SMTaskInfo sMTaskInfo) {
        if (sMTaskInfo.getName() == null) {
            return false;
        }
        return sMTaskInfo.getName().startsWith("_");
    }

    public static boolean isHiddenObject(SMTaskRequestInfo sMTaskRequestInfo) {
        if (sMTaskRequestInfo.getName() == null) {
            return false;
        }
        return sMTaskRequestInfo.getName().startsWith("_");
    }

    private SMTaskRequestInfo[] filterHidden(SMTaskRequestInfo[] sMTaskRequestInfoArray) {
        if (this.getHidden_) {
            return sMTaskRequestInfoArray;
        }
        Vector<SMTaskRequestInfo> vector = new Vector<SMTaskRequestInfo>();
        int n = 0;
        while (n < sMTaskRequestInfoArray.length) {
            if (!SMTaskRequest.isHiddenObject(sMTaskRequestInfoArray[n])) {
                vector.addElement(sMTaskRequestInfoArray[n]);
            }
            ++n;
        }
        Object[] objectArray = new SMTaskRequestInfo[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }
}

