/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.client.table;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRawDataBulkResponse;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.SMRawDataResponse;
import com.sun.symon.base.client.SMRequestStatus;
import com.sun.symon.base.client.table.SMTableDepthTxltr;
import com.sun.symon.base.client.table.SMTablePageFieldTxltr;
import com.sun.symon.base.client.table.SMTablePageResponse;
import com.sun.symon.base.client.table.SMTablePageStatusTxltr;
import com.sun.symon.base.server.types.StObject;
import com.sun.symon.base.server.types.StString;
import com.sun.symon.base.utility.UcInternationalizer;
import java.util.Locale;
import java.util.StringTokenizer;

public class SMTablePageRequest {
    private SMRawDataRequest handle;
    private Locale locale;
    private String[] dataUrls;
    private String[] statusUrls;
    private String[] dataColOidUrls;
    private String[] dtColBaseUrls;
    private String[] stColBaseUrls;
    private String[] dtColBaseOids;
    private String[] stColBaseOids;
    private String targetNode;
    private int pageSize;
    private int tableDepth;
    private String context;
    private String alarmFilter = null;
    private String invalidFieldMsg = null;
    private String invalidStatusMsg = null;
    private boolean isAgentVersion3OrHigher = false;

    public SMTablePageRequest(SMRawDataRequest sMRawDataRequest) {
        this.handle = sMRawDataRequest;
        this.locale = this.handle.getLocale();
        this.pageSize = 0;
        this.tableDepth = 0;
        this.dataUrls = null;
        this.statusUrls = null;
        this.dtColBaseOids = null;
        this.stColBaseOids = null;
        this.dataColOidUrls = null;
        this.alarmFilter = null;
        this.invalidFieldMsg = UcInternationalizer.translateKey((Locale)this.locale, (String)"base.client.ClientApiMessages:TableRequest.InvalidTableFieldReturnData");
        this.invalidStatusMsg = UcInternationalizer.translateKey((Locale)this.locale, (String)"base.client.ClientApiMessages:TableRequest.InvalidTableStatusData");
    }

    public SMTablePageRequest(SMRawDataRequest sMRawDataRequest, String[] stringArray, String[] stringArray2, int n) throws SMAPIException {
        this(sMRawDataRequest);
        this.init(stringArray, stringArray2, n);
    }

    public SMTablePageRequest(SMRawDataRequest sMRawDataRequest, String[] stringArray, String[] stringArray2, int n, String string) throws SMAPIException {
        this(sMRawDataRequest, stringArray, stringArray2, n);
        this.setAlarmFilter(string);
    }

    public void init(String[] stringArray, String[] stringArray2, int n) throws SMAPIException {
        this.pageSize = n;
        this.dataUrls = stringArray;
        this.statusUrls = stringArray2;
        if (this.dataUrls == null || this.dataUrls.length == 0) {
            throw new SMAPIException(this.invalidFieldMsg);
        }
        this.dataColOidUrls = new String[this.dataUrls.length];
        int n2 = 0;
        while (n2 < this.dataUrls.length) {
            this.dataColOidUrls[n2] = SMRawDataRequest.buildShadowURL(this.dataUrls[n2], "oid", null);
            ++n2;
        }
        String[] stringArray3 = new String[this.dataUrls.length + 1];
        Object var6_6 = null;
        stringArray3[0] = SMRawDataRequest.buildShadowURL(this.dataUrls[0], "tabledepth", null);
        int n3 = 0;
        while (n3 < this.dataUrls.length) {
            stringArray3[n3 + 1] = this.dataColOidUrls[n3];
            ++n3;
        }
        StObject[][] stObjectArray = this.handle.getURLValue(stringArray3);
        if (stObjectArray == null || stObjectArray.length != stringArray3.length) {
            throw new SMAPIException(this.invalidFieldMsg);
        }
        this.tableDepth = Integer.parseInt(stObjectArray[0][0].toString());
        this.dtColBaseOids = new String[this.dataUrls.length];
        this.stColBaseOids = null;
        if (this.statusUrls != null && this.statusUrls.length != 0) {
            this.stColBaseOids = new String[this.statusUrls.length];
        }
        int n4 = 1;
        int n5 = 0;
        while (n4 < stObjectArray.length) {
            this.dtColBaseOids[n5] = stObjectArray[n4][0].toString();
            if (this.stColBaseOids != null) {
                int n6 = 0;
                int n7 = this.statusUrls.length;
                while (n6 < n7 && !this.statusUrls[n6].startsWith(this.dataUrls[n5])) {
                    ++n6;
                }
                if (n6 < n7) {
                    this.stColBaseOids[n6] = this.dtColBaseOids[n5];
                }
            }
            ++n4;
            ++n5;
        }
        this.targetNode = this.getTargetNodeByURL(this.dataUrls[0]);
        if (this.targetNode == null) {
            throw new SMAPIException(this.invalidStatusMsg);
        }
        this.context = this.getContextByURL(this.dataUrls[0]);
        this.isAgentVersion3OrHigher = this.handle.isAgentVersionNotLower(this.dataUrls[0], "3.0");
    }

    public SMRawDataRequest getRawDataHandle() {
        return this.handle;
    }

    public void setAlarmFilter(String string) {
        this.alarmFilter = this.isAgentVersion3OrHigher ? string : null;
    }

    public String getAlarmFilter() {
        return this.alarmFilter;
    }

    public void setTableDepth(int n) {
        this.tableDepth = n;
    }

    public Object getTableDepth(String string, String string2, SMTablePageResponse sMTablePageResponse, Object object) throws SMAPIException {
        String[] stringArray = new String[]{SMRawDataRequest.buildShadowURL(string, "tabledepth", null)};
        return this.handle.getURLValue(stringArray, string2, (SMRawDataResponse)new SMTableDepthTxltr(sMTablePageResponse, this.locale), object);
    }

    public Object getTableDepth(String string, String string2, String string3, SMTablePageResponse sMTablePageResponse, Object object) throws SMAPIException {
        if (string2 == null || string2.length() == 0 || string2.equals("STATE=000000")) {
            return this.getTableDepth(string, string3, sMTablePageResponse, object);
        }
        if (!this.handle.isAgentVersionNotLower(string, "3.0")) {
            return this.getTableDepth(string, string3, sMTablePageResponse, object);
        }
        String[] stringArray = new String[]{SMRawDataRequest.buildShadowURL(string, "tabledepth", "index", string2)};
        return this.handle.getURLValue(stringArray, string3, (SMRawDataResponse)new SMTableDepthTxltr(sMTablePageResponse, this.locale), object);
    }

    public Object getTablePageAlarmStatusRequest(String[] stringArray, String string, SMTablePageResponse sMTablePageResponse, Object object) throws SMAPIException {
        if (this.stColBaseOids == null || this.stColBaseOids.length == 0) {
            return null;
        }
        String[] stringArray2 = new String[stringArray.length * this.stColBaseOids.length];
        Object var6_6 = null;
        int n = 0;
        int n2 = 0;
        while (n2 < this.stColBaseOids.length) {
            int n3 = 0;
            while (n3 < stringArray.length) {
                stringArray2[n++] = this.buildStatusURL(this.targetNode, this.stColBaseOids[n2], this.context, stringArray[n3]);
                ++n3;
            }
            ++n2;
        }
        return this.handle.getURLValue(stringArray2, string, (SMRawDataResponse)new SMTablePageStatusTxltr(this.stColBaseOids.length, stringArray.length, sMTablePageResponse, this.locale), object);
    }

    private int getValidRows(int n, int n2) throws SMAPIException {
        if (n + n2 < this.tableDepth) {
            return n2;
        }
        int n3 = n2;
        String[] stringArray = new String[]{SMRawDataRequest.buildShadowURL(this.dataUrls[0], "tabledepth", null)};
        StObject[][] stObjectArray = this.handle.getURLValue(stringArray);
        if (stObjectArray == null || stObjectArray.length != 1) {
            throw new SMAPIException(this.invalidFieldMsg);
        }
        this.tableDepth = Integer.parseInt(stObjectArray[0][0].toString());
        if (n + n2 > this.tableDepth) {
            n3 = this.tableDepth - n;
        }
        if (n3 <= 0) {
            throw new SMAPIException(this.invalidFieldMsg);
        }
        return n3;
    }

    private String[] createTableColumnURL(int n) throws SMAPIException {
        boolean bl = false;
        if (this.alarmFilter != null && this.alarmFilter.length() != 0 && !this.alarmFilter.equals("STATE=000000")) {
            bl = true;
        }
        String[] stringArray = null;
        if (n == 0) {
            stringArray = new String[this.dataUrls.length];
            if (bl) {
                int n2 = 0;
                while (n2 < this.dataUrls.length) {
                    stringArray[n2] = SMRawDataRequest.buildShadowURL(this.dataUrls[n2], null, null, this.alarmFilter);
                    ++n2;
                }
            } else {
                int n3 = 0;
                while (n3 < this.dataUrls.length) {
                    stringArray[n3] = this.dataUrls[n3];
                    ++n3;
                }
            }
            return stringArray;
        }
        stringArray = new String[]{this.dataColOidUrls[0]};
        StObject[][] stObjectArray = new StObject[1][1];
        String string = Integer.toString(n - 1);
        if (bl) {
            string = string + " " + this.alarmFilter;
        }
        stObjectArray[0][0] = new StString(string);
        StObject[][] stObjectArray2 = this.handle.setURLValue(stringArray, stObjectArray);
        if (stObjectArray2 == null || stObjectArray2.length == 0) {
            return null;
        }
        String string2 = stObjectArray2[0][0].toString();
        String string3 = SMTablePageRequest.getInstByUrl(this.dtColBaseOids[0], string2);
        if (string3 == null) {
            return null;
        }
        stringArray = new String[this.dtColBaseOids.length];
        String string4 = this.context;
        if (bl) {
            if (string4 == null) {
                string4 = ":" + this.alarmFilter;
            } else if (string4.indexOf(58) == -1) {
                string4 = string4 + ":" + this.alarmFilter;
            }
        }
        int n4 = 0;
        while (n4 < this.dtColBaseOids.length) {
            stringArray[n4] = this.buildCellURL(null, this.dtColBaseOids[n4], string4, string3);
            ++n4;
        }
        return stringArray;
    }

    public Object getTablePageFieldRequest(int n, int n2, String string, SMTablePageResponse sMTablePageResponse, Object object) throws SMAPIException {
        if (this.dataUrls == null || this.dataUrls.length == 0) {
            return null;
        }
        int n3 = this.getValidRows(n, n2);
        String[] stringArray = this.createTableColumnURL(n);
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        return this.getTablePageFieldRequest(stringArray, n3, string, sMTablePageResponse, object);
    }

    public Object getTablePageFieldRequest(String[] stringArray, int n, String string, SMTablePageResponse sMTablePageResponse, Object object) throws SMAPIException {
        int n2 = n == 0 ? this.pageSize : n;
        return this.handle.getURLValue(stringArray, n2, string, (SMRawDataBulkResponse)new SMTablePageFieldTxltr(stringArray, this.dtColBaseOids, sMTablePageResponse, this.locale), object);
    }

    public Object getTablePageFieldRequest(String[] stringArray, int n, String string, String string2, SMTablePageResponse sMTablePageResponse, Object object) throws SMAPIException {
        int n2;
        int n3 = n2 = n == 0 ? this.pageSize : n;
        if (string != null && string.length() != 0 && !string.equals("STATE=000000")) {
            String[] stringArray2 = new String[stringArray.length];
            int n4 = 0;
            while (n4 < stringArray.length) {
                stringArray2[n4] = SMRawDataRequest.buildShadowURL(stringArray[n4], null, null, string);
                ++n4;
            }
            return this.handle.getURLValue(stringArray2, n2, string2, (SMRawDataBulkResponse)new SMTablePageFieldTxltr(stringArray, this.dtColBaseOids, sMTablePageResponse, this.locale), object);
        }
        return this.handle.getURLValue(stringArray, n2, string2, (SMRawDataBulkResponse)new SMTablePageFieldTxltr(stringArray, this.dtColBaseOids, sMTablePageResponse, this.locale), object);
    }

    public String[][] getTablePageFieldRequest(int n, int n2, String[][] stringArray) throws SMAPIException {
        if (this.dataColOidUrls == null || this.dataColOidUrls.length == 0) {
            return null;
        }
        int n3 = n2;
        if (n + n3 > this.tableDepth) {
            n3 = this.tableDepth - n;
        }
        String[] stringArray2 = new String[]{this.dataColOidUrls[0]};
        StObject[][] stObjectArray = new StObject[1][1];
        stObjectArray[0][0] = new StString(Integer.toString(n));
        StObject[][] stObjectArray2 = this.handle.setURLValue(stringArray2, stObjectArray);
        if (stObjectArray2 == null || stObjectArray2.length == 0) {
            return null;
        }
        String string = stObjectArray2[0][0].toString();
        String string2 = SMTablePageRequest.getInstByUrl(this.dtColBaseOids[0], string);
        if (string2 == null) {
            return null;
        }
        stringArray2 = new String[this.dtColBaseOids.length];
        int n4 = 0;
        while (n4 < this.dtColBaseOids.length) {
            stringArray2[n4] = this.buildCellURL(null, this.dtColBaseOids[n4], this.context, string2);
            ++n4;
        }
        return this.getTablePageFieldRequest(stringArray2, n3, stringArray);
    }

    public String[][] getTablePageFieldRequest(String[] stringArray, int n, String[][] stringArray2) throws SMAPIException {
        int n2 = n == 0 ? this.pageSize : n;
        SMRequestStatus[] sMRequestStatusArray = new SMRequestStatus[1];
        String[][][] stringArray3 = new String[1][][];
        StObject[][] stObjectArray = this.handle.getURLValue(stringArray, n2, stringArray3, sMRequestStatusArray);
        if (sMRequestStatusArray[0].getReturnCode() == 0) {
            String[][] stringArray4 = stringArray3[0];
            String[] stringArray5 = new String[stringArray4[0].length];
            int n3 = 0;
            while (n3 < stringArray4[0].length) {
                stringArray5[n3] = SMTablePageRequest.getInstByUrl(this.dtColBaseOids[0], stringArray4[0][n3]);
                ++n3;
            }
            int n4 = stObjectArray.length;
            int n5 = stObjectArray[0].length;
            String[][] stringArray6 = new String[n4][n5];
            int n6 = 0;
            while (n6 < n4) {
                int n7 = 0;
                while (n7 < n5) {
                    stringArray6[n6][n7] = stObjectArray[n6][n7].toString();
                    ++n7;
                }
                ++n6;
            }
            stringArray2[0] = stringArray5;
            return stringArray6;
        }
        throw new SMAPIException(sMRequestStatusArray[0].getReturnCode(), sMRequestStatusArray[0].getMessageText());
    }

    private String getTargetNodeByURL(String string) {
        String string2 = null;
        int n = string.indexOf("//");
        if (n == -1) {
            return string2;
        }
        String string3 = string.substring(n + 2);
        int n2 = string3.indexOf("/");
        if (n2 != -1) {
            string2 = string.substring(0, n + 2 + n2);
        }
        return string2;
    }

    private String getContextByURL(String string) {
        String string2 = null;
        int n = string.indexOf("//");
        if (n == -1) {
            return string2;
        }
        String string3 = string.substring(n + 2);
        if ((n = string3.indexOf("/")) == -1) {
            return string2;
        }
        if ((n = (string3 = string3.substring(n + 1)).indexOf("/")) == -1) {
            return string2;
        }
        String string4 = string3.substring(0, n);
        if (string4.equals("oid")) {
            return string2;
        }
        if ((n = (string3 = string3.substring(n + 1)).indexOf("/")) == -1) {
            return string2;
        }
        String string5 = string3.substring(0, n);
        if ((n = string5.indexOf("+")) == -1) {
            return string2;
        }
        return string5.substring(n + 1);
    }

    private String buildCellURL(String string, String string2, String string3, String string4) {
        String string5 = string == null ? this.targetNode : string;
        String string6 = string5 + "/oid/";
        if (string3 != null) {
            string6 = string6 + string3 + "/";
        }
        string6 = string6 + string2 + string4;
        return string6;
    }

    private String buildStatusURL(String string, String string2, String string3, String string4) {
        String string5 = string;
        StringTokenizer stringTokenizer = new StringTokenizer(string4, ".");
        int n = stringTokenizer.countTokens();
        String string6 = string5 + "/oid/";
        if (string3 != null) {
            string6 = string6 + string3 + "/";
        }
        string6 = string6 + "2" + string2.substring(1) + string4 + "." + n + ".701.1";
        return string6;
    }

    public static String getInstByUrl(String string, String string2) {
        int n = string2.indexOf("/oid/");
        String string3 = null;
        string3 = n == -1 ? string2 : string2.substring(n + 5);
        if (!string3.startsWith(string)) {
            return null;
        }
        String string4 = string3.substring(string.length());
        return string4;
    }
}

