/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.client.service;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMMessageI18nKey;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.service.SMDBChangeListener;
import com.sun.symon.base.client.service.SMDBObject;
import com.sun.symon.base.client.service.SMDBObjectID;
import com.sun.symon.base.client.service.SMDBRemoteChangeListener;
import com.sun.symon.base.client.service.SMDatabaseException;
import com.sun.symon.base.client.service.SMNoSuchObjectException;
import com.sun.symon.base.client.service.SMRemoteEventAdaptor;
import com.sun.symon.base.client.service.SMRemoteServiceInterface;
import com.sun.symon.base.client.service.SMSecurityException;
import com.sun.symon.base.client.service.SMWrongTypeException;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Locale;

public abstract class SMHandle {
    protected Hashtable map;
    protected SMRemoteServiceInterface handle;
    protected SMRawDataRequest rawRequest;
    protected String domainName;
    protected Locale locale;
    private static String i18nBase_ = "com.sun.symon.base.client.ClientApiMessages";

    protected SMHandle(SMRawDataRequest sMRawDataRequest) {
        this.rawRequest = sMRawDataRequest;
        this.map = new Hashtable();
        this.locale = sMRawDataRequest.getLocale();
    }

    public void setDomainName(String string) {
        this.domainName = string;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public Locale getLocale() {
        return this.locale;
    }

    protected void setHandle(SMRemoteServiceInterface sMRemoteServiceInterface) {
        this.handle = sMRemoteServiceInterface;
    }

    protected SMDBRemoteChangeListener newRemoteChangeListener(SMDBChangeListener sMDBChangeListener) throws RemoteException {
        SMRemoteEventAdaptor sMRemoteEventAdaptor = new SMRemoteEventAdaptor(sMDBChangeListener);
        this.map.put(sMDBChangeListener, sMRemoteEventAdaptor);
        return sMRemoteEventAdaptor;
    }

    protected SMDBRemoteChangeListener findRemoteChangeListener(SMDBChangeListener sMDBChangeListener) {
        return (SMDBRemoteChangeListener)this.map.get(sMDBChangeListener);
    }

    public void addDBChangeListener(SMDBChangeListener sMDBChangeListener) throws SMAPIException {
        try {
            this.handle.addEventListener(this.newRemoteChangeListener(sMDBChangeListener));
        }
        catch (Exception exception) {
            if (exception instanceof SMAPIException) {
                throw (SMAPIException)exception;
            }
            throw new SMAPIException(exception.getMessage(), new SMMessageI18nKey(i18nBase_, "smApiException"));
        }
    }

    public void removeDBChangeListener(SMDBChangeListener sMDBChangeListener) throws SMAPIException {
        try {
            SMDBRemoteChangeListener sMDBRemoteChangeListener = (SMDBRemoteChangeListener)this.map.remove(sMDBChangeListener);
            if (sMDBRemoteChangeListener != null) {
                this.handle.removeEventListener(sMDBRemoteChangeListener);
            }
        }
        catch (Exception exception) {
            if (exception instanceof SMAPIException) {
                throw (SMAPIException)exception;
            }
            throw new SMAPIException(exception.getMessage(), new SMMessageI18nKey(i18nBase_, "smApiException"));
        }
    }

    public void close() throws SMAPIException {
        this.map = null;
    }

    public abstract SMDBObject loadInfoObj(SMDBObjectID var1) throws SMAPIException, SMDatabaseException, SMSecurityException;

    public abstract SMDBObject loadObj(SMDBObjectID var1) throws SMAPIException, SMDatabaseException, SMSecurityException;

    public abstract SMDBObject loadObj(String var1) throws SMAPIException, SMSecurityException, SMNoSuchObjectException, SMDatabaseException;

    public SMDBObject loadObj(SMDBObject sMDBObject) throws SMAPIException, SMDatabaseException, SMSecurityException {
        return this.loadObj(sMDBObject.getObjectID());
    }

    public SMDBObject loadInfoObj(SMDBObject sMDBObject) throws SMAPIException, SMDatabaseException, SMSecurityException {
        return this.loadInfoObj(sMDBObject.getObjectID());
    }

    public abstract SMDBObject[] getAllObjs() throws SMAPIException, SMSecurityException, SMDatabaseException;

    public abstract SMDBObjectID saveObj(SMDBObject var1) throws SMAPIException, SMDatabaseException, SMSecurityException, SMWrongTypeException;

    public abstract SMDBObject saveAsObj(SMDBObject var1, String var2) throws SMAPIException, SMDatabaseException, SMSecurityException, SMWrongTypeException;

    public abstract void delete(SMDBObjectID var1) throws SMAPIException, SMSecurityException, SMDatabaseException, SMNoSuchObjectException;

    public void deleteObj(SMDBObjectID sMDBObjectID) throws SMAPIException, SMDatabaseException, SMSecurityException {
        this.delete(sMDBObjectID);
    }

    public void deleteObj(SMDBObject sMDBObject) throws SMAPIException, SMDatabaseException, SMSecurityException {
        this.delete(sMDBObject.getObjectID());
    }
}

