/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.client.log;

import com.sun.symon.base.client.service.SMDBObject;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class SMLogRecord
implements Serializable {
    private static final String version = "1.0";
    private String line_;
    private transient String subject_;
    private transient Date date_;
    private transient String msg_;

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        SMDBObject.writeString(objectOutputStream, version);
        SMDBObject.writeString(objectOutputStream, this.line_);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        SMDBObject.readString(objectInputStream);
        this.line_ = SMDBObject.readString(objectInputStream);
        this.parse();
    }

    public SMLogRecord(String string) {
        this.line_ = string == null ? "" : string;
    }

    public String getLine() {
        return this.line_;
    }

    public Date getTimestamp() {
        if (this.date_ == null) {
            this.parse();
        }
        return this.date_;
    }

    public String getSubject() {
        if (this.subject_ == null) {
            this.parse();
        }
        return this.subject_;
    }

    public String getMessage() {
        if (this.msg_ == null) {
            this.parse();
        }
        return this.msg_;
    }

    public String toString() {
        return this.line_;
    }

    private void parse() {
        this.subject_ = "";
        this.msg_ = this.line_;
        int n = this.line_.indexOf(32);
        if (n < 0) {
            return;
        }
        this.subject_ = this.line_.substring(0, n);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM d yyyy HH:mm:ss", Locale.US);
        ParsePosition parsePosition = new ParsePosition(n + 1);
        this.date_ = simpleDateFormat.parse(this.line_, parsePosition);
        if (this.date_ == null) {
            simpleDateFormat = new SimpleDateFormat("MMM d HH:mm:ss", Locale.US);
            parsePosition = new ParsePosition(n + 1);
            this.date_ = simpleDateFormat.parse(this.line_, parsePosition);
            if (this.date_ == null) {
                return;
            }
        }
        this.msg_ = this.line_.substring(parsePosition.getIndex() + 1);
    }
}

