/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.client.log;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.log.SMLogRecord;
import com.sun.symon.base.client.log.SMRemoteLogReader;

public class SMLogReader {
    private static final int AT_START = 0;
    private static final int AT_END = -1;
    private static final int DEFAULT_PAGE_SIZE = 10;
    private SMRemoteLogReader stub_;
    private int curLine_ = 0;
    private int pageSize_ = 10;

    public SMLogReader(SMRemoteLogReader sMRemoteLogReader) {
        this.stub_ = sMRemoteLogReader;
    }

    public void close() throws SMAPIException {
        try {
            this.stub_.close();
        }
        catch (Exception exception) {
            throw new SMAPIException(exception);
        }
    }

    public int getFirstLineNumber() {
        return this.curLine_;
    }

    public void setPageSize(int n) {
        if (n < 1) {
            n = 10;
        }
        this.pageSize_ = n;
    }

    public void setToBeginning() {
        this.curLine_ = 0;
    }

    public void setToEnd() {
        this.curLine_ = -1;
    }

    public SMLogRecord[] getPreviousPage() throws SMAPIException {
        if (this.curLine_ == -1) {
            return this.getLastPage();
        }
        if (this.curLine_ <= 1) {
            return null;
        }
        int n = this.curLine_ - this.pageSize_;
        if (n < 1) {
            n = 1;
        }
        SMLogRecord[] sMLogRecordArray = this.getLines(n, this.pageSize_);
        this.curLine_ -= sMLogRecordArray.length;
        if (this.curLine_ < 1) {
            this.curLine_ = 1;
        }
        return sMLogRecordArray;
    }

    public SMLogRecord[] getNextPage() throws SMAPIException {
        if (this.curLine_ == -1) {
            return null;
        }
        int n = this.curLine_ == 0 ? 1 : this.curLine_ + this.pageSize_;
        SMLogRecord[] sMLogRecordArray = this.getLines(n, this.pageSize_);
        if (sMLogRecordArray == null) {
            return null;
        }
        this.curLine_ = n;
        return sMLogRecordArray;
    }

    public int getSize() throws SMAPIException {
        try {
            return this.stub_.getSize();
        }
        catch (Exception exception) {
            throw new SMAPIException(exception);
        }
    }

    public int getPageSize() {
        return this.pageSize_;
    }

    public SMLogRecord[] getLastPage() throws SMAPIException {
        return this.getLastLines(this.pageSize_);
    }

    public SMLogRecord[] getLastLines(int n) throws SMAPIException {
        try {
            SMLogRecord[] sMLogRecordArray = this.stub_.getLastLines(n);
            if (sMLogRecordArray == null) {
                this.curLine_ = 0;
                return null;
            }
            this.curLine_ = this.getSize() - sMLogRecordArray.length + 1;
            return sMLogRecordArray;
        }
        catch (Exception exception) {
            throw new SMAPIException(exception);
        }
    }

    public SMLogRecord[] getLines(int n, int n2) throws SMAPIException {
        try {
            return this.stub_.getLines(n, n2);
        }
        catch (Exception exception) {
            throw new SMAPIException(exception);
        }
    }
}

