/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.client.group;

import com.sun.symon.base.client.SMUtility;
import com.sun.symon.base.client.group.SMObjectGroupInfo;
import com.sun.symon.base.client.service.SMDBObject;
import com.sun.symon.base.client.service.SMDBObjectID;
import com.sun.symon.base.client.service.SMLengthException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Locale;

public class SMObjectGroupData
extends SMObjectGroupInfo {
    private static final String version = "1.0";
    private boolean allObjectsInDomain_;
    private String[] objects_;
    private String userData_;

    public SMObjectGroupData() {
    }

    public SMObjectGroupData(SMDBObjectID sMDBObjectID, String string) {
        super(sMDBObjectID, string);
    }

    public void setName(String string) throws SMLengthException {
        super.setName(string);
    }

    public void setDescription(String string) throws SMLengthException {
        super.setDescription(string);
    }

    protected Object clone() {
        return super.clone();
    }

    public void setDomain(String string) throws SMLengthException {
        super.setDomain(string);
    }

    public void setAllObjectsInDomain(boolean bl) {
        this.allObjectsInDomain_ = bl;
        this.setChanged(true);
    }

    public boolean isAllObjectsInDomain() {
        return this.allObjectsInDomain_;
    }

    public void setObjects(String[] stringArray) throws SMLengthException {
        this.objects_ = SMDBObject.assertLength("object", stringArray, 512);
        this.setChanged(true);
    }

    public String[] getObjects() {
        return this.objects_;
    }

    public void setFilter(SMDBObjectID sMDBObjectID) {
        super.setFilter(sMDBObjectID);
    }

    public void setUserData(String string) throws SMLengthException {
        this.userData_ = SMDBObject.assertLength("userData", string, 64, false);
        this.setChanged(true);
    }

    public String getUserData() {
        if (this.userData_ == null) {
            return "";
        }
        return this.userData_;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        SMDBObject.writeString(objectOutputStream, version);
        objectOutputStream.writeBoolean(this.allObjectsInDomain_);
        objectOutputStream.writeObject(this.objects_);
        SMDBObject.writeString(objectOutputStream, this.userData_);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        SMDBObject.readString(objectInputStream);
        this.allObjectsInDomain_ = objectInputStream.readBoolean();
        this.objects_ = (String[])objectInputStream.readObject();
        this.userData_ = SMDBObject.readString(objectInputStream);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        stringBuffer.append(super.toString());
        stringBuffer.append(", allObjectsInDomain=").append(this.allObjectsInDomain_);
        stringBuffer.append(", userData=").append(this.userData_);
        stringBuffer.append(", objects=");
        SMDBObject.arrayToStringBuffer(this.objects_, stringBuffer);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public void validate() throws IllegalArgumentException {
        this.validate(Locale.getDefault());
    }

    public void validate(Locale locale) throws IllegalArgumentException {
        if (this.name_ == null || this.name_.trim().equals("") || SMUtility.validate(this.name_) >= 0) {
            throw new IllegalArgumentException(SMUtility.getClientMessage(locale, "GroupRequest.InvalidGroupName"));
        }
        if (this.domain_ == null || this.domain_.trim().equals("") || SMUtility.validate(this.domain_) >= 0) {
            throw new IllegalArgumentException(SMUtility.getClientMessage(locale, "GroupRequest.InvalidDomainName"));
        }
        if (!this.allObjectsInDomain_ && this.objects_ == null) {
            throw new IllegalArgumentException(SMUtility.getClientMessage(locale, "GroupRequest.EmptyObjectList"));
        }
    }
}

