/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.client.group;

import com.sun.symon.base.client.SMMessageI18nKey;
import com.sun.symon.base.client.group.SMFilterCriteria;
import com.sun.symon.base.client.service.SMDBObject;
import com.sun.symon.base.client.service.SMLengthException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class SMIPRangeCriteria
extends SMFilterCriteria {
    private static final String version = "1.0";
    private String fromAddress_;
    private String toAddress_;
    private long fromAddressCode_;
    private long toAddressCode_;
    private static String i18nBase_ = "com.sun.symon.base.client.ClientApiMessages";

    public SMIPRangeCriteria(String string, String string2, boolean bl) throws IllegalArgumentException, SMLengthException {
        super(bl);
        if (string.length() > 31 || string2.length() > 31) {
            SMLengthException sMLengthException = new SMLengthException();
            sMLengthException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "lengthException"));
            throw sMLengthException;
        }
        this.fromAddress_ = string;
        this.toAddress_ = string2;
        this.fromAddressCode_ = this.getIpToLong(string);
        this.toAddressCode_ = this.getIpToLong(string2);
    }

    public String getFromAddress() {
        return this.fromAddress_;
    }

    public String getToAddress() {
        return this.toAddress_;
    }

    public boolean isInRange(String string) {
        long l = this.getIpToLong(string);
        return l >= this.fromAddressCode_ && l <= this.toAddressCode_;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        SMDBObject.writeString(objectOutputStream, version);
        SMDBObject.writeString(objectOutputStream, this.fromAddress_);
        SMDBObject.writeString(objectOutputStream, this.toAddress_);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        SMDBObject.readString(objectInputStream);
        this.fromAddress_ = SMDBObject.readString(objectInputStream);
        this.toAddress_ = SMDBObject.readString(objectInputStream);
        this.fromAddressCode_ = this.getIpToLong(this.fromAddress_);
        this.toAddressCode_ = this.getIpToLong(this.toAddress_);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("IPRangeCriteria=[");
        stringBuffer.append("fromAddress=").append(this.fromAddress_);
        stringBuffer.append(", toAddress=").append(this.toAddress_);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private long getIpToLong(String string) throws IllegalArgumentException {
        try {
            int n = -1;
            int n2 = string.indexOf(46);
            long l = 0L;
            int n3 = 0;
            while (n3 < 4) {
                int n4 = Integer.parseInt(string.substring(n + 1, n2));
                n = n2;
                n2 = n3 == 2 ? string.length() : string.indexOf(46, n + 1);
                l = (long)((double)l + (double)n4 * Math.pow(10.0, (3 - n3) * 3));
                ++n3;
            }
            return l;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception.getMessage());
        }
    }
}

