/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.client.console;

import com.sun.symon.base.bootstrap.BsRMIBootstrap;
import com.sun.symon.base.bootstrap.BsRMIBootstrapException;
import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.console.main.ConsoleLoginRunner;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class SMMainConsoleBean {
    private String sName;
    private int sPort;
    private String userName;
    private String passwd;
    private String key;
    private String securityScheme;
    private static final String DEFAULT_KEY = "687a8398ad4a85077d33b72a94e16ffde0c4ba023e9c9ba77b247cc25bd3cd0015bc24b7429916751e681fd02e5ad6eb5345eb7c75b39a1c304e0f000846aa470b755b0640af974e7fc70daa6191dff6efa31a09431bb5e9848b7dc4cf4b97e1dbca31792d2860ca5a5990dfb369e1bcf296274a4e4984c8089329679dd304cd";
    private static final String DEFAULT_SECURE_SCHEME = "medium";
    private boolean hasInited = false;
    private PropertyChangeSupport beanChangeSupport = new PropertyChangeSupport(this);
    private SMRawDataRequest rawHandle;
    public static final String LAUNCH_STATUS = "launchStatus";
    public static final String STATUS_STARTUP_OK = "STATUS_STARTUP_OK";
    public static final String STATUS_CONNECTION_OK = "CONNECTION_OK";
    public static final String STATUS_AUTHENTICATION_OK = "AUTHENTICATION_OK";
    private String currentStatus = "";

    public void init(String string, int n, String string2, String string3) {
        this.init(string, n, string2, string3, DEFAULT_KEY, DEFAULT_SECURE_SCHEME);
    }

    public void init(String string, int n, String string2, String string3, String string4, String string5) {
        this.sName = string;
        this.sPort = n;
        this.userName = string2;
        this.passwd = string3;
        if (this.passwd.length() > 8) {
            this.passwd.substring(0, 8);
        }
        this.key = string4;
        this.securityScheme = string5;
        this.hasInited = true;
    }

    public void doLaunchMainConsole() throws SMAPIException {
        if (!this.hasInited) {
            return;
        }
        BsRMIBootstrap bsRMIBootstrap = null;
        try {
            bsRMIBootstrap = new BsRMIBootstrap(this.sName, this.sPort);
        }
        catch (Exception exception) {
            throw new SMAPIException(exception.getMessage());
        }
        this.fireStatusChanged(STATUS_CONNECTION_OK);
        try {
            bsRMIBootstrap.authenticate(this.userName, this.passwd, this.key, this.securityScheme, false);
        }
        catch (BsRMIBootstrapException bsRMIBootstrapException) {
            throw new SMAPIException(bsRMIBootstrapException.getMessage());
        }
        this.fireStatusChanged(STATUS_AUTHENTICATION_OK);
        this.rawHandle = new SMRawDataRequest(bsRMIBootstrap.getServerConn());
        String string = ConsoleLoginRunner.getBaseXFile((SMRawDataRequest)this.rawHandle);
        ConsoleLoginRunner.checkLicense((SMRawDataRequest)this.rawHandle);
        try {
            bsRMIBootstrap.launch(string);
            this.fireStatusChanged(STATUS_STARTUP_OK);
        }
        catch (BsRMIBootstrapException bsRMIBootstrapException) {
            throw new SMAPIException(bsRMIBootstrapException.getMessage());
        }
    }

    public SMRawDataRequest getRawDataRequestHandle() {
        return this.rawHandle;
    }

    protected void fireStatusChanged(String string) {
        this.beanChangeSupport.firePropertyChange(LAUNCH_STATUS, this.currentStatus, string);
        this.currentStatus = string;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.beanChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.beanChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }
}

