/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.client.console;

import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.console.SMDomainChangeEvent;
import com.sun.symon.base.client.console.SMDomainChangeListener;
import com.sun.symon.base.client.console.SMTopologyChangeEvent;
import com.sun.symon.base.client.console.SMTopologyChangeListener;
import com.sun.symon.base.client.console.SMTopologyInfo;
import java.util.Vector;

public class SMConsoleContext {
    private static SMConsoleContext instance_ = new SMConsoleContext();
    private SMRawDataRequest clientAPIHandle_ = null;
    private SMTopologyInfo[] selectedTopologyObjects_ = null;
    private SMTopologyInfo[] topologyObjects_ = null;
    private Vector topologyListeners_ = null;
    private Vector domainListeners_ = null;
    private String[] domains_ = null;
    private String domain_ = "base.console.ConsoleTopology:domain.defaultdomain";

    private SMConsoleContext() {
    }

    public static SMConsoleContext getInstance() {
        return instance_;
    }

    public SMRawDataRequest getAPIHandle() {
        return this.clientAPIHandle_;
    }

    public String getUserID() {
        return this.clientAPIHandle_.getUserId();
    }

    public SMTopologyInfo[] getSelectedTopologyObjects() {
        return this.selectedTopologyObjects_;
    }

    public SMTopologyInfo[] getTopologyObjects() {
        return this.topologyObjects_;
    }

    public String getCurrentDomain() {
        return this.domain_;
    }

    public String[] getDomains() {
        return this.domains_;
    }

    public synchronized void addTopologyChangeListener(SMTopologyChangeListener sMTopologyChangeListener) {
        if (this.topologyListeners_ == null) {
            this.topologyListeners_ = new Vector();
        }
        if (!this.topologyListeners_.contains(sMTopologyChangeListener)) {
            this.topologyListeners_.addElement(sMTopologyChangeListener);
        }
    }

    public synchronized void removeTopologyChangeListener(SMTopologyChangeListener sMTopologyChangeListener) {
        if (this.topologyListeners_ == null) {
            return;
        }
        this.topologyListeners_.removeElement(sMTopologyChangeListener);
    }

    public synchronized void addDomainChangeListener(SMDomainChangeListener sMDomainChangeListener) {
        if (this.domainListeners_ == null) {
            this.domainListeners_ = new Vector();
        }
        if (!this.domainListeners_.contains(sMDomainChangeListener)) {
            this.domainListeners_.addElement(sMDomainChangeListener);
        }
    }

    public synchronized void removeDomainChangeListener(SMDomainChangeListener sMDomainChangeListener) {
        if (this.domainListeners_ == null) {
            return;
        }
        this.domainListeners_.removeElement(sMDomainChangeListener);
    }

    protected void fireTopologyChange(SMTopologyInfo sMTopologyInfo, int n) {
        Vector vector = null;
        if (this.topologyListeners_ == null) {
            return;
        }
        Vector vector2 = this.topologyListeners_;
        synchronized (vector2) {
            vector = (Vector)this.topologyListeners_.clone();
        }
        SMTopologyChangeEvent sMTopologyChangeEvent = new SMTopologyChangeEvent(sMTopologyInfo, n);
        int n2 = 0;
        while (n2 < vector.size()) {
            SMTopologyChangeListener sMTopologyChangeListener = (SMTopologyChangeListener)vector.elementAt(n2);
            sMTopologyChangeListener.changed(sMTopologyChangeEvent);
            ++n2;
        }
    }

    protected void fireDomainChange(String string, int n) {
        Vector vector = null;
        if (this.domainListeners_ == null) {
            return;
        }
        Vector vector2 = this.domainListeners_;
        synchronized (vector2) {
            vector = (Vector)this.domainListeners_.clone();
        }
        SMDomainChangeEvent sMDomainChangeEvent = new SMDomainChangeEvent(string, n);
        int n2 = 0;
        while (n2 < vector.size()) {
            SMDomainChangeListener sMDomainChangeListener = (SMDomainChangeListener)vector.elementAt(n2);
            sMDomainChangeListener.changed(sMDomainChangeEvent);
            ++n2;
        }
    }

    void setAPIHandle(SMRawDataRequest sMRawDataRequest) {
        this.clientAPIHandle_ = sMRawDataRequest;
    }

    public void setCurrentDomain(String string) {
        if (this.domain_.equals(string)) {
            return;
        }
        String string2 = this.domain_;
        this.domain_ = string != null ? string : "";
        if (!string2.equals("")) {
            this.fireDomainChange(string2, 1);
        }
        this.fireDomainChange(this.domain_, 0);
    }

    void setDomains(String[] stringArray) {
        int n;
        String[] stringArray2 = this.cloneDomainList(this.domains_);
        this.domains_ = stringArray;
        if (stringArray == null) {
            if (stringArray2 != null) {
                int n2 = 0;
                while (n2 < stringArray2.length) {
                    this.fireDomainChange(stringArray2[n2], 3);
                    ++n2;
                }
            }
            return;
        }
        if (stringArray2 != null) {
            n = 0;
            while (n < stringArray2.length) {
                if (!this.inList(stringArray2[n], stringArray)) {
                    this.fireDomainChange(stringArray2[n], 3);
                }
                ++n;
            }
        }
        n = 0;
        while (n < stringArray.length) {
            if (stringArray2 == null) {
                this.fireDomainChange(stringArray[n], 2);
            } else if (!this.inList(stringArray[n], stringArray2)) {
                this.fireDomainChange(stringArray[n], 2);
            }
            ++n;
        }
    }

    void setTopologyObjects(SMTopologyInfo[] sMTopologyInfoArray) {
        int n;
        SMTopologyInfo[] sMTopologyInfoArray2 = this.cloneTopologyInfoList(this.topologyObjects_);
        this.topologyObjects_ = sMTopologyInfoArray;
        if (sMTopologyInfoArray == null) {
            if (sMTopologyInfoArray2 != null) {
                int n2 = 0;
                while (n2 < sMTopologyInfoArray2.length) {
                    this.fireTopologyChange(sMTopologyInfoArray2[n2], 3);
                    ++n2;
                }
            }
            return;
        }
        if (sMTopologyInfoArray2 != null) {
            n = 0;
            while (n < sMTopologyInfoArray2.length) {
                if (!this.inList(sMTopologyInfoArray2[n], sMTopologyInfoArray)) {
                    this.fireTopologyChange(sMTopologyInfoArray2[n], 3);
                }
                ++n;
            }
        }
        n = 0;
        while (n < sMTopologyInfoArray.length) {
            if (sMTopologyInfoArray2 == null) {
                this.fireTopologyChange(sMTopologyInfoArray[n], 2);
            } else if (!this.inList(sMTopologyInfoArray[n], sMTopologyInfoArray2)) {
                this.fireTopologyChange(sMTopologyInfoArray[n], 2);
            }
            ++n;
        }
    }

    void setSelectedTopologyObjects(SMTopologyInfo[] sMTopologyInfoArray) {
        int n;
        SMTopologyInfo[] sMTopologyInfoArray2 = this.cloneTopologyInfoList(this.selectedTopologyObjects_);
        this.selectedTopologyObjects_ = sMTopologyInfoArray;
        if (sMTopologyInfoArray == null) {
            if (sMTopologyInfoArray2 != null) {
                int n2 = 0;
                while (n2 < sMTopologyInfoArray2.length) {
                    this.fireTopologyChange(sMTopologyInfoArray2[n2], 1);
                    ++n2;
                }
            }
            return;
        }
        if (sMTopologyInfoArray2 != null) {
            n = 0;
            while (n < sMTopologyInfoArray2.length) {
                if (!this.inList(sMTopologyInfoArray2[n], sMTopologyInfoArray)) {
                    this.fireTopologyChange(sMTopologyInfoArray2[n], 1);
                }
                ++n;
            }
        }
        n = 0;
        while (n < sMTopologyInfoArray.length) {
            if (sMTopologyInfoArray2 == null) {
                this.fireTopologyChange(sMTopologyInfoArray[n], 0);
            } else if (!this.inList(sMTopologyInfoArray[n], sMTopologyInfoArray2)) {
                this.fireTopologyChange(sMTopologyInfoArray[n], 0);
            }
            ++n;
        }
    }

    private boolean inList(SMTopologyInfo sMTopologyInfo, SMTopologyInfo[] sMTopologyInfoArray) {
        int n = 0;
        while (n < sMTopologyInfoArray.length) {
            if (sMTopologyInfoArray[n].equals(sMTopologyInfo)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean inList(String string, String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private SMTopologyInfo[] cloneTopologyInfoList(SMTopologyInfo[] sMTopologyInfoArray) {
        if (sMTopologyInfoArray == null) {
            return null;
        }
        SMTopologyInfo[] sMTopologyInfoArray2 = new SMTopologyInfo[sMTopologyInfoArray.length];
        int n = 0;
        while (n < sMTopologyInfoArray.length) {
            sMTopologyInfoArray2[n] = sMTopologyInfoArray[n];
            ++n;
        }
        return sMTopologyInfoArray2;
    }

    private String[] cloneDomainList(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray2[n] = stringArray[n];
            ++n;
        }
        return stringArray2;
    }
}

