/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.client;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.server.receptors.rmi.RMIClientLevel1;
import com.sun.symon.base.server.receptors.rmi.RMIClientLevel1Exception;
import com.sun.symon.base.server.receptors.rmi.RMILoginException;
import com.sun.symon.base.utility.UcInternationalizer;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Locale;

public class SMLogin {
    private RMIClientLevel1 handle = null;
    private Locale locale;

    public SMLogin() {
        this.locale = Locale.getDefault();
    }

    public SMLogin(Locale locale) {
        this.locale = locale == null ? Locale.getDefault() : locale;
    }

    public void connect(String string, int n, String string2, String string3, String string4) throws SMAPIException {
        this.establish(string, n);
        this.authenticate(string2, string3, string4);
    }

    private void establish(String string, int n) throws SMAPIException {
        try {
            this.handle = new RMIClientLevel1(string, n);
        }
        catch (RMIClientLevel1Exception rMIClientLevel1Exception) {
            String string2 = "base.client.ClientApiMessages:";
            switch (rMIClientLevel1Exception.getReason()) {
                case 0: {
                    string2 = string2 + "ClientAuthRMIImpl.NoRegistryFound";
                    break;
                }
                case 1: {
                    string2 = string2 + "ClientAuthRMIImpl.RemoteNameIsUnbound";
                    break;
                }
                case 2: {
                    string2 = string2 + "ClientAuthRMIImpl.InvalidURL";
                    break;
                }
                case 3: {
                    string2 = string2 + "ClientAuthRMIImpl.CannotRetrieveUserSession";
                    break;
                }
                case 4: {
                    string2 = string2 + "ClientAuthRMIImpl.NoUserSessionAvailable";
                    break;
                }
                default: {
                    string2 = string2 + "ClientAuthRMIImpl.UnknownException";
                }
            }
            throw new SMAPIException(UcInternationalizer.translateKey((Locale)this.locale, (String)string2));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SMAPIException(classNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            throw new SMAPIException(iOException.getMessage());
        }
    }

    private void authenticate(String string, String string2, String string3) throws SMAPIException {
        try {
            this.handle.authenticate(string, string2, string3);
        }
        catch (RMILoginException rMILoginException) {
            String string4 = "base.client.ClientApiMessages:";
            switch (rMILoginException.getReason()) {
                case 1: {
                    string4 = string4 + "ClientAuthRMIImpl.LoginRequestHasBeenRejected";
                    break;
                }
                case 2: {
                    string4 = string4 + "ClientAuthRMIImpl.LoginSecurityInformationIsUnavailable";
                    break;
                }
                case 3: {
                    string4 = string4 + "ClientAuthRMIImpl.LoginProcessingError";
                    break;
                }
                case 6: {
                    string4 = string4 + "ClientAuthRMIImpl.LoginUserOrPasswordError";
                    break;
                }
                case 7: {
                    string4 = string4 + "ClientAuthRMIImpl.LoginUserOrPasswordError";
                    break;
                }
                case 8: {
                    string4 = string4 + "ClientAuthRMIImpl.LoginUserOrPasswordError";
                    break;
                }
                case 5: {
                    string4 = string4 + "ClientAuthRMIImpl.LoginProcessingError";
                    break;
                }
                default: {
                    string4 = string4 + "ClientAuthRMIImpl.UnknownException";
                }
            }
            throw new SMAPIException(1, UcInternationalizer.translateKey((Locale)this.locale, (String)string4));
        }
        catch (RemoteException remoteException) {
            throw new SMAPIException(remoteException.getMessage());
        }
    }

    public SMRawDataRequest getRawDataRequest() {
        return new SMRawDataRequest(this.handle, this.locale);
    }
}

