/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.client;

import com.sun.symon.base.client.SMMessageI18nKey;
import com.sun.symon.base.utility.UcInternationalizer;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Locale;

public class SMAPIException
extends Exception {
    int reasonCode;
    String message = super.getMessage();
    String stackTrace;
    String detailedMessage = null;
    String messageI18nKey = null;

    public SMAPIException(int n, String string, Throwable throwable, SMMessageI18nKey sMMessageI18nKey) {
        super(string);
        this.reasonCode = n;
        if (sMMessageI18nKey != null) {
            this.messageI18nKey = sMMessageI18nKey.getKey();
            if (this.message == null || this.message.length() == 0) {
                this.message = UcInternationalizer.translateKey((Locale)Locale.getDefault(), (String)this.messageI18nKey);
            }
        }
        this.detailedMessage = this.message;
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        super.printStackTrace(printWriter);
        if (throwable != null) {
            printWriter.println("-----caused by-----");
            throwable.printStackTrace(printWriter);
            this.detailedMessage = this.detailedMessage + ": " + throwable.getMessage();
        }
        this.stackTrace = stringWriter.toString();
    }

    public SMAPIException(int n, String string, Throwable throwable) {
        this(n, string, throwable, null);
        this.setMessageI18nKey(throwable);
    }

    public SMAPIException(String string, Throwable throwable) {
        this(3, string, throwable, null);
        this.setMessageI18nKey(throwable);
    }

    public SMAPIException(String string, Throwable throwable, SMMessageI18nKey sMMessageI18nKey) {
        this(3, string, throwable, sMMessageI18nKey);
    }

    public SMAPIException(int n, String string) {
        this(n, string, null, null);
    }

    public SMAPIException(int n, String string, SMMessageI18nKey sMMessageI18nKey) {
        this(n, string, null, sMMessageI18nKey);
    }

    public SMAPIException(String string) {
        this(3, string, null, null);
    }

    public SMAPIException(String string, SMMessageI18nKey sMMessageI18nKey) {
        this(3, string, null, sMMessageI18nKey);
    }

    public SMAPIException(Throwable throwable) {
        this(3, throwable.getMessage(), throwable, null);
        this.setMessageI18nKey(throwable);
    }

    public SMAPIException(Throwable throwable, SMMessageI18nKey sMMessageI18nKey) {
        this(3, throwable.getMessage(), throwable, sMMessageI18nKey);
    }

    public SMAPIException(SMMessageI18nKey sMMessageI18nKey) {
        this(3, null, null, sMMessageI18nKey);
    }

    public int getReasonCode() {
        return this.reasonCode;
    }

    public void setMessageI18nKey(String string) {
        this.messageI18nKey = string;
    }

    public void setMessageI18nKey(SMMessageI18nKey sMMessageI18nKey) {
        this.messageI18nKey = sMMessageI18nKey.getKey();
    }

    public void setMessageI18nKey(Throwable throwable) {
        if (throwable != null && throwable instanceof SMAPIException) {
            this.messageI18nKey = ((SMAPIException)throwable).getMessageI18nKey();
        }
    }

    public String getMessage() {
        return this.message;
    }

    public String getMessage(Locale locale) {
        if (this.messageI18nKey != null) {
            return UcInternationalizer.translateKey((Locale)locale, (String)this.messageI18nKey);
        }
        return this.message;
    }

    public String getMessageI18nKey() {
        return this.messageI18nKey;
    }

    public String getDetailedMessage() {
        return this.detailedMessage;
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream printStream) {
        PrintStream printStream2 = printStream;
        synchronized (printStream2) {
            printStream.println(this.stackTrace);
        }
    }

    public void printStackTrace(PrintWriter printWriter) {
        PrintWriter printWriter2 = printWriter;
        synchronized (printWriter2) {
            printWriter.println(this.stackTrace);
        }
    }

    public Throwable fillInStackTrace() {
        super.fillInStackTrace();
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        super.printStackTrace(printWriter);
        printWriter.println("-----caused by-----");
        this.printStackTrace(printWriter);
        this.stackTrace = stringWriter.toString();
        return this;
    }

    public String toString() {
        if (this.detailedMessage == null) {
            return super.toString();
        }
        return this.detailedMessage;
    }
}

