proc metaLoadAll { source } {set listobject [locate $source]
set knownmodules [toe_send $listobject getValues]
foreach module $knownmodules {if { $module != "" } {if { [ catch { metaLoad $module } error] } {ddl print error "Error loading $module: $error\n"}}}
return [llength $knownmodules]}
proc metaLoad { module } {set moduleowner meta
set infoobject [locate .iso*agent.base.info.modules]
if { [ toe_csend allparams $infoobject editXFileGetFilter $module ] } {error "invalid module: $module"}
set parameters ""
foreach param [split $allparams "\n"] {if { [ regsub {^param:} $param "" newparam ] } {append parameters $newparam "\n"}}
import string _tmp $parameters
set modulename [lookup _tmp module]
undefine _tmp
set loadobject [locate .iso*mibman.modules]
if { ! [toe_send $loadobject isModuleLoaded $modulename $modulename] } {append parameters "instance = $modulename" "\n"
append parameters "instanceName = Metadata Repository" "\n"
append parameters "daqmode = metadata" "\n"
set pdu [bob create pdu]
bob set $pdu securityName $moduleowner
ddl print info "Loading module $module in metadata mode\n"
set result [toe_send $loadobject quickLoad $parameters $pdu]
bob destroy $pdu
ddl print info "Load status for $module: $result\n"}}
toe_send null {proc new_requires { type name args } {if { $type == "package" } {} elseif {$type == "class"} {toe_begin [locate .classes]
if { [ catch { lookup object $name } result ] } {set newobj "$name = { \[ use MANAGED-OBJECT \] }"
import string value $newobj}
toe_end} else {set command [concat [list "old_requires" $type $name] $args]
return [eval $command]}}}
toe_send null {proc new_source { args } {set result ""
set file [lindex $args 0]
set flag [lindex $args 1]
if { $flag == "" } {if { [ catch { old_source $file } result ] } {set result ""}} else {if { [ catch { old_source $file $flag } result ] } {set result ""}}
return $result}}
toe_send null {proc new_ruleFire { action ruleId { rowName "" } { rowIndex "" } { matchList "" } } {return ""}}
toe_send null {proc new_triggerActions { type subspec callback args } {if { [ catch { old_triggerActions $type $subspec $callback $args } result ] } {set result ""}
return $result}}
toe_send null {proc new_loadtemplate { name file } {global templates
if { [ catch { set templates($name) } ] } {set child [locate .templates.$name -create]
ddl print debug "loading template: $name\n"
set result [toe_send $child import interface value "file://localhost/$file;flags=ro" -slice action]
set templates($name) $result}}}
toe_send null {proc new_checkAccess { pdutype securityLevel securityName groups } {if { ![ catch { getDAQMode } result ] && $result == "metadata" } {return 1}
return [old_checkAccess $pdutype $securityLevel $securityName $groups]}}
toe_send null {proc new_checkAccessShadow { attr pdutype securityLevel name groups } {if { ![ catch { getDAQMode } result ] && $result == "metadata" } {return 1}
return [old_checkAccessShadow $attr $pdutype $securityLevel $name $groups]}}
method overridePackageLoader {} {toe_send null rename requires old_requires
toe_send null rename new_requires requires
toe_send null rename source old_source
toe_send null rename new_source source
toe_send null rename loadtemplate old_loadtemplate
toe_send null rename new_loadtemplate loadtemplate
toe_send null rename ruleFire old_ruleFire
toe_send null rename new_ruleFire ruleFire
toe_send null rename triggerActions old_triggerActions
toe_send null rename new_triggerActions triggerActions
toe_send null rename _checkAccess old_checkAccess
toe_send null rename new_checkAccess _checkAccess
toe_send null rename _checkAccessShadow old_checkAccessShadow
toe_send null rename new_checkAccessShadow _checkAccessShadow}
method resetPackageLoader {} {toe_send null rename requires new_requires
toe_send null rename old_requires requires
toe_send null rename source new_source
toe_send null rename old_source source
toe_send null rename loadtemplate new_loadtemplate
toe_send null rename old_loadtemplate loadtemplate
toe_send null rename ruleFire new_ruleFire
toe_send null rename old_ruleFire ruleFire
toe_send null rename triggerActions new_triggerActions
toe_send null rename old_triggerActions triggerActions
toe_send null rename _checkAccess new_checkAccess
toe_send null rename old_checkAccess _checkAccess
toe_send null rename _checkAccessShadow new_checkAccessShadow
toe_send null rename old_checkAccessShadow _checkAccessShadow}
