/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.tools.discovery.console.presentation;

import com.sun.symon.tools.discovery.console.presentation.DiscoverGUIException;
import com.sun.symon.tools.discovery.console.presentation.DiscoverPanel;
import com.sun.symon.tools.discovery.console.presentation.RequestTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.Vector;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class RequestTable
extends JTable
implements TableCellRenderer {
    private RequestTableModel model;
    private DiscoverPanel parent;
    private DefaultListSelectionModel oListModel_;
    private boolean bRowSelectionHasChanged_ = false;
    private boolean bDelete_ = false;
    private Font labelFont = null;
    private Color selectionBackground = this.getSelectionBackground();
    private Color selectionForeground = this.getSelectionForeground();
    private Color labelBackground = Color.white;
    private Color labelForeground = Color.black;
    private JLabel cellLabel = new JLabel(" ");

    public RequestTable(DiscoverPanel discoverPanel, String[] stringArray, boolean[] blArray) throws DiscoverGUIException {
        this.parent = discoverPanel;
        this.model = new RequestTableModel(discoverPanel, stringArray, blArray);
        this.oListModel_ = new DefaultListSelectionModel();
        this.oListModel_.setSelectionMode(0);
    }

    public void init() {
        this.setAutoCreateColumnsFromModel(false);
        this.setRowSelectionAllowed(true);
        this.setColumnSelectionAllowed(false);
        this.setSelectionModel(this.oListModel_);
        this.setModel(this.model);
        int n = 0;
        while (n < this.model.getColumnCount()) {
            if (this.model.isColumnVisible(n)) {
                TableColumn tableColumn = new TableColumn(n);
                tableColumn.setCellRenderer(this);
                tableColumn.setResizable(false);
                this.addColumn(tableColumn);
            }
            ++n;
        }
        this.selectionBackground = this.getSelectionBackground();
        this.selectionForeground = this.getSelectionForeground();
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        JLabel jLabel = this.cellLabel;
        if (object instanceof String) {
            jLabel.setText((String)object);
            if (this.isRowSelected(n)) {
                ((Component)jLabel).setBackground(this.selectionBackground);
                ((Component)jLabel).setForeground(this.selectionForeground);
            } else {
                ((Component)jLabel).setBackground(this.labelBackground);
                ((Component)jLabel).setForeground(this.labelForeground);
            }
            if (this.labelFont == null) {
                ((Component)jLabel).setFont(this.getFont());
            } else {
                ((Component)jLabel).setFont(this.labelFont);
            }
            jLabel.setOpaque(true);
            jLabel.setHorizontalAlignment(0);
        } else {
            jLabel.setText(" ");
            jLabel.setOpaque(true);
            ((Component)jLabel).setBackground(this.labelBackground);
            ((Component)jLabel).setForeground(this.labelForeground);
        }
        return jLabel;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.parent == null) {
            return;
        }
        this.bRowSelectionHasChanged_ = listSelectionEvent.getValueIsAdjusting() || listSelectionEvent.getFirstIndex() != listSelectionEvent.getLastIndex();
        int n = this.getSelectedRow();
        if (n < 0 || n >= this.model.getRealRowCount()) {
            this.parent.informRowSelected(-1);
        } else {
            this.parent.informRowSelected(n);
        }
        this.repaint();
    }

    public int getSelectedRow() {
        return this.oListModel_.getLeadSelectionIndex();
    }

    public boolean isRowSelected(int n) {
        return this.oListModel_.getLeadSelectionIndex() == n;
    }

    public boolean rowSelectionHasChanged() {
        return this.bRowSelectionHasChanged_;
    }

    public void setRequestList(Vector vector) {
        this.setRequestList(vector, false);
    }

    public void setRequestList(Vector vector, boolean bl) {
        int n = this.model.getRealRowCount();
        this.model.setRequestList(vector);
        int n2 = this.oListModel_.getLeadSelectionIndex();
        if (!bl) {
            this.bDelete_ = this.model.getRealRowCount() > vector.size();
        }
        TableModelEvent tableModelEvent = new TableModelEvent(this.model);
        this.tableChanged(tableModelEvent);
        if (this.bDelete_) {
            this.clearSelection();
        } else {
            this.oListModel_.setLeadSelectionIndex(n2);
        }
        if (bl && this.bDelete_) {
            this.bDelete_ = false;
        }
    }

    public void setLabelBackground(Color color) {
        this.labelBackground = color;
    }

    public void setLabelForeground(Color color) {
        this.labelForeground = color;
    }

    public void setLabelFont(Font font) {
        this.labelFont = font;
    }
}

