/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.views.graph;

import com.sun.symon.base.console.views.graph.CvGraphFormat;
import com.sun.symon.base.utility.UcDDL;
import java.awt.Font;

public class CvGraphLegendFormat {
    protected static final String DEFAULT_ORIENTATION = "vertical";
    protected static final String DEFAULT_POSITION = "south";
    private String orientation = "vertical";
    private String position = "south";
    private String fontStyle = "plain";
    private String fontName = "Serif";
    private int fontSize = 10;
    private String borderType = "none";
    private int borderWidth = 2;
    private boolean showLegend = true;

    public String getConfiguration() {
        return "Legend^" + this.showLegend + "^" + this.fontStyle + "^" + this.fontName + "^" + new Integer(this.fontSize).toString() + "^" + this.position + "^" + this.borderType + "^" + new Integer(this.borderWidth).toString();
    }

    public String getOrientation() {
        return this.orientation;
    }

    public int getOrientationNumber() {
        return CvGraphFormat.getDirectionNumber(this.orientation);
    }

    public String getPosition() {
        return this.position;
    }

    public int getPositionNumber() {
        return CvGraphFormat.getPositionNumber(this.position);
    }

    public Font getLegendFont() {
        return new Font(this.fontName, CvGraphFormat.getFontStyleNumber(this.fontStyle), this.fontSize);
    }

    public String getBorderType() {
        return this.borderType;
    }

    public int getBorderTypeNumber() {
        return CvGraphFormat.getBorderTypeNumber(this.borderType);
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public void setConfiguration(String string) {
        if (string == null) {
            return;
        }
        String[] stringArray = CvGraphFormat.splitString(string, "^");
        if (stringArray.length != 8) {
            UcDDL.logDebugMessage((String)("CvGraphLegendFormat::setConfiguration - invalid number of parameters '" + string + "'"));
            return;
        }
        if (!stringArray[0].equals("Legend")) {
            UcDDL.logDebugMessage((String)("CvGraphLegendFormat::setConfiguration - invalid format keyword '" + stringArray[0] + "'"));
            return;
        }
        this.showLegend = Boolean.valueOf(stringArray[1]);
        this.fontStyle = stringArray[2];
        this.fontName = stringArray[3];
        this.position = stringArray[5];
        this.borderType = stringArray[6];
        try {
            this.fontSize = new Integer(stringArray[4]);
            this.borderWidth = new Integer(stringArray[7]);
        }
        catch (NumberFormatException numberFormatException) {
            UcDDL.logDebugMessage((String)("CvGraphTitleFromat::setConfiguration --  cannot convert strings " + stringArray[4] + " and " + stringArray[7] + " to integers "));
        }
    }

    public void setShowLegend(boolean bl) {
        this.showLegend = bl;
    }

    public boolean getShowLegend() {
        return this.showLegend;
    }

    public void setOrientation(String string) {
        this.orientation = string != null ? string : DEFAULT_ORIENTATION;
    }
}

