/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.views.alarmcount;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.SMRawDataResponse;
import com.sun.symon.base.client.SMRequestStatus;
import com.sun.symon.base.client.alarm.SMAlarmStatusRequest;
import com.sun.symon.base.console.awx.AwxServiceManager;
import com.sun.symon.base.console.awx.AwxServiceProvider;
import com.sun.symon.base.console.views.CvContextPopupListener;
import com.sun.symon.base.console.views.CvNavigationListener;
import com.sun.symon.base.console.views.CvPresentationView;
import com.sun.symon.base.console.views.alarmcount.CvStatusLabel;
import com.sun.symon.base.server.types.StObject;
import com.sun.symon.base.utility.UcDDL;
import com.sun.symon.base.utility.UcInternationalizer;
import com.sun.symon.base.utility.UcListUtil;
import java.awt.Font;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class CvAlarmCountView
extends JPanel
implements CvPresentationView,
AwxServiceManager,
SMRawDataResponse,
ActionListener {
    private AwxServiceProvider svcProvider = null;
    private SMRawDataRequest source = null;
    private String url = null;
    private String refreshPeriod = "120";
    private Object dataRequest = null;
    private CvStatusLabel[] labels = new CvStatusLabel[]{null, null, null, null, null};
    private String[] exStatus = new String[]{"DWN", "ERR", "WRN", "INF", "OFF"};
    private boolean gotTimeout = false;
    private String[] alarmSeverities = new String[]{"downs", "criticals", "alerts", "cautions", "off"};

    public CvAlarmCountView() {
        this.setLayout(new BoxLayout(this, 0));
        int n = 0;
        while (n < this.labels.length) {
            Image image = SMAlarmStatusRequest.getStatusOverlay((String)this.exStatus[n], (boolean)false);
            if (image != null) {
                this.labels[n] = new CvStatusLabel("-", new ImageIcon(image));
                this.labels[n].addActionListener(this);
                this.add(this.labels[n]);
            }
            ++n;
        }
        this.validate();
    }

    public void setEnabled(boolean bl) {
        int n = 0;
        while (n < this.labels.length) {
            if (this.labels[n] != null) {
                this.labels[n].setEnabled(bl);
            }
            ++n;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String[] stringArray = new String[1];
        int n = 0;
        while (n < this.alarmSeverities.length) {
            if ((CvStatusLabel)actionEvent.getSource() == this.labels[n]) {
                stringArray[0] = "alarmSeverity=" + this.alarmSeverities[n];
                break;
            }
            ++n;
        }
        if (this.svcProvider != null) {
            this.svcProvider.triggerService("countSelect", stringArray);
        }
    }

    public void addCvContextPopupListener(CvContextPopupListener cvContextPopupListener) {
    }

    public void addCvNavigationListener(CvNavigationListener cvNavigationListener) {
    }

    private void changeData(SMRawDataRequest sMRawDataRequest, String string) {
        if (this.dataRequest != null && this.source != null) {
            this.shutdown();
        }
        this.source = sMRawDataRequest;
        this.url = string;
        if (sMRawDataRequest != null && string != null) {
            String[] stringArray = new String[]{SMRawDataRequest.buildShadowURL((String)string, (String)"statussummary", null)};
            try {
                this.dataRequest = sMRawDataRequest.getURLValue(stringArray, this.refreshPeriod, (SMRawDataResponse)this, null);
            }
            catch (SMAPIException sMAPIException) {
                UcDDL.logErrorMessage((String)"alarm count", (Throwable)sMAPIException);
            }
        }
    }

    public void getURLResponse(SMRequestStatus sMRequestStatus, StObject[][] stObjectArray, Object object) {
        String string;
        Vector vector = new Vector();
        if (sMRequestStatus.getReturnCode() == 4) {
            if (!this.gotTimeout) {
                this.gotTimeout = true;
            } else {
                this.source.launchTimeoutNotification("topology");
            }
        }
        if (sMRequestStatus.getReturnCode() != 0 || stObjectArray.length != 1 || stObjectArray[0].length != 1 || !UcListUtil.decomposeList((String)stObjectArray[0][0].toString(), vector) || vector.size() != 9) {
            String string2 = this.translate("alarmcounts.fail");
            int n = 0;
            while (n < this.labels.length) {
                this.labels[n].updateText("-");
                this.labels[n].setToolTipText(string2);
                ++n;
            }
            return;
        }
        this.gotTimeout = false;
        String string3 = (String)vector.elementAt(1);
        this.labels[0].updateText(string3);
        this.labels[0].setToolTipText(this.translate("alarmcounts.prefix") + this.translate("alarmcounts.down"));
        String string4 = (String)vector.elementAt(2);
        this.labels[1].updateText(string4);
        this.labels[1].setToolTipText(this.translate("alarmcounts.prefix") + this.translate("alarmcounts.critical"));
        String string5 = (String)vector.elementAt(3);
        this.labels[2].updateText(string5);
        this.labels[2].setToolTipText(this.translate("alarmcounts.prefix") + this.translate("alarmcounts.alert"));
        String string6 = (String)vector.elementAt(4);
        this.labels[3].updateText(string6);
        this.labels[3].setToolTipText(this.translate("alarmcounts.prefix") + this.translate("alarmcounts.caution"));
        int n = 0;
        try {
            string = (String)vector.elementAt(6);
            n += Integer.parseInt(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            string = (String)vector.elementAt(7);
            n += Integer.parseInt(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.labels[4].updateText("" + n);
        this.labels[4].setToolTipText(this.translate("alarmcounts.prefix") + this.translate("alarmcounts.off"));
        this.repaint();
    }

    public void registerServiceProvider(AwxServiceProvider awxServiceProvider) {
        this.svcProvider = awxServiceProvider;
    }

    public void removeCvContextPopupListener(CvContextPopupListener cvContextPopupListener) {
    }

    public void removeCvNavigationListener(CvNavigationListener cvNavigationListener) {
    }

    public void setDataSource(SMRawDataRequest sMRawDataRequest) {
        this.changeData(sMRawDataRequest, this.url);
    }

    public void setFont(Font font) {
        if (this.labels == null) {
            return;
        }
        int n = 0;
        while (n < this.labels.length) {
            if (this.labels[n] != null) {
                this.labels[n].setFont(font);
            }
            ++n;
        }
    }

    public void setManagedObjectUrl(String string) {
        this.changeData(this.source, string);
    }

    public void setStdRefreshPeriod(String string) {
        this.refreshPeriod = string == null ? "120" : string;
    }

    public void getURLResponse(SMRequestStatus sMRequestStatus, Vector vector, Object object) {
    }

    public void setURLResponse(SMRequestStatus sMRequestStatus, StObject[][] stObjectArray, Object object) {
    }

    public void setURLResponse(SMRequestStatus sMRequestStatus, Vector vector, Object object) {
    }

    public void shutdown() {
        try {
            this.source.removeURLRequest(this.dataRequest);
        }
        catch (SMAPIException sMAPIException) {
            // empty catch block
        }
    }

    public String translate(String string) {
        return UcInternationalizer.translateKey((String)("base.console.ConsoleGeneric:" + string));
    }
}

