/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.tools.editor;

import com.sun.symon.base.console.tools.editor.CommonTimex;
import com.sun.symon.base.console.tools.editor.ComparisonCombos;
import com.sun.symon.base.console.tools.editor.CtArrowsCombo;
import com.sun.symon.base.console.tools.editor.CtMarginPanel;
import com.sun.symon.base.console.tools.editor.CtTimexEditor;
import com.sun.symon.base.console.tools.editor.Operators;
import com.sun.symon.base.console.tools.editor.RootPanel;
import com.sun.symon.base.utility.UcDDL;
import com.sun.symon.base.utility.UcInternationalizer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;

class ComparisonTimex
extends CommonTimex
implements PropertyChangeListener {
    private RootPanel center = new RootPanel(new Insets(15, 5, 15, 5));
    private CtMarginPanel bottom = new CtMarginPanel(new Insets(8, 5, 2, 5));
    private CtMarginPanel top = new CtMarginPanel(new Insets(5, 5, 5, 5));
    private JLabel text = new JLabel("");
    private JComboBox variables = new JComboBox();
    private Operators operators;
    private JComponent values;
    private JComboBox dfw;
    private JComboBox wfy;
    private JComboBox second;
    private JComboBox minute;
    private JComboBox hour;
    private JComboBox day;
    private JComboBox wfm;
    private JComboBox month;
    private JComboBox year;
    private CtArrowsCombo date;
    private CtArrowsCombo time;
    private ComparisonCombos basic;
    private Calendar calendar = new GregorianCalendar();
    boolean isLessThan = false;
    boolean isGreaterThan = false;
    boolean isFirstValue = false;
    boolean isLastValue = false;
    boolean isDateCombo = false;

    public ComparisonTimex(String[] stringArray) {
        this.basic = new ComparisonCombos(stringArray);
        this.operators = new Operators();
        this.setLayout(new BorderLayout());
        this.variables.addItem(UcInternationalizer.translateKey((String)"base.console.tools.editor.TimexLabels:time"));
        this.variables.addItem(UcInternationalizer.translateKey((String)"base.console.tools.editor.TimexLabels:day_of_week"));
        this.variables.addItem(UcInternationalizer.translateKey((String)"base.console.tools.editor.TimexLabels:week_of_year"));
        this.variables.addItem(UcInternationalizer.translateKey((String)"base.console.tools.editor.TimexLabels:hour"));
        this.variables.addItem(UcInternationalizer.translateKey((String)"base.console.tools.editor.TimexLabels:day_of_month"));
        this.variables.addItem(UcInternationalizer.translateKey((String)"base.console.tools.editor.TimexLabels:week_of_month"));
        this.variables.addItem(UcInternationalizer.translateKey((String)"base.console.tools.editor.TimexLabels:month"));
        this.variables.addItem(UcInternationalizer.translateKey((String)"base.console.tools.editor.TimexLabels:year"));
        this.variables.addItem(UcInternationalizer.translateKey((String)"base.console.tools.editor.TimexLabels:date"));
        this.dfw = this.basic.getDFWCombo();
        this.wfy = this.basic.getWFYCombo();
        this.hour = this.basic.getHourCombo();
        this.day = this.basic.getDayCombo();
        this.wfm = this.basic.getWFMCombo();
        this.month = this.basic.getMonthCombo();
        this.year = this.basic.getYearCombo();
        this.date = this.basic.getDateCombo();
        this.time = this.basic.getTimeCombo();
        this.dfw.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                ComparisonTimex.this.updateTimex();
            }
        });
        this.wfy.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                ComparisonTimex.this.updateTimex();
            }
        });
        this.hour.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                ComparisonTimex.this.updateTimex();
            }
        });
        this.day.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                ComparisonTimex.this.updateTimex();
            }
        });
        this.wfm.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                ComparisonTimex.this.updateTimex();
            }
        });
        this.month.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                ComparisonTimex.this.updateTimex();
            }
        });
        this.year.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                ComparisonTimex.this.updateTimex();
            }
        });
        this.date.addPropertyChangeListener(this);
        this.time.addPropertyChangeListener(this);
        int n = this.calendar.get(2);
        int n2 = this.calendar.get(5) - 1;
        int n3 = 0;
        int n4 = this.calendar.get(11);
        int n5 = this.calendar.get(7) - 1;
        int n6 = this.calendar.get(3) - 1;
        int n7 = this.calendar.get(4) - 1;
        if (stringArray != null) {
            UcDDL.logDebugMessage((String)"Agent time");
            try {
                n = new Integer(stringArray[3]) - 1;
                n2 = new Integer(stringArray[4]) - 1;
                n4 = new Integer(stringArray[6]);
                n5 = new Integer(stringArray[5]);
                n6 = new Integer(stringArray[9]);
                n7 = new Integer(stringArray[10]) - 1;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.dfw.setSelectedIndex(n5 == -1 ? 0 : n5);
        this.hour.setSelectedIndex(n4 == -1 ? 0 : n4);
        this.day.setSelectedIndex(n2 == -1 ? 0 : n2);
        this.month.setSelectedIndex(n == -1 ? 0 : n);
        this.year.setSelectedIndex(n3 == -1 ? 0 : n3);
        this.wfy.setSelectedIndex(n6 == -1 ? 0 : n6);
        this.wfm.setSelectedIndex(n7 == -1 ? 0 : n7);
        this.values = this.time;
        this.text.setText(this.getCurrentTimex());
        this.text.setFont(new JTextField("").getFont());
        this.text.setForeground(Color.black);
        CtTimexEditor.addTimezoneInfo(this.top, stringArray);
        this.add("North", this.top);
        this.add("South", this.bottom);
        this.add("Center", this.center);
        this.center.add(this.variables);
        this.center.add(this.operators);
        this.center.add(this.values);
        this.center.setBorder(BorderFactory.createTitledBorder(UcInternationalizer.translateKey((String)"base.console.tools.editor.TimexLabels:comparisontitle")));
        this.variables.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                ComparisonTimex.this.variableChanged();
            }
        });
        this.operators.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                ComparisonTimex.this.operatorChanged();
            }
        });
        this.bottom.setLayout(new BoxLayout(this.bottom, 0));
        this.bottom.add(new JLabel(UcInternationalizer.translateKey((String)"base.console.tools.editor.TimexLabels:currentSE") + "   "));
        this.bottom.add(this.text);
    }

    public void updateTimex() {
        this.text.setText(this.getCurrentTimex());
        this.text.invalidate();
        this.text.validate();
        this.text.repaint();
        this.validate();
        this.repaint();
    }

    public String getCurrentText() {
        return this.text.getText();
    }

    public String getCurrentTimex() {
        int n;
        String string = "";
        String string2 = "";
        int n2 = this.variables.getSelectedIndex();
        if (n2 == 0) {
            string2 = "Time";
            string = this.time.getComboValue();
            if (this.time.isFirst()) {
                this.isFirstValue = true;
                this.isLastValue = false;
            } else if (this.time.isLast()) {
                this.isLastValue = true;
                this.isFirstValue = false;
            } else {
                this.isLastValue = false;
                this.isFirstValue = false;
            }
            this.isDateCombo = false;
        } else if (n2 == 1) {
            string2 = "Day_of_week";
            n = this.dfw.getSelectedIndex();
            if (n == 0) {
                string = "Sunday";
            } else if (n == 1) {
                string = "Monday";
            } else if (n == 2) {
                string = "Tuesday";
            } else if (n == 3) {
                string = "Wednesday";
            } else if (n == 4) {
                string = "Thursday";
            } else if (n == 5) {
                string = "Friday";
            } else if (n == 6) {
                string = "Saturday";
            }
        } else if (n2 == 2) {
            string2 = "Week_of_year";
            string = (String)this.wfy.getSelectedItem();
        } else if (n2 == 3) {
            string2 = "Hour";
            string = (String)this.hour.getSelectedItem();
        } else if (n2 == 4) {
            string2 = "Day_of_month";
            string = (String)this.day.getSelectedItem();
        } else if (n2 == 5) {
            string2 = "Week_of_month";
            string = (String)this.wfm.getSelectedItem();
        } else if (n2 == 6) {
            string2 = "Month";
            n = this.month.getSelectedIndex();
            if (n == 0) {
                string = "January";
            } else if (n == 1) {
                string = "February";
            } else if (n == 2) {
                string = "March";
            } else if (n == 3) {
                string = "April";
            } else if (n == 4) {
                string = "May";
            } else if (n == 5) {
                string = "June";
            } else if (n == 6) {
                string = "July";
            } else if (n == 7) {
                string = "August";
            } else if (n == 8) {
                string = "September";
            } else if (n == 9) {
                string = "October";
            } else if (n == 10) {
                string = "November";
            } else if (n == 11) {
                string = "December";
            }
        } else if (n2 == 7) {
            string2 = "Year";
            string = (String)this.year.getSelectedItem();
        } else if (n2 == 8) {
            string2 = "Date";
            string = this.basic.getEnglishDate();
            if (this.basic.getTimeAndDate().isToday()) {
                this.isFirstValue = true;
            } else if (this.date.isLast()) {
                this.isLastValue = true;
            } else {
                this.isLastValue = false;
                this.isFirstValue = false;
            }
            this.isDateCombo = true;
        }
        if (this.values instanceof JComboBox) {
            n = ((JComboBox)this.values).getSelectedIndex();
            int n3 = ((JComboBox)this.values).getItemCount();
            if (n == 0) {
                this.isFirstValue = true;
                this.isLastValue = false;
            } else if (n == n3 - 1) {
                this.isLastValue = true;
                this.isFirstValue = false;
            } else {
                this.isLastValue = false;
                this.isFirstValue = false;
            }
            this.isDateCombo = false;
        }
        return string2 + " " + this.operators.getSelectedItem() + " " + string;
    }

    public int checkTimex() {
        if (this.isDateCombo) {
            if (!this.basic.getTimeAndDate().isValidDate()) {
                return -2;
            }
            if (this.basic.getTimeAndDate().earlierThanToday()) {
                return -1;
            }
            if (this.isLessThan && this.isFirstValue || this.isGreaterThan && this.isLastValue) {
                return 0;
            }
            return 1;
        }
        if (this.isLessThan && this.isFirstValue || this.isGreaterThan && this.isLastValue) {
            return 0;
        }
        return 1;
    }

    public void setErrorMesg(String string) {
        this.text.setText(string);
        this.text.invalidate();
        this.text.validate();
        this.text.repaint();
        this.validate();
        this.repaint();
    }

    public Insets getInsets() {
        return new Insets(15, 15, 15, 15);
    }

    public void variableChanged() {
        this.center.remove(this.values);
        int n = this.variables.getSelectedIndex();
        if (n == 1) {
            this.values = this.dfw;
            this.center.add(this.values);
        } else if (n == 2) {
            this.values = this.wfy;
            this.center.add(this.values);
        } else if (n == 3) {
            this.values = this.hour;
            this.center.add(this.values);
        } else if (n == 4) {
            this.values = this.day;
            this.center.add(this.values);
        } else if (n == 5) {
            this.values = this.wfm;
            this.center.add(this.values);
        } else if (n == 6) {
            this.values = this.month;
            this.center.add(this.values);
        } else if (n == 7) {
            this.values = this.year;
            this.center.add(this.values);
        } else if (n == 8) {
            this.values = this.date;
            this.center.add(this.values);
        } else if (n == 0) {
            this.values = this.time;
            this.center.add(this.values);
        }
        this.updateTimex();
        if (n != 0 && n != 8) {
            this.center.setInsets(new Insets(24, 5, 15, 5));
        } else {
            this.center.setInsets(new Insets(14, 5, 15, 5));
        }
        this.validate();
        this.repaint();
    }

    public void operatorChanged() {
        String string = (String)this.operators.getSelectedItem();
        if (string.equals("<")) {
            this.isLessThan = true;
            this.isGreaterThan = false;
        } else if (string.equals(">")) {
            this.isGreaterThan = true;
            this.isLessThan = false;
        } else {
            this.isGreaterThan = false;
            this.isLessThan = false;
        }
        this.updateTimex();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.updateTimex();
    }
}

