/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.services.logger;

import com.sun.symon.base.console.services.logger.CsDDLBuffer;
import com.sun.symon.base.console.services.logger.CsDDLBufferListener;
import com.sun.symon.base.utility.UcDialog;
import com.sun.symon.base.utility.UcInternationalizer;
import java.awt.Window;
import java.io.File;
import java.io.FileWriter;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class CsDDLBufferViewer
extends JScrollPane
implements CsDDLBufferListener {
    private String LineSeparator = System.getProperty("line.separator");
    private JTextArea MyText = new JTextArea();
    private CsDDLBuffer MyBuffer;
    private static String BaseDir = "/tmp";

    public CsDDLBufferViewer() {
        this.getViewport().add(this.MyText);
        this.MyText.setEditable(false);
        this.MyText.setColumns(80);
    }

    public void clearBuffer() {
        if (this.MyBuffer != null) {
            this.MyBuffer.LogInfoLength = 0;
        }
        if (this.MyText != null) {
            this.MyText.setText("");
        }
    }

    public void disconnect() {
        if (this.MyBuffer != null) {
            this.MyBuffer.removeCsDDLBufferListener(this);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void saveBuffer() {
        if (this.MyText == null) {
            return;
        }
        Window window = SwingUtilities.windowForComponent(this.MyText);
        if (!(window instanceof JFrame)) {
            return;
        }
        String string = UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:diag.save.title");
        JFileChooser jFileChooser = new JFileChooser(BaseDir);
        jFileChooser.setDialogTitle(string);
        jFileChooser.showSaveDialog((JFrame)window);
        if (jFileChooser.getSelectedFile() == null) {
            return;
        }
        String string2 = jFileChooser.getSelectedFile().getName();
        if (string2.trim().length() == 0) {
            return;
        }
        string2 = jFileChooser.getCurrentDirectory() + "/" + string2;
        File file = new File(string2);
        if (file.exists()) {
            String string3 = "base.console.ConsoleGeneric:standard.fileexists(" + string2 + ")";
            int n = UcDialog.showOkCancel((String)(UcInternationalizer.translateKey((String)string3) + " " + UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:standard.fileoverwrite")));
            if (n != 0) return;
            this.saveMessage(file, window);
            return;
        } else {
            this.saveMessage(file, window);
        }
    }

    public void saveMessage(File file, Window window) {
        try {
            FileWriter fileWriter = new FileWriter(file);
            String string = this.MyText.getText();
            fileWriter.write(string, 0, string.length());
            fileWriter.close();
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception.getMessage());
            Object[] objectArray = new String[]{UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:message.ok")};
            JOptionPane.showOptionDialog(window, UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:diag.saverr.text"), UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:diag.saverr.title"), -1, 0, null, objectArray, objectArray[0]);
        }
    }

    public void setDDLBuffer(Object object) {
        this.MyBuffer = (CsDDLBuffer)object;
        this.MyBuffer.addCsDDLBufferListener(this);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.MyBuffer.LogInfoLength) {
            stringBuffer.append(this.MyBuffer.LogInfo[n]);
            stringBuffer.append(this.LineSeparator);
            ++n;
        }
        if (this.MyText != null) {
            this.MyText.setText(stringBuffer.toString());
        }
    }

    public void sendLine(String string, int n) {
        if (this.MyText != null) {
            this.MyText.append(string + this.LineSeparator);
        }
    }
}

