/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.grouping.aggregate;

import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.service.SMLengthException;
import com.sun.symon.base.client.task.SMTask;
import com.sun.symon.base.client.task.SMTaskEditor;
import com.sun.symon.base.client.task.SMTaskEditorManager;
import com.sun.symon.base.client.task.SMTaskEditorManagerEx;
import com.sun.symon.base.client.task.SMTaskOperationData;
import com.sun.symon.base.console.grouping.CgUtility;
import com.sun.symon.base.console.grouping.aggregate.CgPropertyChooser;
import com.sun.symon.base.console.grouping.aggregate.CgTableInfo;
import com.sun.symon.base.console.grouping.aggregate.CgTableRequest;
import com.sun.symon.base.console.grouping.aggregate.CgUpdateRowChooser;
import com.sun.symon.base.console.grouping.table.CgComboBox;
import com.sun.symon.base.console.grouping.table.CgData;
import com.sun.symon.base.console.grouping.table.CgTblColumnFormat;
import com.sun.symon.base.console.grouping.table.CgTblPane;
import com.sun.symon.base.console.grouping.table.CgTblSelectEvent;
import com.sun.symon.base.console.grouping.table.CgTblSelectListener;
import com.sun.symon.base.utility.UcCommon;
import com.sun.symon.base.utility.UcDDL;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class CgTableTaskEditor
extends JPanel
implements SMTaskEditor {
    private static String ADD_ROW_ACTION = "add_row";
    private static String EDIT_ROW_ACTION = "modify_row";
    private static String DELETE_ROW_ACTION = "delete_row";
    private static String AUX_ROW_ACTION = "aux";
    private static String END_ACTION = "end";
    private GridBagLayout gridBagLayout_ = new GridBagLayout();
    private SMRawDataRequest handle_;
    private SMTaskEditorManagerEx taskManager_;
    private Frame parentFrame_;
    private CgTblPane tablePanel_ = new CgTblPane();
    private JButton deleteEntryButton_ = new JButton();
    private CgPropertyChooser pc_;
    private TableManager tm_ = new TableManager();
    private JButton selectButton_ = new JButton();
    private JLabel selectActionLabel_ = new JLabel();
    private CgComboBox selectAction_ = new CgComboBox();
    private CgComboBox moduleTableCombo_ = new CgComboBox();
    private JLabel moduleTable_ = new JLabel();
    private boolean editing_ = true;

    public CgTableTaskEditor() {
        this(null, null, null, false);
    }

    public CgTableTaskEditor(SMTaskEditorManager sMTaskEditorManager, SMTask sMTask, SMRawDataRequest sMRawDataRequest, boolean bl) {
        this.handle_ = sMRawDataRequest;
        this.taskManager_ = (SMTaskEditorManagerEx)sMTaskEditorManager;
        if (this.taskManager_ instanceof Frame) {
            this.parentFrame_ = (Frame)this.taskManager_;
        }
        CgTblColumnFormat[] cgTblColumnFormatArray = new CgTblColumnFormat[]{new CgTblColumnFormat(CgUtility.getI18nMsg("table.tableName"), false, null), new CgTblColumnFormat(CgUtility.getI18nMsg("table.selectTableAction"), false, null), new CgTblColumnFormat(CgUtility.getI18nMsg("table.index"), false, null)};
        this.tablePanel_ = new CgTblPane(cgTblColumnFormatArray, false);
        this.selectAction_ = new CgComboBox(new CgData[]{new CgData(CgUtility.getI18nMsg("table.addRow"), null, ADD_ROW_ACTION), new CgData(CgUtility.getI18nMsg("table.editRow"), null, EDIT_ROW_ACTION), new CgData(CgUtility.getI18nMsg("table.deleteRow"), null, DELETE_ROW_ACTION)});
        this.selectAction_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!CgTableTaskEditor.this.editing_) {
                    return;
                }
                int n = CgTableTaskEditor.this.tablePanel_.getSelectedRow();
                int n2 = CgTableTaskEditor.this.tablePanel_.getRowCount();
                if (n < 0 || n2 <= 0 || n + 1 > n2 || n + 1 > CgTableTaskEditor.this.tm_.size()) {
                    return;
                }
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                CgData cgData = (CgData)jComboBox.getSelectedItem();
                if (cgData == null) {
                    return;
                }
                String string = (String)cgData.getUserData();
                Table table = (Table)CgTableTaskEditor.this.tm_.get(n);
                table.setRowAction(string);
                if (string.equals("")) {
                    CgTableTaskEditor.this.tablePanel_.setValueAt(new CgData(string, null, string), n, 1);
                } else {
                    CgTableTaskEditor.this.tablePanel_.setValueAt(new CgData(CgUtility.getI18nMsg(CgTableTaskEditor.this.rowActionToKey(string)), null, string), n, 1);
                }
                CgTableTaskEditor.this.tablePanel_.setValueAt(new CgData(""), n, 2);
                CgTableTaskEditor.this.taskManager_.setModified(true);
                CgTableTaskEditor.this.doRowAction();
            }
        });
        this.tablePanel_.setShowConfirmForRow(false);
        Vector<CgData> vector = new Vector<CgData>();
        vector.add(new CgData(""));
        vector.add(new CgData(""));
        vector.add(new CgData(""));
        this.tablePanel_.addRow(vector);
        this.tablePanel_.setShowConfirmForRow(false);
        this.tablePanel_.addCgTblSelectListener(new CgTblSelectListener(){

            public void selectionOccurred(CgTblSelectEvent cgTblSelectEvent) {
                CgTableTaskEditor.this.tableRowSelected(cgTblSelectEvent);
            }
        });
        TableRender tableRender = new TableRender();
        this.tablePanel_.getTable().setColumnSelectionAllowed(false);
        this.tablePanel_.getTable().getColumnModel().getColumn(0).setCellRenderer(tableRender);
        this.tablePanel_.getTable().getColumnModel().getColumn(1).setCellRenderer(tableRender);
        this.tablePanel_.getTable().getColumnModel().getColumn(2).setCellRenderer(tableRender);
        this.tablePanel_.getTable().getColumnModel().getColumn(0).setPreferredWidth(500);
        this.tablePanel_.getTable().getColumnModel().getColumn(1).setPreferredWidth(150);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.localize();
        this.selectAction_.setEnabled(false);
        this.moduleTableCombo_.setEnabled(false);
        this.tablePanel_.setRowSelectionInterval(0, 0);
        this.enableButtons();
        this.setVisible(true);
        this.getTableInfo();
    }

    private String rowActionToKey(String string) {
        if (string.equals(ADD_ROW_ACTION)) {
            return "table.addRow";
        }
        if (string.equals(EDIT_ROW_ACTION)) {
            return "table.editRow";
        }
        if (string.equals(DELETE_ROW_ACTION)) {
            return "table.deleteRow";
        }
        return string;
    }

    public void setOperationData(SMTaskOperationData[] sMTaskOperationDataArray) {
        int n = this.tablePanel_.getRowCount();
        SMTaskOperationData sMTaskOperationData = null;
        int n2 = 0;
        while (n2 < sMTaskOperationDataArray.length) {
            Vector<Object> vector = new Vector<Object>();
            sMTaskOperationData = sMTaskOperationDataArray[n2];
            Table table = new Table(sMTaskOperationData.getOperand());
            String string = sMTaskOperationData.getUserData();
            vector.add(sMTaskOperationData);
            if (!sMTaskOperationData.getOperation().equals(DELETE_ROW_ACTION)) {
                ++n2;
                while (n2 < sMTaskOperationDataArray.length) {
                    sMTaskOperationData = sMTaskOperationDataArray[n2];
                    vector.add(sMTaskOperationData);
                    if (sMTaskOperationData.getOperation().equals(END_ACTION)) break;
                    ++n2;
                }
            }
            Object[] objectArray = new SMTaskOperationData[vector.size()];
            vector.copyInto(objectArray);
            table.setOperationData((SMTaskOperationData[])objectArray);
            this.tm_.add(table);
            vector = new Vector();
            vector.add(new CgData(table.getUrl()));
            if (table.getRowAction().equals("")) {
                vector.add(new CgData(CgUtility.getI18nMsg(table.getRowAction()), null, table.getRowAction()));
            } else {
                vector.add(new CgData(CgUtility.getI18nMsg(this.rowActionToKey(table.getRowAction())), null, table.getRowAction()));
            }
            vector.add(new CgData(string));
            int n3 = this.tablePanel_.getSelectedRow();
            if (n == 1 || n3 + 1 == this.tablePanel_.getRowCount()) {
                this.tablePanel_.getTable().insertRow(vector, this.tablePanel_.getRowCount() - 1);
            } else {
                this.tablePanel_.setValueAt(vector.elementAt(0), n3, 0);
                this.tablePanel_.setValueAt(vector.elementAt(1), n3, 1);
                this.tablePanel_.setValueAt(vector.elementAt(2), n3, 2);
            }
            ++n2;
        }
        n = this.tablePanel_.getRowCount() - 1;
        this.tablePanel_.setRowSelectionInterval(n, n);
        this.enableButtons();
    }

    public SMTaskOperationData[] getOperationData() {
        return this.tm_.getOperationData();
    }

    public boolean validateData() {
        return this.tm_.validate();
    }

    public void cleanup() {
    }

    private void localize() {
        int n = this.taskManager_.getTaskNameLabelWidth();
        this.selectActionLabel_.setMinimumSize(new Dimension(n, 26));
        this.selectActionLabel_.setPreferredSize(new Dimension(n, 26));
        this.selectActionLabel_.setText(CgUtility.getI18nMsg("table.selectTableAction") + ":");
        this.selectActionLabel_.setLabelFor(this.selectAction_);
        this.moduleTable_.setMinimumSize(new Dimension(n, 26));
        this.moduleTable_.setPreferredSize(new Dimension(n, 26));
        this.moduleTable_.setText(CgUtility.getI18nMsg("table.moduleTable") + ":");
        this.selectButton_.setText(CgUtility.getI18nMsg("table.setParameters") + "...");
        this.deleteEntryButton_.setText(CgUtility.getI18nMsg("standard.deleteEntry"));
    }

    private void tableRowSelected(CgTblSelectEvent cgTblSelectEvent) {
        this.editing_ = false;
        int n = 0;
        int n2 = this.tablePanel_.getSelectedRow();
        int n3 = this.tablePanel_.getRowCount();
        this.moduleTableCombo_.setEnabled(true);
        if (n3 <= 0 || n2 < 0) {
            this.editing_ = true;
            return;
        }
        this.enableButtons();
        if (n2 < this.tm_.size()) {
            Object object;
            Table table = (Table)this.tm_.get(n2);
            String string = this.stripInstance(table.getUrl());
            if (string != null) {
                n = 0;
                while (n < this.moduleTableCombo_.getItemCount()) {
                    object = (CgData)this.moduleTableCombo_.getItemAt(n);
                    CgTableInfo cgTableInfo = (CgTableInfo)((CgTableInfo)((CgData)object).getUserData()).clone();
                    String string2 = this.stripInstance(cgTableInfo.getUrl());
                    if (string2.equals(string)) {
                        this.moduleTableCombo_.setSelectedIndex(n);
                        break;
                    }
                    ++n;
                }
            }
            if (((String)(object = table.getRowAction())).equals(ADD_ROW_ACTION)) {
                this.selectAction_.setSelectedIndex(0);
            } else if (((String)object).equals(EDIT_ROW_ACTION)) {
                this.selectAction_.setSelectedIndex(1);
            } else if (((String)object).equals(DELETE_ROW_ACTION)) {
                this.selectAction_.setSelectedIndex(2);
            } else {
                this.selectAction_.setSelectedIndex(-1);
            }
        } else {
            this.moduleTableCombo_.setSelectedIndex(-1);
            this.selectAction_.setSelectedIndex(-1);
        }
        this.tablePanel_.resetWorkingRow();
        this.editing_ = true;
    }

    private String stripInstance(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf("+");
        int n2 = -1;
        if (n > -1) {
            n2 = n + string.substring(n).indexOf("/");
        }
        if (n2 > n) {
            return string.substring(0, n) + string.substring(n2);
        }
        return string;
    }

    private void enableButtons() {
        int n = this.tablePanel_.getSelectedRow();
        if (n < 0) {
            this.deleteEntryButton_.setEnabled(false);
            this.selectButton_.setEnabled(false);
            return;
        }
        CgData cgData = (CgData)this.tablePanel_.getValueAt(n, 1);
        String string = null;
        if (cgData != null) {
            string = (String)cgData.getUserData();
        }
        boolean bl = string != null && !string.equals("") && n != this.tablePanel_.getRowCount() - 1;
        this.selectButton_.setEnabled(bl);
        this.deleteEntryButton_.setEnabled(n != this.tablePanel_.getRowCount() - 1);
        this.selectAction_.setEnabled(n != this.tablePanel_.getRowCount() - 1);
    }

    private void doRowAction() {
        int n = this.tablePanel_.getSelectedRow();
        SMTaskOperationData[] sMTaskOperationDataArray = ((Table)this.tm_.get(n)).getOperationData();
        CgUpdateRowChooser cgUpdateRowChooser = new CgUpdateRowChooser(this.parentFrame_, sMTaskOperationDataArray, this.handle_);
        if (cgUpdateRowChooser.isOK()) {
            sMTaskOperationDataArray = cgUpdateRowChooser.getRowOperation();
            Vector<SMTaskOperationData> vector = new Vector<SMTaskOperationData>();
            int n2 = 0;
            while (n2 < sMTaskOperationDataArray.length) {
                if (!sMTaskOperationDataArray[n2].getOperation().equals(AUX_ROW_ACTION) || sMTaskOperationDataArray[n2].getValue() != null && !sMTaskOperationDataArray[n2].getValue().equals("")) {
                    vector.add(sMTaskOperationDataArray[n2]);
                }
                ++n2;
            }
            Object[] objectArray = new SMTaskOperationData[vector.size()];
            vector.copyInto(objectArray);
            this.tm_.setOperationData(n, (SMTaskOperationData[])objectArray);
            this.tablePanel_.setValueAt(new CgData(objectArray[0].getUserData(), null, objectArray[0].getUserData()), n, 2);
        }
        this.tablePanel_.setRowSelectionInterval(n, n);
        this.enableButtons();
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout_);
        this.deleteEntryButton_.setText("deleteEntry");
        this.deleteEntryButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CgTableTaskEditor.this.deleteButton__actionPerformed(actionEvent);
            }
        });
        this.selectButton_.setText("selectTable");
        this.selectButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CgTableTaskEditor.this.selectButton__actionPerformed(actionEvent);
            }
        });
        this.setAlignmentX(0.0f);
        this.setMinimumSize(new Dimension(10, 10));
        this.setPreferredSize(new Dimension(10, 10));
        this.selectActionLabel_.setMaximumSize(new Dimension(125, 18));
        this.selectActionLabel_.setMinimumSize(new Dimension(125, 18));
        this.selectActionLabel_.setPreferredSize(new Dimension(125, 18));
        this.selectActionLabel_.setText("selectAction");
        this.moduleTable_.setMaximumSize(new Dimension(125, 18));
        this.moduleTable_.setMinimumSize(new Dimension(125, 18));
        this.moduleTable_.setPreferredSize(new Dimension(125, 18));
        this.moduleTable_.setText("ModuleTable");
        this.moduleTableCombo_.setAlignmentX(0.0f);
        this.moduleTableCombo_.setAlignmentY(0.0f);
        this.add((Component)this.tablePanel_, new GridBagConstraints(0, 2, 2, 4, 1.0, 1.0, 10, 1, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.deleteEntryButton_, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 11, 2, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this.selectButton_, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this.selectAction_, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.selectActionLabel_, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.moduleTableCombo_, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.moduleTable_, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    void selectButton__actionPerformed(ActionEvent actionEvent) {
        this.enableButtons();
        this.doRowAction();
    }

    void deleteButton__actionPerformed(ActionEvent actionEvent) {
        int n = this.tablePanel_.getSelectedRow();
        if (n < 0 || n > this.tablePanel_.getRowCount()) {
            return;
        }
        if (!CgUtility.confirmDelete(this, CgUtility.getI18nMsg("standard.askDeleteEntry"))) {
            return;
        }
        this.tablePanel_.deleteRow(n);
        this.tm_.removeElementAt(n);
        if (this.tablePanel_.getRowCount() <= 0) {
            this.deleteEntryButton_.setEnabled(false);
        } else {
            this.tablePanel_.setRowSelectionInterval(n, n);
        }
        this.taskManager_.setModified(true);
    }

    private DefaultCellEditor getActionEditor() {
        final CgComboBox cgComboBox = new CgComboBox(new CgData[]{new CgData(CgUtility.getI18nMsg("table.addRow"), null, "add"), new CgData(CgUtility.getI18nMsg("table.editRow"), null, "edit"), new CgData(CgUtility.getI18nMsg("table.deleteRow"), null, "delete")});
        cgComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = CgTableTaskEditor.this.tablePanel_.getPreEditingRow();
                int n2 = CgTableTaskEditor.this.tablePanel_.getPreEditingColumn();
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                CgData cgData = (CgData)jComboBox.getSelectedItem();
                CgTableTaskEditor.this.tablePanel_.setValueAt(cgData, n, 1);
                CgTableTaskEditor.this.taskManager_.setModified(true);
            }
        });
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(cgComboBox){
            CgData currentData = null;

            public Object getCellEditorValue() {
                return this.currentData;
            }

            public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
                this.currentData = (CgData)object;
                cgComboBox.setSelectedItem(object);
                return cgComboBox;
            }
        };
        defaultCellEditor.setClickCountToStart(2);
        return defaultCellEditor;
    }

    private void getTableInfo() {
        Thread thread = new Thread(){

            public void run() {
                CgTableInfo[] cgTableInfoArray = null;
                while ((cgTableInfoArray = CgTableRequest.getInstance().getTableInfo()) == null) {
                    CgTableTaskEditor.this.taskManager_.setStatusMessage(CgUtility.getI18nMsg("table.loadTable"));
                    CgTableTaskEditor.this.taskManager_.setBusy(true);
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        UcDDL.logErrorMessage((String)("CgTableRequest.getTableInfo Failed :" + interruptedException));
                    }
                }
                CgTableTaskEditor.this.setTableInfo(cgTableInfoArray);
                CgTableTaskEditor.this.taskManager_.setBusy(false);
                CgTableTaskEditor.this.taskManager_.setStatusMessage("");
            }
        };
        thread.start();
    }

    private void setTableInfo(CgTableInfo[] cgTableInfoArray) {
        Arrays.sort((Object[])cgTableInfoArray, new Comparator(){

            public int compare(Object object, Object object2) {
                CgTableInfo cgTableInfo = (CgTableInfo)object;
                CgTableInfo cgTableInfo2 = (CgTableInfo)object2;
                return cgTableInfo.getModuleName().compareTo(cgTableInfo2.getModuleName());
            }

            public boolean equals(Object object, Object object2) {
                CgTableInfo cgTableInfo = (CgTableInfo)object;
                CgTableInfo cgTableInfo2 = (CgTableInfo)object2;
                return cgTableInfo.getModuleName().equals(cgTableInfo2.getModuleName());
            }
        });
        int n = 0;
        while (n < cgTableInfoArray.length) {
            CgData cgData = new CgData(cgTableInfoArray[n].getModuleName(), null, cgTableInfoArray[n]);
            this.moduleTableCombo_.addItem(cgData);
            ++n;
        }
        this.moduleTableCombo_.setSelectedIndex(-1);
        this.selectAction_.setSelectedIndex(-1);
        this.moduleTableCombo_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                if (CgTableTaskEditor.this.moduleTableCombo_.getSelectedIndex() < 0 || !CgTableTaskEditor.this.editing_) {
                    return;
                }
                CgData cgData = (CgData)CgTableTaskEditor.this.moduleTableCombo_.getSelectedItem();
                CgTableInfo cgTableInfo = (CgTableInfo)((CgTableInfo)cgData.getUserData()).clone();
                String string = cgTableInfo.getUrl();
                if (cgTableInfo.isMultipleInstance()) {
                    object = CgUtility.getInstanceName((JFrame)CgTableTaskEditor.this.taskManager_);
                    if (object == null) {
                        return;
                    }
                    int n = string.indexOf("dummy");
                    string = string.substring(0, n) + (String)object + string.substring(n + 5);
                }
                object = cgTableInfo.getRowAction();
                try {
                    object[0].setOperand(string);
                    object[0].setUserData("");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                int n = CgTableTaskEditor.this.tablePanel_.getSelectedRow();
                if (n + 1 == CgTableTaskEditor.this.tablePanel_.getRowCount()) {
                    Vector<CgData> vector = new Vector<CgData>();
                    vector.add(new CgData(""));
                    vector.add(new CgData(""));
                    vector.add(new CgData(""));
                    CgTableTaskEditor.this.tablePanel_.addRow(vector);
                    Table table = new Table(string);
                    table.setOperationData((SMTaskOperationData[])object);
                    table.setRowAction("");
                    CgTableTaskEditor.this.tm_.addTable(table);
                } else {
                    CgTableTaskEditor.this.tm_.setOperationData(n, (SMTaskOperationData[])object);
                }
                CgTableTaskEditor.this.tablePanel_.setValueAt(new CgData(string), n, 0);
                CgTableTaskEditor.this.tablePanel_.setValueAt(new CgData(""), n, 1);
                CgTableTaskEditor.this.tablePanel_.setValueAt(new CgData(""), n, 2);
                CgTableTaskEditor.this.taskManager_.setModified(true);
                CgTableTaskEditor.this.enableButtons();
            }
        });
    }

    class TableRender
    extends DefaultTableCellRenderer {
        TableRender() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setFont(jTable.getFont());
            int n3 = CgTableTaskEditor.this.tablePanel_.getSelectedRow();
            if (object instanceof CgData) {
                this.setText(((CgData)object).getLabel());
            }
            if (n == n3) {
                this.setBackground(jTable.getSelectionBackground());
            } else {
                this.setBackground(UcCommon.getLightGrayColor());
            }
            return this;
        }
    }

    class TableManager
    extends Vector {
        TableManager() {
        }

        Table getTable(String string) {
            int n = 0;
            while (n < this.size()) {
                Table table = (Table)this.get(n);
                if (table.getUrl().equals(string)) {
                    return table;
                }
                ++n;
            }
            return null;
        }

        boolean validate() {
            int n = 0;
            while (n < this.size()) {
                Table table = (Table)this.get(n);
                if (table.getRowAction() == null || table.getRowAction().equals("")) {
                    CgTableTaskEditor.this.taskManager_.setStatusMessage(CgUtility.getI18nMsg("table.incompleteData"));
                    return false;
                }
                SMTaskOperationData[] sMTaskOperationDataArray = table.getOperationData();
                if (sMTaskOperationDataArray == null || sMTaskOperationDataArray.length == 0) {
                    CgTableTaskEditor.this.taskManager_.setStatusMessage(CgUtility.getI18nMsg("table.incompleteDataValue"));
                    return false;
                }
                boolean bl = true;
                int n2 = 0;
                while (n2 < sMTaskOperationDataArray.length) {
                    if (sMTaskOperationDataArray[n2].getOperation().equals(AUX_ROW_ACTION)) {
                        if (sMTaskOperationDataArray[n2].getValue() == null || sMTaskOperationDataArray[n2].getValue().equals("")) {
                            bl = false;
                            break;
                        }
                        bl = true;
                    }
                    ++n2;
                }
                if (!bl) {
                    CgTableTaskEditor.this.taskManager_.setStatusMessage(CgUtility.getI18nMsg("table.incompleteDataValue"));
                    return false;
                }
                String string = table.getUrl();
                int n3 = n + 1;
                while (n3 < this.size()) {
                    Table table2 = (Table)this.get(n3);
                    if (string.equals(table2.getUrl()) && table.getRowIndex().equals(table2.getRowIndex())) {
                        CgTableTaskEditor.this.taskManager_.setStatusMessage(CgUtility.getI18nMsg("table.duplicateInstanceRow"));
                        return false;
                    }
                    ++n3;
                }
                ++n;
            }
            return true;
        }

        void addTable(String string) {
            this.add(new Table(string));
        }

        void addTable(Table table) {
            this.add(table);
        }

        void removeTable(String string) {
            int n = 0;
            while (n < this.size()) {
                Table table = (Table)this.get(n);
                if (table.getUrl().equals(string)) {
                    this.removeElementAt(n);
                    break;
                }
                ++n;
            }
        }

        void setOperationData(String string, SMTaskOperationData[] sMTaskOperationDataArray) {
            Table table = this.getTable(string);
            if (table != null) {
                table.setOperationData(sMTaskOperationDataArray);
            }
        }

        void setOperationData(int n, SMTaskOperationData[] sMTaskOperationDataArray) {
            Table table = (Table)this.get(n);
            if (table != null) {
                table.setOperationData(sMTaskOperationDataArray);
            }
        }

        void setOperationData(SMTaskOperationData[] sMTaskOperationDataArray) {
        }

        SMTaskOperationData[] getOperationData() {
            SMTaskOperationData[] sMTaskOperationDataArray = new SMTaskOperationData[]{};
            int n = 0;
            while (n < this.size()) {
                Table table = (Table)this.get(n);
                SMTaskOperationData[] sMTaskOperationDataArray2 = table.getOperationData();
                sMTaskOperationDataArray = table.getRowAction().equals(DELETE_ROW_ACTION) ? this.appendOperationData(sMTaskOperationDataArray, new SMTaskOperationData[]{sMTaskOperationDataArray2[0]}) : this.appendOperationData(sMTaskOperationDataArray, sMTaskOperationDataArray2);
                ++n;
            }
            return sMTaskOperationDataArray;
        }

        private SMTaskOperationData[] appendOperationData(SMTaskOperationData[] sMTaskOperationDataArray, SMTaskOperationData[] sMTaskOperationDataArray2) {
            if (sMTaskOperationDataArray == null) {
                sMTaskOperationDataArray = new SMTaskOperationData[]{};
            }
            if (sMTaskOperationDataArray2 == null) {
                return sMTaskOperationDataArray;
            }
            SMTaskOperationData[] sMTaskOperationDataArray3 = new SMTaskOperationData[sMTaskOperationDataArray.length + sMTaskOperationDataArray2.length];
            int n = 0;
            while (n < sMTaskOperationDataArray.length) {
                sMTaskOperationDataArray3[n] = sMTaskOperationDataArray[n];
                ++n;
            }
            int n2 = 0;
            while (n2 < sMTaskOperationDataArray2.length) {
                sMTaskOperationDataArray3[sMTaskOperationDataArray.length + n2] = sMTaskOperationDataArray2[n2];
                ++n2;
            }
            return sMTaskOperationDataArray3;
        }
    }

    class Table {
        String url_;
        private SMTaskOperationData[] operationData_ = new SMTaskOperationData[0];

        Table(String string) {
            this.url_ = string;
        }

        String getUrl() {
            return this.url_;
        }

        void setUrl(String string) {
            this.url_ = string;
        }

        SMTaskOperationData[] getOperationData() {
            return this.operationData_;
        }

        void setOperationData(SMTaskOperationData[] sMTaskOperationDataArray) {
            this.operationData_ = sMTaskOperationDataArray;
        }

        void setRowAction(String string) {
            try {
                this.operationData_[0].setOperation(string);
            }
            catch (SMLengthException sMLengthException) {
                // empty catch block
            }
        }

        String getRowAction() {
            return this.operationData_[0].getOperation();
        }

        String getRowIndex() {
            return this.operationData_[0].getUserData();
        }
    }

    class ButtonEditor
    extends DefaultCellEditor {
        CgData data;

        public ButtonEditor(JButton jButton) {
            super(new JCheckBox());
            this.editorComponent = jButton;
            this.setClickCountToStart(1);
            jButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ ButtonEditor this$1;
                {
                    this.this$1 = buttonEditor;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.stopCellEditing();
                }
            });
        }

        public Object getCellEditorValue() {
            return this.data;
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            ((JButton)this.editorComponent).setText(object.toString());
            return this.editorComponent;
        }
    }
}

