/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.apps.lv.console.presentation;

import com.sun.symon.apps.hardview.console.presentation.SMHvBean;
import com.sun.symon.apps.hardview.console.presentation.SMHvUpdateBean;
import com.sun.symon.apps.hardview.console.presentation.SMHvUpdateListener;
import com.sun.symon.apps.lv.console.presentation.SMLvDRListener;
import com.sun.symon.apps.lv.console.presentation.SMLvDataTree;
import com.sun.symon.apps.lv.console.presentation.SMLvExpandListener;
import com.sun.symon.apps.lv.console.presentation.SMLvNode;
import com.sun.symon.apps.lv.console.presentation.SMLvRefreshListener;
import com.sun.symon.apps.lv.console.presentation.SMLvSearchListener;
import com.sun.symon.apps.lv.console.presentation.SMLvTreeCellRenderer;
import com.sun.symon.apps.lv.console.presentation.SMLvTreeNode;
import com.sun.symon.apps.pv.console.presentation.SMPvGlobals;
import com.sun.symon.apps.pv.console.tool.SMPvCompDetailPanel;
import com.sun.symon.base.client.SMLogin;
import com.sun.symon.base.client.SMPropertyData;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.SMResourceAccess;
import com.sun.symon.base.client.module.SMModuleRequest;
import com.sun.symon.base.utility.UcInternationalizer;
import com.sun.symon.base.utility.UcListUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class SMLvBean
extends JPanel
implements SMHvUpdateListener {
    int agentPort;
    String hostName;
    String moduleName;
    String elementName = "system";
    int elementInstance = 1;
    JLabel status;
    JLabel statusMsg = null;
    JPanel statusPanel = null;
    JPanel treePanel;
    JTree lvHierarchy = null;
    JButton dr = null;
    JButton expandTree;
    JCheckBox refreshDetails;
    SMPvCompDetailPanel lvDetails = null;
    SMLvDataTree dataTree = null;
    SMRawDataRequest dReq = null;
    SMResourceAccess resAcc = null;
    boolean expandShowing = false;
    boolean searchOn = false;
    SMHvUpdateBean updateBean;
    JPanel main;
    JLabel errorMsg;
    JPanel hierarchyPanel;
    JPanel optionsPanel;
    JSplitPane splitForHierarchyAndDetail;
    SMHvBean hvbean = null;
    Hashtable treeDataCache;
    Hashtable compDataCache;
    Hashtable propCache;
    Hashtable treePropOrderCache;
    Hashtable rawTreePropCache;

    public synchronized void init() {
        this.updateBean = new SMHvUpdateBean(this.hvbean, this.moduleName);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.main = new JPanel(new BorderLayout());
        this.main.setBorder(BorderFactory.createEmptyBorder(10, 10, 20, 10));
        SMModuleRequest sMModuleRequest = new SMModuleRequest(this.dReq);
        try {
            if (!sMModuleRequest.isModuleLoaded(this.getAgentHost(), this.getAgentPort(), this.getModuleName())) {
                this.postStatus(this.getI18NString("lvNoModule"));
                this.displayErrorMsg("lvNoLV");
                return;
            }
        }
        catch (Exception exception) {
            this.postStatus(exception.getMessage());
            this.displayErrorMsg("lvNoLV");
            return;
        }
        this.postStatus(this.getI18NString("lvLoadingHierarchy"));
        if (!this.initDataTree()) {
            this.postStatus(this.getI18NString("lvLoadingHierarchyFailed"));
            return;
        }
        this.postStatus(this.getI18NString("lvLoadingConsole"));
        this.optionsPanel = this.createOptionsPanel();
        this.main.add((Component)this.optionsPanel, "North");
        this.hierarchyPanel = this.createHierarchyPanel();
        this.lvDetails = this.createDetailsPanel();
        this.splitForHierarchyAndDetail = new JSplitPane(1, false, this.hierarchyPanel, this.lvDetails);
        this.splitForHierarchyAndDetail.setDividerLocation(350);
        this.main.add((Component)this.splitForHierarchyAndDetail, "Center");
        this.statusPanel = this.createStatusPanel();
        this.main.add("South", this.statusPanel);
        this.postStatus("");
        try {
            this.updateBean.addDataUpdateListener(this);
            this.updateBean.addAlarmUpdateListener(this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.displayMainPanel();
        this.getAccessibleContext().setAccessibleDescription(UcInternationalizer.translateKey((String)"com.sun.symon.base.console.AccessibleDescriptions:lv.description"));
    }

    private boolean initDataTree() {
        try {
            if (this.dataTree == null && (this.dataTree = new SMLvDataTree()) == null) {
                return false;
            }
            this.dataTree.setRawDataRequestHandle(this.dReq);
            this.dataTree.setAgentHost(this.hostName);
            this.dataTree.setAgentPort(this.agentPort);
            this.dataTree.setModuleName(this.getModuleName());
            this.dataTree.setBeanReference(this);
            this.dataTree.setElementName(this.getElementName());
            this.dataTree.setElementInstance(this.getElementInstance());
            this.dataTree.init();
        }
        catch (Exception exception) {
            this.postStatus(this.getI18NString(exception.getMessage()));
            this.displayErrorMsg("lvNoLV");
            return false;
        }
        return true;
    }

    public void cleanup() {
        if (this.updateBean != null) {
            this.updateBean.removeDataUpdateListener();
            this.updateBean.removeAlarmUpdateListener();
        }
        if (this.dr != null && this.getModuleName().equals("Config-Reader4u")) {
            this.dr.setVisible(false);
        }
    }

    private void displayMainPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        this.revalidate();
        this.add((Component)new JScrollPane(this.main), gridBagConstraints);
        this.getParent().validate();
        this.getParent().setVisible(true);
        if (this.getComponentDetailPanel() != null) {
            this.showComponentDetails();
        }
    }

    private void displayErrorMsg(String string) {
        this.errorMsg.setText(this.getI18NString(string));
        this.revalidate();
        this.add(this.errorMsg);
        this.getParent().validate();
        this.getParent().setVisible(true);
    }

    public Dimension getPanelSize() {
        return new Dimension(this.lvHierarchy.getWidth() + this.lvDetails.getWidth(), this.lvHierarchy.getHeight());
    }

    public String determineModuleName() {
        return new String("Config-Reader4u");
    }

    public void setModuleName(String string) {
        this.moduleName = new String(string);
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setElementName(String string) {
        this.elementName = new String(string);
    }

    public String getElementName() {
        return this.elementName;
    }

    public void setElementInstance(int n) {
        this.elementInstance = n;
    }

    public int getElementInstance() {
        return this.elementInstance;
    }

    public void setCaches(Hashtable hashtable, Hashtable hashtable2, Hashtable hashtable3, Hashtable hashtable4, Hashtable hashtable5) {
        this.treeDataCache = hashtable;
        this.compDataCache = hashtable2;
        this.propCache = hashtable3;
        this.treePropOrderCache = hashtable4;
        this.rawTreePropCache = hashtable5;
    }

    public SMRawDataRequest getRawDataRequestHandle() {
        return this.dReq;
    }

    public void setRawDataRequestHandle(SMRawDataRequest sMRawDataRequest) {
        this.dReq = sMRawDataRequest;
        this.resAcc = new SMResourceAccess(this.dReq);
    }

    public void setAgentPort(int n) {
        this.agentPort = n;
    }

    public void setAgentHost(String string) {
        this.hostName = new String(string);
    }

    public int getAgentPort() {
        return this.agentPort;
    }

    public String getAgentHost() {
        return this.hostName;
    }

    public void setWindowStatusField(Object object) {
        this.statusMsg = (JLabel)object;
    }

    private JPanel getHierarchyPanel() {
        return this.hierarchyPanel;
    }

    public JLabel getWindowStatusField() {
        return this.statusMsg;
    }

    public void setHvBean(SMHvBean sMHvBean) {
        this.hvbean = sMHvBean;
    }

    public void postStatus(String string) {
        if (this.statusMsg != null) {
            this.statusMsg.setText(string);
            this.statusMsg.validate();
        }
    }

    public SMLvDataTree getDataTreeRef() {
        return this.dataTree;
    }

    public void postPath(String string) {
        this.status.setText(string);
    }

    public SMLvNode getSelectedLvNode() {
        TreePath treePath = this.lvHierarchy.getSelectionPath();
        if (treePath != null) {
            this.lvHierarchy.scrollPathToVisible(treePath);
            SMLvTreeNode sMLvTreeNode = (SMLvTreeNode)treePath.getLastPathComponent();
            return sMLvTreeNode.getNode();
        }
        return null;
    }

    private void postNodeDetails() {
        this.postStatus("");
        SMLvNode sMLvNode = this.getSelectedLvNode();
        if (sMLvNode != null) {
            SMLvNode sMLvNode2;
            this.postPath(sMLvNode.getPath());
            if (sMLvNode.link_to != null && sMLvNode.link_to.length != 0 && (sMLvNode2 = SMLvNode.searchNode(this.dataTree.getRoot(), sMLvNode.link_to[0])) != null) {
                sMLvNode = sMLvNode2;
            }
            this.postDetails(sMLvNode);
        } else {
            this.postPath("");
        }
    }

    protected void postDetails(SMLvNode sMLvNode) {
        Vector vector = this.getComponentDetail(sMLvNode);
        if (vector == null) {
            this.postStatus(this.getI18NString("lvNoComponentDetails"));
        } else {
            this.postStatus("");
        }
        this.populateComponentDetails(vector);
    }

    private JPanel createOptionsPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 20, 10));
        JPanel jPanel2 = new JPanel(new FlowLayout());
        JButton jButton = new JButton(this.getI18NString("lvSearchNode") + "...");
        jPanel2.add(jButton);
        jButton.setToolTipText(this.getI18NString("lvSearchTip"));
        jButton.setMnemonic(this.getI18NString("lvSearchNode.mnemonic").charAt(0));
        jButton.addActionListener(new SMLvSearchListener(this));
        this.dr = new JButton(this.getI18NString("lvDR"));
        this.dr.setMnemonic(this.getI18NString("lvDR.mnemonic").charAt(0));
        this.dr.setAlignmentY(0.5f);
        this.dr.addActionListener(new SMLvDRListener(this));
        this.hvbean.getCbPanel().add(this.dr);
        this.dr.setVisible(false);
        if (this.getModuleName().equals("Config-Reader4u")) {
            this.dr.setVisible(true);
        }
        this.expandTree = new JButton(this.getI18NString("lvExpandAll"));
        jPanel2.add(this.expandTree);
        this.expandTree.setToolTipText(this.getI18NString("lvExpandTreeTip"));
        this.expandTree.setMnemonic(this.getI18NString("lvExpandAll.mnemonic").charAt(0));
        this.expandTree.addActionListener(new SMLvExpandListener(this));
        this.refreshDetails = new JCheckBox(this.getI18NString("lvRefreshDetails"), false);
        this.refreshDetails.setToolTipText(this.getI18NString("lvRefreshTip"));
        this.refreshDetails.setMnemonic(this.getI18NString("lvRefreshDetails.mnemonic").charAt(0));
        this.refreshDetails.addActionListener(new SMLvRefreshListener(this));
        this.refreshDetails.setVisible(false);
        jPanel2.add(this.refreshDetails);
        jPanel.add((Component)jPanel2, "West");
        return jPanel;
    }

    public void showComponentDetails() {
        this.getComponentDetailPanel().setVisible(true);
        this.postNodeDetails();
        this.refreshDetails.setVisible(true);
        this.validate();
    }

    public void expandTreeNode(SMLvNode sMLvNode) {
        SMLvNode sMLvNode2 = sMLvNode.first_child;
        while (sMLvNode2 != null) {
            TreePath treePath = null;
            treePath = new TreePath(sMLvNode2.getTreeNode().getPath());
            if (this.lvHierarchy.isExpanded(treePath)) {
                sMLvNode2.setNodeExpandFlag(true);
            } else {
                sMLvNode2.setNodeExpandFlag(false);
            }
            this.expandTreeNode(sMLvNode2);
            this.lvHierarchy.scrollPathToVisible(treePath);
            sMLvNode2 = sMLvNode2.brother;
        }
        this.validate();
    }

    public void defaultTreeNode(SMLvNode sMLvNode) {
        SMLvNode sMLvNode2 = sMLvNode.first_child;
        while (sMLvNode2 != null) {
            this.defaultTreeNode(sMLvNode2);
            if (!sMLvNode2.getNodeExpandFlag()) {
                this.lvHierarchy.collapsePath(new TreePath(sMLvNode2.getTreeNode().getPath()));
            }
            sMLvNode2 = sMLvNode2.brother;
        }
        this.validate();
    }

    protected boolean getExpandFlag() {
        return this.expandShowing;
    }

    protected boolean refreshNow() {
        return this.refreshDetails.isSelected();
    }

    protected JButton getMoreButtonRef() {
        return this.expandTree;
    }

    protected void toggleExpandFlag() {
        this.expandShowing = !this.expandShowing;
    }

    public SMPvCompDetailPanel getComponentDetailPanel() {
        return this.lvDetails;
    }

    private JPanel createHierarchyPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 0, 5, 10), BorderFactory.createLoweredBevelBorder()));
        jPanel.setSize(800, 800);
        this.lvHierarchy = null;
        this.lvHierarchy = new JTree(this.dataTree.getRoot().SMLvBuildHierarchy(null));
        this.lvHierarchy.setCellRenderer(new SMLvTreeCellRenderer());
        this.lvHierarchy.getSelectionModel().setSelectionMode(1);
        this.lvHierarchy.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                SMLvBean.this.postNodeDetails();
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.lvHierarchy);
        jScrollPane.setBorder(BorderFactory.createEtchedBorder());
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    private JPanel createStatusPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(20, 0, 20, 0));
        JLabel jLabel = new JLabel(this.getI18NString("lvComponent"));
        jLabel.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 10));
        jPanel.add((Component)jLabel, "West");
        this.status = new JLabel(this.getI18NString("lvComponentPath"));
        this.status.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 2));
        this.status.setForeground(Color.blue);
        jPanel.add((Component)this.status, "Center");
        return jPanel;
    }

    public SMPvCompDetailPanel createDetailsPanel() {
        SMPvCompDetailPanel sMPvCompDetailPanel = new SMPvCompDetailPanel(this.getModuleName());
        sMPvCompDetailPanel.setVisible(false);
        return sMPvCompDetailPanel;
    }

    public SMPvCompDetailPanel getDetailsPanel() {
        return this.lvDetails;
    }

    public void reinitializeBean() {
        this.searchOn = false;
        this.lvHierarchy = null;
        this.dataTree = null;
        this.getParent().setVisible(false);
        this.removeAll();
        this.main.removeAll();
        this.getParent().validate();
        this.postStatus(this.getI18NString("lvReloadingHierarchy"));
        if (!this.initDataTree()) {
            this.postStatus(this.getI18NString("lvLoadingHierarchyFailed"));
            this.getParent().setVisible(true);
            return;
        }
        this.postStatus(this.getI18NString("lvReloadingConsole"));
        this.main.add((Component)this.optionsPanel, "North");
        this.hierarchyPanel = this.createHierarchyPanel();
        this.splitForHierarchyAndDetail.setLeftComponent(this.hierarchyPanel);
        this.splitForHierarchyAndDetail.setDividerLocation(350);
        this.main.add((Component)this.splitForHierarchyAndDetail, "Center");
        this.postStatus("");
        this.displayMainPanel();
        this.populateComponentDetails(new Vector());
        if (this.getModuleName().equals("Config-Reader4u")) {
            this.dr.setVisible(true);
        }
        this.lvDetails.setModuleName(this.getModuleName());
        this.expandTree.setText(this.getI18NString("lvExpandAll"));
        this.expandShowing = false;
    }

    public synchronized void reinit() {
        this.updateBean.removeDataUpdateListener();
        this.updateBean.removeAlarmUpdateListener();
        this.reinitializeBean();
        try {
            this.updateBean.setModuleName(this.moduleName);
            this.updateBean.addDataUpdateListener(this);
            this.updateBean.addAlarmUpdateListener(this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public synchronized void updateDataTree() {
        this.treeDataCache.clear();
        this.compDataCache.clear();
        this.propCache.clear();
        this.treePropOrderCache.clear();
        this.rawTreePropCache.clear();
        this.reinitializeBean();
        try {
            this.updateBean.addAlarmUpdateListener(this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void updateAlarm(ArrayList arrayList) {
        int n = 0;
        while (n < arrayList.size()) {
            Vector vector = (Vector)arrayList.get(n);
            this.processOneAlarm(vector);
            ++n;
        }
    }

    private int mapAlarmStatus(String string) {
        if (string.indexOf("ERR") != -1) {
            return 1;
        }
        if (string.indexOf("WRN") != -1) {
            return 2;
        }
        if (string.indexOf("INF") != -1) {
            return 3;
        }
        return 0;
    }

    public void processOneAlarm(Vector vector) {
        int n = 0;
        int n2 = 0;
        String string = SMPvGlobals.getAlarmNodeName(vector.elementAt(7).toString());
        String string2 = SMPvGlobals.getAlarmNodeInstance(vector.elementAt(8).toString());
        String string3 = vector.elementAt(0).toString();
        String string4 = vector.lastElement().toString();
        int n3 = this.mapAlarmStatus(string3);
        SMLvNode sMLvNode = this.dataTree.getRoot().findAlarmNode(this.dataTree.getRoot(), string, string2, this.rawTreePropCache, this.moduleName);
        if (sMLvNode == null) {
            return;
        }
        if (!string4.equals("alarm_unchanged")) {
            sMLvNode.resetCompInfoDB();
            this.compDataCache.remove(this.moduleName + "." + sMLvNode.getManagedObjectName());
            n = sMLvNode.getAlarmState();
            if (string4.equals("alarm_closed")) {
                sMLvNode.decAlarmCounts(n3);
            } else {
                sMLvNode.incAlarmCounts(n3);
            }
            n2 = sMLvNode.getChildRedCnt() > 0 || sMLvNode.getRedCnt() > 0 ? 1 : (sMLvNode.getChildYellowCnt() > 0 || sMLvNode.getYellowCnt() > 0 ? 2 : (sMLvNode.getChildBlueCnt() > 0 || sMLvNode.getBlueCnt() > 0 ? 3 : 0));
            if (n != n2) {
                sMLvNode.setAlarmState(n2);
                if (sMLvNode.getParentNode() != null) {
                    sMLvNode.getParentNode().propagateUp(n, n2);
                }
            }
        }
        this.lvHierarchy.repaint();
    }

    public Vector getComponentDetail(SMLvNode sMLvNode) {
        Object object;
        Vector vector;
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        Vector vector4 = new Vector();
        Vector<String> vector5 = new Vector<String>();
        Vector vector6 = new Vector();
        String string = null;
        if (sMLvNode.getCompInfoDB() != null && !this.refreshNow()) {
            return sMLvNode.getCompInfoDB();
        }
        this.postStatus(this.getI18NString("lvLoadingComponentDetails"));
        String string2 = sMLvNode.getManagedObjectName();
        string = this.rawTreePropCache.get(this.moduleName) != null ? new String(string2 + "." + sMLvNode.getNodeInstance()) : string2;
        vector4 = (Vector)this.propCache.get(this.moduleName + "." + string2);
        if (vector4 == null) {
            return null;
        }
        String string3 = this.dataTree.getBaseUrl();
        int n = 0;
        while (n < vector4.size()) {
            String string4 = ((SMPropertyData)vector4.elementAt(n)).getPropertyName();
            try {
                vector = SMRawDataRequest.createURL((String)string3, (String)string2, (String)string4, (String)"", (String)"");
                if (((SMPropertyData)vector4.elementAt(n)).getPropertyType()) {
                    vector5.addElement((String)((Object)vector) + "#0");
                } else if (this.rawTreePropCache.get(this.moduleName) != null) {
                    object = this.rawTreePropCache.get(this.moduleName + "." + string + ".SNMP").toString();
                    if (object == null) {
                        return null;
                    }
                    vector5.addElement((String)((Object)vector) + "#" + (String)object);
                } else {
                    vector5.addElement((String)((Object)vector));
                }
            }
            catch (Exception exception) {
                return null;
            }
            vector3.addElement(vector4.elementAt(n));
            ++n;
        }
        if (vector5.size() == 0) {
            return null;
        }
        vector6 = (Vector)this.compDataCache.get(this.moduleName + "." + string);
        if (vector6 == null || this.refreshNow()) {
            if (this.refreshNow()) {
                this.compDataCache.remove(this.moduleName + "." + string2);
                sMLvNode.resetCompInfoDB();
            }
            try {
                vector2 = this.dReq.getURLValue(vector5);
            }
            catch (Exception exception) {
                return null;
            }
            if (vector2 == null || vector2.size() != vector3.size()) {
                SMPvGlobals.debug("something's lurking in the dark !!!!!");
                return null;
            }
            vector6 = new Vector();
            int n2 = 0;
            while (n2 < vector3.size()) {
                vector = (Vector)vector2.elementAt(n2);
                if (vector != null) {
                    object = vector.elementAt(0).toString();
                    if (object != null && !((String)object).equals("") && !((String)object).equals(" ")) {
                        vector = new Vector();
                        UcListUtil.decomposeList((String)object, vector);
                        vector6.addElement(vector);
                    } else {
                        vector = new Vector();
                        vector.addElement("");
                        vector6.addElement(vector);
                    }
                }
                ++n2;
            }
            this.compDataCache.put(this.moduleName + "." + string, vector6);
        }
        int n3 = 0;
        while (n3 < vector6.size()) {
            Enumeration enumeration;
            String string5;
            int n4;
            vector = ((SMPropertyData)vector3.elementAt(n3)).getPropertyName();
            object = (Vector)vector6.elementAt(n3);
            boolean bl = true;
            if (((SMPropertyData)vector3.elementAt(n3)).getPropertyType()) {
                n4 = 0;
            } else {
                bl = false;
                n4 = Integer.parseInt(sMLvNode.getNodeInstance()) - 1;
            }
            Vector<String> vector7 = new Vector<String>();
            vector7.addElement(sMLvNode.getManagedObjectName() + "." + vector);
            if (bl) {
                string5 = new String("");
                enumeration = ((Vector)object).elements();
                while (enumeration.hasMoreElements()) {
                    string5 = string5.concat(enumeration.nextElement().toString()).concat(" ");
                }
                vector7.addElement(string5);
            } else if (this.rawTreePropCache.get(this.moduleName) != null) {
                string5 = new String("");
                enumeration = ((Vector)object).elements();
                while (enumeration.hasMoreElements()) {
                    string5 = string5.concat(enumeration.nextElement().toString()).concat(" ");
                }
                vector7.addElement(string5);
            } else {
                vector7.addElement(((Vector)object).elementAt(n4).toString());
            }
            sMLvNode.compInfoDB.addElement(vector7);
            ++n3;
        }
        return sMLvNode.compInfoDB;
    }

    public void populateComponentDetails(Object object) {
        if (this.lvDetails != null && this.lvDetails.isShowing()) {
            this.lvDetails.populateDetailsTable(object);
        }
    }

    public SMLvNode expandTreeForNode(String string, SMLvNode sMLvNode) {
        SMLvNode sMLvNode2 = null;
        SMLvNode sMLvNode3 = sMLvNode;
        if (null == sMLvNode) {
            sMLvNode2 = SMLvNode.searchNode(this.dataTree.getRoot(), string);
        } else if (sMLvNode3 == this.dataTree.getRoot()) {
            if (sMLvNode3.getFirstChild() != null) {
                sMLvNode2 = SMLvNode.searchNode(sMLvNode3.getFirstChild(), string);
            }
        } else {
            boolean bl = true;
            while (sMLvNode3 != this.dataTree.getRoot()) {
                if (sMLvNode3.getFirstChild() != null && bl) {
                    sMLvNode2 = SMLvNode.searchNode(sMLvNode3.getFirstChild(), string);
                    if (sMLvNode2 != null) break;
                    sMLvNode3 = sMLvNode3.getFirstChild();
                    continue;
                }
                if (sMLvNode3.getBrother() != null) {
                    bl = true;
                    sMLvNode2 = SMLvNode.searchNode(sMLvNode3.getBrother(), string);
                    if (sMLvNode2 != null) break;
                    sMLvNode3 = sMLvNode3.getBrother();
                    continue;
                }
                bl = false;
                sMLvNode3 = sMLvNode3.getParentNode();
            }
        }
        if (sMLvNode2 == null) {
            this.postStatus(this.getI18NString("lvNodeNotFound"));
            return null;
        }
        this.lvHierarchy.scrollPathToVisible(new TreePath(sMLvNode2.getTreeNode().getPath()));
        this.lvHierarchy.setSelectionPath(new TreePath(sMLvNode2.getTreeNode().getPath()));
        this.postDetails(sMLvNode2);
        this.postPath(sMLvNode2.getPath());
        return sMLvNode2;
    }

    public Frame getFrame(Component component) {
        Frame frame = null;
        while ((component = component.getParent()) != null) {
            if (!(component instanceof Frame)) continue;
            frame = (Frame)component;
            break;
        }
        return frame;
    }

    public String getI18NString(String string) {
        return UcInternationalizer.translateKey((String)("com.sun.symon.apps.lv.console.presentation.LogicalView:" + string));
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 3) {
            System.out.println("Usage: SMLvBean agentHost agentPort serverHost");
            System.exit(1);
        }
        JFrame jFrame = new JFrame("Symon Logical View");
        SMLvBean sMLvBean = new SMLvBean();
        try {
            String string = "687a8398ad4a85077d33b72a94e16ffde0c4ba023e9c9ba77b247cc25bd3cd0015bc24b7429916751e681fd02e5ad6eb5345eb7c75b39a1c304e0f000846aa470b755b0640af974e7fc70daa6191dff6efa31a09431bb5e9848b7dc4cf4b97e1dbca31792d2860ca5a5990dfb369e1bcf296274a4e4984c8089329679dd304cd";
            SMLogin sMLogin = new SMLogin();
            sMLogin.connect(stringArray[2], 0, "adetti", "hello", string);
            sMLvBean.setRawDataRequestHandle(sMLogin.getRawDataRequest());
            sMLvBean.setAgentHost(stringArray[0]);
            sMLvBean.setAgentPort(Integer.parseInt(stringArray[1]));
            sMLvBean.setModuleName("Config-Reader4u");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        sMLvBean.init();
        jFrame.getContentPane().add(sMLvBean);
        jFrame.pack();
        jFrame.validate();
        jFrame.show();
    }
}

