/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.client.view;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMMessageI18nKey;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.service.SMDBChangeListener;
import com.sun.symon.base.client.service.SMDBObject;
import com.sun.symon.base.client.service.SMDBObjectID;
import com.sun.symon.base.client.service.SMDBRemoteChangeListener;
import com.sun.symon.base.client.service.SMDatabaseException;
import com.sun.symon.base.client.service.SMDuplicateException;
import com.sun.symon.base.client.service.SMHandle;
import com.sun.symon.base.client.service.SMNoSuchObjectException;
import com.sun.symon.base.client.service.SMSecurityException;
import com.sun.symon.base.client.service.SMStaleDataException;
import com.sun.symon.base.client.service.SMWrongTypeException;
import com.sun.symon.base.client.view.SMRemoteView;
import com.sun.symon.base.client.view.SMViewConstants;
import com.sun.symon.base.client.view.SMViewData;
import com.sun.symon.base.client.view.SMViewInfo;
import java.rmi.RemoteException;
import java.util.Locale;

public class SMView
extends SMHandle
implements SMViewConstants {
    protected SMRemoteView serviceHandle;
    protected SMRawDataRequest handle;
    protected Locale locale;
    protected int serviceType;
    private static String i18nBase_ = "com.sun.symon.base.client.ClientApiMessages";

    public SMView(SMRawDataRequest sMRawDataRequest) throws SMAPIException {
        super(sMRawDataRequest);
        this.handle = sMRawDataRequest;
        this.locale = this.handle.getLocale();
        this.serviceType = 0;
        this.serviceHandle = (SMRemoteView)this.handle.getService("View_ViewService");
        this.setHandle(this.serviceHandle);
    }

    public void setType(int n) {
        this.serviceType = n;
    }

    public void close() throws SMAPIException {
        try {
            super.close();
            this.serviceHandle.close();
            this.serviceHandle = null;
        }
        catch (RemoteException remoteException) {
            SMMessageI18nKey sMMessageI18nKey = new SMMessageI18nKey(i18nBase_, "remoteException");
            throw new SMAPIException(remoteException, sMMessageI18nKey);
        }
    }

    public SMViewInfo[] getAll() throws SMAPIException, SMSecurityException, SMDatabaseException {
        try {
            return this.serviceHandle.getAll();
        }
        catch (RemoteException remoteException) {
            SMMessageI18nKey sMMessageI18nKey = new SMMessageI18nKey(i18nBase_, "remoteException");
            throw new SMAPIException(remoteException.getMessage(), sMMessageI18nKey);
        }
    }

    public SMViewData load(SMDBObjectID sMDBObjectID) throws SMAPIException, SMSecurityException, SMDatabaseException {
        try {
            return this.serviceHandle.load(sMDBObjectID);
        }
        catch (RemoteException remoteException) {
            SMMessageI18nKey sMMessageI18nKey = new SMMessageI18nKey(i18nBase_, "remoteException");
            throw new SMAPIException(remoteException.getMessage(), sMMessageI18nKey);
        }
    }

    public SMViewData load(String string, String string2) throws SMAPIException, SMSecurityException, SMDatabaseException {
        try {
            return this.serviceHandle.load(string, string2, this.serviceType);
        }
        catch (RemoteException remoteException) {
            SMMessageI18nKey sMMessageI18nKey = new SMMessageI18nKey(i18nBase_, "remoteException");
            throw new SMAPIException(remoteException.getMessage(), sMMessageI18nKey);
        }
    }

    public SMViewData load(SMViewInfo sMViewInfo) throws SMAPIException, SMSecurityException, SMDatabaseException {
        try {
            return this.serviceHandle.load(sMViewInfo.getObjectID());
        }
        catch (RemoteException remoteException) {
            SMMessageI18nKey sMMessageI18nKey = new SMMessageI18nKey(i18nBase_, "remoteException");
            throw new SMAPIException(remoteException.getMessage(), sMMessageI18nKey);
        }
    }

    public SMDBObjectID save(SMViewData sMViewData) throws SMAPIException, SMSecurityException, SMStaleDataException, SMNoSuchObjectException, SMDatabaseException, SMDuplicateException {
        try {
            sMViewData.validate(this.locale);
            if (!sMViewData.isChanged()) {
                return sMViewData.getObjectID();
            }
            if (sMViewData.getViewType() == 0) {
                sMViewData.setViewType(this.serviceType);
            }
            SMDBObject sMDBObject = this.serviceHandle.save(sMViewData);
            sMViewData.refresh(sMDBObject);
            return sMDBObject.getObjectID();
        }
        catch (Exception exception) {
            if (exception instanceof SMAPIException) {
                throw (SMAPIException)exception;
            }
            SMMessageI18nKey sMMessageI18nKey = new SMMessageI18nKey(i18nBase_, "smApiException");
            throw new SMAPIException(exception.getMessage(), sMMessageI18nKey);
        }
    }

    public SMViewData saveAs(SMViewData sMViewData, String string, boolean bl) throws SMAPIException, SMSecurityException, SMDatabaseException, SMDuplicateException {
        return this.saveAs(sMViewData, string);
    }

    public SMViewData saveAs(SMViewData sMViewData, String string) throws SMAPIException, SMSecurityException, SMDatabaseException, SMDuplicateException {
        SMViewData sMViewData2 = (SMViewData)sMViewData.clone();
        sMViewData2.setName(string);
        this.save(sMViewData2);
        return sMViewData2;
    }

    public void delete(SMDBObjectID sMDBObjectID) throws SMAPIException, SMSecurityException, SMDatabaseException, SMNoSuchObjectException {
        try {
            this.serviceHandle.delete(sMDBObjectID, this.serviceType);
        }
        catch (RemoteException remoteException) {
            SMMessageI18nKey sMMessageI18nKey = new SMMessageI18nKey(i18nBase_, "remoteException");
            throw new SMAPIException(remoteException.getMessage(), sMMessageI18nKey);
        }
    }

    public void delete(SMViewInfo sMViewInfo) throws SMAPIException, SMSecurityException, SMDatabaseException, SMNoSuchObjectException {
        try {
            this.serviceHandle.delete(sMViewInfo.getObjectID(), this.serviceType);
        }
        catch (RemoteException remoteException) {
            SMMessageI18nKey sMMessageI18nKey = new SMMessageI18nKey(i18nBase_, "remoteException");
            throw new SMAPIException(remoteException.getMessage(), sMMessageI18nKey);
        }
    }

    public void addViewChangeListener(SMDBChangeListener sMDBChangeListener) throws SMAPIException {
        try {
            SMDBRemoteChangeListener sMDBRemoteChangeListener = this.newRemoteChangeListener(sMDBChangeListener);
            this.serviceHandle.addViewChangeListener(sMDBRemoteChangeListener, this.serviceType);
        }
        catch (Exception exception) {
            if (exception instanceof SMAPIException) {
                throw (SMAPIException)exception;
            }
            SMMessageI18nKey sMMessageI18nKey = new SMMessageI18nKey(i18nBase_, "smApiException");
            throw new SMAPIException(exception.getMessage(), sMMessageI18nKey);
        }
    }

    public void removeViewChangeListener(SMDBChangeListener sMDBChangeListener) throws SMAPIException {
        try {
            SMDBRemoteChangeListener sMDBRemoteChangeListener = this.findRemoteChangeListener(sMDBChangeListener);
            if (sMDBRemoteChangeListener != null) {
                this.serviceHandle.removeViewChangeListener(sMDBRemoteChangeListener, this.serviceType);
            }
        }
        catch (Exception exception) {
            if (exception instanceof SMAPIException) {
                throw (SMAPIException)exception;
            }
            SMMessageI18nKey sMMessageI18nKey = new SMMessageI18nKey(i18nBase_, "smApiException");
            throw new SMAPIException(exception.getMessage(), sMMessageI18nKey);
        }
    }

    public SMDBObject loadInfoObj(SMDBObjectID sMDBObjectID) throws SMAPIException, SMDatabaseException, SMSecurityException {
        return this.load(sMDBObjectID);
    }

    public SMDBObject loadObj(SMDBObjectID sMDBObjectID) throws SMAPIException, SMDatabaseException, SMSecurityException {
        return this.load(sMDBObjectID);
    }

    public SMDBObjectID saveObj(SMDBObject sMDBObject) throws SMAPIException, SMDatabaseException, SMSecurityException, SMWrongTypeException {
        if (!(sMDBObject instanceof SMViewData)) {
            SMWrongTypeException sMWrongTypeException = new SMWrongTypeException();
            SMMessageI18nKey sMMessageI18nKey = new SMMessageI18nKey(i18nBase_, "wrongDataTypeException");
            sMWrongTypeException.setMessageI18nKey(sMMessageI18nKey);
            throw sMWrongTypeException;
        }
        return this.save((SMViewData)sMDBObject);
    }

    public SMDBObject saveAsObj(SMDBObject sMDBObject, String string) throws SMAPIException, SMDatabaseException, SMSecurityException, SMWrongTypeException {
        if (!(sMDBObject instanceof SMViewData)) {
            SMWrongTypeException sMWrongTypeException = new SMWrongTypeException();
            SMMessageI18nKey sMMessageI18nKey = new SMMessageI18nKey(i18nBase_, "wrongDataTypeException");
            sMWrongTypeException.setMessageI18nKey(sMMessageI18nKey);
            throw sMWrongTypeException;
        }
        return this.saveAs((SMViewData)sMDBObject, string);
    }

    public SMDBObject loadObj(String string) throws SMAPIException, SMSecurityException, SMNoSuchObjectException, SMDatabaseException {
        return this.load(string, this.getDomainName());
    }

    public SMDBObject[] getAllObjs() throws SMAPIException, SMSecurityException, SMDatabaseException {
        return this.getAll();
    }
}

