/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.client.task;

import com.sun.symon.base.client.service.SMDBObject;
import com.sun.symon.base.utility.UcInternationalizer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;

public class SMTaskType
implements Serializable {
    private static final String VERSION = "1.0";
    private String taskType_;
    private String taskTypeNameKey_;
    private String taskTypeDescriptionKey_ = "";
    private Vector presentations_ = new Vector();
    private transient String[] presentationsArray_ = null;
    private Hashtable presentationToClass_ = new Hashtable();
    private Hashtable logPresentationToClass_ = new Hashtable();
    private boolean hidden_ = false;

    public SMTaskType(String string, String string2, String string3, boolean bl) {
        this.taskType_ = string;
        this.taskTypeNameKey_ = string2;
        if (string3 != null) {
            this.taskTypeDescriptionKey_ = string3;
        }
        this.hidden_ = bl;
    }

    public SMTaskType(String string, String string2, boolean bl) {
        this(string, string2, "", bl);
    }

    public SMTaskType(int n, String string) {
        this(n + "", string, "", false);
    }

    public int getTaskType() {
        try {
            return Integer.parseInt(this.taskType_);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public String getTaskTypeString() {
        return this.taskType_;
    }

    public String getTaskTypeNameKey() {
        return this.taskTypeNameKey_;
    }

    public String getTaskTypeDescriptionKey() {
        return this.taskTypeDescriptionKey_;
    }

    public boolean isHidden() {
        return this.hidden_;
    }

    public String getConsoleClassName() {
        return this.getPresentationClassName("console");
    }

    public String getWebClassName() {
        return this.getPresentationClassName("web");
    }

    public String getCLIClassName() {
        return this.getPresentationClassName("cli");
    }

    public String getConsoleLogClassName() {
        return this.getLogPresentationClassName("console");
    }

    public String getWebLogClassName() {
        return this.getLogPresentationClassName("web");
    }

    public String getCLILogClassName() {
        return this.getLogPresentationClassName("cli");
    }

    public String[] getPresentations() {
        if (this.presentationsArray_ != null) {
            return this.presentationsArray_;
        }
        this.presentationsArray_ = new String[this.presentations_.size()];
        this.presentations_.copyInto(this.presentationsArray_);
        return this.presentationsArray_;
    }

    public String getPresentationClassName(String string) {
        String string2 = (String)this.presentationToClass_.get(string);
        if (string2 == null) {
            return "";
        }
        return string2;
    }

    public String getLogPresentationClassName(String string) {
        String string2 = (String)this.logPresentationToClass_.get(string);
        if (string2 == null) {
            return "";
        }
        return string2;
    }

    public void setPresentationClass(String string, String string2) {
        if (!this.presentations_.contains(string)) {
            this.presentations_.addElement(string);
        }
        this.presentationToClass_.put(string, string2);
    }

    public void setLogPresentationClass(String string, String string2) {
        if (!this.presentations_.contains(string)) {
            this.presentations_.addElement(string);
        }
        this.logPresentationToClass_.put(string, string2);
    }

    public String toString() {
        return UcInternationalizer.translateKey((String)this.taskTypeNameKey_);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        SMDBObject.writeString(objectOutputStream, VERSION);
        SMDBObject.writeString(objectOutputStream, this.taskType_);
        SMDBObject.writeString(objectOutputStream, this.taskTypeNameKey_);
        SMDBObject.writeString(objectOutputStream, this.taskTypeDescriptionKey_);
        objectOutputStream.writeObject(this.presentations_);
        objectOutputStream.writeObject(this.presentationToClass_);
        objectOutputStream.writeObject(this.logPresentationToClass_);
        objectOutputStream.writeBoolean(this.hidden_);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        SMDBObject.readString(objectInputStream);
        this.taskType_ = SMDBObject.readString(objectInputStream);
        this.taskTypeNameKey_ = SMDBObject.readString(objectInputStream);
        this.taskTypeDescriptionKey_ = SMDBObject.readString(objectInputStream);
        this.presentations_ = (Vector)objectInputStream.readObject();
        this.presentationToClass_ = (Hashtable)objectInputStream.readObject();
        this.logPresentationToClass_ = (Hashtable)objectInputStream.readObject();
        this.hidden_ = objectInputStream.readBoolean();
    }
}

