/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.client.task;

import com.sun.symon.base.client.group.SMGroupConstants;
import com.sun.symon.base.client.service.SMDBObject;
import com.sun.symon.base.client.service.SMDBObjectID;
import com.sun.symon.base.client.task.SMTaskConstants;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class SMTaskRequestInfo
extends SMDBObject
implements SMTaskConstants,
SMGroupConstants {
    private static final String version = "1.0";
    protected String name;
    protected String description;
    protected String taskName;
    protected String groupName;
    protected int status;
    protected boolean isScheduled;
    protected String domain;
    protected String filterName;

    public SMTaskRequestInfo() {
    }

    public SMTaskRequestInfo(SMDBObjectID sMDBObjectID, String string, String string2, String string3, String string4, int n, boolean bl, String string5, String string6) {
        this.setObjectID(sMDBObjectID);
        this.name = string;
        this.description = string2;
        this.taskName = string3;
        this.groupName = string4;
        this.status = n;
        this.isScheduled = bl;
        this.domain = string5;
        this.filterName = string6;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append("\nRequest:" + this.name + "\n").append("Description:" + this.description + "\n").append("Task:" + this.taskName + "\n").append("Group:" + this.groupName + "\n").append("Status (hex): " + Integer.toString(this.status, 16) + "\n").append("Scheduled:" + this.isScheduled + "\n").append("Domain:" + this.domain + "\n").append("FilterName:" + this.filterName + "\n");
        return stringBuffer.toString();
    }

    public SMTaskRequestInfo(SMDBObjectID sMDBObjectID) {
        super(sMDBObjectID);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getObjectGroupName() {
        return this.groupName;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public int getStatus() {
        return this.status;
    }

    public boolean isScheduled() {
        return this.isScheduled;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getFilterName() {
        return this.filterName;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        SMDBObject.writeString(objectOutputStream, version);
        SMDBObject.writeString(objectOutputStream, this.name);
        SMDBObject.writeString(objectOutputStream, this.description);
        SMDBObject.writeString(objectOutputStream, this.taskName);
        SMDBObject.writeString(objectOutputStream, this.groupName);
        objectOutputStream.writeInt(this.status);
        objectOutputStream.writeBoolean(this.isScheduled);
        SMDBObject.writeString(objectOutputStream, this.domain);
        SMDBObject.writeString(objectOutputStream, this.filterName);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        SMDBObject.readString(objectInputStream);
        this.name = SMDBObject.readString(objectInputStream);
        this.description = SMDBObject.readString(objectInputStream);
        this.taskName = SMDBObject.readString(objectInputStream);
        this.groupName = SMDBObject.readString(objectInputStream);
        this.status = objectInputStream.readInt();
        this.isScheduled = objectInputStream.readBoolean();
        this.domain = SMDBObject.readString(objectInputStream);
        this.filterName = SMDBObject.readString(objectInputStream);
    }

    public boolean isRunning() {
        return (2 & this.status) != 0;
    }

    public boolean isFailure() {
        return (0x10 & this.status) != 0;
    }

    public boolean hasTarget() {
        return (0x100 & this.status) == 0;
    }

    public boolean isSuccess() {
        return (8 & this.status) != 0;
    }

    public boolean isMissed() {
        return (0x20 & this.status) != 0;
    }

    public boolean isSuspended() {
        return (4 & this.status) != 0;
    }

    public boolean isRunImmediate() {
        return (0x40 & this.status) != 0;
    }

    public boolean isPeriodic() {
        return (0x80 & this.status) != 0;
    }
}

