/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.client.task;

import com.sun.symon.base.client.SMUtility;
import com.sun.symon.base.client.service.SMDBObject;
import com.sun.symon.base.client.service.SMDBObjectID;
import com.sun.symon.base.client.service.SMLengthException;
import com.sun.symon.base.client.task.SMTaskInfo;
import com.sun.symon.base.client.task.SMTaskOperationData;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Locale;

public class SMTaskData
extends SMTaskInfo {
    private static final String version = "1.0";
    private SMTaskOperationData[] taskOperations_ = null;
    private boolean operationChanged_ = true;

    public SMTaskData() {
    }

    public SMTaskData(SMDBObjectID sMDBObjectID) {
        super(sMDBObjectID);
    }

    public void setName(String string) throws SMLengthException {
        super.setName(string);
    }

    public void setDescription(String string) throws SMLengthException {
        super.setDescription(string);
    }

    public void setTaskType(String string) {
        super.setTaskType(string);
    }

    public void setTaskType(int n) {
        super.setTaskType(n);
    }

    public void setOperations(SMTaskOperationData[] sMTaskOperationDataArray) {
        this.taskOperations_ = sMTaskOperationDataArray;
        this.setChanged(true);
        this.operationChanged_ = true;
    }

    public SMTaskOperationData[] getOperations() {
        return this.taskOperations_;
    }

    public Object clone() {
        SMTaskData sMTaskData = (SMTaskData)super.clone();
        if (this.taskOperations_ != null) {
            sMTaskData.taskOperations_ = new SMTaskOperationData[this.taskOperations_.length];
            int n = 0;
            while (n < this.taskOperations_.length) {
                sMTaskData.taskOperations_[n] = (SMTaskOperationData)this.taskOperations_[n].clone();
                ++n;
            }
        }
        sMTaskData.operationChanged_ = true;
        return sMTaskData;
    }

    public void setChanged(boolean bl) {
        if (!bl) {
            this.operationChanged_ = false;
        }
        super.setChanged(bl);
    }

    public boolean isOperationChanged() {
        return this.operationChanged_;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        SMDBObject.writeString(objectOutputStream, version);
        objectOutputStream.writeObject(this.taskOperations_);
        objectOutputStream.writeBoolean(this.operationChanged_);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        SMDBObject.readString(objectInputStream);
        this.taskOperations_ = (SMTaskOperationData[])objectInputStream.readObject();
        this.operationChanged_ = objectInputStream.readBoolean();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = super.toString();
        stringBuffer.append(string.substring(0, string.length() - 1));
        stringBuffer.append(", OPERATIONS CHANGED?=");
        stringBuffer.append(this.isOperationChanged());
        stringBuffer.append(", OPERATIONS=");
        SMDBObject.arrayToStringBuffer(this.taskOperations_, stringBuffer);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public void validate() throws IllegalArgumentException {
        this.validate(Locale.getDefault());
    }

    public void validate(Locale locale) throws IllegalArgumentException {
        if (this.name_ == null || this.name_.trim().equals("") || SMUtility.validate(this.name_) >= 0) {
            throw new IllegalArgumentException(SMUtility.getClientMessage(locale, "TaskRequest.InvalidTaskName"));
        }
        if (this.taskOperations_ == null) {
            throw new IllegalArgumentException(SMUtility.getClientMessage(locale, "TaskRequest.InvalidOperation"));
        }
    }
}

