/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.client.task;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMMessageI18nKey;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.log.SMLogReader;
import com.sun.symon.base.client.service.SMDBObject;
import com.sun.symon.base.client.service.SMDBObjectID;
import com.sun.symon.base.client.service.SMDatabaseException;
import com.sun.symon.base.client.service.SMDuplicateException;
import com.sun.symon.base.client.service.SMHandle;
import com.sun.symon.base.client.service.SMNoSuchObjectException;
import com.sun.symon.base.client.service.SMSecurityException;
import com.sun.symon.base.client.service.SMStaleDataException;
import com.sun.symon.base.client.service.SMWrongTypeException;
import com.sun.symon.base.client.task.SMRemoteTask;
import com.sun.symon.base.client.task.SMTaskData;
import com.sun.symon.base.client.task.SMTaskInfo;
import com.sun.symon.base.client.task.SMTaskType;
import java.rmi.RemoteException;
import java.util.Vector;

public class SMTask
extends SMHandle {
    private SMRemoteTask stub_;
    private static String i18nBase_ = "com.sun.symon.base.client.ClientApiMessages";
    private boolean getHiddenTasks_ = false;
    private boolean getHiddenTaskTypes_ = false;
    private SMTaskType[] types_ = null;

    public SMTask(SMRawDataRequest sMRawDataRequest) throws SMAPIException {
        this(sMRawDataRequest, false);
    }

    public SMTask(SMRawDataRequest sMRawDataRequest, boolean bl) throws SMAPIException {
        this(sMRawDataRequest, bl, false);
    }

    public SMTask(SMRawDataRequest sMRawDataRequest, boolean bl, boolean bl2) throws SMAPIException {
        super(sMRawDataRequest);
        this.getHiddenTasks_ = bl;
        this.getHiddenTaskTypes_ = bl2;
        this.stub_ = (SMRemoteTask)sMRawDataRequest.getService("Task_Task", null);
        this.setHandle(this.stub_);
        if (this.stub_ == null) {
            SMMessageI18nKey sMMessageI18nKey = new SMMessageI18nKey(i18nBase_, "stubIsNull");
            throw new SMAPIException("stub_ is null-getService failed", sMMessageI18nKey);
        }
    }

    public void close() throws SMAPIException {
        try {
            super.close();
            this.stub_.close();
            this.stub_ = null;
        }
        catch (RemoteException remoteException) {
            SMMessageI18nKey sMMessageI18nKey = new SMMessageI18nKey(i18nBase_, "smApiException");
            throw new SMAPIException(remoteException, sMMessageI18nKey);
        }
    }

    public SMTaskInfo[] getAll() throws SMAPIException, SMSecurityException, SMDatabaseException {
        try {
            return this.filterHidden(this.stub_.getAll());
        }
        catch (RemoteException remoteException) {
            SMMessageI18nKey sMMessageI18nKey = new SMMessageI18nKey(i18nBase_, "remoteException");
            throw new SMAPIException(remoteException, sMMessageI18nKey);
        }
    }

    public SMTaskInfo[] getAll(String string) throws SMAPIException, SMSecurityException, SMDatabaseException {
        try {
            return this.filterHidden(this.stub_.getAll(string));
        }
        catch (RemoteException remoteException) {
            SMMessageI18nKey sMMessageI18nKey = new SMMessageI18nKey(i18nBase_, "remoteException");
            throw new SMAPIException(remoteException, sMMessageI18nKey);
        }
    }

    public SMTaskInfo[] getAll(int n) throws SMAPIException, SMSecurityException, SMDatabaseException {
        return this.getAll(n + "");
    }

    public SMTaskInfo loadInfo(SMDBObjectID sMDBObjectID) throws SMAPIException, SMSecurityException, SMNoSuchObjectException, SMDatabaseException {
        try {
            return this.stub_.loadInfo(sMDBObjectID);
        }
        catch (RemoteException remoteException) {
            SMMessageI18nKey sMMessageI18nKey = new SMMessageI18nKey(i18nBase_, "remoteException");
            throw new SMAPIException(remoteException, sMMessageI18nKey);
        }
    }

    public SMTaskData load(SMDBObjectID sMDBObjectID) throws SMAPIException, SMSecurityException, SMNoSuchObjectException, SMDatabaseException {
        try {
            return this.stub_.load(sMDBObjectID);
        }
        catch (RemoteException remoteException) {
            SMMessageI18nKey sMMessageI18nKey = new SMMessageI18nKey(i18nBase_, "remoteException");
            throw new SMAPIException(remoteException, sMMessageI18nKey);
        }
    }

    public SMTaskData load(String string) throws SMAPIException, SMSecurityException, SMNoSuchObjectException, SMDatabaseException {
        try {
            return this.stub_.load(string);
        }
        catch (RemoteException remoteException) {
            SMMessageI18nKey sMMessageI18nKey = new SMMessageI18nKey(i18nBase_, "remoteException");
            throw new SMAPIException(remoteException, sMMessageI18nKey);
        }
    }

    public SMTaskData load(SMTaskInfo sMTaskInfo) throws SMAPIException, SMSecurityException, SMNoSuchObjectException, SMDatabaseException {
        try {
            return this.stub_.load(sMTaskInfo.getObjectID());
        }
        catch (RemoteException remoteException) {
            SMMessageI18nKey sMMessageI18nKey = new SMMessageI18nKey(i18nBase_, "remoteException");
            throw new SMAPIException(remoteException, sMMessageI18nKey);
        }
    }

    public SMDBObjectID save(SMTaskData sMTaskData) throws SMAPIException, SMSecurityException, SMStaleDataException, SMNoSuchObjectException, SMDatabaseException, SMDuplicateException {
        if (!sMTaskData.isChanged()) {
            return sMTaskData.getObjectID();
        }
        try {
            sMTaskData.validate(this.locale);
            SMDBObject sMDBObject = this.stub_.save(sMTaskData);
            sMTaskData.refresh(sMDBObject);
            return sMDBObject.getObjectID();
        }
        catch (Exception exception) {
            if (exception instanceof SMAPIException) {
                throw (SMAPIException)exception;
            }
            SMMessageI18nKey sMMessageI18nKey = new SMMessageI18nKey(i18nBase_, "smApiException");
            throw new SMAPIException(exception.getMessage(), sMMessageI18nKey);
        }
    }

    public SMTaskData saveAs(SMTaskData sMTaskData, String string) throws SMSecurityException, SMDuplicateException, SMDatabaseException, SMAPIException {
        SMTaskData sMTaskData2 = (SMTaskData)sMTaskData.clone();
        sMTaskData2.setName(string);
        this.save(sMTaskData2);
        return sMTaskData2;
    }

    public SMTaskData saveAs(SMTaskData sMTaskData, String string, boolean bl) throws SMAPIException, SMSecurityException, SMSecurityException, SMStaleDataException, SMNoSuchObjectException, SMDatabaseException, SMDuplicateException {
        return this.saveAs(sMTaskData, string);
    }

    public void delete(SMDBObjectID sMDBObjectID) throws SMAPIException, SMSecurityException, SMDatabaseException, SMNoSuchObjectException {
        try {
            this.stub_.delete(sMDBObjectID);
        }
        catch (RemoteException remoteException) {
            SMMessageI18nKey sMMessageI18nKey = new SMMessageI18nKey(i18nBase_, "remoteException");
            throw new SMAPIException(remoteException, sMMessageI18nKey);
        }
    }

    public void delete(SMTaskInfo sMTaskInfo) throws SMAPIException, SMSecurityException, SMDatabaseException, SMNoSuchObjectException {
        try {
            this.stub_.delete(sMTaskInfo.getObjectID());
        }
        catch (RemoteException remoteException) {
            SMMessageI18nKey sMMessageI18nKey = new SMMessageI18nKey(i18nBase_, "remoteException");
            throw new SMAPIException(remoteException, sMMessageI18nKey);
        }
    }

    public SMLogReader getLogReader() throws SMAPIException {
        try {
            return new SMLogReader(this.stub_.getLogReader("taskreq"));
        }
        catch (Exception exception) {
            SMMessageI18nKey sMMessageI18nKey = new SMMessageI18nKey(i18nBase_, "remoteException");
            throw new SMAPIException(exception, sMMessageI18nKey);
        }
    }

    public SMDBObject loadInfoObj(SMDBObjectID sMDBObjectID) throws SMAPIException, SMDatabaseException, SMSecurityException {
        return this.loadInfo(sMDBObjectID);
    }

    public SMDBObject loadObj(SMDBObjectID sMDBObjectID) throws SMAPIException, SMDatabaseException, SMSecurityException {
        return this.load(sMDBObjectID);
    }

    public SMDBObjectID saveObj(SMDBObject sMDBObject) throws SMAPIException, SMDatabaseException, SMSecurityException, SMWrongTypeException {
        if (!(sMDBObject instanceof SMTaskData)) {
            SMWrongTypeException sMWrongTypeException = new SMWrongTypeException();
            SMMessageI18nKey sMMessageI18nKey = new SMMessageI18nKey(i18nBase_, "wrongDataTypeException");
            sMWrongTypeException.setMessageI18nKey(sMMessageI18nKey);
            throw sMWrongTypeException;
        }
        return this.save((SMTaskData)sMDBObject);
    }

    public SMDBObject saveAsObj(SMDBObject sMDBObject, String string) throws SMAPIException, SMDatabaseException, SMSecurityException, SMWrongTypeException {
        if (!(sMDBObject instanceof SMTaskData)) {
            SMWrongTypeException sMWrongTypeException = new SMWrongTypeException();
            SMMessageI18nKey sMMessageI18nKey = new SMMessageI18nKey(i18nBase_, "wrongDataTypeException");
            sMWrongTypeException.setMessageI18nKey(sMMessageI18nKey);
            throw sMWrongTypeException;
        }
        return this.saveAs((SMTaskData)sMDBObject, string);
    }

    public SMDBObject loadObj(String string) throws SMAPIException, SMSecurityException, SMNoSuchObjectException, SMDatabaseException {
        return this.load(string);
    }

    public SMDBObject[] getAllObjs() throws SMAPIException, SMSecurityException, SMDatabaseException {
        return this.getAll();
    }

    public SMTaskType[] getTaskTypes() throws SMAPIException, SMSecurityException {
        return this.getTaskTypes(false);
    }

    private SMTaskType[] getTaskTypes(boolean bl) throws SMAPIException, SMSecurityException {
        try {
            this.types_ = this.stub_.getTaskTypes();
            if (bl) {
                return this.types_;
            }
            Vector<SMTaskType> vector = new Vector<SMTaskType>();
            int n = 0;
            while (n < this.types_.length) {
                if (!this.types_[n].isHidden()) {
                    vector.addElement(this.types_[n]);
                }
                ++n;
            }
            Object[] objectArray = new SMTaskType[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        catch (Exception exception) {
            System.out.println(exception);
            return SMTask.getStaticTaskTypes();
        }
    }

    public static SMTaskType[] getStaticTaskTypes() {
        SMTaskType[] sMTaskTypeArray = new SMTaskType[3];
        boolean bl = false;
        sMTaskTypeArray[0] = new SMTaskType("Core_Module", "com.sun.symon.base.console.grouping.GroupingMessages:task.moduleType", bl);
        sMTaskTypeArray[0].setPresentationClass("console", "com.sun.symon.base.console.grouping.aggregate.CgModuleTaskEditorFactory");
        sMTaskTypeArray[0].setLogPresentationClass("console", "com.sun.symon.base.console.grouping.aggregate.CgModuleLogFactory");
        sMTaskTypeArray[1] = new SMTaskType("Core_DataProperty", "com.sun.symon.base.console.grouping.GroupingMessages:task.propertyType", bl);
        sMTaskTypeArray[1].setPresentationClass("console", "com.sun.symon.base.console.grouping.aggregate.CgPropertyTaskEditorFactory");
        sMTaskTypeArray[1].setLogPresentationClass("console", "com.sun.symon.base.console.grouping.aggregate.CgPropertyLogFactory");
        sMTaskTypeArray[2] = new SMTaskType("Core_Table", "com.sun.symon.base.console.grouping.GroupingMessages:task.tableType", bl);
        sMTaskTypeArray[2].setPresentationClass("console", "com.sun.symon.base.console.grouping.aggregate.CgTableTaskEditorFactory");
        sMTaskTypeArray[2].setLogPresentationClass("console", "com.sun.symon.base.console.grouping.aggregate.CgTableLogFactory");
        return sMTaskTypeArray;
    }

    public boolean isHiddenObject(SMTaskInfo sMTaskInfo) {
        if (sMTaskInfo.getName() == null) {
            return true;
        }
        if (!this.getHiddenTasks_ && sMTaskInfo.getName().startsWith("_")) {
            return true;
        }
        return !this.getHiddenTaskTypes_ && this.isHiddenTaskType(sMTaskInfo.getTaskTypeString());
    }

    public boolean isHiddenTaskType(String string) {
        try {
            if (this.types_ == null) {
                this.types_ = this.getTaskTypes(true);
            }
        }
        catch (Exception exception) {
            this.types_ = SMTask.getStaticTaskTypes();
        }
        int n = 0;
        while (n < this.types_.length) {
            if (this.types_[n].getTaskTypeString().equals(string)) {
                return this.types_[n].isHidden();
            }
            ++n;
        }
        return false;
    }

    private SMTaskInfo[] filterHidden(SMTaskInfo[] sMTaskInfoArray) {
        if (this.getHiddenTasks_ && this.getHiddenTaskTypes_) {
            return sMTaskInfoArray;
        }
        Vector<SMTaskInfo> vector = new Vector<SMTaskInfo>();
        int n = 0;
        while (n < sMTaskInfoArray.length) {
            if (!this.isHiddenObject(sMTaskInfoArray[n])) {
                vector.addElement(sMTaskInfoArray[n]);
            }
            ++n;
        }
        Object[] objectArray = new SMTaskInfo[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }
}

