/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.client.table;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.SMRawDataResponse;
import com.sun.symon.base.client.SMResourceAccess;
import com.sun.symon.base.client.table.SMTableColumnFormatInfo;
import com.sun.symon.base.client.table.SMTableFieldTxltr;
import com.sun.symon.base.client.table.SMTableLayoutTxltr;
import com.sun.symon.base.client.table.SMTablePageRequest;
import com.sun.symon.base.client.table.SMTableResponse;
import com.sun.symon.base.client.table.SMTableStatusTxltr;
import com.sun.symon.base.server.types.StObject;
import com.sun.symon.base.utility.UcDDL;
import com.sun.symon.base.utility.UcInternationalizer;
import com.sun.symon.base.utility.UcListUtil;
import java.util.Locale;
import java.util.Vector;

public class SMTableRequest {
    private SMRawDataRequest handle;
    private SMResourceAccess resourceAcc;
    private Locale locale;
    public static final String ALLROWS = "ALL";
    public static final String NONFILTER = "STATE=000000";

    public SMTableRequest(SMRawDataRequest sMRawDataRequest) {
        this.handle = sMRawDataRequest;
        this.resourceAcc = new SMResourceAccess(sMRawDataRequest);
        this.locale = sMRawDataRequest.getLocale();
    }

    public static String createFilter(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("STATE=");
        if (bl) {
            stringBuffer.append("1");
        } else {
            stringBuffer.append("0");
        }
        if (bl2) {
            stringBuffer.append("1");
        } else {
            stringBuffer.append("0");
        }
        if (bl3) {
            stringBuffer.append("1");
        } else {
            stringBuffer.append("0");
        }
        if (bl4) {
            stringBuffer.append("1");
        } else {
            stringBuffer.append("0");
        }
        if (bl5) {
            stringBuffer.append("1");
        } else {
            stringBuffer.append("0");
        }
        if (bl6) {
            stringBuffer.append("1");
        } else {
            stringBuffer.append("0");
        }
        return stringBuffer.toString();
    }

    public Object getTableAlarmStatusRequest(String[] stringArray, boolean bl, String string, SMTableResponse sMTableResponse, Object object) throws SMAPIException {
        return this.handle.getURLValue(stringArray, string, (SMRawDataResponse)new SMTableStatusTxltr(sMTableResponse, bl, this.locale), object);
    }

    public Object getTableAlarmStatusRequest(String[] stringArray, boolean bl, String string, String string2, SMTableResponse sMTableResponse, Object object) throws SMAPIException {
        if (stringArray == null) {
            return null;
        }
        if (string == null || string.length() == 0 || string.equals(NONFILTER)) {
            return this.getTableAlarmStatusRequest(stringArray, bl, string2, sMTableResponse, object);
        }
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray2[n] = SMRawDataRequest.buildShadowURL(stringArray[n], "tableindstatus", null, string);
            ++n;
        }
        return this.getTableAlarmStatusRequest(stringArray2, bl, string2, sMTableResponse, object);
    }

    public Object getTableFieldRequest(String[] stringArray, boolean bl, String string, SMTableResponse sMTableResponse, Object object) throws SMAPIException {
        return this.handle.getURLValue(stringArray, string, (SMRawDataResponse)new SMTableFieldTxltr(sMTableResponse, bl, this.locale), object);
    }

    public Object getTableFieldRequest(String[] stringArray, boolean bl, String string, String string2, SMTableResponse sMTableResponse, Object object) throws SMAPIException {
        if (stringArray == null) {
            return null;
        }
        if (string == null || string.length() == 0 || string.equals(NONFILTER)) {
            return this.getTableAlarmStatusRequest(stringArray, bl, string2, sMTableResponse, object);
        }
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray2[n] = SMRawDataRequest.buildShadowURL(stringArray[n], null, null, string);
            ++n;
        }
        return this.getTableFieldRequest(stringArray2, bl, string2, sMTableResponse, object);
    }

    public Object getTableLayoutRequest(String string, SMTableResponse sMTableResponse, Object object) throws SMAPIException {
        String[] stringArray = new String[]{SMRawDataRequest.buildShadowURL(string, "tabledetail", null)};
        return this.handle.getURLValue(stringArray, null, (SMRawDataResponse)new SMTableLayoutTxltr(sMTableResponse, this.resourceAcc), object);
    }

    public int getTableDepth(String string) {
        return this.getTableDepth(string, null);
    }

    public int getTableDepth(String string, String string2) {
        if (string == null) {
            return 0;
        }
        boolean bl = false;
        if (string2 != null && string2.length() != 0 && !string2.equals(NONFILTER)) {
            bl = true;
        }
        String string3 = null;
        if (bl) {
            string3 = "index";
        }
        String[] stringArray = new String[]{SMRawDataRequest.buildShadowURL(string, "tabledepth", string3, string2)};
        try {
            StObject[][] stObjectArray = this.handle.getURLValue(stringArray);
            String string4 = stObjectArray[0][0].toString();
            return Integer.parseInt(string4);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public SMTablePageRequest getTablePageRequest(String[] stringArray, String[] stringArray2, int n) throws SMAPIException {
        return new SMTablePageRequest(this.handle, stringArray, stringArray2, n);
    }

    public SMTablePageRequest getTablePageRequest(String[] stringArray, String[] stringArray2, int n, String string) throws SMAPIException {
        if (stringArray == null || stringArray.length == 0) {
            throw new SMAPIException(UcInternationalizer.translateKey((Locale)this.locale, (String)"base.client.ClientApiMessages:TableRequest.InvalidTableRequest"));
        }
        if (!this.handle.isAgentVersionNotLower(stringArray[0], "3.0")) {
            UcDDL.logErrorMessage((String)("table filtering ---" + UcInternationalizer.translateKey((Locale)this.locale, (String)"base.client.ClientApiMessages:RawDataRequest.UnSupportedFunction")));
            return new SMTablePageRequest(this.handle, stringArray, stringArray2, n);
        }
        return new SMTablePageRequest(this.handle, stringArray, stringArray2, n, string);
    }

    public boolean isLargeTableSupported(String string) {
        try {
            return this.handle.isAgentVersionNotLower(string, "2.1.1");
        }
        catch (Exception exception) {
            return false;
        }
    }

    public SMTableColumnFormatInfo[] getTableColumnFormat(String string) throws SMAPIException {
        if (!this.handle.isAgentVersionNotLower(string, "3.0")) {
            return new SMTableColumnFormatInfo[0];
        }
        String[] stringArray = new String[]{SMRawDataRequest.buildShadowURL(string, "tablesimpleformat", null)};
        StObject[][] stObjectArray = this.handle.getURLValue(stringArray);
        Vector vector = new Vector();
        UcListUtil.decomposeList((String)stObjectArray[0][0].toString(), vector);
        SMTableColumnFormatInfo[] sMTableColumnFormatInfoArray = new SMTableColumnFormatInfo[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            String string2 = (String)vector.elementAt(n);
            Vector vector2 = new Vector();
            UcListUtil.decomposeList((String)string2, vector2);
            if (vector2.size() != 3) {
                throw new SMAPIException(UcInternationalizer.translateKey((Locale)this.locale, (String)"base.client.ClientApiMessages:TableRequest.InvalidColumnLayoutReturnData"));
            }
            sMTableColumnFormatInfoArray[n] = new SMTableColumnFormatInfo((String)vector2.elementAt(0), (String)vector2.elementAt(1), (String)vector2.elementAt(2), this.locale);
            ++n;
        }
        return sMTableColumnFormatInfoArray;
    }

    public void setColumnData(String string, String string2, StObject stObject) throws SMAPIException {
        if (!this.handle.isAgentVersionNotLower(string, "3.0")) {
            UcDDL.logErrorMessage((String)("set table column ---" + UcInternationalizer.translateKey((Locale)this.locale, (String)"base.client.ClientApiMessages:RawDataRequest.UnSupportedFunction")));
            return;
        }
        String string3 = SMRawDataRequest.buildShadowURL(string, string2, null, ALLROWS);
        String[] stringArray = new String[]{string3};
        StObject[][] stObjectArray = new StObject[1][1];
        stObjectArray[0][0] = stObject;
        this.handle.setURLValue(stringArray, stObjectArray);
    }
}

