/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.client.probe;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.probe.SMProbeListener;
import com.sun.symon.base.server.common.ScBaseProbeImpl;
import com.sun.symon.base.server.common.ScProbeListener;
import com.sun.symon.base.server.receptors.rmi.RMIProbeInterface;
import com.sun.symon.base.server.receptors.rmi.RMIProbeListener;
import com.sun.symon.base.utility.UcDDL;
import com.sun.symon.base.utility.UcURL;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ResourceBundle;

public class SMProbeConnection {
    private SMRawDataRequest handle;
    private RMIProbeInterface pHandle;
    private ScBaseProbeImpl localProbeHandle;
    private RMIProbeListener innerCallback;
    private RMIProbeListener innerCallbackStdErr;
    private SMProbeListener externalCallback;
    private SMProbeListener externalCallbackStdErr;
    private ScProbeListener localProbecallback;
    private static String[] dummyArgs = new String[0];
    boolean isConnected;
    String host;
    int port;
    String password;
    private ResourceBundle bundle;
    private boolean isLocal;
    private String basePropFile;

    public SMProbeConnection(SMRawDataRequest sMRawDataRequest, SMProbeListener sMProbeListener) throws SMAPIException {
        this(sMRawDataRequest);
        this.externalCallback = sMProbeListener;
    }

    public SMProbeConnection(SMRawDataRequest sMRawDataRequest, SMProbeListener sMProbeListener, SMProbeListener sMProbeListener2) throws SMAPIException {
        this(sMRawDataRequest);
        this.externalCallback = sMProbeListener;
        this.externalCallbackStdErr = sMProbeListener2;
    }

    public SMProbeConnection(SMRawDataRequest sMRawDataRequest) throws SMAPIException {
        block5: {
            this.isConnected = false;
            this.isLocal = false;
            this.basePropFile = "com.sun.symon.base.client.ClientApiMessages";
            try {
                this.handle = sMRawDataRequest;
                this.bundle = sMRawDataRequest.getResourceBundle();
                this.isLocal = sMRawDataRequest.getLocal();
                if (!this.isLocal) {
                    this.pHandle = sMRawDataRequest.getProbeService();
                } else {
                    this.localProbeHandle = new ScBaseProbeImpl();
                }
                this.isConnected = false;
            }
            catch (Throwable throwable) {
                if (throwable instanceof RemoteException) {
                    throw new SMAPIException(throwable.getMessage());
                }
                if (!(throwable instanceof SMAPIException)) break block5;
                throw (SMAPIException)throwable;
            }
        }
    }

    public void setResponse(SMProbeListener sMProbeListener) {
        this.externalCallback = sMProbeListener;
    }

    public void setResponseStdErr(SMProbeListener sMProbeListener) {
        this.externalCallbackStdErr = sMProbeListener;
    }

    public void connectWithErr(String string, String[] stringArray) throws SMAPIException {
        UcURL ucURL = new UcURL(string);
        String string2 = ucURL.getHost();
        String string3 = ucURL.getPort();
        try {
            String string4 = this.handle.getProbeErrCookie(string, stringArray);
            this.parseResponse(string4);
            if (!this.isLocal) {
                this.innerCallback = new ProbeCallback(false);
                this.innerCallbackStdErr = new ProbeCallback(true);
                this.pHandle.connectWithErr(this.host + ":" + string3, this.port, this.password, this.innerCallback, this.innerCallbackStdErr);
            } else {
                this.localProbeHandle.connectWithErr(this.host + ":" + string3, this.port, this.password, (ScProbeListener)new LocalProbeCallback(false), (ScProbeListener)new LocalProbeCallback(true));
            }
            this.isConnected = true;
        }
        catch (Throwable throwable) {
            try {
                if (!this.isLocal) {
                    this.innerCallback = new ProbeCallback(false);
                    this.innerCallbackStdErr = new ProbeCallback(true);
                    this.pHandle.connectWithErr(string2 + ":" + string3, this.port, this.password, this.innerCallback, this.innerCallbackStdErr);
                } else {
                    this.localProbeHandle.connectWithErr(this.host + ":" + string3, this.port, this.password, (ScProbeListener)new LocalProbeCallback(false), (ScProbeListener)new LocalProbeCallback(true));
                }
                this.isConnected = true;
            }
            catch (Exception exception) {
                String string5 = this.bundle.getString("ProbeConnection.ConnectionNotAvailable");
                UcDDL.logInfoMessage((String)(string5 + string));
                throw new SMAPIException(exception.getMessage());
            }
        }
    }

    public void startReader() throws SMAPIException {
        try {
            if (!this.isLocal) {
                this.pHandle.startReader();
            } else {
                this.localProbeHandle.startReader();
            }
        }
        catch (Throwable throwable) {
            String string = this.bundle.getString("ProbeConnection.CouldNotStartReader");
            UcDDL.logInfoMessage((String)string, (Throwable)throwable);
            throw new SMAPIException(string, throwable);
        }
    }

    public void stopReader() throws SMAPIException {
        try {
            if (!this.isLocal) {
                this.pHandle.stopReader();
            } else {
                this.localProbeHandle.stopReader();
            }
        }
        catch (Exception exception) {
            String string = this.bundle.getString("Exception while stopping the reader.");
            UcDDL.logDebugMessage((String)string, (Throwable)exception);
            throw new SMAPIException(string, exception);
        }
    }

    private void invalidFields(String string) throws SMAPIException {
        String string2 = this.bundle.getString("ProbeConnection.InvalidFieldsFromSetRequest");
        throw new SMAPIException(string2 + string);
    }

    protected void parseResponse(String string) throws SMAPIException {
        int n = string.indexOf(58);
        if (n == -1) {
            this.invalidFields(string);
        }
        this.host = string.substring(0, n);
        if (this.host.equals("Error")) {
            throw new SMAPIException(string);
        }
        int n2 = string.indexOf(58, n + 1);
        if (n2 == -1) {
            this.invalidFields(string);
        }
        this.port = 0;
        try {
            this.port = Integer.parseInt(string.substring(n + 1, n2));
        }
        catch (NumberFormatException numberFormatException) {
            this.invalidFields(string);
        }
        this.password = string.substring(n2 + 1) + "\n";
    }

    public void connect(String string, String[] stringArray) throws SMAPIException {
        UcURL ucURL = new UcURL(string);
        String string2 = ucURL.getHost();
        String string3 = ucURL.getPort();
        try {
            String string4 = this.handle.getProbeCookie(string, stringArray);
            this.parseResponse(string4);
            if (!this.isLocal) {
                this.innerCallback = new ProbeCallback(false);
                this.pHandle.connect(string2 + ":" + string3, this.port, this.password, this.innerCallback);
            } else {
                this.localProbeHandle.connect(this.host + ":" + string3, this.port, this.password, (ScProbeListener)new LocalProbeCallback(false));
            }
            this.isConnected = true;
        }
        catch (Throwable throwable) {
            try {
                if (!this.isLocal) {
                    this.innerCallback = new ProbeCallback(false);
                    this.pHandle.connect(string2 + ":" + string3, this.port, this.password, this.innerCallback);
                } else {
                    this.localProbeHandle.connect(string2 + ":" + string3, this.port, this.password, (ScProbeListener)new LocalProbeCallback(false));
                }
                this.isConnected = true;
            }
            catch (Exception exception) {
                String string5 = this.bundle.getString("ProbeConnection.ConnectionNotAvailable");
                UcDDL.logInfoMessage((String)(string5 + string));
                throw new SMAPIException(string5, throwable);
            }
        }
    }

    public void setTimeOut(int n) throws SMAPIException {
        try {
            if (!this.isLocal) {
                this.pHandle.setTimeOut(n);
            } else {
                this.localProbeHandle.setTimeOut(n);
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof SMAPIException) {
                throw (SMAPIException)throwable;
            }
            throw new SMAPIException(throwable);
        }
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public void setEndOfStream(String string) throws SMAPIException {
        try {
            if (!this.isLocal) {
                this.pHandle.setEndOfStream(string);
            } else {
                this.localProbeHandle.setEndOfStream(string);
            }
        }
        catch (RemoteException remoteException) {
            String string2 = this.bundle.getString("ProbeConnection.RemoteException");
            throw new SMAPIException(string2, remoteException);
        }
    }

    public void connect(String string) throws SMAPIException {
        this.connect(string, null);
        this.isConnected = true;
    }

    public void connectWithErr(String string) throws SMAPIException {
        this.connectWithErr(string, dummyArgs);
        this.isConnected = true;
    }

    public void readLines(int n) throws SMAPIException {
        try {
            if (!this.isConnected) {
                String string = this.bundle.getString("ProbeConnection.ReadFromUnconnected");
                UcDDL.logErrorMessage((String)string);
                throw new SMAPIException(string);
            }
            if (!this.isLocal) {
                this.pHandle.readLines(n);
            } else {
                this.localProbeHandle.readLines(n);
            }
        }
        catch (Throwable throwable) {
            String string = this.bundle.getString("ProbeConnection.ReadFailure");
            UcDDL.logErrorMessage((String)string, (Throwable)throwable);
            if (throwable instanceof SMAPIException) {
                throw (SMAPIException)throwable;
            }
            throw new SMAPIException(string, throwable);
        }
    }

    public void write2probe(String string) throws SMAPIException {
        try {
            if (!this.isConnected) {
                String string2 = this.bundle.getString("ProbeConnection.WriteToUnconnected");
                UcDDL.logErrorMessage((String)string2);
                throw new SMAPIException(string2);
            }
            if (!this.isLocal) {
                this.pHandle.write2probe(string);
            } else {
                this.localProbeHandle.write2probe(string);
            }
        }
        catch (Throwable throwable) {
            String string3 = this.bundle.getString("ProbeConnection.WriteFailure");
            UcDDL.logErrorMessage((String)string3, (Throwable)throwable);
            if (throwable instanceof SMAPIException) {
                throw (SMAPIException)throwable;
            }
            throw new SMAPIException(string3, throwable);
        }
    }

    public synchronized void close() throws SMAPIException {
        this.isConnected = false;
        try {
            if (!this.isLocal && this.pHandle != null) {
                this.pHandle.close();
                this.pHandle = null;
            } else {
                this.localProbeHandle.close();
                this.localProbeHandle = null;
            }
            if (this.externalCallback != null) {
                this.externalCallback = null;
            }
            if (this.externalCallbackStdErr != null) {
                this.externalCallbackStdErr = null;
            }
        }
        catch (Throwable throwable) {
            UcDDL.logErrorMessage((String)("Probe Close: " + throwable));
            if (throwable instanceof SMAPIException) {
                throw (SMAPIException)throwable;
            }
            throw new SMAPIException(throwable);
        }
    }

    public synchronized void closeImmediate() throws SMAPIException {
        UcDDL.logInfoMessage((String)"SMProbeConnection closeImmediate called.");
        this.isConnected = false;
        try {
            if (!this.isLocal && this.pHandle != null) {
                this.pHandle.closeImmediate();
                this.pHandle = null;
            } else {
                this.localProbeHandle.closeImmediate();
                this.localProbeHandle = null;
            }
            if (this.externalCallback != null) {
                this.externalCallback = null;
            }
            if (this.externalCallbackStdErr != null) {
                this.externalCallbackStdErr = null;
            }
        }
        catch (Throwable throwable) {
            UcDDL.logErrorMessage((String)("Probe Close: " + throwable));
            if (throwable instanceof SMAPIException) {
                throw (SMAPIException)throwable;
            }
            throw new SMAPIException(throwable);
        }
    }

    class ProbeCallback
    extends UnicastRemoteObject
    implements RMIProbeListener {
        StringBuffer sb;
        final int INITIAL_CAPACITY = 10000;
        boolean stdErr;

        ProbeCallback(boolean bl) throws RemoteException {
            this.stdErr = bl;
        }

        public void receiveBeginData() throws RemoteException {
            this.sb = new StringBuffer(10000);
        }

        public void receiveEndData() throws RemoteException {
            SMProbeListener sMProbeListener;
            SMProbeListener sMProbeListener2 = sMProbeListener = this.stdErr ? SMProbeConnection.this.externalCallbackStdErr : SMProbeConnection.this.externalCallback;
            if (sMProbeListener != null) {
                sMProbeListener.receiveData(this.sb.toString());
            } else {
                String string = SMProbeConnection.this.bundle.getString("ProbeConnection.CallbackFailure");
                UcDDL.logErrorMessage((String)string);
            }
        }

        public void receiveDataPortion(String string) throws RemoteException {
            this.sb.append(string);
        }

        public synchronized void receiveData(String string) throws RemoteException {
            SMProbeListener sMProbeListener;
            SMProbeListener sMProbeListener2 = sMProbeListener = this.stdErr ? SMProbeConnection.this.externalCallbackStdErr : SMProbeConnection.this.externalCallback;
            if (sMProbeListener != null) {
                sMProbeListener.receiveData(string);
            } else {
                String string2 = SMProbeConnection.this.bundle.getString("ProbeConnection.CallbackFailure");
                UcDDL.logErrorMessage((String)string2);
            }
        }

        public void receiveException(SMAPIException sMAPIException) throws RemoteException {
            SMProbeListener sMProbeListener;
            if (!SMProbeConnection.this.isConnected) {
                return;
            }
            SMProbeListener sMProbeListener2 = sMProbeListener = this.stdErr ? SMProbeConnection.this.externalCallbackStdErr : SMProbeConnection.this.externalCallback;
            if (sMProbeListener != null) {
                sMProbeListener.receiveException(sMAPIException);
            } else {
                String string = SMProbeConnection.this.bundle.getString("ProbeConnection.CallbackFailure");
                UcDDL.logErrorMessage((String)(string + sMAPIException));
            }
        }
    }

    class LocalProbeCallback
    implements ScProbeListener {
        StringBuffer sb;
        final int INITIAL_CAPACITY = 10000;
        boolean stdErr;

        LocalProbeCallback(boolean bl) {
            this.stdErr = bl;
        }

        public void receiveBeginData() {
            this.sb = new StringBuffer(10000);
        }

        public void receiveEndData() {
            SMProbeListener sMProbeListener;
            SMProbeListener sMProbeListener2 = sMProbeListener = this.stdErr ? SMProbeConnection.this.externalCallbackStdErr : SMProbeConnection.this.externalCallback;
            if (sMProbeListener != null) {
                sMProbeListener.receiveData(this.sb.toString());
            } else {
                String string = SMProbeConnection.this.bundle.getString("ProbeConnection.CallbackFailure");
                UcDDL.logErrorMessage((String)string);
            }
        }

        public void receiveDataPortion(String string) {
            this.sb.append(string);
        }

        public synchronized void receiveData(String string) {
            SMProbeListener sMProbeListener;
            SMProbeListener sMProbeListener2 = sMProbeListener = this.stdErr ? SMProbeConnection.this.externalCallbackStdErr : SMProbeConnection.this.externalCallback;
            if (sMProbeListener != null) {
                sMProbeListener.receiveData(string);
            } else {
                String string2 = SMProbeConnection.this.bundle.getString("ProbeConnection.CallbackFailure");
                UcDDL.logErrorMessage((String)string2);
            }
        }

        public void receiveException(SMAPIException sMAPIException) {
            SMProbeListener sMProbeListener;
            if (!SMProbeConnection.this.isConnected) {
                return;
            }
            SMProbeListener sMProbeListener2 = sMProbeListener = this.stdErr ? SMProbeConnection.this.externalCallbackStdErr : SMProbeConnection.this.externalCallback;
            if (sMProbeListener != null) {
                sMProbeListener.receiveException(sMAPIException);
            } else {
                String string = SMProbeConnection.this.bundle.getString("ProbeConnection.CallbackFailure" + sMAPIException);
                UcDDL.logErrorMessage((String)string);
            }
        }
    }
}

