/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.client.log;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.log.LogAsyncProbe;
import com.sun.symon.base.client.log.LogSyncProbe;
import com.sun.symon.base.client.log.SMLogViewerResponse;
import com.sun.symon.base.server.types.StObject;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class SMLogViewerRequest {
    protected SMRawDataRequest handle;
    private LogSyncProbe syncProbe;
    private LogAsyncProbe asyncProbe;
    private ResourceBundle rbundle;
    private Locale locale;
    private String agentHostName = null;
    private int agentPort = 0;
    private boolean isAgent3OrLater = true;
    private String probeURL = null;
    public static final String SYSLOG = "syslog";
    public static final String SUNMCLOG = "sunmclog";
    public static String END_OF_STREAM = "LGSCNEOM";
    public static final String OTHERFILE = "otherfile";

    public SMLogViewerRequest(SMRawDataRequest sMRawDataRequest, String string, int n) throws SMAPIException {
        this.handle = sMRawDataRequest;
        this.agentPort = n == 0 ? 161 : n;
        this.agentHostName = string;
        this.probeURL = "snmp://" + string + ":" + n + "/mod/tools-adhocs/admins?runadhoccommand.logscan";
        this.syncProbe = new LogSyncProbe(this);
        this.syncProbe.setEndOfStream(END_OF_STREAM);
        this.syncProbe.connect(this.probeURL);
        this.syncProbe.close();
        this.syncProbe = null;
        this.isAgent3OrLater = sMRawDataRequest.isAgentVersionNotLower(string, n, "3.0");
        this.rbundle = this.handle.getResourceBundle();
        this.locale = this.handle.getLocale();
    }

    public String[] getSunMCLogList() throws SMAPIException {
        String[] stringArray;
        if (!this.isAgent3OrLater) {
            return new String[0];
        }
        String string = "sunmclogfiles";
        String string2 = "snmp://" + this.agentHostName + ":" + this.agentPort + "/sym/base/info.agent.fileinfo.sunmclogfiles#0";
        String[] stringArray2 = new String[]{string2};
        StObject[][] stObjectArray = this.handle.getURLValue(stringArray2);
        Vector<String[]> vector = new Vector<String[]>();
        String string3 = stObjectArray[0][0].toString();
        StringTokenizer stringTokenizer = new StringTokenizer(string3, " ");
        while (stringTokenizer.hasMoreTokens()) {
            stringArray = stringTokenizer.nextToken();
            vector.addElement(stringArray);
        }
        stringArray = new String[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            stringArray[n] = (String)vector.elementAt(n);
            ++n;
        }
        return stringArray;
    }

    public synchronized String[] getOtherFileList() throws SMAPIException {
        if (!this.isAgent3OrLater) {
            return new String[0];
        }
        if (this.syncProbe == null) {
            this.syncProbe = new LogSyncProbe(this);
            this.syncProbe.setEndOfStream(END_OF_STREAM);
        }
        if (!this.syncProbe.isConnected()) {
            this.syncProbe.connect(this.probeURL);
        }
        this.syncProbe.writeAndWait("LS_GETFILELIST");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.syncProbe.getData());
        this.syncProbe.close();
        this.syncProbe = null;
        if (stringBuffer.length() == 0) {
            return null;
        }
        int n = stringBuffer.toString().getBytes().length;
        byte[] byArray = new byte[n];
        byte[] byArray2 = new byte[n];
        System.arraycopy(stringBuffer.substring(0, stringBuffer.length()).getBytes(), 0, byArray, 0, n);
        String string = new String(byArray, 0, 8);
        int n2 = Integer.parseInt(string, 16);
        String[] stringArray = new String[n2];
        int n3 = 8;
        boolean bl = false;
        int n4 = 0;
        while (n4 < n2) {
            String string2 = new String(byArray, n3, 8);
            int n5 = Integer.parseInt(string2, 16);
            stringArray[n4] = new String(byArray, n3 += 8, n5);
            n3 += n5;
            ++n4;
        }
        return stringArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized StringBuffer logSearch(String string, String string2, int n, int n2, long l, long l2, boolean bl, String string3, int n3) throws SMAPIException {
        if (!this.isAgent3OrLater) {
            if (string.compareToIgnoreCase(SYSLOG) != 0) throw new SMAPIException(this.rbundle.getString("LogViewerRequest.UnknownFiletypeProvided"));
            string = SYSLOG;
        } else if (string.compareToIgnoreCase(SYSLOG) == 0) {
            string = SYSLOG;
        } else if (string.compareToIgnoreCase(SUNMCLOG) == 0) {
            string = SUNMCLOG;
        } else {
            if (string.compareToIgnoreCase(OTHERFILE) != 0) throw new SMAPIException(this.rbundle.getString("LogViewerRequest.UnknownFiletypeProvided"));
            string = OTHERFILE;
        }
        if (this.syncProbe == null) {
            this.syncProbe = new LogSyncProbe(this);
        }
        this.syncProbe.setEndOfStream(END_OF_STREAM);
        if (!this.syncProbe.isConnected()) {
            this.syncProbe.connect(this.probeURL);
        }
        if (n == 0) {
            n = 100;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (l < 0L) {
            l = 0L;
        }
        if (l2 < 0L) {
            l2 = 0L;
        }
        int n4 = bl ? 1 : 0;
        if (string3 == null) {
            string3 = "";
        }
        String string4 = "LS_SEARCH " + n + " 0 " + l + " " + l2 + " " + n4 + " " + n2 + " {" + string3 + "} {" + string + "}";
        if (this.isAgent3OrLater) {
            string4 = string4 + " {" + string2 + "}";
        }
        this.syncProbe.writeAndWait(string4);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.syncProbe.getData());
        this.syncProbe.close();
        this.syncProbe = null;
        if (stringBuffer.length() == 0) {
            return null;
        }
        int n5 = stringBuffer.toString().getBytes().length;
        byte[] byArray = new byte[n5];
        byte[] byArray2 = new byte[n5];
        System.arraycopy(stringBuffer.substring(0, stringBuffer.length()).getBytes(), 0, byArray, 0, n5);
        String string5 = new String(byArray, 0, 8);
        int n6 = Integer.parseInt(string5, 16);
        int n7 = 8;
        int n8 = 0;
        int n9 = 0;
        while (n9 < n6) {
            String string6 = new String(byArray, n7, 8);
            int n10 = Integer.parseInt(string6, 16);
            System.arraycopy(byArray, n7 += 8, byArray2, n8, n10);
            n7 += n10;
            byArray2[n8 += n10] = 10;
            ++n8;
            ++n9;
        }
        if (n8 == 0) {
            return null;
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(new String(byArray2, 0, n8));
        return stringBuffer2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void logSearch(String string, String string2, String string3, SMLogViewerResponse sMLogViewerResponse, Object object) throws SMAPIException {
        if (!this.isAgent3OrLater) {
            if (string.compareToIgnoreCase(SYSLOG) != 0) throw new SMAPIException(this.rbundle.getString("LogViewerRequest.UnknownFiletypeProvided"));
            string = SYSLOG;
        } else if (string.compareToIgnoreCase(SYSLOG) == 0) {
            string = SYSLOG;
        } else if (string.compareToIgnoreCase(SUNMCLOG) == 0) {
            string = SUNMCLOG;
        } else {
            if (string.compareToIgnoreCase(OTHERFILE) != 0) throw new SMAPIException(this.rbundle.getString("LogViewerRequest.UnknownFiletypeProvided"));
            string = OTHERFILE;
        }
        if (this.asyncProbe != null) {
            this.asyncProbe.close();
        }
        this.asyncProbe = new LogAsyncProbe(this, sMLogViewerResponse, object);
        this.asyncProbe.connect(this.probeURL);
        int n = 100;
        int n2 = 1;
        if (string3 == null) {
            string3 = "";
        }
        String string4 = "LS_SEARCH " + n + " 1 0 0 " + n2 + " 0 {" + string3 + "} {" + string + "}";
        if (this.isAgent3OrLater) {
            string4 = string4 + " {" + string2 + "}";
        }
        this.asyncProbe.setTimeOut(0);
        this.asyncProbe.write(string4);
    }

    public synchronized void closeConnection() throws SMAPIException {
        if (this.syncProbe != null && this.syncProbe.isConnected()) {
            this.syncProbe.close();
        }
        if (this.asyncProbe != null && this.asyncProbe.isConnected()) {
            this.asyncProbe.close();
        }
    }
}

