/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.client.group;

import com.sun.symon.base.client.SMUtility;
import com.sun.symon.base.client.group.SMFilterCriteria;
import com.sun.symon.base.client.group.SMFilterInfo;
import com.sun.symon.base.client.service.SMDBObject;
import com.sun.symon.base.client.service.SMDBObjectID;
import com.sun.symon.base.client.service.SMLengthException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Locale;

public class SMFilterData
extends SMFilterInfo {
    private static final String version = "1.0";
    private SMFilterCriteria[] criteria_;
    private boolean criteriaChanged_ = true;
    private String userData_;

    public SMFilterData() {
    }

    public SMFilterData(SMDBObjectID sMDBObjectID) {
        super(sMDBObjectID);
    }

    public void setName(String string) throws SMLengthException {
        super.setName(string);
    }

    public void setDescription(String string) throws SMLengthException {
        super.setDescription(string);
    }

    protected Object clone() {
        SMFilterData sMFilterData = (SMFilterData)super.clone();
        if (this.criteria_ != null) {
            sMFilterData.criteria_ = new SMFilterCriteria[this.criteria_.length];
            int n = 0;
            while (n < this.criteria_.length) {
                sMFilterData.criteria_[n] = (SMFilterCriteria)this.criteria_[n].clone();
                ++n;
            }
        }
        sMFilterData.criteriaChanged_ = true;
        return sMFilterData;
    }

    public void setFilterCriteria(SMFilterCriteria[] sMFilterCriteriaArray) throws IllegalArgumentException {
        int n;
        if (sMFilterCriteriaArray == null) {
            throw new IllegalArgumentException("criteria is null");
        }
        int n2 = 0;
        while (n2 < sMFilterCriteriaArray.length - 1) {
            n = n2 + 1;
            while (n < sMFilterCriteriaArray.length) {
                if (sMFilterCriteriaArray[n2].getClass().equals(sMFilterCriteriaArray[n].getClass())) {
                    throw new IllegalArgumentException("duplicate criteria: " + sMFilterCriteriaArray[n2] + "  and  " + sMFilterCriteriaArray[n]);
                }
                ++n;
            }
            ++n2;
        }
        this.criteria_ = new SMFilterCriteria[sMFilterCriteriaArray.length];
        n = 0;
        while (n < sMFilterCriteriaArray.length) {
            this.criteria_[n] = (SMFilterCriteria)sMFilterCriteriaArray[n].clone();
            ++n;
        }
        this.setChanged(true);
        this.criteriaChanged_ = true;
    }

    public SMFilterCriteria[] getFilterCriteria() {
        return this.criteria_;
    }

    public void setChanged(boolean bl) {
        if (!bl) {
            this.criteriaChanged_ = false;
        }
        super.setChanged(bl);
    }

    public boolean isCriteriaChanged() {
        return this.criteriaChanged_;
    }

    public void setUserData(String string) throws SMLengthException {
        this.userData_ = SMDBObject.assertLength("userData", string, 64, false);
        this.setChanged(true);
    }

    public String getUserData() {
        if (this.userData_ == null) {
            return "";
        }
        return this.userData_;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        SMDBObject.writeString(objectOutputStream, version);
        objectOutputStream.writeObject(this.criteria_);
        objectOutputStream.writeBoolean(this.criteriaChanged_);
        SMDBObject.writeString(objectOutputStream, this.userData_);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        SMDBObject.readString(objectInputStream);
        this.criteria_ = (SMFilterCriteria[])objectInputStream.readObject();
        this.criteriaChanged_ = objectInputStream.readBoolean();
        this.userData_ = SMDBObject.readString(objectInputStream);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        stringBuffer.append(super.toString());
        stringBuffer.append(", criteriaChanged=").append(this.criteriaChanged_);
        stringBuffer.append(", userData=").append(this.userData_);
        stringBuffer.append(", criteria=");
        SMDBObject.arrayToStringBuffer(this.criteria_, stringBuffer);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public void validate() throws IllegalArgumentException {
        this.validate(Locale.getDefault());
    }

    public void validate(Locale locale) throws IllegalArgumentException {
        if (this.name_ == null || this.name_.trim().equals("") || SMUtility.validate(this.name_) >= 0) {
            throw new IllegalArgumentException(SMUtility.getClientMessage(locale, "FilterRequest.InvalidFilterName"));
        }
        if (this.criteria_ == null) {
            throw new IllegalArgumentException(SMUtility.getClientMessage(locale, "FilterRequest.InvalidCriteria"));
        }
    }
}

