/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.client.graph;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.SMRawDataResponse;
import com.sun.symon.base.client.SMUtility;
import com.sun.symon.base.client.graph.SMGraphCurrentAdapter;
import com.sun.symon.base.client.graph.SMGraphData;
import com.sun.symon.base.client.graph.SMGraphHistoryAdapter;
import com.sun.symon.base.client.graph.SMGraphInfo;
import com.sun.symon.base.client.graph.SMGraphResponse;
import com.sun.symon.base.server.types.StInteger;
import com.sun.symon.base.server.types.StObject;
import com.sun.symon.base.server.types.StString;
import com.sun.symon.base.utility.UcDDL;
import com.sun.symon.base.utility.UcInternationalizer;
import com.sun.symon.base.utility.UcListUtil;
import com.sun.symon.base.utility.UcURL;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;

public class SMGraphRequest {
    private SMRawDataRequest handle;
    private ResourceBundle rbundle;
    private Locale locale;

    public SMGraphRequest(SMRawDataRequest sMRawDataRequest) {
        this.handle = sMRawDataRequest;
        this.rbundle = this.handle.getResourceBundle();
        this.locale = this.handle.getLocale();
    }

    public boolean createGraph(String string, String string2) throws SMAPIException {
        string = string.replace(',', ' ');
        string2 = UcListUtil.UnicodeToAscii((String)string2);
        String string3 = "#" + this.handle.getUserId() + "," + string;
        String string4 = this.handle.getConfigurationBaseURL() + "mod/cfgserver/userGraphs/userGraphTable/userGraphEntry";
        String[] stringArray = new String[]{string4 + "/rowstatus" + string3, string4 + "/username" + string3, string4 + "/graphname" + string3, string4 + "/graphinfo" + string3};
        StObject[][] stObjectArray = new StObject[4][1];
        stObjectArray[0][0] = new StInteger("4");
        stObjectArray[1][0] = new StString(this.handle.getUserId());
        stObjectArray[2][0] = new StString(string);
        stObjectArray[3][0] = new StString(string2);
        try {
            this.handle.setURLValue(stringArray, stObjectArray);
            return true;
        }
        catch (SMAPIException sMAPIException) {
            String[] stringArray2 = new String[]{string4 + "/username" + string3};
            try {
                this.handle.getURLValue(stringArray2);
                return false;
            }
            catch (SMAPIException sMAPIException2) {
                throw sMAPIException;
            }
        }
    }

    public boolean createGraphTemplate(String string, String string2) throws SMAPIException {
        string = string.replace(',', ' ');
        string2 = UcListUtil.UnicodeToAscii((String)string2);
        String string3 = "#" + this.handle.getUserId() + "," + string;
        String string4 = this.handle.getConfigurationBaseURL() + "mod/cfgserver/userGraphTemplates/" + "userTemplateTable/userTemplateEntry";
        String[] stringArray = new String[]{string4 + "/rowstatus" + string3, string4 + "/username" + string3, string4 + "/templatename" + string3, string4 + "/templateinfo" + string3};
        StObject[][] stObjectArray = new StObject[4][1];
        stObjectArray[0][0] = new StInteger("4");
        stObjectArray[1][0] = new StString(this.handle.getUserId());
        stObjectArray[2][0] = new StString(string);
        stObjectArray[3][0] = new StString(string2);
        try {
            this.handle.setURLValue(stringArray, stObjectArray);
            return true;
        }
        catch (SMAPIException sMAPIException) {
            String[] stringArray2 = new String[]{string4 + "/username" + string3};
            try {
                this.handle.getURLValue(stringArray2);
                return false;
            }
            catch (SMAPIException sMAPIException2) {
                throw sMAPIException;
            }
        }
    }

    public void deleteGraph(String string, String string2) throws SMAPIException {
        string2 = string2.replace(',', ' ');
        String string3 = "#" + string + "," + string2;
        String string4 = this.handle.getConfigurationBaseURL() + "mod/cfgserver/userGraphs/userGraphTable/userGraphEntry";
        String[] stringArray = new String[]{string4 + "/rowstatus" + string3};
        StObject[][] stObjectArray = new StObject[1][1];
        stObjectArray[0][0] = new StInteger("6");
        this.handle.setURLValue(stringArray, stObjectArray);
    }

    public void deleteGraphTemplate(String string, String string2) throws SMAPIException {
        string2 = string2.replace(',', ' ');
        String string3 = "#" + string + "," + string2;
        String string4 = this.handle.getConfigurationBaseURL() + "mod/cfgserver/userGraphTemplates/" + "userTemplateTable/userTemplateEntry";
        String[] stringArray = new String[]{string4 + "/rowstatus" + string3};
        StObject[][] stObjectArray = new StObject[1][1];
        stObjectArray[0][0] = new StInteger("6");
        this.handle.setURLValue(stringArray, stObjectArray);
    }

    public Object getGraphCurrentValue(String string, SMGraphResponse sMGraphResponse, Object object) throws SMAPIException {
        if (string == null || sMGraphResponse == null) {
            return null;
        }
        UcURL ucURL = new UcURL(string);
        String string2 = ucURL.getFragment();
        if (string2.length() > 1) {
            string2 = string2.substring(1);
        }
        String[] stringArray = new String[]{SMRawDataRequest.buildShadowURL(string, "graphmarkpoint", string2)};
        Object object2 = null;
        try {
            object2 = this.handle.getURLValue(stringArray, null, (SMRawDataResponse)new SMGraphCurrentAdapter(sMGraphResponse), object);
        }
        catch (Exception exception) {
            UcDDL.logWarningMessage((String)"Got exception getting current value", (Throwable)exception);
        }
        return object2;
    }

    public Object getGraphHistory(String string, SMGraphResponse sMGraphResponse, Object object) throws SMAPIException {
        if (string == null || sMGraphResponse == null) {
            return null;
        }
        UcURL ucURL = new UcURL(string);
        String string2 = ucURL.getFragment();
        if (string2.length() > 1) {
            string2 = string2.substring(1);
        }
        String[] stringArray = new String[]{SMRawDataRequest.buildShadowURL(string, "history", string2)};
        Object object2 = null;
        try {
            object2 = this.handle.getURLValue(stringArray, null, (SMRawDataResponse)new SMGraphHistoryAdapter(sMGraphResponse), object);
        }
        catch (Exception exception) {
            UcDDL.logWarningMessage((String)"Got exception getting history value", (Throwable)exception);
        }
        return object2;
    }

    public SMGraphData[] getGraphHistory(String string) {
        if (string == null) {
            return null;
        }
        UcURL ucURL = new UcURL(string);
        String string2 = ucURL.getFragment();
        if (string2.length() > 1) {
            string2 = string2.substring(1);
        }
        String[] stringArray = new String[]{SMRawDataRequest.buildShadowURL(string, "history", string2)};
        SMGraphData[] sMGraphDataArray = null;
        try {
            StObject[][] stObjectArray = this.handle.getURLValue(stringArray);
            Vector vector = new Vector();
            if (!UcListUtil.decomposeList((String)stObjectArray[0][0].toString(), vector)) {
                throw new Exception();
            }
            sMGraphDataArray = new SMGraphData[vector.size()];
            if (vector.size() == 0) {
                return sMGraphDataArray;
            }
            Vector vector2 = new Vector();
            int n = 0;
            while (n < vector.size()) {
                vector2.removeAllElements();
                if (!UcListUtil.decomposeList((String)((String)vector.elementAt(n)), vector2)) {
                    throw new Exception();
                }
                if (vector2.size() != 2) {
                    throw new Exception();
                }
                Long l = new Long((String)vector2.elementAt(0));
                Double d = new Double((String)vector2.elementAt(1));
                sMGraphDataArray[n] = new SMGraphData(d, l, 0);
                ++n;
            }
            return sMGraphDataArray;
        }
        catch (Exception exception) {
            UcDDL.logWarningMessage((String)"Got exception getting history value", (Throwable)exception);
            return null;
        }
    }

    public String getUnitForURL(String string) throws SMAPIException {
        StObject[][] stObjectArray;
        if (string == null) {
            return null;
        }
        UcURL ucURL = new UcURL(string);
        String string2 = ucURL.getFragment();
        if (string2.length() > 1) {
            string2 = string2.substring(1);
        }
        String[] stringArray = new String[]{SMRawDataRequest.buildShadowURL(string, "units", string2)};
        String string3 = null;
        try {
            stObjectArray = this.handle.getURLValue(stringArray);
            if (stObjectArray == null || stObjectArray.length != 1 || stObjectArray[0] == null || stObjectArray[0].length != 1) {
                UcDDL.logErrorMessage((String)"SMGraphRequest::getUnitForURL -- Invalid units");
                return null;
            }
            string3 = stObjectArray[0][0].toString();
        }
        catch (Exception exception) {
            UcDDL.logWarningMessage((String)"Got exception getting identifier", (Throwable)exception);
        }
        stringArray[0] = SMRawDataRequest.buildShadowURL(string, "i18nunits", string2);
        try {
            stObjectArray = this.handle.getURLValue(stringArray);
            if (stObjectArray != null && stObjectArray.length == 1 && stObjectArray[0] != null && stObjectArray[0].length == 1 && !stObjectArray[0][0].toString().equals("undefined")) {
                string3 = UcInternationalizer.translateKey((Locale)this.locale, (String)stObjectArray[0][0].toString(), (String)string3);
            }
        }
        catch (SMAPIException sMAPIException) {
            // empty catch block
        }
        return string3;
    }

    public String getRowName(String string) throws SMAPIException {
        Object object;
        Object object2;
        if (string == null) {
            return null;
        }
        UcURL ucURL = new UcURL(string);
        String string2 = ucURL.getFragment();
        if (string2.length() > 1) {
            string2 = string2.substring(1);
        }
        String[] stringArray = new String[]{SMRawDataRequest.buildShadowURL(string, "mapping", string2)};
        String[] stringArray2 = new String[1];
        try {
            object2 = this.handle.getURLValue(stringArray);
            if (object2 == null || ((StObject[][])object2).length != 1 || object2[0] == null || object2[0].length != 1) {
                UcDDL.logErrorMessage((String)"SMGraphRequest::getRowName   -- Invalid mapping");
                return null;
            }
            object = object2[0][0].toString();
            stringArray2[0] = ((String)object).indexOf("rowdescbyname") != -1 ? SMRawDataRequest.buildShadowURL(string, "rowdescbyname", string2) : SMRawDataRequest.buildShadowURL(string, "identifier", string2);
        }
        catch (Exception exception) {
            UcDDL.logWarningMessage((String)"Got exception getting units", (Throwable)exception);
        }
        object2 = null;
        try {
            object = this.handle.getURLValue(stringArray2);
            if (object == null || ((StObject[][])object).length != 1 || object[0] == null || object[0].length != 1) {
                UcDDL.logErrorMessage((String)"SMGraphRequest::getRowName -- Invalid identifier");
                return null;
            }
            object2 = ((StObject)object[0][0]).toString();
        }
        catch (Exception exception) {
            UcDDL.logWarningMessage((String)"Got exception getting row description", (Throwable)exception);
            return null;
        }
        return SMUtility.e2Dot((String)object2);
    }

    public String getGraphUserId() {
        return this.handle.getUserId();
    }

    public SMGraphInfo[] getUserGraphInfo(String string) throws SMAPIException {
        String string2 = this.handle.getConfigurationBaseURL() + "mod/cfgserver/userGraphs/userGraphTable/userGraphEntry";
        String[] stringArray = new String[]{string2 + "/username", string2 + "/graphname", string2 + "/graphinfo"};
        StObject[][] stObjectArray = this.handle.getURLValue(stringArray);
        if (stObjectArray.length != 3 || stObjectArray[0].length != 1 || stObjectArray[1].length != 1 || stObjectArray[2].length != 1) {
            throw new SMAPIException(this.rbundle.getString("GraphRequest.InvalidGraphInfoReturnData"));
        }
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        if (!(UcListUtil.decomposeList((String)stObjectArray[0][0].toString(), vector) && UcListUtil.decomposeList((String)stObjectArray[1][0].toString(), vector2) && UcListUtil.decomposeList((String)stObjectArray[2][0].toString(), vector3) && vector.size() == vector2.size() && vector2.size() == vector3.size())) {
            throw new SMAPIException(this.rbundle.getString("GraphRequest.InvalidGraphListReturnData"));
        }
        SMGraphInfo[] sMGraphInfoArray = null;
        if (string != null) {
            int n = 0;
            int n2 = 0;
            while (n2 < vector.size()) {
                String string3 = (String)vector.elementAt(n2);
                if (string3.compareTo(string) == 0) {
                    ++n;
                }
                ++n2;
            }
            sMGraphInfoArray = new SMGraphInfo[n];
            int n3 = 0;
            int n4 = 0;
            while (n4 < vector.size()) {
                String string4 = (String)vector.elementAt(n4);
                if (string4.compareTo(string) == 0) {
                    String string5 = (String)vector3.elementAt(n4);
                    string5 = UcListUtil.AsciiToUnicode((String)string5);
                    sMGraphInfoArray[n3] = new SMGraphInfo(string4, (String)vector2.elementAt(n4), string5);
                    ++n3;
                }
                ++n4;
            }
        } else {
            sMGraphInfoArray = new SMGraphInfo[vector.size()];
            int n = 0;
            while (n < vector.size()) {
                String string6 = (String)vector.elementAt(n);
                String string7 = (String)vector3.elementAt(n);
                string7 = UcListUtil.AsciiToUnicode((String)string7);
                sMGraphInfoArray[n] = new SMGraphInfo(string6, (String)vector2.elementAt(n), string7);
                ++n;
            }
        }
        return sMGraphInfoArray;
    }

    public SMGraphInfo[] getUserGraphTemplateInfo(String string) throws SMAPIException {
        String string2 = this.handle.getConfigurationBaseURL() + "mod/cfgserver/userGraphTemplates/" + "userTemplateTable/userTemplateEntry";
        String[] stringArray = new String[]{string2 + "/username", string2 + "/templatename", string2 + "/templateinfo"};
        StObject[][] stObjectArray = this.handle.getURLValue(stringArray);
        if (stObjectArray.length != 3 || stObjectArray[0].length != 1 || stObjectArray[1].length != 1 || stObjectArray[2].length != 1) {
            throw new SMAPIException(this.rbundle.getString("GraphRequest.InvalidTemplateInfoReturnData"));
        }
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        if (!(UcListUtil.decomposeList((String)stObjectArray[0][0].toString(), vector) && UcListUtil.decomposeList((String)stObjectArray[1][0].toString(), vector2) && UcListUtil.decomposeList((String)stObjectArray[2][0].toString(), vector3) && vector.size() == vector2.size() && vector2.size() == vector3.size())) {
            throw new SMAPIException(this.rbundle.getString("GraphRequest.InvalidTemplateListReturnData"));
        }
        SMGraphInfo[] sMGraphInfoArray = null;
        if (string != null) {
            int n = 0;
            int n2 = 0;
            while (n2 < vector.size()) {
                String string3 = (String)vector.elementAt(n2);
                if (string3.compareTo(string) == 0) {
                    ++n;
                }
                ++n2;
            }
            sMGraphInfoArray = new SMGraphInfo[n];
            int n3 = 0;
            int n4 = 0;
            while (n4 < vector.size()) {
                String string4 = (String)vector.elementAt(n4);
                if (string4.compareTo(string) == 0) {
                    String string5 = (String)vector3.elementAt(n4);
                    string5 = UcListUtil.AsciiToUnicode((String)string5);
                    sMGraphInfoArray[n3] = new SMGraphInfo(string4, (String)vector2.elementAt(n4), string5);
                    ++n3;
                }
                ++n4;
            }
        } else {
            sMGraphInfoArray = new SMGraphInfo[vector.size()];
            int n = 0;
            while (n < vector.size()) {
                String string6 = (String)vector.elementAt(n);
                String string7 = (String)vector3.elementAt(n);
                string7 = UcListUtil.AsciiToUnicode((String)string7);
                sMGraphInfoArray[n] = new SMGraphInfo(string6, (String)vector2.elementAt(n), string7);
                ++n;
            }
        }
        return sMGraphInfoArray;
    }
}

