/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.client.console;

import com.sun.symon.base.client.console.SMSchedulerCalendar;
import com.sun.symon.base.utility.UcInternationalizer;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class SMScheduler
extends JPanel {
    public static final int ONE_TIME = 0;
    public static final int HOURS = 1;
    public static final int DAYS = 2;
    public static final int WEEKS = 3;
    public static final int MONTHS = 4;
    public static final int HOURLY = 5;
    public static final int DAILY = 6;
    public static final int WEEKLY = 7;
    public static final int MONTHLY = 8;
    public static final int MWF = 9;
    public static final int TT = 10;
    public static final int SS = 11;
    public static final int MTWTF = 12;
    public static final int REPEAT_FOREVER = 0;
    public static final long REPEAT_FOREVER_VALUE = Long.MAX_VALUE;
    public static final int NO_MULT = 0;
    public static final int MULT = 1;
    final String[] lang = new String[]{"en", "fr", "it", "es", "de", "ko", "zh", "ja", "zh_TW"};
    final String[] format = new String[]{"MM/dd/yy", "dd/MM/yy", "dd/MM/yy", "dd/MM/yy", "dd.MM.yy", "yy-MM-dd", "yy-MM-dd", "yy/MM/dd", "yy/MM/dd"};
    final int[] field1 = new int[]{0, 5, 6, 7, 8, 9, 10, 11, 12};
    final int[] field2 = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12};
    final String[] hour = new String[]{"--", "00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23"};
    final String[] minute = new String[]{"--", "00", "05", "10", "15", "20", "25", "30", "35", "40", "45", "50", "55"};
    final String[] repeatChoicesSingular = new String[]{"oneTime", "hourly", "daily", "weekly", "monthly", "mwf", "tt", "ss", "mtwtf"};
    final String[] repeatChoicesMultiple = new String[]{"oneTime", "hours", "days", "weeks", "months", "hourly", "daily", "weekly", "monthly", "mwf", "tt", "ss", "mtwtf"};
    final String[] limitChoices = new String[]{"", "hours", "days", "weeks", "months", "hours", "days", "weeks", "months", "weeks", "weeks", "weeks", "weeks"};
    String scheduleStartDate = null;
    Calendar cal;
    boolean multiplier;
    boolean limit;
    boolean editSchedule;
    boolean schedEnabled = true;
    char mnemonic;
    int colWidth = 0;
    int selectedDay = 0;
    int selectedMonth = 0;
    int selectedYear = 0;
    int unitType = 0;
    long scheduleEndDateMS = Long.MAX_VALUE;
    Hashtable hashForwardSingular = new Hashtable(9);
    Hashtable hashReverseSingular = new Hashtable(9);
    Hashtable hashForwardMultiple = new Hashtable(13);
    Hashtable hashReverseMultiple = new Hashtable(13);
    Hashtable formatTable = new Hashtable(9);
    JPanel pDate = new JPanel(new GridBagLayout());
    JPanel pTime = new JPanel(new GridBagLayout());
    JPanel p1 = new JPanel(new GridBagLayout());
    JPanel p2 = new JPanel(new GridBagLayout());
    JPanel p3 = new JPanel(new GridLayout(1, 1, 0, 0));
    JPanel p4 = new JPanel(new FlowLayout(0, 4, 0));
    JPanel p5 = new JPanel(new FlowLayout(0, 0, 0));
    JPanel pRadios1 = new JPanel(new GridLayout(2, 1, 0, 0));
    JPanel pRadios2 = new JPanel(new GridLayout(2, 1, 0, 6));
    JPanel pButt = new JPanel(new GridLayout(1, 3, 6, 0));
    JPanel pRepeat = new JPanel(new FlowLayout(0, 4, 0));
    JLabel calTitle;
    JLabel startDateLabel = new JLabel("*" + this.tran("startDate") + ":");
    JLabel dateFormatLabel = new JLabel();
    JLabel startTimeLabel = new JLabel("*" + this.tran("startTime") + ":");
    JLabel endTimeLabel = new JLabel(" " + this.tran("endTime") + ":");
    JLabel colon1 = new JLabel(":");
    JLabel colon2 = new JLabel(":");
    JLabel repeatLabel = new JLabel(" " + this.tran("repeatInterval") + ":");
    JLabel limitLabel = new JLabel(" " + this.tran("repeatLimit") + ":");
    JLabel footNote1 = new JLabel("*" + this.tran("footNote1"));
    JLabel footNote2 = new JLabel(this.tran("footNote2"));
    JLabel limitUnit = new JLabel(this.tran("days"));
    JButton backButt;
    JButton nextButt;
    JRadioButton oneTime = new JRadioButton("One Time");
    JRadioButton periodic = new JRadioButton("Periodic");
    JRadioButton every1 = new JRadioButton("Custom");
    JRadioButton every2 = new JRadioButton("Predefined");
    JRadioButton limitYes = new JRadioButton();
    JRadioButton limitNo = new JRadioButton("Forever");
    JTextField dateField = new JTextField();
    JTextField repeatMult = new JTextField(3);
    JTextField limitMult = new JTextField(3);
    JComboBox startHourList = new JComboBox<String>(this.hour);
    JComboBox startMinuteList = new JComboBox<String>(this.minute);
    JComboBox endHourList = new JComboBox<String>(this.hour);
    JComboBox endMinuteList = new JComboBox<String>(this.minute);
    JComboBox repeatList;
    JComboBox repeatListMult;
    SMSchedulerCalendar pCal;

    String tran(String string) {
        return UcInternationalizer.translateKey((String)("com.sun.symon.base.client.console.SMScheduler:" + string));
    }

    void initHashTables() {
        Integer n;
        Integer n2;
        int n3 = 0;
        while (n3 < this.field1.length) {
            n2 = new Integer(this.field1[n3]);
            this.hashForwardSingular.put(n2, this.repeatChoicesSingular[n3]);
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.field2.length) {
            n2 = new Integer(this.field2[n4]);
            this.hashForwardMultiple.put(n2, this.repeatChoicesMultiple[n4]);
            ++n4;
        }
        int n5 = 0;
        while (n5 < this.field1.length) {
            n = new Integer(this.field1[n5]);
            this.hashReverseSingular.put(this.repeatChoicesSingular[n5], n);
            ++n5;
        }
        int n6 = 0;
        while (n6 < this.field2.length) {
            n = new Integer(this.field2[n6]);
            this.hashReverseMultiple.put(this.repeatChoicesMultiple[n6], n);
            ++n6;
        }
        int n7 = 0;
        while (n7 < this.lang.length) {
            this.formatTable.put(this.lang[n7], this.format[n7]);
            ++n7;
        }
    }

    boolean getSchedEnabled() {
        return this.schedEnabled;
    }

    void setSelectedMonth(int n) {
        this.selectedMonth = n;
    }

    void setSelectedYear(int n) {
        this.selectedYear = n;
    }

    public boolean getEditSchedule() {
        return this.editSchedule;
    }

    public long getScheduleEndDateMS() {
        return this.scheduleEndDateMS;
    }

    public void setScheduleEndDateMS(long l) {
        this.scheduleEndDateMS = l;
    }

    public void updateCalendar() {
        this.pCal.buildScheduledDays(this);
    }

    public String getSchedulerStartDateFormat() {
        String string;
        Locale locale = Locale.getDefault();
        String string2 = locale.getLanguage();
        if (string2.compareTo("zh") == 0 && locale.getCountry().compareTo("TW") == 0) {
            string2 = "zh_TW";
        }
        if ((string = (String)this.formatTable.get(string2)) == null) {
            string = (String)this.formatTable.get("en");
        }
        return string;
    }

    public boolean getECLocale() {
        return this.pCal.getECLocale();
    }

    void setDayNumber(int n) {
        this.selectedDay = n;
        Calendar calendar = Calendar.getInstance();
        calendar.set(this.selectedYear, this.selectedMonth, this.selectedDay);
        this.setSchedulerStartDate(calendar.getTime());
    }

    void enableRepeats(boolean bl) {
        this.repeatMult.setEnabled(bl);
        this.limitLabel.setEnabled(bl);
        this.limitMult.setEnabled(bl);
        this.limitUnit.setEnabled(bl);
        this.footNote2.setEnabled(bl);
    }

    void updateRepeatComps(int n) {
        this.enableRepeats(n != 0);
        this.p4.removeAll();
        this.p4.validate();
        this.limitUnit = new JLabel(this.limitChoices[this.getSchedulerIntervalUnit()]);
        this.p4.add(this.limitMult);
        this.p4.add(this.limitUnit);
        this.p4.validate();
    }

    void updateRepeatMultComps(int n) {
        this.enableRepeats(n == 1 || n == 2 || n == 3 || n == 4);
        this.p4.removeAll();
        this.p4.validate();
        this.limitUnit = new JLabel(this.limitChoices[this.getSchedulerIntervalMultUnit()]);
        this.p4.add(this.limitMult);
        this.p4.add(this.limitUnit);
        this.p4.validate();
    }

    public void enableAll(boolean bl) {
        this.pCal.setEnabled(bl);
        this.startDateLabel.setEnabled(bl);
        this.dateField.setEnabled(bl);
        this.dateFormatLabel.setEnabled(bl);
        this.startTimeLabel.setEnabled(bl);
        this.startHourList.setEnabled(bl);
        this.colon1.setEnabled(bl);
        this.startMinuteList.setEnabled(bl);
        this.repeatLabel.setEnabled(bl);
        this.repeatList.setEnabled(bl);
        this.footNote1.setEnabled(bl);
        this.footNote2.setEnabled(bl);
        this.schedEnabled = bl;
    }

    void addEndTime(GridBagConstraints gridBagConstraints) {
        this.endTimeLabel.setLabelFor(this.endHourList);
        this.mnemonic = this.tran("endTime.mnemonic").charAt(0);
        this.endTimeLabel.setDisplayedMnemonic(this.mnemonic);
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        this.pTime.add((Component)this.endTimeLabel, gridBagConstraints);
        this.colon2.setFont(new Font("Dialog", 1, 12));
        this.colon2.setForeground(Color.black);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 18;
        this.p2.add((Component)this.endHourList, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        gridBagConstraints.anchor = 17;
        this.p2.add((Component)this.colon2, gridBagConstraints);
        this.endHourList.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() != 1 || SMScheduler.this.endHourList.getSelectedIndex() > 0) {
                    // empty if block
                }
            }
        });
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        gridBagConstraints.anchor = 18;
        this.p2.add((Component)this.endMinuteList, gridBagConstraints);
        gridBagConstraints.insets = new Insets(6, 11, 0, 12);
        this.endMinuteList.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() != 1 || SMScheduler.this.endMinuteList.getSelectedIndex() > 0) {
                    // empty if block
                }
            }
        });
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        this.pTime.add((Component)this.p2, gridBagConstraints);
    }

    void addRepeatMult(GridBagConstraints gridBagConstraints) {
        this.repeatMult.setMargin(new Insets(0, 1, 0, 0));
        this.pRepeat.add(this.repeatMult);
        this.pRepeat.add(this.repeatListMult);
        gridBagConstraints.insets = new Insets(12, 7, 0, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.pTime.add((Component)this.pRepeat, gridBagConstraints);
        this.repeatListMult.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    String string = (String)SMScheduler.this.repeatListMult.getSelectedItem();
                    Integer n = (Integer)SMScheduler.this.hashReverseMultiple.get(string);
                    SMScheduler.this.updateRepeatMultComps(n);
                }
            }
        });
    }

    void addRepeat(GridBagConstraints gridBagConstraints) {
        gridBagConstraints.insets = new Insets(12, 11, 0, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.pTime.add((Component)this.repeatList, gridBagConstraints);
        this.repeatList.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    String string = (String)SMScheduler.this.repeatList.getSelectedItem();
                    Integer n = (Integer)SMScheduler.this.hashReverseSingular.get(string);
                    SMScheduler.this.updateRepeatComps(n);
                }
            }
        });
    }

    void addLimit(GridBagConstraints gridBagConstraints) {
        this.limitLabel.setLabelFor(this.limitMult);
        this.mnemonic = this.tran("repeatLimit.mnemonic").charAt(0);
        this.limitLabel.setDisplayedMnemonic(this.mnemonic);
        gridBagConstraints.insets = new Insets(15, 0, 0, 0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        this.pTime.add((Component)this.limitLabel, gridBagConstraints);
        this.limitMult.setMargin(new Insets(0, 1, 0, 0));
        this.p4.add(this.limitMult);
        gridBagConstraints.insets = new Insets(12, 7, 0, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.pTime.add((Component)this.p4, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        this.pTime.add((Component)new JLabel(" "), gridBagConstraints);
        this.footNote2.setFont(new Font(null, 0, 12));
        this.p5.add(this.footNote2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(2, 11, 0, 0);
        this.pTime.add((Component)this.p5, gridBagConstraints);
        int n = 0;
        n = this.multiplier ? this.repeatListMult.getSelectedIndex() : this.repeatList.getSelectedIndex();
        this.updateRepeatComps(n);
    }

    public SMScheduler() {
        this(false, false, false, false);
    }

    public SMScheduler(boolean bl) {
        this(bl, false, false, false);
    }

    public SMScheduler(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (!bl) {
            this.endTimeLabel = null;
        }
        this.multiplier = bl2;
        this.limit = bl3;
        this.editSchedule = bl4;
        int n = 0;
        while (n < this.repeatChoicesSingular.length) {
            this.repeatChoicesSingular[n] = this.tran(this.repeatChoicesSingular[n]);
            ++n;
        }
        int n2 = 0;
        while (n2 < this.repeatChoicesMultiple.length) {
            this.repeatChoicesMultiple[n2] = this.tran(this.repeatChoicesMultiple[n2]);
            ++n2;
        }
        int n3 = 1;
        while (n3 < this.limitChoices.length) {
            this.limitChoices[n3] = this.tran(this.limitChoices[n3]);
            ++n3;
        }
        this.repeatList = new JComboBox<String>(this.repeatChoicesSingular);
        this.repeatListMult = new JComboBox<String>(this.repeatChoicesMultiple);
        this.initHashTables();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.pCal = new SMSchedulerCalendar(this);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.pDate.add((Component)this.pCal, gridBagConstraints);
        this.startDateLabel.setLabelFor(this.dateField);
        this.mnemonic = this.tran("startDate.mnemonic").charAt(0);
        this.startDateLabel.setDisplayedMnemonic(this.mnemonic);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.pDate.add((Component)this.startDateLabel, gridBagConstraints);
        this.cal = Calendar.getInstance();
        this.selectedMonth = this.cal.get(2);
        this.selectedYear = this.cal.get(1);
        if (!this.editSchedule) {
            this.setDayNumber(this.cal.get(5));
        }
        this.dateField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
            }

            public void focusLost(FocusEvent focusEvent) {
                SMScheduler.this.setSchedulerStartDate(SMScheduler.this.dateField.getText().trim());
            }
        });
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 11, 0, 0);
        this.pDate.add((Component)this.dateField, gridBagConstraints);
        this.dateFormatLabel.setText(this.getSchedulerStartDateFormat().toLowerCase());
        Font font = this.dateFormatLabel.getFont();
        this.dateFormatLabel.setFont(new Font(font.getName(), 0, font.getSize()));
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(3, 11, 0, 0);
        this.pDate.add((Component)new JLabel(""), gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        this.pDate.add((Component)this.dateFormatLabel, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.pDate, gridBagConstraints);
        this.startTimeLabel.setLabelFor(this.startHourList);
        this.mnemonic = this.tran("startTime.mnemonic").charAt(0);
        this.startTimeLabel.setDisplayedMnemonic(this.mnemonic);
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        this.pTime.add((Component)this.startTimeLabel, gridBagConstraints);
        this.colon1.setFont(new Font("Dialog", 1, 12));
        this.colon1.setForeground(Color.black);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 18;
        this.p1.add((Component)this.startHourList, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        gridBagConstraints.anchor = 17;
        this.p1.add((Component)this.colon1, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        gridBagConstraints.anchor = 18;
        this.p1.add((Component)this.startMinuteList, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 11, 0, 0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        this.pTime.add((Component)this.p1, gridBagConstraints);
        if (this.endTimeLabel != null) {
            this.addEndTime(gridBagConstraints);
        }
        this.repeatLabel.setLabelFor(this.repeatList);
        this.mnemonic = this.tran("repeatInterval.mnemonic").charAt(0);
        this.repeatLabel.setDisplayedMnemonic(this.mnemonic);
        gridBagConstraints.insets = new Insets(15, 0, 0, 0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        this.pTime.add((Component)this.repeatLabel, gridBagConstraints);
        if (this.multiplier) {
            this.addRepeatMult(gridBagConstraints);
        } else {
            this.addRepeat(gridBagConstraints);
        }
        if (this.limit) {
            this.addLimit(gridBagConstraints);
        }
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.pTime, gridBagConstraints);
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        this.footNote1.setFont(new Font(null, 0, 12));
        this.p3.add(this.footNote1);
        this.add((Component)this.p3, gridBagConstraints);
    }

    public Date getSchedulerStartDate() {
        String string = this.getSchedulerStartDateFormat();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        simpleDateFormat.setLenient(false);
        Date date = simpleDateFormat.parse(this.scheduleStartDate, new ParsePosition(0));
        if (date == null) {
            this.setSchedulerStartDate("");
        }
        return date;
    }

    public String getSchedulerStartDateString() {
        return this.scheduleStartDate;
    }

    public String getSchedulerStartHour() {
        return this.hour[this.startHourList.getSelectedIndex()];
    }

    public String getSchedulerStartMinute() {
        return this.minute[this.startMinuteList.getSelectedIndex()];
    }

    public String getSchedulerStartTime() {
        String string = this.hour[this.startHourList.getSelectedIndex()];
        String string2 = this.minute[this.startMinuteList.getSelectedIndex()];
        return string + ":" + string2 + ":00";
    }

    public String getSchedulerEndTime() {
        String string = this.hour[this.endHourList.getSelectedIndex()];
        String string2 = this.minute[this.endMinuteList.getSelectedIndex()];
        return string + ":" + string2 + ":00";
    }

    public String getSchedulerEndHour() {
        return this.hour[this.endHourList.getSelectedIndex()];
    }

    public String getSchedulerEndMinute() {
        return this.minute[this.endMinuteList.getSelectedIndex()];
    }

    int getSchedulerUnitType() {
        return this.unitType;
    }

    public int getSchedulerIntervalUnit() {
        Integer n = (Integer)this.hashReverseSingular.get(this.repeatList.getSelectedItem());
        return n;
    }

    public int getSchedulerIntervalMult() {
        int n;
        if (!this.repeatMult.isEnabled()) {
            return -1;
        }
        try {
            n = Integer.parseInt(this.repeatMult.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
        return n;
    }

    public int getSchedulerIntervalMultUnit() {
        Integer n = (Integer)this.hashReverseMultiple.get(this.repeatListMult.getSelectedItem());
        return n;
    }

    public int getSchedulerLimitMult() {
        int n;
        if (!this.limitMult.isEnabled()) {
            return -1;
        }
        String string = this.limitMult.getText().trim();
        if (string.compareTo("") == 0 || string.compareTo(" ") == 0) {
            return 0;
        }
        try {
            n = Integer.parseInt(this.limitMult.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
        return n;
    }

    public int getSchedulerLimitUnit() {
        Integer n = (Integer)this.hashReverseMultiple.get(this.limitUnit.getText());
        return n;
    }

    public void setSchedulerInitialFocus() {
        this.startHourList.requestFocus();
    }

    public void setSchedulerStartDate(String string) {
        this.dateField.setText(string);
        this.scheduleStartDate = string;
    }

    public void setSchedulerStartDate(Date date) {
        String string = this.getSchedulerStartDateFormat();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        this.setSchedulerStartDate(simpleDateFormat.format(date));
    }

    public void setSchedulerStartHour(String string) {
        if ((string = string.trim()).length() == 1) {
            string = "0" + string;
        }
        this.startHourList.setSelectedItem(string);
    }

    public void setSchedulerStartMinute(String string) {
        if ((string = string.trim()).length() == 1) {
            string = "0" + string;
        }
        this.startMinuteList.setSelectedItem(string);
    }

    public void setSchedulerStartHour(int n) {
        this.setSchedulerStartHour(String.valueOf(n));
    }

    public void setSchedulerStartMinute(int n) {
        this.setSchedulerStartMinute(String.valueOf(n));
    }

    public void setSchedulerEndHour(String string) {
        if ((string = string.trim()).length() == 1) {
            string = "0" + string;
        }
        this.endHourList.setSelectedItem(string);
    }

    public void setSchedulerEndMinute(String string) {
        if ((string = string.trim()).length() == 1) {
            string = "0" + string;
        }
        this.endMinuteList.setSelectedItem(string);
    }

    public void setSchedulerEndHour(int n) {
        this.setSchedulerEndHour(String.valueOf(n));
    }

    public void setSchedulerEndMinute(int n) {
        this.setSchedulerEndMinute(String.valueOf(n));
    }

    public void setSchedulerUnitType(int n) {
        this.unitType = n;
    }

    public void setSchedulerIntervalUnit(int n) {
        Integer n2 = new Integer(n);
        this.repeatList.setSelectedItem(this.hashForwardSingular.get(n2));
    }

    public void setSchedulerIntervalMult(String string) {
        if (string != null) {
            this.repeatMult.setText(string);
        } else {
            this.repeatMult.setText("");
            this.repeatMult.setEnabled(false);
        }
    }

    public void setSchedulerIntervalMultUnit(int n) {
        Integer n2 = new Integer(n);
        this.repeatListMult.setSelectedItem(this.hashForwardMultiple.get(n2));
    }

    public void setSchedulerLimitMult(String string) {
        this.limitMult.setText(string);
    }

    public void setSchedulerLimitUnit(int n) {
        Integer n2 = new Integer(n);
        this.limitUnit.setText((String)this.hashForwardMultiple.get(n2));
    }

    public void setSchedulerIntervalList(int[] nArray) {
        this.repeatList.removeAllItems();
        int n = 0;
        while (n < nArray.length) {
            Integer n2 = new Integer(nArray[n]);
            this.repeatList.addItem(this.hashForwardSingular.get(n2));
            ++n;
        }
    }

    public void setSchedulerIntervalListMult(int[] nArray) {
        this.repeatListMult.removeAllItems();
        int n = 0;
        while (n < nArray.length) {
            Integer n2 = new Integer(nArray[n]);
            this.repeatList.addItem(this.hashForwardMultiple.get(n2));
            this.repeatListMult.addItem(this.repeatChoicesMultiple[nArray[n]]);
            ++n;
        }
    }
}

