/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.client.alarm;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.SMRequestStatus;
import com.sun.symon.base.client.alarm.SMAlarmPageRequest;
import com.sun.symon.base.client.alarm.SMAlarmPageResponse;
import com.sun.symon.base.client.alarm.SMRawAlarmData;
import com.sun.symon.base.client.probe.SMProbeConnection;
import com.sun.symon.base.client.probe.SMProbeListener;
import com.sun.symon.base.utility.UcInternationalizer;
import java.util.Locale;

class SMRequestConnection {
    SMProbeConnection connection;
    String requestId = null;
    Object identifier = null;
    SMAlarmPageResponse callback = null;
    SMAlarmPageRequest alarmRequest;
    boolean isAsyncFlag = false;
    String data = null;
    SMRequestStatus successStat;
    SMRequestResponse resp = new SMRequestResponse();
    SMRawDataRequest handle;

    public SMRequestConnection(String string, SMAlarmPageRequest sMAlarmPageRequest) throws SMAPIException {
        this.requestId = string;
        this.handle = sMAlarmPageRequest.handle;
        Locale locale = this.handle.getLocale();
        this.alarmRequest = sMAlarmPageRequest;
        this.successStat = new SMRequestStatus(0, UcInternationalizer.translateKey((Locale)locale, (String)"base.client.ClientApiMessages:Success"));
    }

    public StringBuffer readInResponse() {
        return new StringBuffer(this.data);
    }

    public boolean isConnected() {
        if (this.connection == null) {
            return false;
        }
        return this.connection.isConnected();
    }

    public void connect(String string) throws SMAPIException {
        if (this.connection != null) {
            this.connection.close();
        }
        this.connection = new SMProbeConnection(this.handle, this.resp);
        this.connection.connect(string);
        this.connection.setEndOfStream(SMAlarmPageRequest.END_OF_STREAM);
        this.connection.startReader();
    }

    public SMRequestConnection(String string, SMAlarmPageRequest sMAlarmPageRequest, Object object, SMAlarmPageResponse sMAlarmPageResponse, boolean bl) throws SMAPIException {
        this(string, sMAlarmPageRequest);
        this.identifier = object;
        this.callback = sMAlarmPageResponse;
    }

    public void setTimeOut(int n) throws SMAPIException {
        this.connection.setTimeOut(n);
    }

    public synchronized void wakeup() {
        this.notify();
    }

    public void close() throws SMAPIException {
        this.connection.close();
    }

    public void write(String string) throws SMAPIException {
        this.data = null;
        this.connection.write2probe(string);
        if (!this.isAsyncFlag) {
            SMRequestConnection sMRequestConnection = this;
            synchronized (sMRequestConnection) {
                try {
                    if (this.data == null) {
                        this.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public void setObjId(Object object) {
        this.identifier = object;
    }

    public void setCallback(SMAlarmPageResponse sMAlarmPageResponse) {
        this.callback = sMAlarmPageResponse;
    }

    public void setAsync(boolean bl) {
        this.isAsyncFlag = bl;
    }

    public boolean isAsyncReq() {
        return this.isAsyncFlag;
    }

    class SMRequestResponse
    implements SMProbeListener {
        SMRequestResponse() {
        }

        public synchronized void receiveData(String string) {
            SMRequestConnection.this.data = string;
            if (!SMRequestConnection.this.isAsyncFlag) {
                if (string.indexOf("rtyp(P)") == -1) {
                    SMRequestConnection.this.wakeup();
                }
                return;
            }
            SMRawAlarmData sMRawAlarmData = null;
            sMRawAlarmData = SMRequestConnection.this.alarmRequest.getRawAlarmData(new StringBuffer(string));
            String string2 = sMRawAlarmData.getType();
            String string3 = sMRawAlarmData.getErrorMessage();
            if (string3 != null) {
                SMRequestStatus sMRequestStatus = new SMRequestStatus(3, string3);
                if (SMRequestConnection.this.callback != null) {
                    SMRequestConnection.this.callback.getExceptionResponse(sMRequestStatus, SMRequestConnection.this.identifier);
                }
            } else if (SMRequestConnection.this.callback != null) {
                if (string2.equals("S3")) {
                    SMRequestConnection.this.callback.selectHostAlarmResponse(SMRequestConnection.this.successStat, sMRawAlarmData.getCounts(), SMRequestConnection.this.identifier);
                }
                if (string2.equals("PN")) {
                    SMRequestConnection.this.callback.pageHostAlarmResponse(SMRequestConnection.this.successStat, sMRawAlarmData.getData(), SMRequestConnection.this.identifier);
                }
                if (string2.equals("P")) {
                    SMRequestConnection.this.callback.updateHostAlarmResponse(SMRequestConnection.this.successStat, sMRawAlarmData.getCounts(), SMRequestConnection.this.identifier);
                }
                if (string2.equals("SF")) {
                    SMRequestConnection.this.callback.sortHostAlarmResponse(SMRequestConnection.this.successStat, SMRequestConnection.this.identifier);
                }
            }
        }

        public void receiveException(SMAPIException sMAPIException) {
            SMRequestStatus sMRequestStatus = new SMRequestStatus(3, sMAPIException.getMessage());
            if (SMRequestConnection.this.callback != null) {
                SMRequestConnection.this.callback.getExceptionResponse(sMRequestStatus, SMRequestConnection.this.identifier);
            }
        }
    }
}

