/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.client.alarm;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.SMRequestStatus;
import com.sun.symon.base.client.alarm.SMAlarmIteratorAsync;
import com.sun.symon.base.client.alarm.SMAlarmObjectRequest;
import com.sun.symon.base.client.alarm.SMAlarmObjectResponse;
import com.sun.symon.base.client.alarm.SMAlarmPageRequest;
import com.sun.symon.base.client.probe.SMProbeConnection;
import com.sun.symon.base.client.probe.SMProbeListener;
import com.sun.symon.base.utility.UcInternationalizer;
import java.util.Locale;
import java.util.Vector;

class SMReqConnect {
    private SMProbeConnection connection;
    protected String requestId = null;
    private Object identifier = null;
    private SMAlarmObjectResponse callback = null;
    private SMAlarmObjectRequest alarmRequest;
    private SMRequestStatus successStat;
    private String connectBrokenMsg;
    private SMAlarmIteratorAsync iter;
    private Vector subReqList = null;

    public SMReqConnect(String string, SMAlarmObjectRequest sMAlarmObjectRequest, Object object, SMAlarmObjectResponse sMAlarmObjectResponse) throws SMAPIException {
        this(string, sMAlarmObjectRequest);
        this.identifier = object;
        this.callback = sMAlarmObjectResponse;
    }

    public SMReqConnect(String string, SMAlarmObjectRequest sMAlarmObjectRequest) throws SMAPIException {
        SMReqResponse sMReqResponse = new SMReqResponse();
        this.requestId = string;
        SMRawDataRequest sMRawDataRequest = sMAlarmObjectRequest.handle;
        this.connection = new SMProbeConnection(sMRawDataRequest, sMReqResponse);
        Locale locale = sMRawDataRequest.getLocale();
        this.alarmRequest = sMAlarmObjectRequest;
        this.subReqList = new Vector();
        this.successStat = new SMRequestStatus(0, UcInternationalizer.translateKey((Locale)locale, (String)"base.client.ClientApiMessages:Success"));
        this.connectBrokenMsg = UcInternationalizer.translateKey((Locale)locale, (String)"base.client.ClientApiMessages:AlarmRequest.EventManagerConnectionBroken");
    }

    public void setAlarmIterator(SMAlarmIteratorAsync sMAlarmIteratorAsync) {
        this.iter = sMAlarmIteratorAsync;
    }

    public void write(String string) throws SMAPIException {
        this.connection.write2probe(string);
    }

    public void close() throws SMAPIException {
        this.connection.close();
    }

    public void setTimeOut(int n) throws SMAPIException {
        this.connection.setTimeOut(n);
    }

    public void connect(String string) throws SMAPIException {
        this.connection.connect(string);
        this.connection.setEndOfStream(SMAlarmPageRequest.END_OF_STREAM);
        this.connection.startReader();
    }

    public void addSubRequest(SMAlarmObjectRequest sMAlarmObjectRequest) {
        this.subReqList.add(sMAlarmObjectRequest);
    }

    public void removeSubRequests() {
        int n = 0;
        while (n < this.subReqList.size()) {
            SMAlarmObjectRequest sMAlarmObjectRequest = (SMAlarmObjectRequest)this.subReqList.elementAt(n);
            try {
                sMAlarmObjectRequest.closeConnection(this.requestId);
            }
            catch (Exception exception) {
                // empty catch block
            }
            sMAlarmObjectRequest = null;
            ++n;
        }
    }

    class SMReqResponse
    implements SMProbeListener {
        SMReqResponse() {
        }

        public void receiveData(String string) {
            SMRequestStatus sMRequestStatus = null;
            StringBuffer stringBuffer = new StringBuffer(string);
            try {
                SMReqConnect.this.setTimeOut(0);
            }
            catch (SMAPIException sMAPIException) {
                sMRequestStatus = new SMRequestStatus(3, SMReqConnect.this.connectBrokenMsg);
                if (SMReqConnect.this.callback != null) {
                    SMReqConnect.this.callback.getAlarmResponse(sMRequestStatus, null, SMReqConnect.this.identifier, SMReqConnect.this.iter);
                }
                return;
            }
            if (string.length() == 0) {
                sMRequestStatus = new SMRequestStatus(3, SMReqConnect.this.connectBrokenMsg);
                if (SMReqConnect.this.callback != null) {
                    SMReqConnect.this.callback.getAlarmResponse(sMRequestStatus, null, SMReqConnect.this.identifier, SMReqConnect.this.iter);
                }
                return;
            }
            Vector vector = null;
            try {
                vector = SMReqConnect.this.alarmRequest.handleRawAlarmData(stringBuffer);
            }
            catch (Throwable throwable) {
                sMRequestStatus = new SMRequestStatus(3, throwable.getMessage());
                if (SMReqConnect.this.callback != null) {
                    SMReqConnect.this.callback.getAlarmResponse(sMRequestStatus, null, SMReqConnect.this.identifier, SMReqConnect.this.iter);
                }
                return;
            }
            if (vector != null && SMReqConnect.this.callback != null) {
                SMReqConnect.this.callback.getAlarmResponse(SMReqConnect.this.successStat, vector, SMReqConnect.this.identifier, SMReqConnect.this.iter);
            }
        }

        public void receiveException(SMAPIException sMAPIException) {
            SMRequestStatus sMRequestStatus = new SMRequestStatus(3, sMAPIException.getMessage());
            if (SMReqConnect.this.callback != null) {
                SMReqConnect.this.callback.getAlarmResponse(sMRequestStatus, null, SMReqConnect.this.identifier, SMReqConnect.this.iter);
            }
        }
    }
}

