/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.client.alarm;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.alarm.AlarmSyncProbe;
import com.sun.symon.base.client.alarm.SMAlarmIteratorAsync;
import com.sun.symon.base.client.alarm.SMAlarmIteratorSync;
import com.sun.symon.base.client.alarm.SMAlarmMessage;
import com.sun.symon.base.client.alarm.SMAlarmObjectData;
import com.sun.symon.base.client.alarm.SMAlarmObjectResponse;
import com.sun.symon.base.client.alarm.SMAlarmOperationStatus;
import com.sun.symon.base.client.alarm.SMReqConnect;
import com.sun.symon.base.client.topology.SMTopologyEntityData;
import com.sun.symon.base.client.topology.SMTopologyRequest;
import com.sun.symon.base.server.types.StObject;
import com.sun.symon.base.server.types.StString;
import com.sun.symon.base.utility.UcAgentURL;
import com.sun.symon.base.utility.UcListUtil;
import com.sun.symon.base.utility.UcURL;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.crimson.tree.XmlDocument;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SMAlarmObjectRequest {
    protected SMRawDataRequest handle;
    protected AlarmSyncProbe syncProbe;
    private Vector connections;
    protected ResourceBundle rbundle;
    private Locale locale;
    protected String eventbaseURL = null;
    protected String eventHostPort = null;
    protected String probeURL = null;
    public static String END_OF_STREAM = "eom\n";
    public static String END = "q\n";
    private static String DOMAINTABLE = "sym/base/mibman/modules/serverSupport/moduleTable/moduleEntry/";
    private static String msgErrorInAction = "AlarmRequest.ErrorInAction";
    private static String msgNoAccess = "AlarmRequest.NoAccess";
    private static String msgRemoteContext = "AlarmRequest.InvalidActionOnRemoteContext";
    private static String msgEventMgrResp = "AlarmRequest.ErrorInEventManagerResponse";
    private static String msgAckAlarm = "AlarmRequest.AcknowledgingAlarm";
    private static String msgGetAlarmMsg = "AlarmRequest.GetAlarmMessage";
    private static String msgRunAction = "AlarmRequest.RunAction";
    private static String msgDelAlarm = "AlarmRequest.DeletingAlarm";
    private static String msgDelClsAlarm = "AlarmRequest.DeletingClosedAlarms";
    private static String msgFixAlarm = "AlarmRequest.FixingAlar";
    private static String msgUpdateAction = "AlarmRequest.UpdatingAlarmAction";

    public SMAlarmObjectRequest(SMRawDataRequest sMRawDataRequest, String string) throws SMAPIException {
        this.handle = sMRawDataRequest;
        if (string == null) {
            this.eventbaseURL = this.handle.getEventBaseURL();
            UcURL ucURL = new UcURL(this.eventbaseURL);
            this.eventHostPort = ucURL.getHost() + ":" + ucURL.getPort();
            this.probeURL = this.eventbaseURL + "mod/eventmgr/probe?runadhoccommand.probe";
        } else {
            this.eventbaseURL = "snmp://" + string + "/";
            this.eventHostPort = string;
            this.probeURL = "snmp://" + string + "/mod/eventmgr/probe?runadhoccommand.probe";
        }
        this.rbundle = this.handle.getResourceBundle();
        this.locale = this.handle.getLocale();
    }

    public synchronized SMAlarmIteratorSync getAlarms(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9) throws SMAPIException {
        return this.getAlarms(string, string2, string3, string4, string5, string6, string7, string8, string9, 60000);
    }

    public synchronized SMAlarmIteratorSync getAlarms(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, int n) throws SMAPIException {
        if (this.syncProbe == null) {
            this.syncProbe = new AlarmSyncProbe(this);
            this.syncProbe.connect(this.probeURL);
        }
        Vector vector = this.getAlarms(string, string2, string3, string4, string5, string6, string7, string8, string9, false, n);
        return new SMAlarmIteratorSync(vector, this, string);
    }

    public void getAlarms(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, SMAlarmObjectResponse sMAlarmObjectResponse, Object object) throws SMAPIException {
        this.registRequest(string, object, sMAlarmObjectResponse);
        this.getAlarms(string, string2, string3, string4, string5, string6, string7, string8, string9, false, sMAlarmObjectResponse, object, 1);
    }

    public void getAlarms(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, SMAlarmObjectResponse sMAlarmObjectResponse, Object object) throws SMAPIException {
        String string9;
        String string10 = this.handle.getTopologyBaseURL();
        String[] stringArray = new String[]{string10 + DOMAINTABLE + "name", string10 + DOMAINTABLE + "modspec"};
        StObject[][] stObjectArray = this.handle.getURLValue(stringArray);
        if (stObjectArray.length != 2) {
            throw new SMAPIException(this.rbundle.getString("AlarmRequest.UnableToReadTheModuleTable"));
        }
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        UcListUtil.decomposeList((String)stObjectArray[0][0].toString(), vector2);
        UcListUtil.decomposeList((String)stObjectArray[1][0].toString(), vector);
        String string11 = null;
        int n = 0;
        while (n < vector2.size()) {
            string9 = vector2.elementAt(n).toString();
            if (string9.indexOf(string2) != -1) {
                string11 = vector.elementAt(n).toString();
                break;
            }
            ++n;
        }
        if (string11 == null) {
            throw new SMAPIException(this.rbundle.getString("AlarmRequest.TopologyNameDoesNotExistInTheServerContext"));
        }
        string9 = string10 + "mod/" + string11;
        this.getAlarmsByTopo(string, string9, string3, string4, string5, string6, string7, string8, sMAlarmObjectResponse, object);
    }

    public synchronized void getAlarmsByTopo(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, SMAlarmObjectResponse sMAlarmObjectResponse, Object object) throws SMAPIException {
        Object object2;
        CharSequence charSequence;
        String string9;
        Object object3;
        Object object4;
        Object object5;
        SMTopologyRequest sMTopologyRequest = new SMTopologyRequest(this.handle);
        SMTopologyEntityData[] sMTopologyEntityDataArray = sMTopologyRequest.getTopologyInfo(string2);
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        int n = 0;
        while (n < sMTopologyEntityDataArray.length) {
            object5 = sMTopologyEntityDataArray[n].getPollType();
            if (((String)object5).equals("aview") || ((String)object5).equals("ahost") || ((String)object5).equals("amod")) {
                if (((String)object5).equals("aview")) {
                    object4 = sMTopologyEntityDataArray[n].getTargetUrl();
                    if (!((String)object4).equals(string2)) {
                        this.getAlarmsByTopo(string, sMTopologyEntityDataArray[n].getTargetUrl(), string3, string4, string5, string6, string7, string8, sMAlarmObjectResponse, object);
                    }
                } else {
                    object4 = string2 + "#" + sMTopologyEntityDataArray[n].getEntityId();
                    String string10 = sMTopologyRequest.getEventMngrFromContext((String)object4);
                    object3 = (StringBuffer)hashtable.get(string10);
                    if (object3 == null) {
                        object3 = new StringBuffer();
                        hashtable.put(string10, object3);
                    } else {
                        ((StringBuffer)object3).append(" ");
                    }
                    string9 = new UcAgentURL(sMTopologyEntityDataArray[n].getTargetUrl());
                    charSequence = "snmp://" + string9.getHost() + ":" + string9.getPort();
                    object2 = string9.getModuleSpec();
                    if (!((String)object2).equals("")) {
                        charSequence = (String)charSequence + "/mod/" + (String)object2;
                    }
                    ((StringBuffer)object3).append("{");
                    ((StringBuffer)object3).append((String)charSequence);
                    ((StringBuffer)object3).append("}");
                }
            }
            ++n;
        }
        object5 = hashtable.keys();
        object4 = hashtable.elements();
        boolean bl = false;
        object3 = this.registRequest(string, object, sMAlarmObjectResponse);
        while (object5.hasMoreElements()) {
            string9 = (String)object5.nextElement();
            charSequence = (StringBuffer)object4.nextElement();
            if (string9.equals(this.eventHostPort)) {
                object2 = new UcAgentURL(string2);
                String string11 = object2.getInstance();
                try {
                    this.getAlarmsByViewId(string, null, string11, string3, string4, string5, string6, string7, string8, false, sMAlarmObjectResponse, object, 1);
                }
                catch (SMAPIException sMAPIException) {}
                continue;
            }
            try {
                object2 = new SMAlarmObjectRequest(this.handle, string9);
                ((SMReqConnect)object3).addSubRequest((SMAlarmObjectRequest)object2);
                ((SMAlarmObjectRequest)object2).getAlarms(string, null, charSequence.toString(), string3, string4, string5, string6, string7, string8, sMAlarmObjectResponse, object);
            }
            catch (SMAPIException sMAPIException) {
                // empty catch block
            }
        }
    }

    public void getAlarms(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, SMAlarmObjectResponse sMAlarmObjectResponse, Object object, String string9) throws SMAPIException {
        this.getAlarmsByTopo(string, string2, string3, string4, string5, string6, string7, string8, sMAlarmObjectResponse, object);
    }

    Vector getAlarms(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, boolean bl) throws SMAPIException {
        return this.getAlarms(string, string2, string3, string4, string5, string6, string7, string8, string9, bl, 60000);
    }

    Vector getAlarms(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, boolean bl, int n) throws SMAPIException {
        if (string == null || string.length() == 0) {
            throw new SMAPIException(this.rbundle.getString("AlarmRequest.InvalidRequestIdParameterPassed"));
        }
        StringBuffer stringBuffer = this.buildAlarmMessage(string, string2, string3, string4, string5, string6, string7, string8, string9, bl, false);
        this.syncProbe.setTimeOut(n);
        this.syncProbe.writeAndWait(stringBuffer);
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(this.syncProbe.getData());
        this.syncProbe.write("f\n");
        if (stringBuffer2.length() == 0) {
            return null;
        }
        return this.handleRawAlarmData(stringBuffer2);
    }

    void getAlarms(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, boolean bl, SMAlarmObjectResponse sMAlarmObjectResponse, Object object, int n) throws SMAPIException {
        SMAlarmIteratorAsync sMAlarmIteratorAsync = new SMAlarmIteratorAsync(this, string, sMAlarmObjectResponse, object, n);
        if (string == null || string.length() == 0) {
            throw new SMAPIException(this.rbundle.getString("AlarmRequest.InvalidRequestIdParameterPassed"));
        }
        StringBuffer stringBuffer = this.buildAlarmMessage(string, string2, string3, string4, string5, string6, string7, string8, string9, bl, false);
        SMReqConnect sMReqConnect = this.getReqConnection(string);
        sMReqConnect.setAlarmIterator(sMAlarmIteratorAsync);
        sMReqConnect.write(stringBuffer.toString());
    }

    private void getAlarmsByViewId(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, boolean bl, SMAlarmObjectResponse sMAlarmObjectResponse, Object object, int n) throws SMAPIException {
        this.registRequest(string, object, sMAlarmObjectResponse);
        if (string == null || string.length() == 0) {
            throw new SMAPIException(this.rbundle.getString("AlarmRequest.InvalidRequestIdParameterPassed"));
        }
        SMAlarmIteratorAsync sMAlarmIteratorAsync = new SMAlarmIteratorAsync(this, string, sMAlarmObjectResponse, object, n);
        StringBuffer stringBuffer = this.buildAlarmMessage(string, string2, string3, string4, string5, string6, string7, string8, string9, bl, true);
        SMReqConnect sMReqConnect = this.getReqConnection(string);
        sMReqConnect.setAlarmIterator(sMAlarmIteratorAsync);
        sMReqConnect.write(stringBuffer.toString());
    }

    void getAlarms(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, boolean bl, SMAlarmObjectResponse sMAlarmObjectResponse, Object object) throws SMAPIException {
        if (string == null || string.length() == 0) {
            throw new SMAPIException(this.rbundle.getString("AlarmRequest.InvalidRequestIdParameterPassed"));
        }
        if (!bl) {
            Object object2;
            Object object3;
            if (string2 == null || string2.length() == 0) {
                throw new SMAPIException(this.rbundle.getString("AlarmRequest.InvalidTopologyNameParameterPassed"));
            }
            String string9 = this.handle.getTopologyBaseURL();
            String[] stringArray = new String[]{string9 + DOMAINTABLE + "name", string9 + DOMAINTABLE + "modspec"};
            StObject[][] stObjectArray = this.handle.getURLValue(stringArray);
            if (stObjectArray.length != 2) {
                throw new SMAPIException(this.rbundle.getString("AlarmRequest.UnableToReadTheModuleTable"));
            }
            Vector vector = new Vector();
            Vector vector2 = new Vector();
            UcListUtil.decomposeList((String)stObjectArray[0][0].toString(), vector2);
            UcListUtil.decomposeList((String)stObjectArray[1][0].toString(), vector);
            String string10 = null;
            int n = 0;
            while (n < vector2.size()) {
                object3 = vector2.elementAt(n).toString();
                if (((String)object3).indexOf(string2) != -1) {
                    string10 = vector.elementAt(n).toString();
                    break;
                }
                ++n;
            }
            if (string10 == null) {
                throw new SMAPIException(this.rbundle.getString("AlarmRequest.TopologyNameDoesNotExistInTheServerContext"));
            }
            object3 = new Vector();
            stringArray = new String[]{string9 + "mod/" + string10 + "/?topologywalk"};
            block1: while (true) {
                if ((stObjectArray = this.handle.getURLValue(stringArray)).length != stringArray.length) {
                    throw new SMAPIException(this.rbundle.getString("AlarmRequest.UnableToPerformTopologywalk"));
                }
                object2 = new StringTokenizer(stObjectArray[0][0].toString(), " ");
                Vector<String> vector3 = new Vector<String>();
                while (((StringTokenizer)object2).hasMoreElements()) {
                    String string11 = ((StringTokenizer)object2).nextElement().toString();
                    long l = Long.valueOf(((StringTokenizer)object2).nextElement().toString());
                    if (l == 1L) {
                        vector3.addElement(string11);
                        continue;
                    }
                    ((Vector)object3).addElement(string11);
                }
                if (vector3.size() == 0) break;
                stringArray = new String[vector3.size()];
                int n2 = 0;
                while (true) {
                    if (n2 >= vector3.size()) continue block1;
                    stringArray[n2] = vector3.elementAt(n2).toString() + "?topologywalk";
                    ++n2;
                }
                break;
            }
            object2 = new StringBuffer();
            int n3 = 0;
            while (n3 < ((Vector)object3).size()) {
                ((StringBuffer)object2).append("{" + ((Vector)object3).elementAt(n3).toString() + "}");
                ++n3;
            }
            this.getAlarms(string, null, ((StringBuffer)object2).toString(), string3, string4, string5, string6, string7, string8, false, sMAlarmObjectResponse, object, 0);
        } else {
            this.getAlarms(string, null, null, null, null, null, null, null, null, true, sMAlarmObjectResponse, object, 0);
        }
    }

    void getAlarms(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, boolean bl, SMAlarmObjectResponse sMAlarmObjectResponse, Object object, String string9) throws SMAPIException {
        if (string == null || string.length() == 0) {
            throw new SMAPIException(this.rbundle.getString("AlarmRequest.InvalidRequestIdParameterPassed"));
        }
        if (!bl) {
            Object object2;
            if (string2 == null || string2.length() == 0) {
                throw new SMAPIException(this.rbundle.getString("AlarmRequest.InvalidTopologyURLParameterPassed"));
            }
            Vector<String> vector = new Vector<String>();
            String[] stringArray = new String[]{string2 + "/?topologywalk"};
            block0: while (true) {
                if (((StObject[][])(object2 = this.handle.getURLValue(stringArray))).length != stringArray.length) {
                    throw new SMAPIException(this.rbundle.getString("AlarmRequest.UnableToPerformTopologywalk"));
                }
                StringTokenizer stringTokenizer = new StringTokenizer(object2[0][0].toString(), " ");
                Vector<String> vector2 = new Vector<String>();
                while (stringTokenizer.hasMoreElements()) {
                    String string10 = stringTokenizer.nextElement().toString();
                    long l = Long.valueOf(stringTokenizer.nextElement().toString());
                    if (l == 1L) {
                        vector2.addElement(string10);
                        continue;
                    }
                    vector.addElement(string10);
                }
                if (vector2.size() == 0) break;
                stringArray = new String[vector2.size()];
                int n = 0;
                while (true) {
                    if (n >= vector2.size()) continue block0;
                    stringArray[n] = vector2.elementAt(n).toString() + "?topologywalk";
                    ++n;
                }
                break;
            }
            object2 = new StringBuffer();
            int n = 0;
            while (n < vector.size()) {
                ((StringBuffer)object2).append("{" + vector.elementAt(n).toString() + "} ");
                ++n;
            }
            this.getAlarms(string, null, ((StringBuffer)object2).toString(), string3, string4, string5, string6, string7, string8, false, sMAlarmObjectResponse, object, 0);
        } else {
            this.getAlarms(string, null, null, null, null, null, null, null, null, true, sMAlarmObjectResponse, object, 0);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private StringBuffer buildAlarmMessage(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, boolean bl, boolean bl2) throws SMAPIException {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append("rtyp(B)|rid(" + string + ")");
        } else {
            stringBuffer.append("rtyp(S)|rid(" + string + ")");
            if (string2 != null && string2.length() != 0) {
                stringBuffer.append("|host(" + string2 + ")");
            }
            if (bl2) {
                if (string3 == null || string3.length() < 6 || string3.indexOf("view-") != 0) throw new SMAPIException(this.rbundle.getString("AlarmRequest.InvalidViewUrl"));
                stringBuffer.append("|viewid(" + string3 + ")");
            } else if (string3 != null && string3.length() != 0) {
                stringBuffer.append("|url(" + string3 + ")");
            } else {
                stringBuffer.append("|url({*})");
            }
            if (string4 != null && string4.length() != 0) {
                stringBuffer.append("|als(" + string4 + ")");
            }
            if (string5 != null && string5.length() != 0) {
                stringBuffer.append("|evs(" + string5 + ")");
            }
            if (string6 != null && string6.length() != 0) {
                stringBuffer.append("|ack(" + string6 + ")");
            }
            if (string7 != null && string7.length() != 0) {
                stringBuffer.append("|rulg(" + string7 + ")");
            }
            if (string8 != null && string8.length() != 0) {
                stringBuffer.append("|ruid(" + string8 + ")");
            }
            if (string9 != null && string9.length() != 0) {
                stringBuffer.append("|evid(" + string9 + ")");
            }
        }
        stringBuffer.append("|eom\n");
        return stringBuffer;
    }

    private String[] getAgentAckableAlarms(String[] stringArray) throws SMAPIException {
        String[] stringArray2 = new String[1];
        StObject[][] stObjectArray = new StObject[1][1];
        Vector<String> vector = new Vector<String>();
        stringArray2[0] = this.eventbaseURL + "mod/eventmgr/actions?eventstatus";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{ ");
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(stringArray[n] + " ");
            ++n;
        }
        stringBuffer.append("}");
        stObjectArray[0][0] = new StString(stringBuffer.toString());
        StObject[][] stObjectArray2 = null;
        try {
            stObjectArray2 = this.handle.setURLValue(stringArray2, stObjectArray);
        }
        catch (Exception exception) {
            return stringArray;
        }
        if (stObjectArray2 != null) {
            String string = stObjectArray2[0][0].toString();
            Vector vector2 = new Vector();
            UcListUtil.decomposeList((String)string, vector2);
            int n2 = 0;
            while (n2 < vector2.size()) {
                Vector vector3 = new Vector();
                UcListUtil.decomposeList((String)vector2.elementAt(n2).toString(), vector3);
                if (vector3.elementAt(1).toString().equals("O") && vector3.elementAt(2).toString().equals("N")) {
                    vector.add(vector3.elementAt(0).toString());
                }
                ++n2;
            }
            return vector.toArray(new String[vector.size()]);
        }
        return new String[0];
    }

    public Vector ackAlarms(String[] stringArray, String string) throws SMAPIException {
        Object object;
        String[] stringArray2 = new String[1];
        StObject[][] stObjectArray = new StObject[1][1];
        Object var6_5 = null;
        String[] stringArray3 = this.getAgentAckableAlarms(stringArray);
        Vector<SMAlarmOperationStatus> vector = this.ackAlarmsToAgents(stringArray3, string);
        if (vector == null) {
            vector = new Vector<SMAlarmOperationStatus>();
        }
        stringArray2[0] = this.eventbaseURL + "mod/eventmgr/actions?eventack";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        StringBuffer stringBuffer2 = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            boolean bl = true;
            int n2 = 0;
            while (vector != null && n2 < vector.size()) {
                object = (SMAlarmOperationStatus)vector.elementAt(n2);
                String string2 = ((SMAlarmOperationStatus)object).getAlarmId();
                if (string2.compareTo(stringArray[n]) == 0) {
                    bl = false;
                    break;
                }
                ++n2;
            }
            if (bl) {
                stringBuffer2.append(stringArray[n]);
                if (n + 1 < stringArray.length) {
                    stringBuffer2.append(" ");
                }
            }
            ++n;
        }
        if (stringBuffer2.toString().length() == 0) {
            if (vector == null || vector.size() == 0) {
                return null;
            }
            return vector;
        }
        stringBuffer.append(stringBuffer2.toString());
        if (string == null || string.length() == 0) {
            stringBuffer.append("} {" + this.handle.getUserId() + "}");
        } else {
            stringBuffer.append("} {" + this.handle.getUserId() + "} {" + string + "}");
        }
        stObjectArray[0][0] = new StString(stringBuffer.toString());
        StObject[][] stObjectArray2 = null;
        try {
            stObjectArray2 = this.handle.setURLValue(stringArray2, stObjectArray);
        }
        catch (Exception exception) {
            this.handleActionException(exception, msgAckAlarm);
        }
        if (stObjectArray2 != null && stObjectArray2[0][0].toString().length() != 0) {
            Vector vector2 = new Vector();
            object = new Vector();
            UcListUtil.decomposeList((String)stObjectArray2[0][0].toString(), vector2);
            int n3 = 0;
            while (n3 < vector2.size()) {
                UcListUtil.decomposeList((String)vector2.elementAt(n3).toString(), (Vector)object);
                SMAlarmOperationStatus sMAlarmOperationStatus = new SMAlarmOperationStatus(((Vector)object).elementAt(0).toString(), ((Vector)object).elementAt(1).toString());
                vector.addElement(sMAlarmOperationStatus);
                ++n3;
            }
            if (vector.size() != 0) {
                return vector;
            }
            return null;
        }
        return null;
    }

    public Vector ackAlarmsToAgents(String[] stringArray, String string) throws SMAPIException {
        Vector<SMAlarmOperationStatus> vector = new Vector<SMAlarmOperationStatus>();
        String[] stringArray2 = new String[1];
        int n = 0;
        while (n < stringArray.length) {
            SMAlarmIteratorSync sMAlarmIteratorSync = this.getAlarms("1", null, null, null, null, null, null, null, stringArray[n]);
            Vector vector2 = sMAlarmIteratorSync.getData();
            SMAlarmObjectData sMAlarmObjectData = (SMAlarmObjectData)vector2.elementAt(0);
            String string2 = SMRawDataRequest.createURL(sMAlarmObjectData.getIp(), sMAlarmObjectData.getAgentPort(), sMAlarmObjectData.getModule(), sMAlarmObjectData.getModuleInstance(), sMAlarmObjectData.getManagedObject(), sMAlarmObjectData.getProperty(), sMAlarmObjectData.getPropertyType(), sMAlarmObjectData.getAttribute(), sMAlarmObjectData.getPropertyInstance());
            stringArray2[0] = SMRawDataRequest.buildShadowURL(string2, "acknowledgement", null);
            if (stringArray2[0].endsWith("/")) {
                stringArray2[0] = stringArray2[0].substring(0, stringArray2[0].length() - 1);
            }
            StObject[][] stObjectArray = new StObject[1][1];
            StObject[][] stObjectArray2 = null;
            StringBuffer stringBuffer = new StringBuffer();
            UcListUtil.appendElement((StringBuffer)stringBuffer, (String)this.handle.getUserId());
            UcListUtil.appendElement((StringBuffer)stringBuffer, (String)string);
            UcListUtil.appendElement((StringBuffer)stringBuffer, (String)"EVENTMGR");
            String string3 = stringBuffer.toString();
            stObjectArray[0][0] = new StString(string3);
            try {
                stObjectArray2 = this.handle.setURLValue(stringArray2, stObjectArray);
            }
            catch (Exception exception) {
                this.handleActionException(exception, msgAckAlarm);
            }
            String string4 = stObjectArray2[0][0].toString();
            if (!stObjectArray2[0][0].toString().equals(string3)) {
                SMAlarmOperationStatus sMAlarmOperationStatus = new SMAlarmOperationStatus(stringArray[n], string4);
                vector.addElement(sMAlarmOperationStatus);
            }
            ++n;
        }
        if (vector.size() != 0) {
            return vector;
        }
        return null;
    }

    public Vector fixAlarms(String[] stringArray, String string) throws SMAPIException {
        String[] stringArray2 = new String[1];
        StObject[][] stObjectArray = new StObject[1][1];
        Vector<SMAlarmOperationStatus> vector = this.fixAlarmsToAgents(stringArray);
        if (vector == null) {
            vector = new Vector<SMAlarmOperationStatus>();
        }
        stringArray2[0] = this.eventbaseURL + "mod/eventmgr/actions?eventfix";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(stringArray[n]);
            if (n + 1 < stringArray.length) {
                stringBuffer.append(" ");
            }
            ++n;
        }
        if (string == null || string.length() == 0) {
            stringBuffer.append("} {" + this.handle.getUserId() + "}");
        } else {
            stringBuffer.append("} {" + this.handle.getUserId() + "} {" + string + "}");
        }
        stObjectArray[0][0] = new StString(stringBuffer.toString());
        StObject[][] stObjectArray2 = null;
        try {
            stObjectArray2 = this.handle.setURLValue(stringArray2, stObjectArray);
        }
        catch (Exception exception) {
            this.handleActionException(exception, msgFixAlarm);
        }
        if (stObjectArray2[0][0].toString().length() != 0) {
            Vector vector2 = new Vector();
            Vector vector3 = new Vector();
            UcListUtil.decomposeList((String)stObjectArray2[0][0].toString(), vector2);
            int n2 = 0;
            while (n2 < vector2.size()) {
                UcListUtil.decomposeList((String)vector2.elementAt(n2).toString(), vector3);
                SMAlarmOperationStatus sMAlarmOperationStatus = new SMAlarmOperationStatus(vector3.elementAt(0).toString(), vector3.elementAt(1).toString());
                vector.addElement(sMAlarmOperationStatus);
                ++n2;
            }
            if (vector.size() != 0) {
                return vector;
            }
            return null;
        }
        return null;
    }

    public Vector fixAlarmsToAgents(String[] stringArray) throws SMAPIException {
        Vector<SMAlarmOperationStatus> vector = new Vector<SMAlarmOperationStatus>();
        String[] stringArray2 = new String[1];
        int n = 0;
        while (n < stringArray.length) {
            SMAlarmIteratorSync sMAlarmIteratorSync = this.getAlarms("1", null, null, null, null, null, null, null, stringArray[n]);
            Vector vector2 = sMAlarmIteratorSync.getData();
            SMAlarmObjectData sMAlarmObjectData = (SMAlarmObjectData)vector2.elementAt(0);
            String string = SMRawDataRequest.createURL(sMAlarmObjectData.getIp(), sMAlarmObjectData.getAgentPort(), sMAlarmObjectData.getModule(), sMAlarmObjectData.getModuleInstance(), sMAlarmObjectData.getManagedObject(), sMAlarmObjectData.getProperty(), sMAlarmObjectData.getPropertyType(), sMAlarmObjectData.getAttribute(), sMAlarmObjectData.getPropertyInstance());
            String string2 = SMRawDataRequest.buildShadowURL(string, "fix", null);
            stringArray2[0] = string2.endsWith("/") ? string2.substring(0, string2.length() - 1) : string2;
            StObject[][] stObjectArray = new StObject[1][1];
            StObject[][] stObjectArray2 = null;
            String string3 = this.handle.getUserId();
            stObjectArray[0][0] = new StString(string3);
            try {
                stObjectArray2 = this.handle.setURLValue(stringArray2, stObjectArray);
            }
            catch (Exception exception) {
                this.handleActionException(exception, msgFixAlarm);
            }
            String string4 = stObjectArray2[0][0].toString();
            if (!stObjectArray2[0][0].toString().equals(string3)) {
                SMAlarmOperationStatus sMAlarmOperationStatus = new SMAlarmOperationStatus(stringArray[n], string4);
                vector.addElement(sMAlarmOperationStatus);
            }
            ++n;
        }
        if (vector.size() != 0) {
            return vector;
        }
        return null;
    }

    public String runAlarmsActionToAgents(String string) throws SMAPIException {
        Vector vector = new Vector();
        String[] stringArray = new String[1];
        SMAlarmIteratorSync sMAlarmIteratorSync = this.getAlarms("1", null, null, null, null, null, null, null, string);
        Vector vector2 = sMAlarmIteratorSync.getData();
        SMAlarmObjectData sMAlarmObjectData = (SMAlarmObjectData)vector2.elementAt(0);
        String string2 = SMRawDataRequest.createURL(sMAlarmObjectData.getIp(), sMAlarmObjectData.getAgentPort(), sMAlarmObjectData.getModule(), sMAlarmObjectData.getModuleInstance(), sMAlarmObjectData.getManagedObject(), sMAlarmObjectData.getProperty(), sMAlarmObjectData.getPropertyType(), sMAlarmObjectData.getAttribute(), sMAlarmObjectData.getPropertyInstance());
        String string3 = SMRawDataRequest.buildShadowURL(string2, "alarmdelayedaction", null);
        stringArray[0] = string3.endsWith("/") ? string3.substring(0, string3.length() - 1) : string3;
        StObject[][] stObjectArray = new StObject[1][1];
        StObject[][] stObjectArray2 = null;
        String string4 = sMAlarmObjectData.getActionName();
        stObjectArray[0][0] = new StString(string4);
        try {
            stObjectArray2 = this.handle.setURLValue(stringArray, stObjectArray);
        }
        catch (Exception exception) {
            this.handleActionException(exception, msgRunAction);
        }
        String string5 = stObjectArray2[0][0].toString();
        if (!stObjectArray2[0][0].toString().equals(string4)) {
            return string5;
        }
        return null;
    }

    public Vector deleteAlarms(String[] stringArray, String string) throws SMAPIException {
        String[] stringArray2 = new String[1];
        StObject[][] stObjectArray = new StObject[1][1];
        stringArray2[0] = this.eventbaseURL + "mod/eventmgr/actions?eventdelete";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(stringArray[n]);
            if (n + 1 < stringArray.length) {
                stringBuffer.append(" ");
            }
            ++n;
        }
        if (string == null || string.length() == 0) {
            stringBuffer.append("} {" + this.handle.getUserId() + "}");
        } else {
            stringBuffer.append("} {" + this.handle.getUserId() + "} {" + string + "}");
        }
        stObjectArray[0][0] = new StString(stringBuffer.toString());
        StObject[][] stObjectArray2 = null;
        try {
            stObjectArray2 = this.handle.setURLValue(stringArray2, stObjectArray);
        }
        catch (Exception exception) {
            this.handleActionException(exception, msgDelAlarm);
        }
        Vector<SMAlarmOperationStatus> vector = new Vector<SMAlarmOperationStatus>();
        if (stObjectArray2[0][0].toString().length() != 0) {
            Vector vector2 = new Vector();
            Vector vector3 = new Vector();
            UcListUtil.decomposeList((String)stObjectArray2[0][0].toString(), vector2);
            int n2 = 0;
            while (n2 < vector2.size()) {
                UcListUtil.decomposeList((String)vector2.elementAt(n2).toString(), vector3);
                SMAlarmOperationStatus sMAlarmOperationStatus = new SMAlarmOperationStatus(vector3.elementAt(0).toString(), vector3.elementAt(1).toString());
                vector.addElement(sMAlarmOperationStatus);
                ++n2;
            }
            if (vector.size() != 0) {
                return vector;
            }
            return null;
        }
        return null;
    }

    public void updateAlarmAction(String string, String string2) throws SMAPIException {
        this.updateAlarmActionOp(string, string2, msgUpdateAction);
    }

    private void updateAlarmActionOp(String string, String string2, String string3) throws SMAPIException {
        if (string == null) {
            return;
        }
        String[] stringArray = new String[]{this.eventbaseURL + "mod/eventmgr/actions?actionnameupdate"};
        StObject[][] stObjectArray = new StString[1][1];
        String string4 = "{" + string + "} {" + string2 + "}";
        stObjectArray[0][0] = new StString(string4);
        try {
            StObject[][] stObjectArray2 = this.handle.setURLValue(stringArray, stObjectArray);
        }
        catch (Exception exception) {
            this.handleActionException(exception, string3);
        }
    }

    public void runAlarmAction(String string) throws SMAPIException {
        String string2 = this.rbundle.getString(msgErrorInAction) + this.rbundle.getString(msgRunAction);
        if (string == null) {
            return;
        }
        String[] stringArray = new String[1];
        StObject[][] stObjectArray = new StObject[1][1];
        String string3 = this.runAlarmsActionToAgents(string);
        if (string3 != null) {
            throw new SMAPIException(string2 + " --- " + string3);
        }
        stringArray[0] = this.eventbaseURL + "mod/eventmgr/actions?actionrun";
        StObject[][] stObjectArray2 = new StString[1][1];
        String string4 = "{" + string + "}";
        stObjectArray2[0][0] = new StString(string4);
        StObject[][] stObjectArray3 = null;
        try {
            stObjectArray3 = this.handle.setURLValue(stringArray, stObjectArray2);
        }
        catch (Exception exception) {
            this.handleActionException(exception, msgRunAction);
        }
        if (stObjectArray3 != null && stObjectArray3[0][0].toString().length() != 0) {
            throw new SMAPIException(string2 + " --- " + stObjectArray3[0][0].toString());
        }
    }

    public void runAlarmAction(String string, String string2) throws SMAPIException {
        this.updateAlarmActionOp(string, string2, msgRunAction);
        this.runAlarmAction(string);
    }

    public void deleteAllClosedAlarms(String string, String string2) throws SMAPIException {
        String[] stringArray = new String[]{this.eventbaseURL + "mod/eventmgr/actions?closedeventsdel"};
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{" + string + "} ");
        stringBuffer.append("{" + this.handle.getUserId() + "} ");
        if (string2 == null || string2.length() == 0) {
            stringBuffer.append("{}");
        } else {
            stringBuffer.append("{" + string2 + "}");
        }
        StObject[][] stObjectArray = new StString[1][1];
        stObjectArray[0][0] = new StString(stringBuffer.toString());
        try {
            StObject[][] stObjectArray2 = this.handle.setURLValue(stringArray, stObjectArray);
        }
        catch (Exception exception) {
            this.handleActionException(exception, msgDelClsAlarm);
        }
    }

    public SMAlarmMessage[] getAlarmNotes(String string) throws SMAPIException {
        if (string == null) {
            return null;
        }
        String string2 = this.eventbaseURL + "mod/eventmgr/actions?notesget";
        return this.getAlarmMessage(string2, string);
    }

    public void setAlarmNotes(String string, String string2) throws SMAPIException {
        if (string == null || string2 == null) {
            return;
        }
        String string3 = this.eventbaseURL + "mod/eventmgr/actions?noteappend";
        String string4 = this.appendAlarmMessage(string3, string, string2);
        if (string4 != null && !string4.equals("")) {
            throw new SMAPIException(string4);
        }
    }

    public void removeAlarmNote(String string) throws SMAPIException {
        if (string == null) {
            return;
        }
        String string2 = this.eventbaseURL + "mod/eventmgr/actions?notedelete";
        String string3 = this.removeAlarmMessage(string2, string);
        if (string3 != null && !string3.equals("")) {
            throw new SMAPIException(string3);
        }
    }

    public void changeAlarmNote(String string, String string2) throws SMAPIException {
        if (string == null) {
            return;
        }
        String string3 = this.eventbaseURL + "mod/eventmgr/actions?noteset";
        String string4 = this.changeAlarmMessage(string3, string, string2);
        if (string4 != null && !string4.equals("")) {
            throw new SMAPIException(string4);
        }
    }

    public SMAlarmMessage[] getSuggestedFixes(String string) throws SMAPIException {
        if (string == null) {
            return null;
        }
        String string2 = null;
        int n = string.indexOf("/mod/");
        if (n > 0) {
            string2 = string.substring(n + 5);
        } else {
            string2 = string.substring(7);
            n = string2.indexOf("/");
            if (n < 0) {
                return null;
            }
            string2 = string2.substring(n + 1);
        }
        String string3 = this.eventbaseURL + "mod/eventmgr/actions?suggestedfixesget";
        return this.getAlarmMessage(string3, string2);
    }

    public void setSuggestedFixes(String string, String string2) throws SMAPIException {
        if (string == null) {
            return;
        }
        int n = string.indexOf("/mod/");
        String string3 = null;
        if (n > 0) {
            string3 = string.substring(n + 5);
        } else {
            string3 = string.substring(7);
            n = string3.indexOf("/");
            if (n < 0) {
                return;
            }
            string3 = string3.substring(n + 1);
        }
        String string4 = this.eventbaseURL + "mod/eventmgr/actions?suggestedfixappend";
        String string5 = this.appendAlarmMessage(string4, string3, string2);
        if (string5 != null && !string5.equals("")) {
            new SMAPIException(string5);
        }
    }

    public void removeSuggestedFix(String string) throws SMAPIException {
        if (string == null) {
            return;
        }
        String string2 = this.eventbaseURL + "mod/eventmgr/actions?suggestedfixdelete";
        String string3 = this.removeAlarmMessage(string2, string);
        if (string3 != null && !string3.equals("")) {
            throw new SMAPIException(string3);
        }
    }

    public void changeSuggestedFix(String string, String string2) throws SMAPIException {
        if (string == null) {
            return;
        }
        String string3 = this.eventbaseURL + "mod/eventmgr/actions?suggestedfixset";
        String string4 = this.changeAlarmMessage(string3, string, string2);
        if (string4 != null && !string4.equals("")) {
            throw new SMAPIException(string4);
        }
    }

    private void handleActionException(Exception exception, String string) throws SMAPIException {
        String string2 = exception.getMessage();
        if (string2 != null && string2.indexOf("no access") != -1) {
            if (string2.indexOf("snmppublic") != -1) {
                throw new SMAPIException(1, this.rbundle.getString(msgRemoteContext) + this.rbundle.getString(string));
            }
            throw new SMAPIException(1, this.rbundle.getString(msgNoAccess) + this.rbundle.getString(string));
        }
        throw new SMAPIException(this.rbundle.getString(msgErrorInAction) + this.rbundle.getString(string));
    }

    /*
     * Unable to fully structure code
     */
    final Vector handleRawAlarmData(StringBuffer var1_1) throws SMAPIException {
        var2_2 = new Vector<Object>();
        var3_3 = new Hashtable<String, String>();
        var4_4 = 0;
        var5_5 = new StringTokenizer(var1_1.toString(), "|");
        while (var5_5.hasMoreElements()) {
            block10: {
                var6_6 = var5_5.nextElement().toString();
                if (!var6_6.startsWith("eom")) ** GOTO lbl12
                var3_3.put(var6_6, "");
                break block10;
lbl-1000:
                // 1 sources

                {
                    var6_6 = var6_6 + "|" + var5_5.nextElement().toString();
lbl12:
                    // 2 sources

                    ** while (!var6_6.endsWith((String)")") && var5_5.hasMoreElements())
                }
lbl13:
                // 1 sources

                var7_7 = var6_6.indexOf("(");
                if (var6_6.substring(var7_7 + 1).length() != 0) {
                    var3_3.put(var6_6.substring(0, var7_7), var6_6.substring(var7_7 + 1, var6_6.length() - 1));
                } else {
                    var3_3.put(var6_6.substring(0, var7_7), "");
                }
            }
            if (!var3_3.containsKey("eom") && !var3_3.containsKey("eom\n")) continue;
            if (var3_3.get("stat") != null) {
                var7_8 = Long.valueOf(var3_3.get("stat").toString());
                if (var7_8 < 0L) {
                    throw new SMAPIException(this.rbundle.getString(SMAlarmObjectRequest.msgEventMgrResp) + "  " + Long.valueOf(var3_3.get("stat").toString()));
                }
                if (var7_8 == 0L) {
                    var9_11 = var3_3.get("rtyp").toString();
                    if (var9_11.compareTo("P") == 0) {
                        return null;
                    }
                    return var2_2;
                }
            }
            var7_9 = null;
            var8_10 = 0;
            if (var3_3.get("actn") != null) {
                var7_9 = var3_3.get("actn").toString();
            }
            if (var3_3.get("acts") != null && !var3_3.get("acts").toString().equals("")) {
                var8_10 = Integer.parseInt(var3_3.get("acts").toString());
            }
            var9_11 = new SMAlarmObjectData(String.valueOf(++var4_4), var3_3.get("evid").toString(), var3_3.get("ruid").toString(), Long.valueOf(var3_3.get("otim").toString()), Long.valueOf(var3_3.get("atim").toString()), Long.valueOf(var3_3.get("ctim").toString()), Long.valueOf(var3_3.get("ftim").toString()), Long.valueOf(var3_3.get("utim").toString()), Long.valueOf(var3_3.get("dtim").toString()), var3_3.get("smsg").toString(), var3_3.get("lmsg").toString(), var3_3.get("url").toString(), var3_3.get("host").toString(), var3_3.get("evs").toString(), var3_3.get("als").toString(), var3_3.get("mtyp").toString(), var3_3.get("rulg").toString(), var3_3.get("anam").toString(), var3_3.get("fnam").toString(), var3_3.get("dnam").toString(), var3_3.get("ursn").toString(), this.toBoolean(var3_3.get("hasfix")), this.toBoolean(var3_3.get("hasnote")), var7_9, var8_10);
            var2_2.addElement(var9_11);
            var3_3 = new Hashtable<K, V>();
        }
        return var2_2;
    }

    protected Boolean toBoolean(Object object) {
        if (object == null) {
            return null;
        }
        return object.toString().equals("T") ? Boolean.TRUE : Boolean.FALSE;
    }

    public synchronized void closeSyncConnection() throws SMAPIException {
        if (this.syncProbe != null) {
            this.syncProbe.write(END);
            this.syncProbe.close();
        }
    }

    public synchronized void closeConnection() throws SMAPIException {
        if (this.connections == null) {
            return;
        }
        int n = this.connections.size();
        int n2 = 0;
        while (n2 < n) {
            SMReqConnect sMReqConnect = (SMReqConnect)this.connections.elementAt(n2);
            sMReqConnect.write(END);
            sMReqConnect.close();
            ++n2;
        }
    }

    public void closeConnection(String string) throws SMAPIException {
        SMReqConnect sMReqConnect = this.removeConnection(string);
        sMReqConnect.write(END);
        sMReqConnect.close();
    }

    private synchronized SMReqConnect registRequest(String string, Object object, SMAlarmObjectResponse sMAlarmObjectResponse) throws SMAPIException {
        if (this.connections == null) {
            this.connections = new Vector();
        }
        SMReqConnect sMReqConnect = null;
        int n = this.connections.size();
        int n2 = 0;
        while (n2 < n) {
            sMReqConnect = (SMReqConnect)this.connections.elementAt(n2);
            if (sMReqConnect != null && string.equals(sMReqConnect.requestId)) {
                return sMReqConnect;
            }
            ++n2;
        }
        sMReqConnect = new SMReqConnect(string, this, object, sMAlarmObjectResponse);
        sMReqConnect.connect(this.probeURL);
        this.connections.addElement(sMReqConnect);
        return sMReqConnect;
    }

    private synchronized SMReqConnect getReqConnection(String string) {
        if (this.connections == null) {
            return null;
        }
        SMReqConnect sMReqConnect = null;
        int n = this.connections.size();
        int n2 = 0;
        while (n2 < n) {
            sMReqConnect = (SMReqConnect)this.connections.elementAt(n2);
            if (sMReqConnect != null && string.equals(sMReqConnect.requestId)) {
                return sMReqConnect;
            }
            ++n2;
        }
        return null;
    }

    private synchronized SMReqConnect removeConnection(String string) {
        if (this.connections == null) {
            return null;
        }
        SMReqConnect sMReqConnect = this.getReqConnection(string);
        if (sMReqConnect != null) {
            this.connections.remove(sMReqConnect);
        }
        return sMReqConnect;
    }

    private SMAlarmMessage[] getAlarmMessage(String string, String string2) throws SMAPIException {
        String[] stringArray = new String[]{string};
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{" + string2 + "}");
        stringBuffer.append(" {" + this.locale.getLanguage() + "}");
        StObject[][] stObjectArray = new StString[1][1];
        stObjectArray[0][0] = new StString(stringBuffer.toString());
        StObject[][] stObjectArray2 = null;
        try {
            stObjectArray2 = this.handle.setURLValue(stringArray, stObjectArray);
        }
        catch (Exception exception) {
            this.handleActionException(exception, msgGetAlarmMsg);
        }
        if (stObjectArray2 == null || stObjectArray2.length == 0 || stObjectArray2[0] == null || stObjectArray2[0].length == 0) {
            throw new SMAPIException(this.rbundle.getString(msgErrorInAction) + this.rbundle.getString(msgGetAlarmMsg));
        }
        String string3 = stObjectArray2[0][0].toString();
        SMAlarmMessage[] sMAlarmMessageArray = this.getAlarmMessageByDoc(string3);
        return sMAlarmMessageArray;
    }

    private String appendAlarmMessage(String string, String string2, String string3) throws SMAPIException {
        String[] stringArray = new String[]{string};
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{" + string2 + "}");
        stringBuffer.append(" {" + this.handle.getUserId() + "}");
        stringBuffer.append(" {" + string3 + "}");
        stringBuffer.append(" {" + this.locale.getLanguage() + "}");
        StObject[][] stObjectArray = new StString[1][1];
        stObjectArray[0][0] = new StString(stringBuffer.toString());
        StObject[][] stObjectArray2 = null;
        try {
            stObjectArray2 = this.handle.setURLValue(stringArray, stObjectArray);
        }
        catch (Exception exception) {
            this.handleActionException(exception, "AlarmRequest.ErrorInAppendAlarmMessage");
        }
        if (stObjectArray2 != null) {
            return stObjectArray2[0][0].toString();
        }
        return null;
    }

    private String removeAlarmMessage(String string, String string2) throws SMAPIException {
        String[] stringArray = new String[]{string};
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{" + string2 + "}");
        StObject[][] stObjectArray = new StString[1][1];
        stObjectArray[0][0] = new StString(stringBuffer.toString());
        StObject[][] stObjectArray2 = null;
        try {
            stObjectArray2 = this.handle.setURLValue(stringArray, stObjectArray);
        }
        catch (Exception exception) {
            this.handleActionException(exception, "AlarmRequest.ErrorInDeleteAlarmMessage");
        }
        if (stObjectArray2 != null) {
            return stObjectArray2[0][0].toString();
        }
        return null;
    }

    private String changeAlarmMessage(String string, String string2, String string3) throws SMAPIException {
        String[] stringArray = new String[]{string};
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{" + string2 + "}");
        stringBuffer.append(" {" + this.handle.getUserId() + "}");
        stringBuffer.append(" {" + string3 + "}");
        StObject[][] stObjectArray = new StString[1][1];
        stObjectArray[0][0] = new StString(stringBuffer.toString());
        StObject[][] stObjectArray2 = null;
        try {
            stObjectArray2 = this.handle.setURLValue(stringArray, stObjectArray);
        }
        catch (Exception exception) {
            this.handleActionException(exception, "AlarmRequest.ErrorInUpdateAlarmMessage");
        }
        if (stObjectArray2 != null) {
            return stObjectArray2[0][0].toString();
        }
        return null;
    }

    public SMAlarmMessage[] getAlarmMessageByDoc(String string) throws SMAPIException {
        SMAlarmMessage[] sMAlarmMessageArray;
        byte[] byArray = string.getBytes();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        Vector<SMAlarmMessage> vector = new Vector<SMAlarmMessage>();
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        try {
            sMAlarmMessageArray = XmlDocument.createXmlDocument((InputStream)byteArrayInputStream, (boolean)false);
            Element element = sMAlarmMessageArray.getDocumentElement();
            element.normalize();
            NodeList nodeList = element.getChildNodes();
            Node node = null;
            int n = 0;
            while (n < nodeList.getLength()) {
                Object object;
                node = nodeList.item(n);
                string2 = node.getNodeName();
                NodeList nodeList2 = node.getChildNodes();
                Node node2 = null;
                string4 = null;
                string5 = null;
                string6 = null;
                int n2 = 0;
                while (n2 < nodeList2.getLength()) {
                    node2 = nodeList2.item(n2);
                    if (node2.getNodeType() != 3 && node2.getNodeType() == 1) {
                        object = node2.getNodeName();
                        Node node3 = node2.getFirstChild();
                        if (node3 != null) {
                            if (((String)object).equals("MSG_ID")) {
                                string3 = node3.getNodeValue().trim();
                            } else if (((String)object).equals("TEXT")) {
                                string4 = node3.getNodeValue();
                                if (string4.length() >= 2) {
                                    string4 = string4.substring(1, string4.length() - 1);
                                }
                            } else if (((String)object).equals("USER")) {
                                string5 = node3.getNodeValue();
                            } else if (((String)object).equals("TIME")) {
                                string6 = node3.getNodeValue();
                            }
                        }
                    }
                    ++n2;
                }
                if (string4 != null || string5 != null || string6 != null) {
                    object = new SMAlarmMessage(string3, string2, string5, string6, string4);
                    vector.addElement((SMAlarmMessage)object);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            throw new SMAPIException(this.rbundle.getString(msgErrorInAction) + this.rbundle.getString(msgGetAlarmMsg) + "  " + exception.getMessage());
        }
        sMAlarmMessageArray = new SMAlarmMessage[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            sMAlarmMessageArray[n] = (SMAlarmMessage)vector.elementAt(n);
            ++n;
        }
        return sMAlarmMessageArray;
    }
}

